/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.export;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.util.ArcoPivotTreeNode;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;

public abstract class PivotTableGenerator {
    private Map rowHeaderObjects = new HashMap();
    private PivotViewConfiguration pvc;

    public PivotTableGenerator(PivotViewConfiguration pvc) {
        this.pvc = pvc;
    }

    protected abstract void printTableStart(PrintWriter var1, int var2);

    protected abstract void printTableEnd(PrintWriter var1);

    protected abstract void printTableHeaderStart(PrintWriter var1);

    protected abstract void printTableHeaderEnd(PrintWriter var1);

    protected abstract void printTableBodyStart(PrintWriter var1);

    protected abstract void printTableBodyEnd(PrintWriter var1);

    protected abstract void printRowStart(PrintWriter var1);

    protected abstract void printRowEnd(PrintWriter var1);

    protected abstract void printHeaderCell(PrintWriter var1, int var2, int var3, Object var4);

    protected abstract void printCell(PrintWriter var1, Object var2);

    protected PivotViewConfiguration getPivotViewConfiguration() {
        return this.pvc;
    }

    public void print(PrintWriter pw) {
        int rowMaxDepth = this.pvc.getRowHierachyDepth();
        int colMaxDepth = this.pvc.getColumnHierarchyDepth();
        SGELog.info("colMaxDepth = {0}", colMaxDepth);
        SGELog.info("rowMaxDepth = {0}", rowMaxDepth);
        ArcoPivotTreeNode colHeader = this.pvc.getColumnHeader();
        int cs = this.getMaxCellSpan(colHeader, colMaxDepth);
        this.printTableStart(pw, cs + rowMaxDepth);
        this.printTableHeaderStart(pw);
        for (int i = 1; i <= colMaxDepth; ++i) {
            ArrayList nodes = new ArrayList();
            this.getNodesForLevel(colHeader, i, true, nodes);
            this.printRowStart(pw);
            for (int n = 0; n < nodes.size(); ++n) {
                if (i == 1 && n == 0) {
                    this.printHeaderCell(pw, rowMaxDepth, colMaxDepth, null);
                }
                ArcoPivotTreeNode node = (ArcoPivotTreeNode)nodes.get(n);
                cs = this.getMaxCellSpan(node, colMaxDepth);
                this.printHeaderCell(pw, cs, 1, node.getUserObject());
            }
            this.printRowEnd(pw);
        }
        this.printTableHeaderEnd(pw);
        colHeader = null;
        ArcoPivotTreeNode rowHeader = this.pvc.getRowHeader();
        this.printTableBodyStart(pw);
        int rows = this.pvc.getRowCount();
        for (int row = 0; row < rows; ++row) {
            this.printRowStart(pw);
            for (int l = 1; l <= rowMaxDepth; ++l) {
                RowHeaderObject rho = this.getRowHeaderNodeForRow(row, l, rowMaxDepth);
                if (rho == null) continue;
                this.printHeaderCell(pw, 1, rho.rowSpan, rho.node.getUserObject());
            }
            this.printTableCellsForRow(pw, row);
            this.printRowEnd(pw);
        }
        this.printTableBodyEnd(pw);
        this.printTableEnd(pw);
    }

    private RowHeaderObject getRowHeaderNodeForRow(int row, int level, int maxDepth) {
        Integer iLevel = new Integer(level);
        HashMap<Integer, RowHeaderObject> column = (HashMap<Integer, RowHeaderObject>)this.rowHeaderObjects.get(iLevel);
        if (column == null) {
            column = new HashMap<Integer, RowHeaderObject>();
            this.rowHeaderObjects.put(iLevel, column);
            ArrayList result = new ArrayList();
            this.getNodesForLevel(this.pvc.getRowHeader(), level, false, result);
            int lastAccumSpan = 0;
            for (int i = 0; i < result.size(); ++i) {
                ArcoPivotTreeNode node = (ArcoPivotTreeNode)result.get(i);
                int span = this.getMaxCellSpan(node, maxDepth);
                RowHeaderObject rho = new RowHeaderObject();
                rho.node = node;
                rho.rowSpan = span;
                rho.accumSpans = span + lastAccumSpan;
                column.put(new Integer(lastAccumSpan), rho);
                lastAccumSpan = rho.accumSpans;
            }
        }
        Integer iRow = new Integer(row);
        Object o = column.get(iRow);
        return (RowHeaderObject)o;
    }

    private void printTableCellsForRow(PrintWriter pw, int row) {
        int cols = this.pvc.getColumnCount();
        for (int c = 0; c < cols; ++c) {
            this.printCell(pw, this.pvc.getValueAt(row, c));
        }
    }

    private void getMaxCellSpan(ArcoPivotTreeNode node, CellSpan csp, int maxDepth) {
        int level = node.getLevel();
        if (level == maxDepth - 1) {
            csp.span += node.getChildCount();
        } else {
            for (int c = 0; c < node.getChildCount(); ++c) {
                ArcoPivotTreeNode n = (ArcoPivotTreeNode)node.getChildAt(c);
                this.getMaxCellSpan(n, csp, maxDepth);
            }
        }
    }

    private int getMaxCellSpan(ArcoPivotTreeNode node, int maxDepth) {
        CellSpan csp = new CellSpan();
        this.getMaxCellSpan(node, csp, maxDepth);
        return csp.span == 0 ? 1 : csp.span;
    }

    private void getNodesForLevel(ArcoPivotTreeNode node, int level, boolean isCols, List result) {
        int l;
        if (node == null) {
            ArcoPivotTreeNode arcoPivotTreeNode = node = isCols ? this.pvc.getColumnHeader() : this.pvc.getRowHeader();
        }
        if ((l = node.getLevel()) == level) {
            ArcoPivotTreeNode parent = (ArcoPivotTreeNode)node.getParent();
            if (parent == null) {
                result.add(node);
            } else {
                ArcoPivotTreeNode pp = (ArcoPivotTreeNode)parent.getParent();
                if (pp == null) {
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        result.add(parent.getChildAt(i));
                    }
                } else {
                    for (int i = 0; i < pp.getChildCount(); ++i) {
                        TreeNode ch = pp.getChildAt(i);
                        Enumeration<? extends TreeNode> e = ch.children();
                        while (e.hasMoreElements()) {
                            result.add(e.nextElement());
                        }
                    }
                }
            }
            return;
        }
        int cc = node.getChildCount();
        if (cc == 0) {
            SGELog.fine("current level={0}, target level=1, node = {1} has no children", new Integer(level), node.getUserObject());
            return;
        }
        ArcoPivotTreeNode c0 = (ArcoPivotTreeNode)node.getChildAt(0);
        this.getNodesForLevel(c0, level, isCols, result);
    }

    private static final class CellSpan {
        int span;

        private CellSpan() {
        }
    }

    private static final class RowHeaderObject {
        ArcoPivotTreeNode node;
        int rowSpan;
        int accumSpans;

        private RowHeaderObject() {
        }
    }
}

