/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.export;

import com.sun.grid.arco.ResultManager;
import com.sun.grid.arco.model.Result;
import com.sun.grid.arco.model.ResultType;
import com.sun.grid.arco.model.Table;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.export.AbstractXSLResultExport;
import com.sun.grid.reporting.export.ExportContext;
import com.sun.grid.reporting.export.PDFPivotTableGenerator;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.Jdk14Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.messaging.MessageHandler;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class PDFResultExport
extends AbstractXSLResultExport {
    public static final String XSL_MASTER = "xslt/pdf_master.xsl";
    File basedir;

    public PDFResultExport(File basedir) {
        super("application/pdf");
        this.basedir = basedir;
    }

    protected Reader createXSLReader(ExportContext ctx) throws IOException {
        Result result = ctx.getXMLResult();
        StringWriter xsl = new StringWriter();
        PrintWriter pw = new PrintWriter(xsl);
        this.writeXSL(ctx, pw);
        pw.flush();
        String str = xsl.getBuffer().toString();
        return new StringReader(str);
    }

    public void export(ExportContext ctx) throws IOException, TransformerException {
        OutputStream out = ctx.getOutputStream();
        StringWriter swr = new StringWriter();
        ResultManager.getInstance().save((Object)ctx.getXMLResult(), swr);
        StreamSource xslStream = new StreamSource(this.createXSLReader(ctx));
        StreamSource xmlStream = new StreamSource(new StringReader(swr.getBuffer().toString()));
        StreamResult outStream = new StreamResult(out);
        Driver driver = new Driver();
        Logger fopLogger = Logger.getAnonymousLogger();
        fopLogger.setParent(SGELog.getLogger());
        fopLogger.setLevel(Level.WARNING);
        Jdk14Logger logger = new Jdk14Logger(fopLogger);
        driver.setLogger((org.apache.avalon.framework.logger.Logger)logger);
        MessageHandler.setScreenLogger((org.apache.avalon.framework.logger.Logger)logger);
        driver.setRenderer(1);
        driver.setOutputStream(out);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xslStream);
        SAXResult res = new SAXResult(driver.getContentHandler());
        transformer.transform(xmlStream, res);
    }

    private void dumpFile(String file, PrintWriter pw, String token, String replacement) throws IOException {
        FileReader fr = new FileReader(new File(this.basedir, file));
        BufferedReader rd = new BufferedReader(fr);
        String line = null;
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int len = token.length();
        while ((line = rd.readLine()) != null) {
            buffer.setLength(0);
            buffer.append(line);
            index = buffer.indexOf(token);
            if (index > 0) {
                buffer.replace(index, index + len, replacement);
            }
            pw.println(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFile(String file, Writer writer) throws IOException {
        FileReader fr = new FileReader(new File(this.basedir, file));
        char[] buf = new char[4096];
        int len = 0;
        try {
            while ((len = fr.read(buf)) > 0) {
                writer.write(buf, 0, len);
            }
        }
        finally {
            fr.close();
        }
    }

    private void writeYetNotImplemented(String text, PrintWriter pw) {
        pw.print("<fo:block color='red'>");
        pw.print(text);
        pw.println("</fo:block>");
    }

    private boolean writeXSLView(ExportContext ctx, int viewIndex, PrintWriter pw) throws IOException {
        Result result = ctx.getXMLResult();
        boolean ret = false;
        if (result.getView().getTable() != null && result.getView().getTable().getOrder() == viewIndex) {
            SGELog.info("write table as view {0}", new Integer(viewIndex));
            this.dumpFile("xslt/pdf_table.xsl", pw, "@@COLUMNWIDTH@@", this.calculateColumnWidth(ctx));
            ret = true;
        } else if (result.getView().getPivot() != null && result.getView().getPivot().getOrder() == viewIndex) {
            SGELog.info("write pivot as view {0}", new Integer(viewIndex));
            this.writePivot(ctx, pw);
            ret = true;
        } else if (result.getView().getGraphic() != null && result.getView().getGraphic().getOrder() == viewIndex) {
            SGELog.info("write graphic as view {0}", new Integer(viewIndex));
            this.writeChart(ctx, pw);
            ret = true;
        }
        return ret;
    }

    private void writePivot(ExportContext ctx, PrintWriter pw) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pivotPW = new PrintWriter(sw);
        PivotViewConfiguration pvc = ctx.getModel().getPivotViewConfiguration();
        pvc.setResult(ctx.getModel().getResult().getValue());
        pvc.buildTree();
        PDFPivotTableGenerator pivotGen = new PDFPivotTableGenerator(pvc);
        pw.println("<fo:block padding-before='1cm'>");
        pivotGen.print(pw);
        pw.println("</fo:block>");
    }

    private String calculateColumnWidth(ExportContext ctx) {
        Result result = ctx.getXMLResult();
        int[] width = new int[result.getColumn().size()];
        ResultType.ColumnType column = null;
        for (int i = 0; i < width.length; ++i) {
            column = (ResultType.ColumnType)result.getColumn().get(i);
            width[i] = column.getName().length();
        }
        Iterator iter = result.getRow().iterator();
        ResultType.RowType row = null;
        String value = null;
        while (iter.hasNext()) {
            row = (ResultType.RowType)iter.next();
            for (int i = 0; i < width.length; ++i) {
                value = (String)row.getValue().get(i);
                width[i] = Math.max(width[i], value.length());
            }
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < width.length; ++i) {
            buf.append("<fo:table-column column-width='");
            buf.append(width[i] * 3);
            buf.append("mm'/>\n");
        }
        return buf.toString();
    }

    private void writeChart(ExportContext ctx, PrintWriter pw) throws IOException {
        File chartFile = null;
        try {
            try {
                JFreeChart chart = ctx.getModel().createChart();
                chartFile = File.createTempFile("arco", ".jpg");
                FileOutputStream fo = new FileOutputStream(chartFile);
                ChartPanel panel = new ChartPanel(chart);
                Dimension dim = panel.getPreferredSize();
                SGELog.fine("writing chart into file {0}", (Object)chartFile.getAbsolutePath());
                ChartUtilities.writeChartAsJPEG((OutputStream)fo, (JFreeChart)chart, (int)dim.width, (int)dim.height);
                fo.flush();
                fo.close();
                this.dumpFile("xslt/pdf_graphic.xsl", pw, "@@FILE@@", chartFile.toURL().toString());
            }
            catch (MalformedURLException mfue) {
                IllegalStateException ilse = new IllegalStateException("file.toUrl failed");
                ilse.initCause(mfue);
                throw ilse;
            }
            Object var9_10 = null;
            if (chartFile != null && chartFile.exists()) {
                ctx.addTempFile(chartFile);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (chartFile != null && chartFile.exists()) {
                ctx.addTempFile(chartFile);
            }
            throw throwable;
        }
    }

    private void writeContent(ExportContext ctx, PrintWriter pw) throws IOException {
        this.dumpFile("xslt/pdf_firstpage.xsl", pw);
        boolean found = false;
        for (int i = 0; i < 3; ++i) {
            if (!this.writeXSLView(ctx, i, pw)) continue;
            found = true;
        }
        if (!found) {
            SGELog.info("no view defined, write table");
            this.dumpFile("xslt/pdf_table.xsl", pw, "@@COLUMNWIDTH@@", this.calculateColumnWidth(ctx));
        }
    }

    private void writeXSL(ExportContext ctx, PrintWriter pw) throws IOException {
        File master = new File(this.basedir, XSL_MASTER);
        BufferedReader rd = new BufferedReader(new FileReader(master));
        String line = null;
        String str = null;
        while ((line = rd.readLine()) != null) {
            str = line.trim();
            if (str.equals("<!--@@CONTENT@@-->")) {
                this.writeContent(ctx, pw);
                continue;
            }
            pw.println(line);
        }
    }

    public void writeTable(Result result, PrintWriter pw) throws IOException {
        pw.println("<fo:table border='0.5pt solid black'>");
        Table table = result.getView().getTable();
        int[] columns = null;
        String columnName = null;
        ResultType.ColumnType column = null;
        if (table != null) {
            columns = new int[table.getColumn().size()];
            List columnList = table.getColumn();
            block0: for (int i = 0; i < columns.length; ++i) {
                columnName = (String)table.getColumn().get(i);
                for (int ii = 0; ii < columnList.size(); ++ii) {
                    column = (ResultType.ColumnType)columnList.get(i);
                    if (!column.getName().equals(columnName)) continue;
                    columns[i] = ii;
                    continue block0;
                }
            }
        } else {
            columns = new int[result.getColumn().size()];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = i;
            }
        }
        pw.println("<fo:table-header>");
        pw.println("  <fo:table-row>");
        for (int i = 0; i < columns.length; ++i) {
            column = (ResultType.ColumnType)result.getColumn().get(columns[i]);
            pw.print("<fo:table-cell>");
            pw.print("<fo:block>");
            pw.print(column.getName());
            pw.print("</fo:block>");
            pw.println("</fo:table-cell>");
        }
        pw.println("  </fo:table-row>");
        pw.println("</fo:table-header>");
        pw.println("<fo:table-data>");
        pw.println("  <fo:table-row>");
        Iterator iter = result.getRow().iterator();
        ResultType.RowType row = null;
        while (iter.hasNext()) {
            row = (ResultType.RowType)iter.next();
            for (int i = 0; i < columns.length; ++i) {
                pw.print("<fo:table-cell>");
                pw.print("<fo:block>");
                pw.print(row.getValue().get(columns[i]));
                pw.print("</fo:block>");
                pw.println("</fo:table-cell>");
            }
        }
        pw.println("  </fo:table-row>");
        pw.println("</fo:table-data>");
        pw.println("</fo:table>");
    }
}

