/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.export;

import com.sun.grid.reporting.export.PivotTableGenerator;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import java.io.PrintWriter;

public class PDFPivotTableGenerator
extends PivotTableGenerator {
    public PDFPivotTableGenerator(PivotViewConfiguration pvc) {
        super(pvc);
    }

    protected void printCell(PrintWriter pw, Object content) {
        pw.print("<fo:table-cell border='0.5pt solid' padding='4pt' font-size='8pt'");
        pw.println("> <fo:block>");
        if (content != null) {
            String str = content.toString();
            if (str.length() > 20) {
                str = str.substring(0, 20);
            }
            pw.print(str);
        }
        pw.println("</fo:block></fo:table-cell>");
    }

    protected void printHeaderCell(PrintWriter pw, int colSpan, int rowSpan, Object content) {
        pw.print("<fo:table-cell border='0.5pt solid' padding='4pt' font-size='8pt' font-weight='bold'");
        pw.print(" number-columns-spanned='");
        pw.print(colSpan);
        pw.print("' number-rows-spanned='");
        pw.print(rowSpan);
        pw.println("'> <fo:block>");
        if (content != null) {
            String str = content.toString();
            if (str.length() > 20) {
                str = str.substring(0, 20);
            }
            pw.print(str);
        }
        pw.println("</fo:block></fo:table-cell>");
    }

    protected void printTableHeaderStart(PrintWriter pw) {
        pw.println("<fo:table-header>");
    }

    protected void printTableHeaderEnd(PrintWriter pw) {
        pw.println("</fo:table-header>");
    }

    protected void printRowEnd(PrintWriter pw) {
        pw.println("</fo:table-row>");
    }

    protected void printRowStart(PrintWriter pw) {
        pw.println("<fo:table-row>");
    }

    protected void printTableEnd(PrintWriter pw) {
        pw.println("</fo:table>");
    }

    protected void printTableStart(PrintWriter pw, int colCount) {
        pw.println("<fo:table table-layout='fixed'>");
        double width = 18.0 / (double)colCount;
        for (int i = 0; i < colCount; ++i) {
            pw.print("<fo:table-column column-width='");
            pw.print(width);
            pw.println("cm'/>");
        }
    }

    protected void printTableBodyStart(PrintWriter pw) {
        pw.println("<fo:table-body>");
    }

    protected void printTableBodyEnd(PrintWriter pw) {
        pw.println("</fo:table-body>");
    }
}

