/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.export;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.ArcoModelBean;
import com.sun.grid.reporting.exception.ArcoException;
import com.sun.grid.reporting.export.ChartManager;
import com.sun.grid.reporting.export.ExportContext;
import com.sun.grid.reporting.export.HTMLPivotTableGenerator;
import com.sun.grid.reporting.export.ResultExport;
import com.sun.grid.reporting.export.ResultExportManager;
import com.sun.grid.reporting.model.DBTableViewConfiguration;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.model.Result;
import com.sun.grid.reporting.sql.SQLTableModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;
import javax.xml.transform.TransformerException;

public class HTMLResultExport
extends ResultExport {
    private File baseDir;
    public static final String PROPERTY_STYLE_SHEET = "html.stylesheet";
    public static final String PROPERTY_TABLE_CLASS = "html.table.class";
    public static final String PROPERTY_TABLE_TH_CLASS = "html.table.th.class";

    public HTMLResultExport(File baseDir) {
        super("text/html");
        this.baseDir = baseDir;
    }

    public void export(ExportContext ctx) throws IOException, TransformerException {
        if (ctx.getType() == 0) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(ctx.getOutputStream()));
            this.export(ctx, pw);
        } else {
            this.exportInDirectory(ctx);
        }
    }

    private void export(ExportContext ctx, PrintWriter pw) throws IOException {
        ArcoModelBean model = ctx.getModel();
        Result result = model.getResult();
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<link rel='stylesheet' type='text/css' href='style.css' />");
        pw.print("<title> N1 Grid Engine - ARCo - ");
        pw.print(model.getResultName());
        pw.println("</title>");
        pw.println("</head>");
        pw.println("<body>");
        int headerCount = 5;
        if (model.isHideDescription()) {
            --headerCount;
        }
        if (model.isHideSQLStatement()) {
            --headerCount;
        }
        String[][] header = new String[headerCount][];
        int headerIndex = 0;
        header[headerIndex++] = new String[]{"Name:", model.getResultName()};
        header[headerIndex++] = new String[]{"Category:", model.getResultCategory()};
        if (!model.isHideDescription()) {
            header[headerIndex++] = new String[]{"Description:", model.getResultDescription()};
        }
        header[headerIndex++] = new String[]{"Filter:", model.getResultViewFilterconditions()};
        if (!model.isHideSQLStatement()) {
            header[headerIndex++] = new String[]{"SQL:", model.getResultViewSQLStatement()};
        }
        pw.println("<table>");
        for (int i = 0; i < header.length; ++i) {
            pw.println("<tr>");
            pw.print("<th valign=\"top\" align=\"left\">");
            pw.print(header[i][0]);
            pw.print("</th>");
            pw.print("<td>");
            pw.print(header[i][1] == null ? "" : header[i][1]);
            pw.print("</td>");
            pw.println("</tr>");
        }
        pw.println("</table>");
        pw.println("<center>");
        block6: for (int i = 0; i < 3; ++i) {
            int viewType = result.getViewConfigurationManager().getViewConfigurationTypeAt(i);
            pw.println("<div>");
            pw.println("<br>");
            switch (viewType) {
                case 1: {
                    this.printHtmlTabular(ctx, pw);
                    break;
                }
                case 2: {
                    this.printPivot(ctx, pw);
                    break;
                }
                case 3: {
                    this.printGraphic(ctx, pw);
                    break;
                }
                default: {
                    if (i != 0) break;
                    this.printHtmlTabular(ctx, pw);
                    break block6;
                }
            }
            pw.println("</div>");
        }
        pw.println("</center>");
        pw.println("</body>");
        pw.println("</html>");
    }

    private void exportInDirectory(ExportContext ctx) throws IOException {
        File outputFile = new File(ctx.getOutputFile(), "index.html");
        FileWriter fw = new FileWriter(outputFile);
        PrintWriter pw = new PrintWriter(fw);
        this.export(ctx, pw);
        outputFile = new File(ctx.getOutputFile(), "style.css");
        FileOutputStream fos = new FileOutputStream(outputFile);
        File inputFile = new File(this.baseDir, HTMLResultExport.getStyleSheet());
        FileInputStream fin = new FileInputStream(inputFile);
        fin.getChannel().transferTo(0L, fin.getChannel().size(), fos.getChannel());
        fin.close();
        fos.close();
        pw.flush();
        pw.close();
        fw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGraphic(ExportContext ctx, PrintWriter pw) throws IOException {
        String url = null;
        if (ctx.getType() == 0) {
            url = "/reporting/chart_servlet?timestamp=" + System.currentTimeMillis();
        } else {
            url = "chart.jpg";
            File file = new File(ctx.getOutputFile(), url);
            try {
                FileOutputStream fo = new FileOutputStream(file);
                try {
                    ChartManager.writeChart(ctx.getModel(), fo);
                    pw.print("<img name='chart' src='");
                    pw.print(url);
                    pw.println("' alt='chart'/>");
                }
                finally {
                    fo.flush();
                    fo.close();
                }
            }
            catch (ArcoException ae) {
                pw.print("<div color='red'>");
                pw.print(ae.getLocalizedMessage());
                pw.println("</div>");
                file.delete();
            }
        }
    }

    private void printPivot(ExportContext ctx, PrintWriter pw) {
        PivotViewConfiguration pivotViewConfiguration = ctx.getModel().getPivotViewConfiguration();
        Result result = ctx.getModel().getResult();
        if (null == pivotViewConfiguration || result == null) {
            pw.println("<p color='red'>[ERROR] MODEL:getPivot can't reate pivot table</p>");
        } else {
            SQLTableModel value = result.getValue();
            if (null == value) {
                pw.println("[INFO] MODEL:getPivot Result is empty !");
            }
            pivotViewConfiguration.setSQLTableModel(value);
            pivotViewConfiguration.buildTree();
            HTMLPivotTableGenerator gen = new HTMLPivotTableGenerator(pivotViewConfiguration);
            gen.print(pw);
        }
    }

    private void printHtmlTabular(ExportContext ctx, PrintWriter pw) {
        int i;
        SGELog.entering(this.getClass(), "getPageableHtmlTabular");
        Result result = ctx.getModel().getResult();
        DBTableViewConfiguration dbvc = ctx.getModel().getDBTableViewConfiguration();
        SQLTableModel sqltm = result.getValue();
        if (sqltm == null) {
            this.printEmptyHtmlTable(pw, "Sorry - No Data: SQLTableModel is null !</div>");
        }
        if (!sqltm.hasData()) {
            this.printEmptyHtmlTable(pw, "Sorry - No Data.");
        }
        int endLine = sqltm.getRowCount() - 1;
        int startLine = 0;
        if (ctx.getType() == 0) {
            startLine = result.getVisibleLineCount() * result.getPageCount();
            endLine = startLine + result.getVisibleLineCount() - 1;
            endLine = Math.min(result.getLineCount() - 1, endLine);
        }
        int[] colIndizes = null;
        if (dbvc != null && dbvc.getColumns().size() > 0) {
            colIndizes = new int[dbvc.getColumns().size()];
            for (i = 0; i < colIndizes.length; ++i) {
                colIndizes[i] = sqltm.getColumnIndexByName((String)dbvc.getColumns().get(i));
            }
        } else {
            colIndizes = new int[sqltm.getColumnCount()];
            for (i = 0; i < colIndizes.length; ++i) {
                colIndizes[i] = i;
            }
        }
        int row = 0;
        int col = 0;
        Object obj = null;
        String str = null;
        pw.print("<table width='100%' border='1' spacing='1' class='");
        pw.print(HTMLResultExport.getTableClass());
        pw.println("'>");
        pw.println("<tr>");
        this.printTHStart(pw);
        pw.println("</th>");
        for (col = 0; col < colIndizes.length; ++col) {
            this.printTHStart(pw);
            str = sqltm.getColumnName(colIndizes[col]);
            pw.println(str);
            pw.println(" (" + sqltm.getColumnClass(colIndizes[col]).getName() + ")");
            pw.println("</th>");
        }
        pw.println("</tr>");
        SGELog.fine("startline = {0}" + startLine);
        SGELog.fine("endLine = " + endLine);
        for (row = startLine; row <= endLine; ++row) {
            pw.println("<tr>");
            for (col = 0; col < colIndizes.length; ++col) {
                obj = result.getValueAt(row, colIndizes[col]);
                str = obj == null ? "" : obj.toString();
                pw.print("<td>");
                pw.print(str);
                pw.print("/<td>");
            }
            pw.println("</tr>");
        }
        pw.println("</table>");
    }

    private void printEmptyHtmlTable(PrintWriter pw, String p_message) {
        pw.println("<table width=\"100%\" border=\"1\" spacing=\"1\" class=\"Tbl\">");
        pw.println("<tr>");
        pw.println("<td>");
        pw.println(p_message);
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
    }

    private static Properties props() {
        return ResultExportManager.getProperties();
    }

    public static String getStyleSheet() {
        return HTMLResultExport.props().getProperty(PROPERTY_STYLE_SHEET);
    }

    public static String getTableClass() {
        return HTMLResultExport.props().getProperty(PROPERTY_TABLE_CLASS, "");
    }

    public static String getTableHeaderClass() {
        return HTMLResultExport.props().getProperty(PROPERTY_TABLE_TH_CLASS, "");
    }

    public void printTHStart(PrintWriter pw) {
        pw.print("<th class='");
        pw.print(HTMLResultExport.getTableHeaderClass());
        pw.println("'>");
    }
}

