/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.export;

import com.sun.grid.arco.model.Result;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.ArcoModelBean;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ExportContext {
    public static final int TYPE_STREAM = 0;
    public static final int TYPE_DIRECTORY = 1;
    private ArcoModelBean model;
    private OutputStream out;
    private Result result;
    private File outputFile;
    private ArrayList tmpFiles;
    private int type;

    public ExportContext(ArcoModelBean model, File outputFile) {
        this.model = model;
        this.outputFile = outputFile;
        this.type = outputFile.isDirectory() ? 1 : 0;
    }

    public ExportContext(ArcoModelBean model, OutputStream out) {
        this.model = model;
        this.out = out;
        this.type = 0;
    }

    public ArcoModelBean getModel() {
        return this.model;
    }

    public int getType() {
        return this.type;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public Result getXMLResult() {
        if (this.result == null) {
            this.result = this.model.getXMLResult();
        }
        return this.result;
    }

    public void addTempFile(File file) {
        if (this.tmpFiles == null) {
            this.tmpFiles = new ArrayList();
        }
        this.tmpFiles.add(file);
    }

    public void cleanup() {
        if (this.tmpFiles != null) {
            Iterator iter = this.tmpFiles.iterator();
            File file = null;
            while (iter.hasNext()) {
                file = (File)iter.next();
                if (file.delete()) continue;
                SGELog.warning("Can''t delete file {0}", (Object)file.getAbsolutePath());
            }
        }
    }
}

