/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.exception;

import com.sun.grid.logging.SGELog;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ArcoException
extends Exception {
    private Locale locale;
    private String messageKey;
    private String originatorClassName;
    private Object[] description;

    public ArcoException(String messageKey) {
        super(messageKey);
        this.messageKey = messageKey;
    }

    public ArcoException(String messageKey, String originatorClassname) {
        this(messageKey);
        this.originatorClassName = originatorClassname;
    }

    public ArcoException(String messageKey, Object[] value) {
        this(messageKey);
        this.description = value;
    }

    public ArcoException(String messageKey, Throwable cause) {
        this(messageKey);
        this.initCause(cause);
    }

    public ArcoException(String messageKey, String originatorClassname, Object[] value) {
        this(messageKey, originatorClassname);
        this.description = value;
    }

    public ArcoException(String messageKey, Throwable cause, String originatorClassname) {
        this(messageKey, cause, originatorClassname, null);
    }

    public ArcoException(String messageKey, Throwable cause, Object[] value) {
        this(messageKey);
        this.description = value;
        this.initCause(cause);
    }

    public ArcoException(String messageKey, Throwable cause, String originatorClassname, Object[] value) {
        this(messageKey, originatorClassname);
        this.description = value;
        this.initCause(cause);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getLocalizedMessage() {
        if (this.locale == null) {
            this.locale = Locale.US;
        }
        SGELog.fine("using locale {0}", this.locale);
        String localizedMessage = "";
        try {
            ResourceBundle messages = ResourceBundle.getBundle("com.sun.grid.reporting.resources.Exceptions", this.locale);
            try {
                localizedMessage = messages.getString(this.messageKey);
                localizedMessage = this.formatMessage(localizedMessage, this.getMessageValue());
            }
            catch (MissingResourceException mre) {
                SGELog.warning("Missing resource {0}", (Object)this.messageKey);
                localizedMessage = this.messageKey;
            }
        }
        catch (MissingResourceException mre) {
            SGELog.warning("ResourceBundle com.sun.grid.reporting.resources.Exceptions not found");
            localizedMessage = this.messageKey;
        }
        return localizedMessage;
    }

    public String getLocalizedMessage(Locale locale) {
        this.locale = locale;
        return this.getLocalizedMessage();
    }

    public String getOriginatorClassName() {
        return this.originatorClassName;
    }

    private Object[] getMessageValue() {
        return this.description;
    }

    private String formatMessage(String messageString, Object[] replaceValue) {
        SGELog.finest("formating localized string {0}", (Object)messageString);
        MessageFormat mf = new MessageFormat(messageString);
        return mf.format(replaceValue);
    }
}

