/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.control;

import com.sun.grid.arco.model.StorageType;
import com.sun.grid.reporting.AcroServletBase;
import com.sun.grid.reporting.control.ResultActionControl;
import com.sun.grid.reporting.io.SaveResultXML;
import com.sun.grid.reporting.model.ArcoResultExport;
import com.sun.grid.reporting.model.Result;
import com.sun.grid.reporting.util.PropertyKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ResultExportControl
extends ResultActionControl {
    public static final String CSV_XSLT = "xslt/result2csv.xsl";
    private Vector exportList;
    private Properties storagePoperties;
    private String outFile;

    public ResultExportControl(String xmlFile, String xslFile, String outputFile) {
        this.exportList = new Vector();
        ArcoResultExport listElem = new ArcoResultExport();
        listElem.setOutpuFile(outputFile);
        listElem.setXmlFile(xmlFile);
        listElem.setXslFile(xslFile);
        this.exportList.add(listElem);
    }

    public ResultExportControl(Vector exportList, Properties storage) {
        this.exportList = exportList;
        Iterator exportIt = exportList.iterator();
        while (exportIt.hasNext()) {
            ArcoResultExport export = (ArcoResultExport)exportIt.next();
            String pathKey = PropertyKey.DATA_STORAGE_PATH_COMMON.getName();
            String path = this.storagePoperties.getProperty(pathKey);
            path = path + File.separatorChar;
            pathKey = PropertyKey.DATA_STORAGE_SUBPATH_RESULTS.getName();
            path = path + this.storagePoperties.getProperty(pathKey);
            path = path + File.separatorChar;
            export.setXmlFile(path + export.getXmlFile() + ".xml");
        }
    }

    public ResultExportControl(Vector exportList, StorageType storage) {
        this.exportList = exportList;
        Iterator exportIt = exportList.iterator();
        String path = storage.getRoot() + File.separatorChar + storage.getResults() + File.separatorChar;
        ArcoResultExport export = null;
        while (exportIt.hasNext()) {
            export = (ArcoResultExport)exportIt.next();
            export.setXmlFile(path + export.getXmlFile() + ".xml");
        }
    }

    public ResultExportControl(int exportType, String outputFile, Result result) throws IOException {
        String xsltFile = null;
        Object xmlFile = null;
        String extention = null;
        this.exportList = new Vector();
        this.result = result;
        SaveResultXML xml = new SaveResultXML(outputFile, true);
        try {
            xml.save(result);
        }
        catch (IOException ioEx) {
            System.out.println("ERROR:\t" + this.getClass().getName() + " <init>: " + ioEx.getMessage());
            throw ioEx;
        }
        catch (IllegalStateException illegalState) {
            System.out.println("ERROR:\t" + this.getClass().getName() + " <init>: " + illegalState.getMessage());
            throw illegalState;
        }
        switch (exportType) {
            case 501: {
                xsltFile = AcroServletBase.getApplDir().getAbsolutePath() + File.separatorChar + CSV_XSLT;
                extention = ".csv";
                break;
            }
            default: {
                throw new UnsupportedOperationException("This export is not supported yet");
            }
        }
        this.outFile = outputFile + extention;
        ArcoResultExport export = new ArcoResultExport();
        export.setXmlFile(xml.getStoragePath() + File.separatorChar + outputFile + ".xml");
        export.setXslFile(xsltFile);
        export.setOutpuFile("/usr/share/webconsole/reporting/export/" + this.outFile);
        this.exportList.add(export);
    }

    public void run() {
        try {
            Iterator exportIt = this.exportList.iterator();
            while (exportIt.hasNext()) {
                ArcoResultExport export = (ArcoResultExport)exportIt.next();
                System.out.println("DEBUG:\tArcoCmdlnQuery.run()\n\tDo export " + export.getXmlFile() + " with " + export.getXslFile() + " to " + export.getOutpuFile());
                StreamSource xslStream = new StreamSource(export.getXslFile());
                StreamSource xmlStream = new StreamSource(export.getXmlFile());
                FileOutputStream fos = new FileOutputStream(export.getOutpuFile());
                StreamResult outStream = new StreamResult(fos);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(xslStream);
                transformer.transform(xmlStream, outStream);
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR:\tThread <" + this.getName() + "> ResultExportControl.run()\n\t" + ex.getMessage());
        }
    }

    public String getOutFileName() {
        return this.outFile;
    }
}

