/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.AcroServletBase;
import com.sun.grid.reporting.ArcoModelBean;
import com.sun.grid.reporting.export.ResultExportManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportResultServlet
extends HttpServlet {
    private ResultExportManager exportManager;

    public void init() throws ServletException {
        this.exportManager = new ResultExportManager(AcroServletBase.getApplDir());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    private void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArcoModelBean model = (ArcoModelBean)req.getSession().getAttribute("MODEL");
        String exportType = req.getParameter("type");
        String orgContentType = "text/html";
        ServletOutputStream out = resp.getOutputStream();
        try {
            String mimeType = this.exportManager.getMimeType(exportType);
            if (mimeType == null) {
                throw new ServletException("Unknown exportTyp " + exportType);
            }
            resp.setContentType(mimeType);
            this.exportManager.export(exportType, model, (OutputStream)out);
        }
        catch (Exception e) {
            SGELog.severe((Throwable)e, "Can''t export result: {0}", (Object)e.getMessage());
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out));
            resp.setContentType("text/html");
            pw.println("<html>");
            pw.println("<body>");
            pw.print("<H1 color='red'> Error </H1>");
            pw.print("Can't export result: " + e.getMessage());
            pw.println("</body>");
            pw.println("</html>");
            pw.flush();
        }
    }
}

