/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.ArcoModelBean;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SGELog.info("entry");
        try {
            ArcoModelBean model = (ArcoModelBean)req.getSession().getAttribute("MODEL");
            JFreeChart chart = model.createChart();
            if (chart == null) {
                throw new IllegalStateException("chart is null");
            }
            resp.setContentType("image/png");
            ServletOutputStream out = resp.getOutputStream();
            ChartPanel chartPanel = new ChartPanel(chart);
            Dimension dim = chartPanel.getPreferredSize();
            ChartUtilities.writeChartAsJPEG((OutputStream)out, (JFreeChart)chart, (int)dim.width, (int)dim.height);
            out.flush();
        }
        catch (Throwable e) {
            SGELog.severe(e, "error {0}", (Object)e);
            req.setAttribute("error", (Object)e);
            RequestDispatcher disp = this.getServletContext().getRequestDispatcher("/reporting/jsp/error.jsp");
            resp.setContentType("text/html");
            disp.forward((ServletRequest)req, (ServletResponse)resp);
            PrintWriter pw = new PrintWriter((OutputStream)resp.getOutputStream());
        }
        finally {
            SGELog.info("exit");
        }
    }
}

