/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting;

import com.sun.grid.arco.QueryManager;
import com.sun.grid.arco.ResultManager;
import com.sun.grid.arco.model.NamedObject;
import com.sun.grid.arco.model.StorageType;
import com.sun.grid.logging.SGEFormatter;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.ArcoModelBean;
import com.sun.grid.reporting.exception.ArcoException;
import com.sun.grid.reporting.export.ResultExportManager;
import com.sun.grid.reporting.sql.ArcoDbConnectionPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;

public class ArcoRun {
    public static final int MODE_EXPORT = 0;
    public static final int MODE_LIST = 1;
    public static final int MODE_HELP = 2;
    public static final int MODE_VERSION = 3;
    public static final String DEFAULT_ARCO_CONFIG_FILE = "/usr/share/webconsole/reporting/config.xml";
    public static final Level DEFAULT_LOG_LEVEL = Level.INFO;
    public static final int OUTPUT_FORMAT_XML = 0;
    public static final int OUTPUT_FORMAT_CSV = 1;
    public static final int OUTPUT_FORMAT_PDF = 2;
    public static final int OUTPUT_FORMAT_HTML = 3;
    private Logger logger;
    private ConsoleHandler consoleHandler;
    private Level logLevel = Level.INFO;
    private File arcoConfigFile = new File("/usr/share/webconsole/reporting/config.xml");
    private File outputFile = null;
    private int outputFormat = 0;
    private Properties latebindings = new Properties();
    private String queryName;
    private int mode = 0;
    private File arcoHome;

    public void run() throws ArcoException, IOException, TransformerException {
        switch (this.mode) {
            case 0: {
                this.export();
                break;
            }
            case 2: {
                this.usage();
                break;
            }
            case 1: {
                this.list();
                break;
            }
            case 3: {
                System.out.println(ArcoRun.getVersion());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode " + this.mode);
            }
        }
    }

    public static String getVersion() {
        return "com.sun.grid.arco - 6u1 - arcorun";
    }

    private void list() {
        ArcoDbConnectionPool dbConnections = ArcoDbConnectionPool.getInstance();
        dbConnections.setConfigurationFile(this.arcoConfigFile.getPath());
        StorageType storage = dbConnections.getConfig().getStorage();
        File storageDir = new File(storage.getRoot());
        File queryDir = new File(storageDir, storage.getQueries());
        QueryManager.createInstance(queryDir, this.getClass().getClassLoader());
        NamedObject[] queries = QueryManager.getInstance().getAvailableObjects();
        for (int i = 0; i < queries.length; ++i) {
            System.out.println(queries[i].getName());
        }
    }

    public void export() throws ArcoException, IOException, TransformerException {
        SGELog.entering(this.getClass(), "run");
        ArcoDbConnectionPool dbConnections = ArcoDbConnectionPool.getInstance();
        dbConnections.setConfigurationFile(this.arcoConfigFile.getPath());
        String user = System.getProperty("user.name");
        ArcoModelBean sessionBean = new ArcoModelBean(user, dbConnections);
        StorageType storage = dbConnections.getConfig().getStorage();
        File storageDir = new File(storage.getRoot());
        File queryDir = new File(storageDir, storage.getQueries());
        File resultDir = new File(storageDir, storage.getResults());
        QueryManager.createInstance(queryDir, this.getClass().getClassLoader());
        ResultManager.createInstance(resultDir, this.getClass().getClassLoader());
        sessionBean.setQuery(this.queryName);
        sessionBean.setInitialvaluesForViewConfiguration();
        if (sessionBean.hasLateBindings()) {
            sessionBean.setLatebindings(this.latebindings);
        }
        sessionBean.executeQuery();
        if (sessionBean.getResult().getLineCount() > 0) {
            ResultExportManager exportManager = new ResultExportManager(this.arcoHome);
            switch (this.outputFormat) {
                case 0: {
                    exportManager.export("xml", sessionBean, this.createOutputStream());
                    break;
                }
                case 1: {
                    exportManager.export("csv", sessionBean, this.createOutputStream());
                    break;
                }
                case 2: {
                    exportManager.export("pdf", sessionBean, this.createOutputStream());
                    break;
                }
                case 3: {
                    exportManager.export("html", sessionBean, this.outputFile);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown output format " + this.outputFormat);
                }
            }
        } else {
            SGELog.warning("ArcoRun.noResult");
        }
        dbConnections.releaseConnections();
        SGELog.exiting(this.getClass(), "run");
    }

    private OutputStream createOutputStream() throws ArcoException {
        try {
            if (this.outputFile == null) {
                return System.out;
            }
            return new FileOutputStream(this.outputFile);
        }
        catch (IOException ioe) {
            throw new ArcoException("ArcoRun.outputFileOpenError", (Throwable)ioe, this.getClass().getName(), new Object[]{ioe.getMessage()});
        }
    }

    private void initLogging() {
        int[] columns = new int[]{8, 6};
        this.logger = Logger.getLogger("arcoLogger", "com.sun.grid.reporting.resources.Resources");
        this.consoleHandler = new ConsoleHandler();
        SGEFormatter formatter = new SGEFormatter("arcorun", true, columns);
        formatter.setDelimiter(": ");
        this.consoleHandler.setFormatter(formatter);
        this.logger.addHandler(this.consoleHandler);
        this.logger.setUseParentHandlers(false);
        SGELog.init(this.logger);
    }

    public static void main(String[] args) {
        ArcoRun app = new ArcoRun();
        app.initLogging();
        int exit = 0;
        try {
            try {
                app.setArguments(args);
            }
            catch (ArcoException ae) {
                SGELog.severe(ae.getLocalizedMessage());
                app.usage();
                exit = -1;
            }
            if (exit == 0) {
                app.run();
            }
        }
        catch (ArcoException ae) {
            SGELog.severe(ae.getLocalizedMessage());
            exit = -2;
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Unexpected Error: {0}", (Object)ex.getMessage());
            ex.printStackTrace();
            exit = -3;
        }
        System.exit(exit);
    }

    public void setArguments(String[] args) throws ArcoException {
        if (args.length < 1) {
            throw new ArcoException("ArcoRun.illegalArgumentCount");
        }
        String arcoHomeStr = System.getProperty("arco.home");
        if (arcoHomeStr == null) {
            throw new ArcoException("ArcoRun.missingArcoHome");
        }
        this.arcoHome = new File(arcoHomeStr);
        if (!this.arcoHome.isDirectory()) {
            throw new ArcoException("ArcoRun.arcoHomeIsNoDirectory", new Object[]{this.arcoHome});
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-c")) {
                if (++i >= args.length) {
                    throw new ArcoException("ArcoRun.arcoConfFileisMissing");
                }
                this.arcoConfigFile = new File(args[i]);
                continue;
            }
            if (args[i].equals("-d")) {
                if (++i >= args.length) {
                    throw new ArcoException("ArcoRun.debugLevelIsMissing");
                }
                try {
                    this.logLevel = Level.parse(args[i]);
                    SGELog.info("set debug level to {0}", (Object)this.logLevel.toString());
                    this.logger.setLevel(this.logLevel);
                    this.consoleHandler.setLevel(this.logLevel);
                    continue;
                }
                catch (IllegalArgumentException ile) {
                    throw new ArcoException("ArcoRun.invalidLogLevel", new Object[]{args[i]});
                }
            }
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    throw new ArcoException("ArcoRun.outputFileMissing");
                }
                this.outputFile = new File(args[i]);
                continue;
            }
            if (args[i].equals("-f")) {
                if (++i >= args.length) {
                    throw new ArcoException("ArcoRun.outputFormatMissing");
                }
                this.outputFormat = ArcoRun.strToOutputFormat(args[i]);
                if (this.outputFormat >= 0) continue;
                throw new ArcoException("ArcoRun.unknownOutputFormat", new Object[]{args[i]});
            }
            if (args[i].equals("-lb")) {
                if (++i >= args.length) {
                    throw new ArcoException("ArcoRun.missingLateBindingParameter");
                }
                int index = args[i].indexOf(61);
                if (index <= 0) {
                    throw new ArcoException("ArcoRun.invalidLateBindingParameter", new Object[]{args[i]});
                }
                String name = args[i].substring(0, index).trim();
                String value = args[i].substring(index + 1, args[i].length()).trim();
                SGELog.fine("late binding {0} = {1}", (Object)name, (Object)value);
                this.latebindings.setProperty(name, value);
                continue;
            }
            if (args[i].equals("-lbfile")) {
                if (++i >= args.length) {
                    throw new ArcoException("ArcoRun.missingLateBindingFile");
                }
                Properties props = new Properties();
                try {
                    FileInputStream fin = new FileInputStream(args[i]);
                    props.load(fin);
                    Enumeration<?> names = props.propertyNames();
                    String name = null;
                    String value = null;
                    while (names.hasMoreElements()) {
                        name = (String)names.nextElement();
                        value = props.getProperty(name);
                        SGELog.fine("late binding {0} = {1}", (Object)name, (Object)value);
                        this.latebindings.setProperty(name, value);
                    }
                    continue;
                }
                catch (IOException ioe) {
                    throw new ArcoException("ArcoRun.latebindingIOError", (Throwable)ioe, new Object[]{args[i], ioe.getMessage()});
                }
            }
            if (args[i].equals("-l")) {
                this.mode = 1;
                continue;
            }
            if (args[i].equals("-help") || args[i].equals("-?")) {
                this.mode = 2;
                continue;
            }
            if (args[i].equals("-v")) {
                this.mode = 3;
                continue;
            }
            if (i == args.length - 1) {
                this.queryName = args[i];
                continue;
            }
            throw new ArcoException("ArcoRun.unknownOption", new Object[]{args[i]});
        }
        if (this.mode == 0) {
            if (this.queryName == null) {
                throw new ArcoException("ArcoRun.missingQueryName");
            }
            if (this.outputFormat == 3) {
                if (this.outputFile == null) {
                    throw new ArcoException("ArcoRun.missingOutputForHTML");
                }
                if (!this.outputFile.isDirectory()) {
                    throw new ArcoException("ArcoRun.invalidOutputForHTML", new Object[]{this.outputFile});
                }
            }
        }
        SGELog.fine("parameters list is ok");
    }

    public static int strToOutputFormat(String str) {
        if (str.equals("xml")) {
            return 0;
        }
        if (str.equals("csv")) {
            return 1;
        }
        if (str.equals("pdf")) {
            return 2;
        }
        if (str.equals("html")) {
            return 3;
        }
        return -1;
    }

    public void usage() {
        System.err.println(ArcoRun.getVersion());
        System.err.println("arcorun  [-c <file>] [-d <debuglevel>]");
        System.err.println("         [-l] [-help] [-?] [-v] [-o <output file>]");
        System.err.println("         [-f <format>] (-lb name=value)* [-lbfile <file>]  <query name> )");
        System.err.println();
        System.err.println("       -l                  list all available query names");
        System.err.println("       -help               print this help message");
        System.err.println("       -v                  print the N1GE ARCo version");
        System.err.println("       -c <file>           path to the configuration file of arco");
        System.err.println("                           (default /usr/share/webconsole/reporting/config.xml)");
        System.err.println("       -d <level>          debug level for arco run (FINE INFO WARING)");
        System.err.println("       -o <output file>    path of the file where the result of the query will be stored");
        System.err.println("                           (default stdout)");
        System.err.println("       -f <format>         format of the output (xml|csv|pdf|html). If the output format");
        System.err.println("                           is html the output file must be a directory.");
        System.err.println("                           (default xml");
        System.err.println("       -lb <name>=<value>  specify the a late binding parameter for the query");
        System.err.println("       -lbfile <file>      where late binding parameters are specified");
        System.err.println("       <query name>        name of the query which should be executed");
        System.err.println();
    }
}

