/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting;

import com.sun.grid.arco.ResultConverter;
import com.sun.grid.arco.model.Configuration;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.AcroModelBeanInterface;
import com.sun.grid.reporting.dob.DataObject;
import com.sun.grid.reporting.dob.ListObject;
import com.sun.grid.reporting.exception.ArcoException;
import com.sun.grid.reporting.model.AdvancedQuery;
import com.sun.grid.reporting.model.DBTableViewConfiguration;
import com.sun.grid.reporting.model.GraphicalViewConfiguration;
import com.sun.grid.reporting.model.LateBinding;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.model.Query;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFieldManager;
import com.sun.grid.reporting.model.QueryFilter;
import com.sun.grid.reporting.model.QueryFilterManager;
import com.sun.grid.reporting.model.QueryProperties;
import com.sun.grid.reporting.model.QuerySortPair;
import com.sun.grid.reporting.model.Result;
import com.sun.grid.reporting.model.SimpleQuery;
import com.sun.grid.reporting.model.ViewConfiguration;
import com.sun.grid.reporting.model.ViewConfigurationManager;
import com.sun.grid.reporting.sql.ArcoDbConnectionPool;
import com.sun.grid.reporting.sql.SQLExecutor;
import com.sun.grid.reporting.sql.SQLTableModel;
import com.sun.grid.reporting.util.FieldFunction;
import com.sun.grid.reporting.util.FilterType;
import com.sun.grid.reporting.util.LogicalConnection;
import com.sun.grid.reporting.util.SortType;
import com.sun.grid.reporting.util.Sorter;
import com.sun.grid.reporting.viewconfiguration.ChartManager;
import com.sun.grid.reporting.viewconfiguration.ChartTypes;
import java.awt.Color;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import org.jfree.chart.JFreeChart;

public class ArcoModelBean
implements AcroModelBeanInterface,
Serializable {
    private static final boolean bDebug = false;
    private ArcoDbConnectionPool dbConnectionPool;
    private SQLExecutor m_SQLExecutor;
    private SQLTableModel m_SQLTableModel;
    private Result m_Result;
    private String m_AdvancedSQLStatement;
    private static int m_counter = -1;
    private Stack m_BreadCrumbStack = null;
    private ViewConfigurationManager m_ViewConfigurationManager = null;
    private SimpleQuery m_SimpleQuery;
    private AdvancedQuery m_AdvancedQuery;
    private PrintWriter log;
    private File f;
    private int m_currentPage = -1;
    private String m_QueryType = "";
    private String m_QueryName = "";
    private boolean m_bActiveQuery = false;
    private boolean m_bNewSimpleQuery = false;
    private String m_ApplicationUser = "initial_unknown";
    private String m_TargetURL = "/jsp/reportingmodule/ResultList.jsp";
    private Locale m_Locale = null;
    private String m_server = "unknown_server";
    private String m_port = "unknown_port";
    private String m_scheme = "unknown_scheme";
    private String m_GraphType = "";
    private String m_X_1 = "";
    private String m_X_2 = "";
    private String m_X_3 = "";
    private String m_X_4 = "";
    private String m_Y = "";
    private String m_Type = "";
    private static int counter = -1;
    private static final String SLASH = System.getProperties().getProperty("file.separator");
    private static final String APP_NAME = "reporting_";
    private String m_SessionID = "";
    QueryProperties m_QueryProperties = null;
    private boolean m_bOverWrite = true;
    private String m_message = "";
    private boolean bAdvancedQuery = false;
    private String m_QueryCategory = "";
    private String m_ImageUrl = "";
    private String m_QueryDescription = "";
    boolean bDontShowLegend = false;
    boolean bDontShowSqlStatement = false;
    boolean bDontShowResultDescription = false;
    boolean bDontShowFilterConditions = false;
    DBTableViewConfiguration m_DBTableViewConfiguration = null;
    PivotViewConfiguration m_PivotViewConfiguration = null;
    GraphicalViewConfiguration m_GraphicalViewConfiguration = null;
    private Vector m_db_src = null;
    private Vector m_db_target = null;
    private Vector m_pivot_src = null;
    private Vector m_pivot_row = null;
    private Vector m_pivot_col = null;
    private Vector m_pivot_dta = null;
    private Vector m_chart_src = null;
    String m_SelectedViewConfiguration = "-1";
    private String m_parent = "/jsp/reportingmodule/Acro.jsp";
    private Vector m_Vector_Table1 = null;
    private DataObject m_TargetUpdate2 = null;
    private DataObject m_TargetUpdate = null;
    private DataObject m_SourceUpdate = null;
    private Vector m_Updater = null;
    private DataObject m_SourceUpdate2 = null;
    private Vector m_Updater2 = null;
    private boolean m_EditMode = false;
    private boolean m_EditMode2 = false;
    private String m_ExportType = "CSV";
    private Vector m_Vector_Table2 = null;
    private Vector m_Vector_LateBinding = null;
    private Vector m_Vector_SortLimit = null;
    private String m_QuerySortCriteria = "none selected";
    private SortType m_QuerySortDirection = SortType.ASC;
    private String m_ResultSortCriteria = "none selected";
    private SortType m_ResultSortDirection = SortType.ASC;
    private boolean m_bIsResultMode = false;
    private String m_ResultType = null;
    private boolean bTabular = true;
    private boolean bGraph = false;
    SortType m_SortType = SortType.ASC;
    private String m_SelectedSortableHeaderName = "none selected";
    private Vector m_Indexer = null;
    private String m_ResultName = "UNKNOWN_RESULT_NAME";
    private String m_ResultDescription = "UNKNOWN_RESULT_DESCRIPTION";
    private String m_ResultCategory = "UNKNOWN_RESULT_CATEGORY";

    public ArcoModelBean(String p_UserName, ArcoDbConnectionPool connectionPool) {
        this.dbConnectionPool = connectionPool;
        this.setApplicationUser(p_UserName);
        this.resetAll();
        this.init();
    }

    public void resetAll() {
        this.setQueryType(null);
        this.setActiveQuery(false);
        this.setResultName("");
        this.setMessage("");
        this.setIsNewSimpleQuery(false);
        this.setSimpleQuery(null);
        this.m_BreadCrumbStack = null;
    }

    public void setRequestLocale(Locale p_Locale) {
        this.m_Locale = p_Locale;
    }

    public Locale getRequestLocale() {
        return this.m_Locale;
    }

    private String getBaseURL() {
        return this.getScheme() + ":" + "//" + this.getServer() + ":" + this.getPort() + "/" + "reporting";
    }

    public void setServer(String p_Server) {
        this.m_server = p_Server;
    }

    public void setPort(String p_port) {
        this.m_port = p_port;
    }

    public void setScheme(String p_scheme) {
        this.m_scheme = p_scheme;
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getPort() {
        return this.m_port;
    }

    public String getServer() {
        return this.m_server;
    }

    public String getType() {
        return this.m_Type;
    }

    public String getX_1() {
        return this.m_X_1;
    }

    public String getX_2() {
        return this.m_X_2;
    }

    public String getX_3() {
        return this.m_X_3;
    }

    public String getX_4() {
        return this.m_X_4;
    }

    public String getY() {
        return this.m_Y;
    }

    private int getCountX() {
        int cnt = 0;
        if (!this.m_X_1.equals("none selected") && !this.m_X_1.equals("")) {
            ++cnt;
        }
        if (!this.m_X_2.equals("none selected") && !this.m_X_2.equals("")) {
            ++cnt;
        }
        if (!this.m_X_3.equals("none selected") && !this.m_X_3.equals("")) {
            ++cnt;
        }
        if (!this.m_X_4.equals("none selected") && !this.m_X_4.equals("")) {
            ++cnt;
        }
        return cnt;
    }

    private String[] getStringArrayOf_X_Data() {
        String[] sa = new String[this.getCountX()];
        int ia = -1;
        if (!this.m_X_1.equals("none selected") && !this.m_X_1.equals("")) {
            sa[++ia] = this.m_X_1;
        }
        if (!this.m_X_2.equals("none selected") && !this.m_X_2.equals("")) {
            sa[++ia] = this.m_X_2;
        }
        if (!this.m_X_3.equals("none selected") && !this.m_X_3.equals("")) {
            sa[++ia] = this.m_X_3;
        }
        if (!this.m_X_4.equals("none selected") && !this.m_X_4.equals("")) {
            sa[++ia] = this.m_X_4;
        }
        if (SGELog.isLoggable(Level.FINER)) {
            for (int i = 0; i < this.getCountX(); ++i) {
                SGELog.finer("sa[" + i + "]={0}", (Object)sa[i]);
            }
        }
        return sa;
    }

    public String checkChart() {
        if (this.m_SQLTableModel == null) {
            return "Sorry -- no data for a graph";
        }
        if (this.m_SQLTableModel.getColumnCount() < 2) {
            return "Need at least 2 columns for drawing a graph !";
        }
        return "";
    }

    public JFreeChart createChart() {
        SGELog.fine("entry");
        if (null == this.m_SQLTableModel) {
            throw new IllegalStateException("SQLTableModel is null/empty");
        }
        int cols = this.m_SQLTableModel.getColumnCount();
        if (cols < 2) {
            throw new IllegalStateException("Need at least 2 columns for drawing a graph !");
        }
        ChartManager manager = ChartManager.getManager();
        JFreeChart chart = null;
        try {
            boolean showLegend;
            boolean bl = showLegend = !this.isHideLegend();
            if (this.m_GraphType.equals("Bar chart")) {
                if (this.getCountX() > 1) {
                    SGELog.fine("X > 1");
                    chart = manager.createChart(this.m_SQLTableModel, ChartTypes.BAR_CHART, this.getStringArrayOf_X_Data(), this.m_Y, Color.WHITE, true, showLegend);
                } else {
                    chart = manager.createChart(this.m_SQLTableModel, ChartTypes.BAR_CHART, this.m_X_1, this.m_Y, Color.WHITE, false, showLegend);
                }
            } else if (this.m_GraphType.equals("Pie chart")) {
                chart = manager.createChart(this.m_SQLTableModel, ChartTypes.PIE_CHART, this.m_X_1, this.m_Y, Color.WHITE, true, showLegend);
            } else if (this.m_GraphType.equals("Line chart")) {
                chart = manager.createChart(this.m_SQLTableModel, ChartTypes.LINE_CHART, this.m_X_1, this.m_Y, this.m_Type, Color.WHITE, false, showLegend);
            } else if (this.m_GraphType.equals("Stacked line chart")) {
                chart = manager.createChart(this.m_SQLTableModel, ChartTypes.STACKED_LINE_CHART, this.m_X_1, this.m_Y, this.m_Type, Color.WHITE, false, showLegend);
            } else {
                throw new IllegalStateException("Unkonwn graph type " + this.m_GraphType);
            }
            SGELog.fine("exit: '{0}'", chart);
            return chart;
        }
        catch (Exception ex) {
            IllegalStateException ilse = new IllegalStateException("Error while create chart: " + ex.getMessage());
            ilse.initCause(ex);
            throw ilse;
        }
    }

    private int getCounter() {
        return ++counter;
    }

    public String getUniqueURL() {
        StringBuffer buf = new StringBuffer();
        buf.append(SLASH);
        buf.append(APP_NAME);
        buf.append(this.getSessionID());
        buf.append(this.getCounter());
        String ret = buf.toString();
        SGELog.fine("return {0}", (Object)ret);
        return ret;
    }

    public String getSessionID() {
        return this.m_SessionID;
    }

    public void setSessionID(String p_SessionID) {
        this.m_SessionID = p_SessionID;
    }

    private String getSessionIdAndCounter() {
        return this.getSessionID() + this.getCounter();
    }

    public String removeQuery(String p_QueryName) throws UnsupportedOperationException {
        try {
            this.m_SQLExecutor.removeQuery(p_QueryName);
        }
        catch (UnsupportedOperationException usoex) {
            SGELog.severe((Throwable)usoex, "removeQuery(String p_QueryName) not implemented: {0}", (Object)p_QueryName);
            return usoex.getMessage();
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "removeQuery(String p_QueryName) Exception ??? {0}", (Object)p_QueryName);
            return ex.getMessage();
        }
        return "";
    }

    public String removeResult(String p_ResultName) throws UnsupportedOperationException {
        try {
            this.m_SQLExecutor.removeResult(p_ResultName);
        }
        catch (UnsupportedOperationException usoex) {
            SGELog.severe(usoex, "removeResult(String p_ResultName) not implemented");
            return usoex.getMessage();
        }
        return "";
    }

    public String deleteQueries(Vector p_Vector) {
        if (p_Vector.isEmpty()) {
            return "[INFO] Can't delete empty selection!";
        }
        int size = p_Vector.size();
        for (int ii = 0; ii < size; ++ii) {
            DataObject dob = (DataObject)p_Vector.get(ii);
            String s = dob.getValue1();
            String msg = this.removeQuery(s);
            if (msg.equals("")) continue;
            return "[ERROR] Delete failed on " + s + " cause:" + msg;
        }
        return "";
    }

    public String deleteResults(List resultList) {
        if (resultList.isEmpty()) {
            return "[INFO] Can't delete empty selection!";
        }
        int size = resultList.size();
        String s = null;
        DataObject dob = null;
        String msg = null;
        for (int ii = 0; ii < size; ++ii) {
            dob = (DataObject)resultList.get(ii);
            s = dob.getValue1();
            SGELog.fine("Try to delete result {0}", (Object)s);
            try {
                msg = this.removeResult(s);
            }
            catch (Exception ex) {
                msg = ex.getMessage();
                SGELog.severe((Throwable)ex, "Error while deleting result {0}: {1}", (Object)s, (Object)msg);
            }
            if (msg.length() <= 0) continue;
            return "[ERROR] Delete failed on " + s + " cause:" + msg;
        }
        return "";
    }

    public String getSqlStatement() {
        if (this.isAdvancedQuery()) {
            return this.m_AdvancedQuery.getSQL();
        }
        return this.m_SimpleQuery.getSQL();
    }

    public String saveAdvancedQuery() {
        try {
            if (null == this.m_AdvancedQuery) {
                this.m_AdvancedQuery = new AdvancedQuery();
            }
            this.m_AdvancedQuery.setBaseTable(this.getQueryType());
            this.m_AdvancedQuery.setSQL(this.getAdvancedSQLStatement());
            this.m_SQLExecutor.saveQuery(this.m_AdvancedQuery);
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "view = {0}, message = {1}", (Object)this.getQueryType(), (Object)ex.getMessage());
            return "[EXCEPTION] MODEL:saveAdvancedQuery Exception occured: view=" + this.getQueryType() + " statement=" + this.getAdvancedSQLStatement() + " message=" + ex.getMessage();
        }
        return "";
    }

    public boolean hasUserWritePermission() {
        Configuration config = this.m_SQLExecutor.getDbConnectionPool().getConfig();
        String currentUser = this.getApplicationUser();
        Iterator iter = config.getApplUser().iterator();
        while (iter.hasNext()) {
            if (!currentUser.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public String saveQuery() {
        if (this.m_SimpleQuery != null) {
            SGELog.fine("save simple query");
            this.m_SQLExecutor.saveQuery(this.m_SimpleQuery);
        } else if (this.m_AdvancedQuery != null) {
            SGELog.fine("save advanced query");
            this.m_SQLExecutor.saveQuery(this.m_AdvancedQuery);
        } else {
            throw new IllegalStateException("simple and advanced query is null");
        }
        return "";
    }

    public String setQueryProperties(QueryProperties p_QueryProperties) {
        p_QueryProperties.setCreationDate(new Date());
        if (this.isAdvancedQuery()) {
            if (this.m_AdvancedQuery == null) {
                SGELog.warning("ADVANCED IS NULL");
                this.m_AdvancedQuery = new AdvancedQuery();
            }
            this.m_AdvancedQuery.setQueryProperties(p_QueryProperties);
        } else {
            this.m_SimpleQuery.setQueryProperties(p_QueryProperties);
        }
        this.setQueryName(p_QueryProperties.getName());
        return "";
    }

    public QueryProperties getQueryProperties() {
        QueryProperties ret = null;
        if (this.isAdvancedQuery()) {
            if (this.m_AdvancedQuery == null) {
                SGELog.warning("ADVANCED IS NULL");
                this.m_AdvancedQuery = new AdvancedQuery();
            }
            if (this.m_AdvancedQuery.getQueryProperties() == null) {
                SGELog.warning("ADVANCED_PROPERTIES ARE NULL");
                this.m_QueryProperties = new QueryProperties();
                this.m_QueryProperties.setName("A_Query_" + this.m_QueryProperties.getCreationDate().toString());
                this.m_QueryProperties.setDescription("Please fill in your description");
                try {
                    this.m_QueryProperties.setImageURL("file:/reporting/arco_files/");
                }
                catch (MalformedURLException mfurlEx) {
                    mfurlEx.printStackTrace();
                }
                this.m_AdvancedQuery.setQueryProperties(this.m_QueryProperties);
            }
            ret = this.m_AdvancedQuery.getQueryProperties();
        } else {
            if (this.m_SimpleQuery.getQueryProperties() == null) {
                SGELog.warning("SIMPLE_PROPERTIES ARE NULL");
                this.m_QueryProperties = new QueryProperties();
                this.m_QueryProperties.setName("S_Query_" + this.m_QueryProperties.getCreationDate().toString());
                this.m_QueryProperties.setDescription("Please fill in your description");
                try {
                    this.m_QueryProperties.setImageURL("file:/reporting/arco_files/");
                }
                catch (MalformedURLException mfurlEx) {
                    mfurlEx.printStackTrace();
                }
                this.m_SimpleQuery.setQueryProperties(this.m_QueryProperties);
            }
            ret = this.m_SimpleQuery.getQueryProperties();
        }
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("returning {0}", (Object)ret.toString());
        }
        return ret;
    }

    public void pushBreadCrumbStack(String p_URL) {
        if (-1 == this.m_BreadCrumbStack.search(p_URL)) {
            this.m_BreadCrumbStack.push(p_URL);
            SGELog.fine("push {0}", (Object)p_URL);
        }
        this.showBreadCrumbStack();
    }

    public void popBreadCrumbStack() {
        if (!this.m_BreadCrumbStack.empty()) {
            String s = (String)this.m_BreadCrumbStack.pop();
            SGELog.fine("pop {0}", (Object)s);
        } else {
            SGELog.fine("empty");
        }
        this.showBreadCrumbStack();
    }

    public void showBreadCrumbStack() {
        if (SGELog.isLoggable(Level.FINER)) {
            int size = this.m_BreadCrumbStack.size();
            String s = null;
            for (int ii = 0; ii < size; ++ii) {
                s = (String)this.m_BreadCrumbStack.get(ii);
                SGELog.finer("bread crump: {0}", (Object)s);
            }
        }
    }

    public Stack getBreadCrumbStack() {
        Stack<String> st = new Stack<String>();
        int size = this.m_BreadCrumbStack.size();
        for (int ii = 0; ii < size; ++ii) {
            String s = (String)this.m_BreadCrumbStack.get(ii);
            st.add(ii, s);
        }
        return st;
    }

    public void removeFromBreadCrumbStack(String p_removeMe) {
        this.m_BreadCrumbStack.remove(p_removeMe);
    }

    public void clearBreadCrumbStack() {
        this.m_BreadCrumbStack.clear();
    }

    public void setOverWrite(boolean p_bOverWrite) {
        this.m_bOverWrite = p_bOverWrite;
    }

    public boolean getOverWrite() {
        return this.m_bOverWrite;
    }

    public boolean checkIfQueryExists(String p_queryName) {
        try {
            SGELog.fine("checkIfQueryExists {0}", (Object)p_queryName);
            Query q = this.m_SQLExecutor.loadQuery(p_queryName);
            if (null == q) {
                this.setOverWrite(true);
                return false;
            }
            this.setOverWrite(false);
            return true;
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception checkIfQueryExists: {0}", (Object)ex);
            this.setOverWrite(false);
            return true;
        }
    }

    public String checkQueryOrResultName(String p_QueryName) {
        boolean bError = false;
        if (null == p_QueryName || p_QueryName.equals("")) {
            return "[INFO] A name may not be empty";
        }
        String file_err_msg = "[INFO] A name mustn't contain ";
        int iFound = 0;
        iFound = p_QueryName.indexOf("?", 0);
        if (-1 != iFound) {
            file_err_msg = file_err_msg + "'?' ";
            bError = true;
        }
        if (-1 != (iFound = p_QueryName.indexOf("|", 0))) {
            file_err_msg = file_err_msg + "'|' ";
            bError = true;
        }
        if (-1 != (iFound = p_QueryName.indexOf("[", 0))) {
            file_err_msg = file_err_msg + "'[' ";
            bError = true;
        }
        if (-1 != (iFound = p_QueryName.indexOf("]", 0))) {
            file_err_msg = file_err_msg + "']' ";
            bError = true;
        }
        if (-1 != (iFound = p_QueryName.indexOf("/", 0))) {
            file_err_msg = file_err_msg + "'/' ";
            bError = true;
        }
        if (-1 != (iFound = p_QueryName.indexOf("\\", 0))) {
            file_err_msg = file_err_msg + "'' ";
            bError = true;
        }
        if (-1 != (iFound = p_QueryName.indexOf("<", 0))) {
            file_err_msg = file_err_msg + "'<' ";
            bError = true;
        }
        if (-1 != (iFound = p_QueryName.indexOf(">", 0))) {
            file_err_msg = file_err_msg + "'>'";
            bError = true;
        }
        if (bError) {
            return file_err_msg;
        }
        return "";
    }

    public boolean checkIfResultExists(String p_resultName) {
        try {
            Result r = this.m_SQLExecutor.loadResult(p_resultName);
            if (null == r) {
                this.setOverWrite(true);
                return false;
            }
            this.setOverWrite(false);
            return true;
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            return true;
        }
    }

    public String getAdvancedSQLStatement() {
        return this.m_AdvancedSQLStatement;
    }

    public void setAdvancedSQLStatement(String p_AdvancedSQLStatement) {
        this.m_AdvancedSQLStatement = p_AdvancedSQLStatement;
    }

    public String getApplicationUser() {
        return this.m_ApplicationUser;
    }

    public void setApplicationUser(String p_ApplicationUser) {
        this.m_ApplicationUser = new String(p_ApplicationUser);
    }

    public void setCounterTest(int p_counter) {
        m_counter = p_counter;
    }

    public int getCounterTest() {
        return m_counter;
    }

    public void init() {
        this.m_SQLExecutor = new SQLExecutor(this.dbConnectionPool);
        this.m_SQLExecutor.setApplicationUser(this.getApplicationUser());
        this.m_SimpleQuery = new SimpleQuery(this.dbConnectionPool.getSQLGenerator());
        this.m_BreadCrumbStack = new Stack();
    }

    public void setMessage(String message) {
        this.m_message = message;
    }

    public String getMastHeadHref() {
        Stack stack = this.getBreadCrumbStack();
        int size = stack.size();
        String toURL = (String)stack.elementAt(0);
        if (toURL.equals("QueryList")) {
            return "ResultList";
        }
        if (toURL.equals("ResultList")) {
            return "QueryList";
        }
        return "[FIXME] MODEL:getMastHeadHref can't find HREF for Masthead!";
    }

    public String getMessage() {
        return this.m_message;
    }

    public boolean isAdvanced() {
        if (this.getResultMode()) {
            if (null != this.m_Result) {
                return this.m_Result.isAdvanced();
            }
            return false;
        }
        return this.isAdvancedQuery();
    }

    public boolean isAdvancedQuery() {
        return this.bAdvancedQuery;
    }

    public void setAdvancedQuery(boolean p_AdvancedQuery) {
        this.bAdvancedQuery = p_AdvancedQuery;
    }

    public String setQuery(String p_QueryName) {
        try {
            if (null == p_QueryName || p_QueryName.equals("")) {
                return "[ERROR] QueryName is empty or null";
            }
            Query query = this.m_SQLExecutor.loadQuery(p_QueryName);
            if (query == null) {
                return "[ERROR] Query with name " + p_QueryName + " not found";
            }
            this.setQueryType(query.getBaseTable());
            if (query.isAdvancedQuery()) {
                this.m_AdvancedQuery = (AdvancedQuery)query;
                this.setSimpleQuery(null);
                this.setAdvancedQuery(true);
                this.setAdvancedSQLStatement(this.m_AdvancedQuery.getUnparsedSQL());
                SGELog.fine("set advanced query {0}", (Object)p_QueryName);
            } else {
                this.setSimpleQuery((SimpleQuery)query);
                this.m_AdvancedQuery = null;
                this.setAdvancedQuery(false);
                this.setAdvancedSQLStatement(null);
                SGELog.fine("set simple query {0}", (Object)p_QueryName);
            }
            this.setQueryName(p_QueryName);
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception occured: {0}", (Object)ex);
            return "[ERROR] MODEL:setQuery Exception occured:" + ex.getMessage();
        }
        return "";
    }

    public void setQueryName(String p_QueryName) {
        this.m_QueryName = p_QueryName;
    }

    public String getQueryName() {
        return this.m_QueryName;
    }

    public String getImageUrl() {
        return this.m_ImageUrl;
    }

    public String getQueryDescription() {
        return this.m_QueryDescription;
    }

    public void setImageUrl(String p_ImageUrl) {
        this.m_ImageUrl = p_ImageUrl;
    }

    public List getFieldListForViewConfiguration() {
        ArrayList<String> ret = null;
        if (this.getResultMode()) {
            ret = new ArrayList<String>();
            Iterator it = this.m_SQLTableModel.getColumnNames().iterator();
            while (it.hasNext()) {
                String s = it.next().toString();
                if (s.startsWith("\"")) {
                    s = s.substring(1);
                }
                if (s.endsWith("\"")) {
                    s = s.substring(0, s.length() - 1);
                }
                ret.add(s);
            }
        } else {
            ret = this.getSelectedFields();
        }
        return ret;
    }

    public List getFieldList(String table) throws SQLException {
        List<String> ret = null;
        if (null == table || table.equals("")) {
            ret = new ArrayList<String>();
            ret.add("select a view");
            return ret;
        }
        ret = this.m_SQLExecutor.getFieldList(table);
        return ret;
    }

    public List getSelectedFields() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator it = null;
        QueryFieldManager fieldManager = null;
        fieldManager = this.isAdvancedQuery() ? this.m_AdvancedQuery.getFieldManager() : this.m_SimpleQuery.getFieldManager();
        if (fieldManager == null) {
            SGELog.warning("query has not a fieldManager");
        } else {
            it = fieldManager.fields();
        }
        if (it != null) {
            try {
                while (it.hasNext()) {
                    QueryField queryField = (QueryField)it.next();
                    if (null == queryField) {
                        SGELog.warning("get an empty selected field");
                        continue;
                    }
                    String s = queryField.getName();
                    if (s == null) {
                        s = queryField.generateName();
                    }
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    ret.add(s);
                }
            }
            catch (Exception ex) {
                SGELog.severe((Throwable)ex, "Execption {0}", (Object)ex.getMessage());
            }
        } else {
            SGELog.warning("no selected fields");
        }
        return ret;
    }

    public boolean getValueShowLegend() {
        return this.bDontShowLegend;
    }

    public boolean getValueShowSqlStatement() {
        return this.bDontShowSqlStatement;
    }

    public boolean getValueShowFilterConditions() {
        return this.bDontShowFilterConditions;
    }

    public boolean getValueShowResultDescription() {
        return this.bDontShowResultDescription;
    }

    public String setValueShowLegend(boolean bDontShow) {
        this.bDontShowLegend = bDontShow;
        return "";
    }

    public String setValueShowSqlStatement(boolean bDontShow) {
        this.bDontShowSqlStatement = bDontShow;
        return "";
    }

    public String setValueShowFilterConditions(boolean bDontShow) {
        this.bDontShowFilterConditions = bDontShow;
        return "";
    }

    public String setValueShowResultDescription(boolean bDontShow) {
        this.bDontShowResultDescription = bDontShow;
        return "";
    }

    public boolean isHideLegend() {
        if (null == this.m_GraphicalViewConfiguration) {
            return true;
        }
        ChartTypes ct = this.m_GraphicalViewConfiguration.getChartType();
        if (null == ct) {
            return true;
        }
        return this.m_GraphicalViewConfiguration.isHideLegend();
    }

    public boolean isHideLegendAllowed() {
        if (this.getGraphType().equals("Bar chart")) {
            return true;
        }
        if (this.getGraphType().equals("Line chart")) {
            return true;
        }
        if (this.getGraphType().equals("Pie chart")) {
            return true;
        }
        if (this.getGraphType().equals("Stacked line chart")) {
            return true;
        }
        if (null == this.m_GraphicalViewConfiguration) {
            return false;
        }
        return this.m_GraphicalViewConfiguration.isHideLegendAllowed();
    }

    public String setHideLegend(boolean hideLegend) {
        if (null == this.m_GraphicalViewConfiguration) {
            return "[INFO] Can't hide a legend for a nonexisting GraphicalViewConfiguration";
        }
        ChartTypes ct = this.m_GraphicalViewConfiguration.getChartType();
        if (ct.getName().startsWith("P")) {
            return "[INFO] You can't hide a legend for a piechart !";
        }
        this.m_GraphicalViewConfiguration.setHideLegend(hideLegend);
        return "";
    }

    public boolean isHideDescription() {
        return this.m_ViewConfigurationManager.isHideDescription();
    }

    public boolean isHideParameter() {
        if (this.isAdvanced()) {
            return true;
        }
        return this.m_ViewConfigurationManager.isHideParameter();
    }

    public boolean isHideSQLStatement() {
        return this.m_ViewConfigurationManager.isHideSQLStatement();
    }

    public boolean isValid() {
        return this.m_ViewConfigurationManager.isValid();
    }

    public void setHideDescription(boolean hideDescription) {
        this.m_ViewConfigurationManager.setHideDescription(hideDescription);
    }

    public void setHideParameter(boolean hideParameter) {
        this.m_ViewConfigurationManager.setHideParameter(hideParameter);
    }

    public void setHideSQLStatement(boolean hideSQLStatement) {
        this.m_ViewConfigurationManager.setHideSQLStatement(hideSQLStatement);
    }

    public Vector getVectorForSelectedFields() {
        Vector<String> v = new Vector<String>();
        Iterator it = this.m_SimpleQuery != null && !this.isAdvancedQuery() ? this.m_SimpleQuery.getFieldManager().fields() : this.m_AdvancedQuery.getFieldManager().fields();
        if (null != it) {
            try {
                while (it.hasNext()) {
                    QueryField queryField = (QueryField)it.next();
                    if (queryField == null) continue;
                    String s = queryField.getName();
                    if (s == null) {
                        s = queryField.generateName();
                    }
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    v.add(s);
                }
            }
            catch (Exception ex) {
                SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            }
        } else {
            SGELog.warning("No selected fields");
        }
        return v;
    }

    public Vector getVectorForViewConfiguration() {
        if (this.getResultMode()) {
            return new Vector(this.m_SQLTableModel.getColumnNames());
        }
        return this.getVectorForSelectedFields();
    }

    public String checkViewConfiguration(String ViewFirst, String ViewSecond, String ViewThird) {
        String msg = "";
        if ((msg = msg + this.checkSelectedViews(ViewFirst, ViewSecond, ViewThird)).equals("")) {
            if (ViewFirst.equals("Database table") || ViewSecond.equals("Database table") || ViewThird.equals("Database table")) {
                msg = msg + this.checkDbViewConfiguration();
            }
            if (ViewFirst.equals("Pivot table") || ViewSecond.equals("Pivot table") || ViewThird.equals("Pivot table")) {
                msg = msg + this.checkPivotViewConfiguration();
            }
        }
        return msg;
    }

    private String checkSelectedViews(String ViewFirst, String ViewSecond, String ViewThird) {
        String msg = "";
        if (ViewFirst.equals("none selected") && ViewSecond.equals("none selected") && ViewThird.equals("none selected")) {
            return msg;
        }
        if (ViewSecond.equals("none selected") && ViewThird.equals("none selected")) {
            return msg;
        }
        if (ViewSecond.equals("none selected") && !ViewThird.equals("none selected")) {
            return "[INFO] Selecting a 3rd view requires a 2nd view !";
        }
        if (ViewFirst.equals(ViewSecond)) {
            return "[INFO] The 1st and 2nd view must be different!";
        }
        if (ViewFirst.equals(ViewThird)) {
            return "[INFO] The 1st and 3rd view must be different!";
        }
        if (ViewSecond.equals(ViewThird)) {
            return "[INFO] The 2nd and 3rd view must be different!";
        }
        return msg;
    }

    public String checkDbViewConfiguration() {
        if (0 < this.m_db_target.size()) {
            return "";
        }
        return " [INFO] dbtable no entry selected !";
    }

    public String checkFirstAdd(String FieldFunction2, String FieldName, String AdditionalParameter, String UserDefinedName) {
        int i;
        DataObject dob;
        String msg = "";
        Vector v = this.getDataTable1();
        if (v == null) {
            return "";
        }
        int size = v.size();
        if (UserDefinedName.length() > 0) {
            boolean bInfo = false;
            for (int i2 = 0; i2 < size; ++i2) {
                dob = (DataObject)v.get(i2);
                if (!dob.getValue1().equals(FieldFunction2) || !dob.getValue2().equals(FieldName)) continue;
                if (dob.getValue4().equals(UserDefinedName)) {
                    return "[ERROR] MODEL:checkFirstAdd(1) the selected field is not unique.";
                }
                bInfo = true;
            }
            if (bInfo) {
                return "[INFO] MODEL:checkFirstAdd(1) Detected duplicate entries  for " + FieldFunction2 + " and " + FieldName + " !";
            }
        }
        for (i = 0; i < size; ++i) {
            dob = (DataObject)v.get(i);
            if (!dob.getValue1().equals(FieldFunction2) || !dob.getValue2().equals(FieldName) || !dob.getValue4().equals(UserDefinedName)) continue;
            return "[ERROR] MODEL:checkFirstAdd(2) the selected field is not unique.";
        }
        for (i = 0; i < size; ++i) {
            dob = (DataObject)v.get(i);
            if (!dob.getValue1().equals(FieldFunction2) || !dob.getValue2().equals(FieldName) || dob.getValue4().equals(UserDefinedName)) continue;
            return "[ERROR] MODEL:checkFirstAdd(3) the selected field is not unique.";
        }
        return "";
    }

    public String checkPivotViewConfiguration() {
        if (0 < this.m_pivot_row.size() && 0 < this.m_pivot_col.size() && 1 == this.m_pivot_dta.size()) {
            return "";
        }
        if (0 < this.m_pivot_row.size() && 0 < this.m_pivot_col.size() && 0 < this.m_pivot_dta.size()) {
            return "";
        }
        if (0 == this.m_pivot_row.size() && 0 == this.m_pivot_col.size() && 0 == this.m_pivot_dta.size()) {
            return "";
        }
        return " [INFO] Pivot: select n entries for row and col, only one entry for data";
    }

    public String checkChartViewConfiguration(String GraphType, String X_1, String X_2, String X_3, String X_4, String Y, String Type2) {
        this.m_GraphType = GraphType;
        this.m_X_1 = X_1;
        this.m_X_2 = X_2;
        this.m_X_3 = X_3;
        this.m_X_4 = X_4;
        this.m_Y = Y;
        this.m_Type = Type2;
        if (this.m_GraphType.equals("Bar chart")) {
            if (this.m_Y.equals("none selected") || this.m_Y.equals("")) {
                return "[INFO] Bar chart y missing !";
            }
            if ((this.m_X_1.equals("none selected") || this.m_X_1.equals("")) && (this.m_X_2.equals("none selected") || this.m_X_2.equals("")) && (this.m_X_3.equals("none selected") || this.m_X_3.equals("")) && (this.m_X_4.equals("none selected") || this.m_X_4.equals(""))) {
                return "[INFO] Bar chart At least one X must be specified ! !";
            }
        } else if (this.m_GraphType.equals("Pie chart")) {
            if (this.m_Y.equals("none selected") || this.m_Y.equals("")) {
                return "[INFO] Pie chart y missing !";
            }
            if (this.m_X_1.equals("none selected") || this.m_X_1.equals("")) {
                return "[INFO] Pie chart X must be specified ! !";
            }
        } else if (this.m_GraphType.equals("Line chart")) {
            if (this.m_Y.equals("none selected") || this.m_Y.equals("")) {
                return "[INFO] Line chart y missing !";
            }
            if (this.m_X_1.equals("none selected") || this.m_X_1.equals("")) {
                return "[INFO] Line chart X must be specified ! !";
            }
            if (null == this.m_Type || this.m_Type.equals("none selected") || this.m_Type.equals("")) {
                return "[INFO] Line chart Type must be specified ! !";
            }
        } else if (this.m_GraphType.equals("Stacked line chart")) {
            if (this.m_Y.equals("none selected") || this.m_Y.equals("")) {
                return "[INFO] Stacked line chart y missing !";
            }
            if (this.m_X_1.equals("none selected") || this.m_X_1.equals("")) {
                return "[INFO] Stacked line chart X must be specified ! !";
            }
            if (null == this.m_Type || this.m_Type.equals("none selected") || this.m_Type.equals("")) {
                return "[INFO] Stacked line chart Type must be specified ! !";
            }
        } else {
            return "[INFO] Unknown charttype !";
        }
        return "";
    }

    private int View2ViewNumber(String view) {
        if (view.equals("none selected")) {
            return 0;
        }
        if (view.equals("Database table")) {
            return 1;
        }
        if (view.equals("Pivot table")) {
            return 2;
        }
        if (view.equals("Graphical presentation")) {
            return 3;
        }
        return -1;
    }

    public String getVisibleViewconfiguration(int p_index) {
        Integer theIndex = new Integer(p_index);
        SGELog.fine("entry p_index = {0}", theIndex);
        ViewConfiguration vc = null;
        if (null == this.m_ViewConfigurationManager) {
            SGELog.fine("m_ViewConfigurationManager is null => nothing selected");
            return "none selected";
        }
        vc = this.m_ViewConfigurationManager.getViewConfigurationAt(p_index);
        int type = this.m_ViewConfigurationManager.getViewConfigurationTypeAt(p_index);
        SGELog.fine("found type {0} at index {1}", new Integer(type), (Object)theIndex);
        if (null == vc) {
            SGELog.fine("vc is null => nothing selected");
            return "none selected";
        }
        try {
            if (vc instanceof GraphicalViewConfiguration) {
                if (null == this.m_ViewConfigurationManager.getViewConfiguration(type)) {
                    SGELog.fine("NONE_SELECTED PRESENTATIONLIST_GRAPHICAL_PRESENTATION");
                    return "none selected";
                }
                SGELog.fine("PRESENTATIONLIST_GRAPHICAL_PRESENTATION");
                return "Graphical presentation";
            }
            if (vc instanceof PivotViewConfiguration) {
                if (null == this.m_ViewConfigurationManager.getViewConfiguration(type)) {
                    SGELog.fine("NONE_SELECTED PRESENTATIONLIST_PIVOT_TABLE");
                    return "none selected";
                }
                SGELog.fine("PRESENTATIONLIST_PIVOT_TABLE");
                return "Pivot table";
            }
            if (vc instanceof DBTableViewConfiguration) {
                if (null == this.m_ViewConfigurationManager.getViewConfiguration(type)) {
                    SGELog.fine("NONE_SELECTED PRESENTATIONLIST_DATABASE_TABLE");
                    return "none selected";
                }
                SGELog.fine("NONE_SELECTED PRESENTATIONLIST_DATABASE_TABLE");
                return "Database table";
            }
        }
        catch (IllegalArgumentException iaex) {
            SGELog.severe((Throwable)iaex, "Exception {0}", (Object)iaex);
            return "[EXCEPTION] MODEL:getVisibleViewconfiguration index=" + p_index + " type=" + type + " " + iaex.getMessage();
        }
        return "[ERROR] No type of viewconfiguration specified - default gets db-table.";
    }

    public String saveViewConfiguration(String ViewFirst, String ViewSecond, String ViewThird, boolean hide_description, boolean hide_filter, boolean hide_sql, boolean hide_legend) {
        SGELog.fine("entry: first = ''{0}'', second = ''{1}'', third = ''{2}", (Object)ViewFirst, (Object)ViewSecond, (Object)ViewThird);
        try {
            String entry;
            Iterator it;
            if (null == this.m_ViewConfigurationManager) {
                this.m_ViewConfigurationManager = new ViewConfigurationManager();
                SGELog.fine("new ViewConfigurationManager");
            }
            this.setHideDescription(hide_description);
            this.setHideParameter(hide_filter);
            this.setHideSQLStatement(hide_sql);
            if (0 < this.m_db_target.size()) {
                this.m_DBTableViewConfiguration = new DBTableViewConfiguration();
                it = this.m_db_target.iterator();
                if (null != it) {
                    while (it.hasNext()) {
                        entry = (String)it.next();
                        this.m_DBTableViewConfiguration.addColumn(entry);
                    }
                }
                this.m_ViewConfigurationManager.setViewConfiguration(this.m_DBTableViewConfiguration, 1);
            } else {
                this.m_ViewConfigurationManager.setViewConfiguration(null, 1);
            }
            if (0 < this.m_pivot_row.size() && 0 < this.m_pivot_col.size() && 0 < this.m_pivot_dta.size() && 10 >= this.m_pivot_dta.size()) {
                Iterator setIt;
                Iterator itt;
                this.m_PivotViewConfiguration = new PivotViewConfiguration();
                it = this.m_pivot_row.iterator();
                if (null != it) {
                    while (it.hasNext()) {
                        entry = (String)it.next();
                        this.m_PivotViewConfiguration.addRowAttribute(entry);
                        SGELog.fine("PIVOT: row = {0}", (Object)entry);
                    }
                }
                if (null != (itt = this.m_pivot_col.iterator())) {
                    while (itt.hasNext()) {
                        String entry2 = (String)itt.next();
                        this.m_PivotViewConfiguration.addColumnAttribute(entry2);
                        SGELog.fine("PIVOT: col = {0}", (Object)entry2);
                    }
                }
                if (null != (setIt = this.m_pivot_dta.iterator())) {
                    while (setIt.hasNext()) {
                        String entry3 = (String)setIt.next();
                        this.m_PivotViewConfiguration.addDataAttribute(entry3);
                        SGELog.fine("PIVOT: data = {0}", (Object)entry3);
                    }
                }
                try {
                    if (!this.m_PivotViewConfiguration.isValid()) {
                        SGELog.fine("PIVOT: ###NOT_VALID####!");
                        return "[INFO] MODEL:saveViewConfiguration PIVOT is not valid !";
                    }
                    SGELog.fine("PIVOT is valid");
                }
                catch (IllegalStateException ilsex) {
                    SGELog.warning(ilsex, "###NOT_VALID####!");
                    return "[EXCEPTION] MODEL:saveViewConfiguration PIVOT is not valid !" + ilsex.getMessage();
                }
                this.m_ViewConfigurationManager.setViewConfiguration(this.m_PivotViewConfiguration, 2);
            } else {
                this.m_ViewConfigurationManager.setViewConfiguration(null, 2);
            }
            if (this.m_GraphType.equals("Bar chart")) {
                this.m_GraphicalViewConfiguration = new GraphicalViewConfiguration();
                this.m_GraphicalViewConfiguration.setCharType(ChartTypes.BAR_CHART);
                this.m_GraphicalViewConfiguration.setHideLegend(hide_legend);
                this.m_GraphicalViewConfiguration.setYValue(this.m_Y);
                if (!this.m_X_1.equals("none selected") && !this.m_X_1.equals("")) {
                    this.m_GraphicalViewConfiguration.addXValue(this.m_X_1);
                }
                if (!this.m_X_2.equals("none selected") && !this.m_X_2.equals("")) {
                    this.m_GraphicalViewConfiguration.addXValue(this.m_X_2);
                }
                if (!this.m_X_3.equals("none selected") && !this.m_X_3.equals("")) {
                    this.m_GraphicalViewConfiguration.addXValue(this.m_X_3);
                }
                if (!this.m_X_4.equals("none selected") && !this.m_X_4.equals("")) {
                    this.m_GraphicalViewConfiguration.addXValue(this.m_X_4);
                }
                this.m_ViewConfigurationManager.setViewConfiguration(this.m_GraphicalViewConfiguration, 3);
            } else if (this.m_GraphType.equals("Pie chart")) {
                this.m_GraphicalViewConfiguration = new GraphicalViewConfiguration();
                this.m_GraphicalViewConfiguration.setCharType(ChartTypes.PIE_CHART);
                this.m_GraphicalViewConfiguration.setHideLegend(hide_legend);
                this.m_GraphicalViewConfiguration.setYValue(this.m_Y);
                this.m_GraphicalViewConfiguration.addXValue(this.m_X_1);
                this.m_ViewConfigurationManager.setViewConfiguration(this.m_GraphicalViewConfiguration, 3);
            } else if (this.m_GraphType.equals("Line chart")) {
                this.m_GraphicalViewConfiguration = new GraphicalViewConfiguration();
                this.m_GraphicalViewConfiguration.setCharType(ChartTypes.LINE_CHART);
                this.m_GraphicalViewConfiguration.setHideLegend(hide_legend);
                this.m_GraphicalViewConfiguration.setYValue(this.m_Y);
                this.m_GraphicalViewConfiguration.addXValue(this.m_X_1);
                this.m_GraphicalViewConfiguration.setType(this.m_Type);
                this.m_ViewConfigurationManager.setViewConfiguration(this.m_GraphicalViewConfiguration, 3);
            } else if (this.m_GraphType.equals("Stacked line chart")) {
                this.m_GraphicalViewConfiguration = new GraphicalViewConfiguration();
                this.m_GraphicalViewConfiguration.setCharType(ChartTypes.STACKED_LINE_CHART);
                this.m_GraphicalViewConfiguration.setHideLegend(hide_legend);
                this.m_GraphicalViewConfiguration.setYValue(this.m_Y);
                this.m_GraphicalViewConfiguration.addXValue(this.m_X_1);
                this.m_GraphicalViewConfiguration.setType(this.m_Type);
                this.m_ViewConfigurationManager.setViewConfiguration(this.m_GraphicalViewConfiguration, 3);
            } else {
                this.m_ViewConfigurationManager.setViewConfiguration(null, 3);
            }
            if (!this.m_ViewConfigurationManager.isValid()) {
                return "[ERROR] The configuration is not valid for an unknown reason !";
            }
            this.setViewConfiguration(this.m_ViewConfigurationManager);
            this.m_ViewConfigurationManager.setVisibleViewconfiguration(this.View2ViewNumber(ViewFirst), 0);
            this.m_ViewConfigurationManager.setVisibleViewconfiguration(this.View2ViewNumber(ViewSecond), 1);
            this.m_ViewConfigurationManager.setVisibleViewconfiguration(this.View2ViewNumber(ViewThird), 2);
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "[Exception] {0}", (Object)ex);
            return "[Exception] MODEL:saveViewConfiguration" + ex.getMessage();
        }
        return "";
    }

    private Vector adjustSource(Vector p_src, Vector p_target) {
        if (p_target != null) {
            p_src.removeAll(p_target);
        }
        return p_src;
    }

    public Vector getSelectedDbColumns() {
        return this.m_db_target;
    }

    public String setInitialvaluesForViewConfiguration() {
        this.m_db_src = new Vector();
        this.m_db_target = new Vector();
        this.m_pivot_src = new Vector();
        this.m_pivot_row = new Vector();
        this.m_pivot_col = new Vector();
        this.m_pivot_dta = new Vector();
        this.m_chart_src = new Vector();
        this.setSelectedViewConfiguration("0");
        this.m_ViewConfigurationManager = this.getViewConfiguration();
        if (null == this.m_ViewConfigurationManager) {
            this.m_ViewConfigurationManager = new ViewConfigurationManager();
            this.m_pivot_src = this.getVectorForViewConfiguration();
            this.m_db_src = this.getVectorForViewConfiguration();
            this.m_chart_src = this.getVectorForViewConfiguration();
            this.setSelectedViewConfiguration("0");
        } else {
            this.m_pivot_src = this.getVectorForViewConfiguration();
            this.m_db_src = this.getVectorForViewConfiguration();
            this.m_chart_src = this.getVectorForViewConfiguration();
            if (null != this.m_ViewConfigurationManager.getViewConfiguration(1)) {
                this.m_DBTableViewConfiguration = (DBTableViewConfiguration)this.m_ViewConfigurationManager.getViewConfiguration(1);
                this.m_db_target = this.m_DBTableViewConfiguration.getColumns();
                this.adjustSource(this.m_db_src, this.m_db_target);
            }
            if (null != this.m_ViewConfigurationManager.getViewConfiguration(2)) {
                Iterator findIt;
                Iterator itt;
                this.m_PivotViewConfiguration = (PivotViewConfiguration)this.m_ViewConfigurationManager.getViewConfiguration(2);
                Iterator it = this.m_PivotViewConfiguration.columnAttributes();
                if (null != it) {
                    while (it.hasNext()) {
                        String entry = (String)it.next();
                        this.m_pivot_col.add(entry);
                    }
                }
                if (null != (itt = this.m_PivotViewConfiguration.rowAttributes())) {
                    while (itt.hasNext()) {
                        String entry = (String)itt.next();
                        this.m_pivot_row.add(entry);
                    }
                }
                if (null != (findIt = this.m_PivotViewConfiguration.dataAttributes())) {
                    while (findIt.hasNext()) {
                        String entry = (String)findIt.next();
                        this.m_pivot_dta.add(entry);
                    }
                }
                this.adjustSource(this.m_pivot_src, this.m_pivot_col);
                this.adjustSource(this.m_pivot_src, this.m_pivot_row);
                this.adjustSource(this.m_pivot_src, this.m_pivot_dta);
            }
            if (null == this.m_ViewConfigurationManager.getViewConfiguration(3)) {
                SGELog.fine("m_GraphType = NONE_SELECTED ");
                this.setGraphType("none selected");
            } else {
                this.m_GraphicalViewConfiguration = (GraphicalViewConfiguration)this.m_ViewConfigurationManager.getViewConfiguration(3);
                ChartTypes ct = this.m_GraphicalViewConfiguration.getChartType();
                if (ct.getName().startsWith("B")) {
                    this.m_GraphType = ct.getName();
                } else if (ct.getName().startsWith("P")) {
                    this.m_GraphType = ct.getName();
                } else if (ct.getName().startsWith("L")) {
                    this.m_GraphType = ct.getName();
                } else if (ct.getName().startsWith("S")) {
                    this.m_GraphType = ct.getName();
                } else {
                    this.setGraphType("none selected");
                }
                this.m_Y = this.m_GraphicalViewConfiguration.getYValue();
                this.m_Type = this.m_GraphicalViewConfiguration.getType();
                this.m_X_1 = "none selected";
                this.m_X_2 = "none selected";
                this.m_X_3 = "none selected";
                this.m_X_4 = "none selected";
                if (null != this.m_GraphicalViewConfiguration.getXValues()) {
                    Vector v = this.m_GraphicalViewConfiguration.getXValues();
                    int v_size = v.size();
                    for (int i = 0; i < v_size; ++i) {
                        if (0 == i) {
                            this.m_X_1 = (String)v.get(i);
                        }
                        if (1 == i) {
                            this.m_X_2 = (String)v.get(i);
                        }
                        if (2 == i) {
                            this.m_X_3 = (String)v.get(i);
                        }
                        if (3 != i) continue;
                        this.m_X_4 = (String)v.get(i);
                    }
                }
            }
            if (null == this.m_ViewConfigurationManager.getDefaultViewConfiguration()) {
                this.setSelectedViewConfiguration("0");
            } else {
                ViewConfiguration vc = this.m_ViewConfigurationManager.getDefaultViewConfiguration();
                if (vc instanceof GraphicalViewConfiguration) {
                    this.setSelectedViewConfiguration("3");
                } else if (vc instanceof PivotViewConfiguration) {
                    this.setSelectedViewConfiguration("2");
                } else if (vc instanceof DBTableViewConfiguration) {
                    this.setSelectedViewConfiguration("1");
                } else {
                    this.setSelectedViewConfiguration("-1");
                    return "[ERROR] No type of viewconfiguration specified - default gets db-table.";
                }
            }
        }
        return "";
    }

    public String getGraphType() {
        return this.m_GraphType;
    }

    public void setGraphType(String p_GraphType) {
        this.m_GraphType = p_GraphType;
    }

    public String getSelectedViewConfiguration() {
        this.m_ViewConfigurationManager = this.getViewConfiguration();
        if (null == this.m_ViewConfigurationManager) {
            SGELog.fine("no view conifguration manager");
            return "0";
        }
        ViewConfiguration vc = this.m_ViewConfigurationManager.getDefaultViewConfiguration();
        if (vc == null) {
            SGELog.fine("no default view");
            return "0";
        }
        if (vc instanceof GraphicalViewConfiguration) {
            SGELog.fine("selected view is a graph");
            this.setSelectedViewConfiguration("3");
        } else if (vc instanceof PivotViewConfiguration) {
            SGELog.fine("selected view if pivot");
            this.setSelectedViewConfiguration("2");
        } else if (vc instanceof DBTableViewConfiguration) {
            SGELog.fine("selected view is table");
            this.setSelectedViewConfiguration("1");
        } else {
            SGELog.warning("strange state => no view selected ");
            this.setSelectedViewConfiguration("0");
        }
        return this.m_SelectedViewConfiguration;
    }

    public void setSelectedViewConfiguration(String p_conf) {
        this.m_SelectedViewConfiguration = p_conf;
    }

    public List getListForDbSrc() {
        return this.m_db_src;
    }

    public List getListForDbTarget() {
        return this.m_db_target;
    }

    public void add2DbSrc(String p_Entry) {
        this.m_db_src.add(p_Entry);
    }

    public void add2DbTarget(String p_Entry) {
        this.m_db_target.add(p_Entry);
    }

    public boolean removeFromDbSrc(String p_Entry) {
        return this.m_db_src.removeElement(p_Entry);
    }

    public boolean removeFromDbTarget(String p_Entry) {
        return this.m_db_target.remove(p_Entry);
    }

    public List getListForSrc() {
        return this.m_pivot_src;
    }

    public List getListForRow() {
        return this.m_pivot_row;
    }

    public List getListForCol() {
        return this.m_pivot_col;
    }

    public List getListForDta() {
        return this.m_pivot_dta;
    }

    public void add2Src(String p_Entry) {
        this.m_pivot_src.add(p_Entry);
    }

    public String add2Col(String p_Entry) {
        if (this.m_pivot_col.size() < 2) {
            this.m_pivot_col.add(p_Entry);
            return "";
        }
        return "[INFO] Couldn't add entry because the maximum of entries has been reached .";
    }

    public String add2Row(String p_Entry) {
        if (this.m_pivot_row.size() < 2) {
            this.m_pivot_row.add(p_Entry);
            return "";
        }
        return "[INFO] Couldn't add entry because the maximum of entries has been reached .";
    }

    public String add2Dta(String p_Entry) {
        if (this.m_pivot_dta.size() < 10) {
            this.m_pivot_dta.add(p_Entry);
            return "";
        }
        return "[INFO] Couldn't add entry because the maximum of entries has been reached .";
    }

    public boolean removeFromSrc(String p_Entry) {
        return this.m_pivot_src.removeElement(p_Entry);
    }

    public boolean removeFromRow(String p_Entry) {
        return this.m_pivot_row.remove(p_Entry);
    }

    public boolean removeFromCol(String p_Entry) {
        return this.m_pivot_col.remove(p_Entry);
    }

    public boolean removeFromDta(String p_Entry) {
        return this.m_pivot_dta.remove(p_Entry);
    }

    public List getListForChart() {
        return this.m_chart_src;
    }

    private String setViewConfiguration(ViewConfigurationManager p_ViewConfigurationManager) {
        try {
            if (this.getResultMode()) {
                this.m_Result.setViewConfigurationManager(p_ViewConfigurationManager);
            } else if (this.isAdvancedQuery()) {
                this.m_AdvancedQuery.setViewConfigurationManager(p_ViewConfigurationManager);
            } else {
                this.m_SimpleQuery.setViewConfigurationManager(p_ViewConfigurationManager);
            }
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            return "[EXCEPTION] MODEL:setViewConfiguration Except. occured-" + ex.getMessage();
        }
        return "";
    }

    public boolean hasViewConfigurationManagerChanged() {
        ViewConfigurationManager vm = this.getViewConfiguration();
        return vm.hasDataChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    private ViewConfigurationManager getViewConfiguration() {
        ViewConfigurationManager ret = null;
        if (this.getResultMode()) {
            if (null != this.m_Result) {
                SGELog.fine("-------ResultMode--NOT NULL---");
                ret = this.m_Result.getViewConfigurationManager();
            } else {
                SGELog.fine("-------ResultMode--NULL !!---");
                ret = this.m_ViewConfigurationManager = new ViewConfigurationManager();
            }
        } else if (this.isAdvancedQuery()) {
            if (null == this.m_AdvancedQuery) {
                SGELog.fine("-------ADVANCED--NULL !!---");
                this.m_ViewConfigurationManager = new ViewConfigurationManager();
                return this.m_ViewConfigurationManager;
            }
            SGELog.fine("-------ADVANCED--NOT NULL---");
            ret = this.m_AdvancedQuery.getViewConfigurationManager();
        } else if (null != this.m_SimpleQuery) {
            SGELog.fine("-------SIMPLE--NOT NULL----");
            ret = this.m_SimpleQuery.getViewConfigurationManager();
        } else {
            SGELog.fine("-------SIMPLE--NULL !!----");
            ret = this.m_ViewConfigurationManager = new ViewConfigurationManager();
        }
        SGELog.fine("returning viewconfiguration manager {0}", (Object)ret.getAddress());
        return ret;
    }

    public DBTableViewConfiguration getDBTableViewConfiguration() {
        ViewConfigurationManager vcm = this.getViewConfiguration();
        return (DBTableViewConfiguration)vcm.getViewConfiguration(1);
    }

    public PivotViewConfiguration getPivotViewConfiguration() {
        ViewConfigurationManager vcm = this.getViewConfiguration();
        return (PivotViewConfiguration)vcm.getViewConfiguration(2);
    }

    public void setQueryDescription(String p_QueryDescription) {
        this.m_QueryDescription = p_QueryDescription;
    }

    public void setParentURL(String parent) {
        this.m_parent = parent;
    }

    public String getParentURL() {
        return this.m_parent;
    }

    public String getPage(String p_direction) {
        return "[INFO] getPage:requested " + p_direction;
    }

    public void setTargetURL(String p_TargetURL) {
        this.m_TargetURL = p_TargetURL;
    }

    public String getTargetURL() {
        return this.m_TargetURL;
    }

    public void setIsNewSimpleQuery(boolean p_bNewSimpleQuery) {
        this.m_bNewSimpleQuery = p_bNewSimpleQuery;
    }

    public boolean isNewSimpleQuery() {
        return this.m_bNewSimpleQuery;
    }

    public String isQueryEmpty() {
        Vector v = this.getDataTable1();
        if (null == v || v.isEmpty()) {
            return "[ERROR] Empty queries can't be saved nor configured  !";
        }
        return "";
    }

    private void setSimpleQuery(SimpleQuery p_SimpleQuery) {
        SGELog.fine("simple query is {0}", p_SimpleQuery);
        this.m_SimpleQuery = p_SimpleQuery;
    }

    public SimpleQuery getSimpleQuery() {
        return this.m_SimpleQuery;
    }

    public boolean isLateBinded() {
        Vector v = this.getDataTable2();
        int size = v.size();
        DataObject dob = null;
        for (int ii = 0; ii < size; ++ii) {
            dob = (DataObject)v.get(ii);
            if (!Boolean.valueOf(dob.getValue5()).booleanValue() || Boolean.valueOf(dob.getValue6()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Query getActiveQuery() {
        if (this.isAdvancedQuery()) {
            return this.m_AdvancedQuery;
        }
        return this.m_SimpleQuery;
    }

    public void setLatebindings(Properties lateBinding) throws ArcoException {
        this.getActiveQuery().setLatebindings(lateBinding);
    }

    public boolean hasLateBindings() {
        return this.getActiveQuery().hasLateBindings();
    }

    public String executeSQL(String p_sql) throws SQLException {
        try {
            if (null == this.m_AdvancedQuery) {
                SGELog.warning("advanced query is null");
                this.m_AdvancedQuery = new AdvancedQuery();
            }
            this.m_AdvancedQuery.setSQL(p_sql);
            boolean rescue_IsAdvancedQuery = this.isAdvancedQuery();
            this.setAdvancedQuery(true);
            String msg = this.executeQuery();
            this.setAdvancedQuery(rescue_IsAdvancedQuery);
            if (msg.length() > 0) {
                return msg;
            }
            this.m_SQLTableModel = this.m_SQLExecutor.getResult();
        }
        catch (ArcoException aex) {
            SGELog.severe((Throwable)aex, "Exception {0}", (Object)aex.getMessage());
            return aex.getLocalizedMessage(this.getRequestLocale());
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            return "[EXCEPTION] MODEL:executeSQL" + ex.getMessage();
        }
        return "";
    }

    public boolean hasAdvancedLateBindings(String p_advancedStatement) {
        this.setMessage("");
        if (null == this.m_AdvancedQuery) {
            this.m_AdvancedQuery = new AdvancedQuery();
        }
        try {
            this.m_AdvancedQuery.setSQL(p_advancedStatement);
            return this.m_AdvancedQuery.hasLateBindings();
        }
        catch (ArcoException aex) {
            SGELog.severe((Throwable)aex, "Exception {0}", (Object)aex.getMessage());
            this.setMessage(aex.getLocalizedMessage(this.getRequestLocale()) + " " + p_advancedStatement);
            return false;
        }
    }

    public String executeQuery() {
        try {
            if (!this.isAdvancedQuery() && !this.getParentURL().equals("/jsp/reportingmodule/AdvancedQuery.jsp")) {
                SGELog.fine("simple query");
                if (null == this.m_SimpleQuery) {
                    return "[ERROR] SimpleQuery isNull!";
                }
                if (0 == this.m_SimpleQuery.getFieldManager().getFieldCount()) {
                    return "[ERROR] can't execute empty SimpleQuery!";
                }
                this.m_SQLExecutor.executeQuery(this.m_SimpleQuery);
            } else {
                SGELog.fine("advanced query");
                if (null == this.m_AdvancedQuery) {
                    return "[ERROR] AdvancedQuery isNull!";
                }
                if (null == this.m_AdvancedQuery.getSQL() || this.m_AdvancedQuery.getSQL().length() == 0) {
                    return "[ERROR] can't execute empty AdvancedQuery!";
                }
                SGELog.fine("sql = {0}", (Object)this.m_AdvancedQuery.getSQL());
                this.m_SQLExecutor.executeQuery(this.m_AdvancedQuery);
            }
        }
        catch (SQLException sqlex) {
            SGELog.severe((Throwable)sqlex, "SQLException errorCode = {0}, sqlState = {1}", (Object)new Integer(sqlex.getErrorCode()), (Object)sqlex.getSQLState());
            if (this.isAdvancedQuery()) {
                return "[ERROR] (advanced) SQLException in MODEL:executeQuery() occured: msg=" + sqlex.getMessage() + " code=" + sqlex.getErrorCode() + " state=" + sqlex.getSQLState() + " statement=" + this.m_AdvancedQuery.getSQL();
            }
            return "[ERROR] (simple) SQLException in MODEL:executeQuery() occured: msg=" + sqlex.getMessage() + " code=" + sqlex.getErrorCode() + " state=" + sqlex.getSQLState() + " statement=" + this.m_SimpleQuery.getSQL();
        }
        this.m_SQLTableModel = this.m_SQLExecutor.getResult();
        this.createResult(this.m_SQLTableModel);
        return "";
    }

    private void createResult(SQLTableModel m_SQLTableModel) {
        this.m_Result = new Result();
        this.m_Result.setValue(m_SQLTableModel);
        this.initPaging("none selected");
    }

    public Vector getDataTable1() {
        this.m_Vector_Table1 = new Vector();
        Iterator it = this.isAdvancedQuery() || null == this.m_SimpleQuery ? this.m_AdvancedQuery.getFieldManager().fields() : this.m_SimpleQuery.getFieldManager().fields();
        QueryField qf = null;
        DataObject dob = null;
        while (it.hasNext()) {
            qf = (QueryField)it.next();
            dob = new DataObject();
            dob.setValue1(qf.getAggregateFunction().getName());
            dob.setValue2(qf.getDbFieldName());
            if (qf.getAdditionalParameter() != null) {
                dob.setValue3(qf.getAdditionalParameter());
            } else {
                dob.setValue3("");
            }
            if (qf.getName() != null) {
                if (qf.getName().equals(qf.getDbFieldName())) {
                    dob.setValue4("");
                } else {
                    dob.setValue4(qf.getName());
                }
            } else {
                dob.setValue4("");
            }
            this.m_Vector_Table1.add(dob);
        }
        return this.m_Vector_Table1;
    }

    public Vector getDataTable2() {
        this.m_Vector_Table2 = new Vector();
        if (this.m_SimpleQuery != null) {
            Iterator it = this.m_SimpleQuery.getFilterManager().iterator();
            QueryFilter qfilter = null;
            DataObject dob = null;
            QueryField qfield = null;
            while (it.hasNext()) {
                qfilter = (QueryFilter)it.next();
                dob = new DataObject();
                try {
                    dob.setValue1(qfilter.getLogicalConnection().getName());
                }
                catch (NullPointerException npex) {
                    dob.setValue1("");
                }
                qfield = qfilter.getField();
                if (qfield == null) {
                    this.setMessage("[ERROR] MODEL:getDataTable2 QueryField is null");
                    dob.setValue1("[ERROR] val1 qfield is null");
                    dob.setValue2("[ERROR] val2 qfield is null");
                    dob.setValue3("[ERROR] val3 qfield is null");
                    this.m_Vector_Table2.add(dob);
                    return this.m_Vector_Table2;
                }
                if (null == qfield.getName() || qfield.getName().equals("")) {
                    dob.setValue2(qfield.generateName());
                } else {
                    dob.setValue2(qfield.getName());
                }
                dob.setValue3(qfilter.getFilterType().getName());
                if (qfilter.getParameter() != null) {
                    dob.setValue4(qfilter.getParameter());
                } else {
                    dob.setValue4("");
                }
                if (qfilter.isLateBinding()) {
                    dob.setValue5("true");
                } else {
                    dob.setValue5("false");
                }
                if (qfilter.isActivated()) {
                    dob.setValue6("false");
                } else {
                    dob.setValue6("true");
                }
                this.m_Vector_Table2.add(dob);
            }
        }
        return this.m_Vector_Table2;
    }

    public String setDataTable2(Vector v) {
        if (this.m_Vector_Table2 == null) {
            this.m_Vector_Table2 = new Vector();
        }
        this.m_Vector_Table2.clear();
        QueryFilterManager qfm = new QueryFilterManager();
        int size = v.size();
        DataObject dob = null;
        String s = null;
        int ii = 0;
        int dd = 0;
        while (ii < size) {
            QueryFilter qfilter;
            block12: {
                dob = (DataObject)v.get(ii);
                qfilter = new QueryFilter();
                if ((ii == 0 || 0 == dd) && (s = dob.getValue1()).length() > 0) {
                    this.setMessage("[INFO] Removed logical connection for the first filter :" + dob.getValue1() + " " + dob.getValue2());
                    dob.setValue1("");
                }
                try {
                    qfilter.setLogicalConnection(LogicalConnection.getLogicalConnectionByName(dob.getValue1()));
                }
                catch (IllegalArgumentException iaex) {
                    if (ii <= 0 || false == dd) break block12;
                    return "[INFO] Please select a logical connection for this filter!";
                }
            }
            QueryField qfield = null;
            qfield = this.m_SimpleQuery.getFieldManager().getFieldByUserName(dob.getValue2());
            if (null == qfield) {
                --dd;
            } else {
                this.m_Vector_Table2.add((DataObject)v.get(ii));
                qfilter.setField(qfield);
                try {
                    qfilter.setFilterType(FilterType.getFilterTypeByName(dob.getValue3()));
                }
                catch (IllegalArgumentException iaex) {
                    return "[INFO] " + iaex.getMessage();
                }
                try {
                    if (null != dob.getValue4()) {
                        qfilter.setParameter(dob.getValue4());
                    }
                }
                catch (IllegalArgumentException iaex) {
                    return "[INFO] " + iaex.getMessage();
                }
                qfilter.setLateBinding(Boolean.valueOf(dob.getValue5()));
                qfilter.setActivated(Boolean.valueOf(dob.getValue6()) == false);
                qfm.addFilter(qfilter);
            }
            ++ii;
            ++dd;
        }
        this.m_SimpleQuery.setFilterManager(qfm);
        return "";
    }

    public boolean getDebug(String view) {
        if (view.equals("QueryList")) {
            return false;
        }
        if (view.equals("AdvancedQuery")) {
            return false;
        }
        if (view.equals("LateBinding")) {
            return false;
        }
        if (view.equals("ResultList")) {
            return false;
        }
        if (view.equals("ResultView")) {
            return false;
        }
        if (view.equals("SaveQuery")) {
            return false;
        }
        if (view.equals("SaveResult")) {
            return false;
        }
        if (view.equals("SimpleQuery")) {
            return false;
        }
        return !view.equals("ViewConfiguration");
    }

    public String setUpdateObject2(DataObject p_dob) {
        this.m_TargetUpdate2 = p_dob;
        return "";
    }

    public String setUpdateObject(DataObject p_dob) {
        this.m_TargetUpdate = p_dob;
        return "";
    }

    public String UpdateObject(DataObject p_dob) {
        this.m_Updater = new Vector();
        if (null == this.m_Vector_Table1) {
            return "[ERROR] ###MODEL:UpdateObject null ==m_Vector_Table1";
        }
        if (null == this.m_TargetUpdate) {
            return "[ERROR] ###MODEL:UpdateObject null ==m_TargetUpdate";
        }
        int size = this.m_Vector_Table1.size();
        DataObject dataObject = null;
        for (int i = 0; i < size; ++i) {
            dataObject = (DataObject)this.m_Vector_Table1.get(i);
            String val1 = this.m_TargetUpdate.getValue1();
            String val2 = this.m_TargetUpdate.getValue2();
            String val3 = this.m_TargetUpdate.getValue3();
            String val4 = this.m_TargetUpdate.getValue4();
            String dob1 = dataObject.getValue1();
            String dob2 = dataObject.getValue2();
            String dob3 = dataObject.getValue3();
            String dob4 = dataObject.getValue4();
            if (val1.equals(dob1) && val2.equals(dob2) && val3.equals(dob3) && val4.equals(dob4)) {
                DataObject update_dataObject = new DataObject();
                update_dataObject.setValue1(p_dob.getValue1());
                update_dataObject.setValue2(p_dob.getValue2());
                update_dataObject.setValue3(p_dob.getValue3());
                update_dataObject.setValue4(p_dob.getValue4());
                this.m_Updater.add(update_dataObject);
                continue;
            }
            this.m_Updater.add(dataObject);
        }
        return this.setDataTable1(this.m_Updater);
    }

    public String UpdateObject2(DataObject p_dob) {
        this.m_Updater2 = new Vector();
        if (null == this.m_Vector_Table2) {
            return "[ERROR] ###MODEL:UpdateObject null ==m_Vector_Table2";
        }
        if (null == this.m_TargetUpdate2) {
            return "[ERROR] ###MODEL:UpdateObject null ==m_TargetUpdate2";
        }
        int size = this.m_Vector_Table2.size();
        for (int i = 0; i < size; ++i) {
            DataObject dataObject2 = new DataObject();
            dataObject2 = (DataObject)this.m_Vector_Table2.get(i);
            String val1 = this.m_TargetUpdate2.getValue1();
            String val2 = this.m_TargetUpdate2.getValue2();
            String val3 = this.m_TargetUpdate2.getValue3();
            String val4 = this.m_TargetUpdate2.getValue4();
            String val5 = this.m_TargetUpdate2.getValue5();
            String val6 = this.m_TargetUpdate2.getValue6();
            String dob1 = dataObject2.getValue1();
            String dob2 = dataObject2.getValue2();
            String dob3 = dataObject2.getValue3();
            String dob4 = dataObject2.getValue4();
            String dob5 = dataObject2.getValue5();
            String dob6 = dataObject2.getValue6();
            if (val1.equals(dob1) && val2.equals(dob2) && val3.equals(dob3) && val4.equals(dob4) && val5.equals(dob5) && val6.equals(dob6)) {
                DataObject update_dataObject2 = new DataObject();
                update_dataObject2.setValue1(p_dob.getValue1());
                update_dataObject2.setValue2(p_dob.getValue2());
                update_dataObject2.setValue3(p_dob.getValue3());
                update_dataObject2.setValue4(p_dob.getValue4());
                update_dataObject2.setValue5(p_dob.getValue5());
                update_dataObject2.setValue6(p_dob.getValue6());
                this.m_Updater2.add(update_dataObject2);
                continue;
            }
            this.m_Updater2.add(dataObject2);
        }
        String msg = this.setDataTable2(this.m_Updater2);
        return msg;
    }

    public String setDataTable1(Vector v) {
        Vector<QueryField> qfm = new Vector<QueryField>();
        this.m_Vector_Table1 = new Vector();
        int size = v.size();
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("entry: v.size = {0}", new Integer(size));
        }
        FieldFunction function = null;
        String value = null;
        for (int ii = 0; ii < size; ++ii) {
            this.m_Vector_Table1.add((DataObject)v.get(ii));
            DataObject dob = new DataObject();
            dob = (DataObject)v.get(ii);
            QueryField qf = new QueryField();
            value = dob.getValue1();
            function = FieldFunction.getFieldFunctionByName(value);
            SGELog.fine("getValue1() = ''{0}''", (Object)value);
            SGELog.fine("fieldFunction = ''{0}''", function);
            qf.setAggregateFunction(function);
            SGELog.fine("getAggregateFunction()Name = ''{0}''", (Object)qf.getAggregateFunction().getName());
            SGELog.fine("getAggregateFunction()= ''{0}''", qf.getAggregateFunction());
            value = dob.getValue2();
            SGELog.fine("DBFieldName = ''{0}''", (Object)value);
            qf.setDbFieldName(value);
            value = dob.getValue3();
            if (value != null && value.length() > 0) {
                qf.setAdditionalParameter(value);
                SGELog.fine("AdditionalParameter = {0}", (Object)value);
            }
            if ((value = dob.getValue4()) != null && value.length() > 0) {
                qf.setName(value);
                SGELog.fine("Logical Name = ''{0}''", (Object)value);
            }
            qfm.add(qf);
        }
        try {
            this.m_SimpleQuery.getFieldManager().update(qfm);
        }
        catch (IllegalArgumentException ia) {
            SGELog.warning((Throwable)ia, "Illegal argument: {0}", (Object)ia.getMessage());
            return ia.getMessage();
        }
        catch (IllegalStateException ist) {
            SGELog.warning((Throwable)ist, "Illegal State: {0}", (Object)ist.getMessage());
            return ist.getMessage();
        }
        catch (Exception ex) {
            SGELog.warning((Throwable)ex, "Unknown exception {0}", (Object)ex);
            return ex.getMessage();
        }
        return "";
    }

    public boolean getEditMode() {
        return this.m_EditMode;
    }

    public void setEditMode(boolean p_bState) {
        this.m_EditMode = p_bState;
    }

    public boolean getEditMode2() {
        return this.m_EditMode2;
    }

    public void setEditMode2(boolean p_bState) {
        this.m_EditMode2 = p_bState;
    }

    public String getExportType() {
        return this.m_ExportType;
    }

    public void setExportType(String p_ExportType) {
        this.m_ExportType = p_ExportType;
    }

    public Result getResult() {
        String a_sql;
        Result a_result = new Result();
        QueryProperties a_properties = new QueryProperties();
        String a_name = null;
        if (this.getResultMode()) {
            a_name = this.getResultName();
        } else {
            a_name = this.getQueryName();
            if (a_name.length() == 0) {
                a_name = "UNKNOWN";
            }
        }
        a_properties.setName(a_name);
        a_properties.setCategory(this.getResultCategory());
        a_properties.setDescription(this.getResultViewDescription());
        a_result.setProperties(a_properties);
        a_result.setValue(this.m_SQLTableModel);
        String[] paramList = new String[]{""};
        if (this.isAdvancedQuery()) {
            a_sql = this.m_AdvancedQuery.getSQL();
            SGELog.warning(" not implemented : m_AdvancedQuery.generateParameterArray()");
        } else {
            a_sql = this.m_SimpleQuery.getSQL();
            paramList = this.m_SimpleQuery.generateParameterArray();
        }
        a_result.setSQLStatement(a_sql);
        a_result.setParameterList(paramList);
        if (null == this.m_ViewConfigurationManager) {
            this.setInitialvaluesForViewConfiguration();
        }
        a_result.setViewConfigurationManager(this.getViewConfiguration());
        return a_result;
    }

    public com.sun.grid.arco.model.Result getXMLResult() {
        Result result = this.getReadyResult();
        result.setViewConfigurationManager(this.getViewConfiguration());
        String str = result.getProperties().getName();
        if (str == null || str.equals("UNKNOWN") || str.startsWith("[Error")) {
            str = this.getQueryName();
        }
        result.getProperties().setName(str);
        str = result.getProperties().getDescription();
        if (str == null || str.equals("UNKNOWN") || str.startsWith("[Error")) {
            str = this.getQueryName();
        }
        result.getProperties().setName(str);
        com.sun.grid.arco.model.Result ret = ResultConverter.toXML(result);
        ret.setSql(this.getSqlStatement());
        ret.setCategory(this.getCategory());
        return ret;
    }

    public Result getReadyResult() {
        Result result = this.m_Result;
        if (result == null) {
            result = new Result();
            result.setValue(this.m_SQLTableModel);
            result.setProperties(this.m_QueryProperties);
        }
        return result;
    }

    protected String buildExportURL(String file, int exportType) {
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"");
        sb.append(file);
        sb.append("\"");
        sb.append(" title=\"result_pdf\">");
        switch (exportType) {
            case 501: {
                sb.append("The result as CSV");
                sb.append("</a>");
                break;
            }
            case 502: {
                sb.append("The result as PDF");
                sb.append("</a>");
                break;
            }
            default: {
                sb = new StringBuffer();
                sb.append("The selected export is not supported");
            }
        }
        return sb.toString();
    }

    public String getExportName() {
        if (this.getResultMode()) {
            return this.getResultName() + "_" + this.getCategory();
        }
        return (this.getQueryName().equals("") ? "UNKNOWN" : this.getQueryName()) + "_" + this.getCategory();
    }

    public Vector getDataLateBinding() {
        if (null == this.m_Vector_LateBinding) {
            this.m_Vector_LateBinding = new Vector();
        }
        if (this.getParentURL().equals("/jsp/reportingmodule/AdvancedQuery.jsp")) {
            this.m_Vector_LateBinding.clear();
            Vector v = new Vector();
            v = this.m_AdvancedQuery.getLatebindings();
            int size = v.size();
            for (int ii = 0; ii < size; ++ii) {
                LateBinding lb = (LateBinding)v.get(ii);
                DataObject dob = new DataObject();
                dob.setIndex(ii);
                dob.setValue2(lb.getAttribute());
                dob.setValue3(lb.getOperator());
                dob.setValue4(lb.getValue());
                dob.setValue5("true");
                this.m_Vector_LateBinding.add(dob);
            }
            return this.m_Vector_LateBinding;
        }
        if (this.getResultMode()) {
            this.m_Vector_LateBinding = new Vector();
            return this.m_Vector_LateBinding;
        }
        this.m_Vector_LateBinding.clear();
        Vector v = this.getDataTable2();
        int size = v.size();
        for (int ii = 0; ii < size; ++ii) {
            DataObject dob = new DataObject();
            dob = (DataObject)v.get(ii);
            dob.setIndex(ii);
            this.m_Vector_LateBinding.add(dob);
        }
        return this.m_Vector_LateBinding;
    }

    public void setDataLateBinding(Vector v) {
        if (null == this.m_Vector_LateBinding) {
            this.m_Vector_LateBinding = new Vector();
        }
        this.m_Vector_LateBinding.clear();
        this.m_Vector_LateBinding.addAll(v);
        if (this.getParentURL().equals("/jsp/reportingmodule/AdvancedQuery.jsp")) {
            if (this.m_AdvancedQuery.hasLateBindings()) {
                Vector lb = this.m_AdvancedQuery.getLatebindings();
                LateBinding[] lateBinding = new LateBinding[lb.size()];
                for (int i = 0; i < lb.size(); ++i) {
                    DataObject dob = new DataObject();
                    dob = (DataObject)v.get(i);
                    lateBinding[i] = (LateBinding)((LateBinding)lb.get(i)).clone();
                    lateBinding[i].setValue(dob.getValue4());
                }
                this.m_AdvancedQuery.replaceLateBindings(lateBinding);
            }
        } else {
            this.setDataTable2(this.m_Vector_LateBinding);
        }
    }

    private boolean compareDataTable2(Vector v_new) {
        int v_new_size;
        Vector v_old = this.getDataTable2();
        DataObject d_old = null;
        DataObject d_new = null;
        int v_old_size = v_old.size();
        if (v_old_size != (v_new_size = v_new.size())) {
            return false;
        }
        for (int ii = 0; ii < v_old_size; ++ii) {
            d_old = (DataObject)v_old.get(ii);
            d_new = (DataObject)v_new.get(ii);
            if (d_old.getValue1().equals(d_new.getValue1()) && d_old.getValue2().equals(d_new.getValue2()) && d_old.getValue3().equals(d_new.getValue3()) && d_old.getValue4().equals(d_new.getValue4()) && d_old.getValue5().equals(d_new.getValue5()) && d_old.getValue6().equals(d_new.getValue6())) continue;
            return false;
        }
        return true;
    }

    private boolean compareDataTable1(Vector v_new) {
        int v_new_size;
        Vector v_old = new Vector();
        v_old = this.getDataTable1();
        DataObject d_old = new DataObject();
        DataObject d_new = new DataObject();
        int v_old_size = v_old.size();
        if (v_old_size != (v_new_size = v_new.size())) {
            return false;
        }
        for (int ii = 0; ii < v_old_size; ++ii) {
            d_old = (DataObject)v_old.get(ii);
            d_new = (DataObject)v_new.get(ii);
            if (d_old.getValue1().equals(d_new.getValue1()) && d_old.getValue2().equals(d_new.getValue2()) && d_old.getValue3().equals(d_new.getValue3()) && d_old.getValue4().equals(d_new.getValue4())) continue;
            return false;
        }
        return true;
    }

    private boolean compareDataSortLimit(Vector v_new) {
        Vector v_old = this.getDataSortLimit();
        DataObject d_old = null;
        DataObject d_new = null;
        d_old = (DataObject)v_old.get(0);
        d_new = (DataObject)v_new.get(0);
        if (d_old.getValue1().equals(d_new.getValue1()) && d_old.getValue3().equals(d_new.getValue3()) && d_old.getValue4().equals(d_new.getValue4())) {
            return d_old.getValue2().equals("none selected") && d_new.getValue2().equals("") || d_old.getValue2().equals(d_new.getValue2());
        }
        return false;
    }

    public String setDataSortLimit(Vector v) {
        if (null == this.m_Vector_SortLimit) {
            this.m_Vector_SortLimit = new Vector();
        }
        this.m_Vector_SortLimit.clear();
        QuerySortPair qsp = new QuerySortPair();
        DataObject dob = (DataObject)v.get(0);
        if (dob.getValue1().equals("true")) {
            String s = dob.getValue2();
            if (s.equals("none selected") || s.equals("")) {
                return "[ERROR] MODELL:Sort by - parameter is missing !";
            }
            if (this.isAdvancedQuery()) {
                return "[ERROR] MODELL:Sort by - only for Simple Queries !";
            }
            QueryField qf = this.m_SimpleQuery.getFieldManager().getFieldByUserName(dob.getValue2());
            qsp.setField(qf);
            this.m_SimpleQuery.setSort(qsp);
        } else {
            this.m_SimpleQuery.setSort((QuerySortPair)null);
        }
        if (dob.getValue3().equals("true")) {
            try {
                Integer integer = new Integer(dob.getValue4());
                this.m_SimpleQuery.setRowLimit(integer);
            }
            catch (NumberFormatException nfex) {
                String msg = "[ERROR] MODELL:setDataSortLimit unparsable integer in limit :" + dob.getValue4();
                return msg;
            }
        } else {
            this.m_SimpleQuery.setRowLimit(0);
            dob.setValue4("");
        }
        this.m_Vector_SortLimit.add(dob);
        return "";
    }

    public Vector getDataSortLimit() {
        DataObject dob = new DataObject();
        if (null == this.m_Vector_SortLimit) {
            this.m_Vector_SortLimit = new Vector();
        }
        this.m_Vector_SortLimit.clear();
        QuerySortPair qsp = this.m_SimpleQuery.getSort();
        int i = this.m_SimpleQuery.getRowLimit();
        if (null == qsp && 0 == i) {
            return this.m_Vector_SortLimit;
        }
        if (null != qsp) {
            QueryField qf = qsp.getField();
            if (null == qf) {
                dob.setValue1("false");
                dob.setValue2("none selected");
            } else {
                dob.setValue1("true");
                String s = qf.getName();
                dob.setValue2(s != null ? s : qf.generateName());
            }
        } else {
            dob.setValue1("false");
            dob.setValue2("none selected");
        }
        if (0 != i) {
            dob.setValue3("true");
            try {
                Integer integer = new Integer(i);
                dob.setValue4(integer.toString());
            }
            catch (NumberFormatException nfex) {
                dob.setValue4("invalid number for limit - please correct !");
            }
        } else {
            dob.setValue3("false");
            dob.setValue4("");
        }
        this.m_Vector_SortLimit.add(dob);
        return this.m_Vector_SortLimit;
    }

    public String getQuerySortCriteria() {
        return this.m_QuerySortCriteria;
    }

    public SortType getQuerySortDirection() {
        return this.m_QuerySortDirection;
    }

    public String getResultSortCriteria() {
        return this.m_ResultSortCriteria;
    }

    public SortType getResultSortDirection() {
        return this.m_ResultSortDirection;
    }

    public void setQuerySortCriteria(String p_criteria) {
        this.m_QuerySortCriteria = p_criteria;
    }

    public void setQuerySortDirection(SortType p_direction) {
        this.m_QuerySortDirection = p_direction;
    }

    public void setResultSortCriteria(String p_criteria) {
        this.m_ResultSortCriteria = p_criteria;
    }

    public void setResultSortDirection(SortType p_direction) {
        this.m_ResultSortDirection = p_direction;
    }

    public List getQueryTypes() throws SQLException {
        return this.m_SQLExecutor.getViewList();
    }

    public List getQueryList(String p_table, int col, SortType sorttype) {
        this.setMessage("");
        Vector v = new Vector();
        Vector queryList = this.m_SQLExecutor.getQueryList(null);
        v.addAll(queryList);
        Sorter sorter = new Sorter();
        if (-1 == col) {
            sorter.sort(v, 3, 0, sorttype);
        } else {
            sorter.sort(v, col, sorttype);
        }
        int size = v.size();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, this.getRequestLocale());
        for (int ii = 0; ii < size; ++ii) {
            ListObject lo = new ListObject();
            lo = (ListObject)v.get(ii);
            if (lo.getDateObj() == null) continue;
            lo.setDate(df.format(lo.getDateObj()));
        }
        return v;
    }

    public String loadResult(String p_ResultName) {
        if (null == p_ResultName) {
            return "[ERROR] MODEL:loadResult p_ResultName is null!";
        }
        this.m_Result = null;
        this.m_SQLTableModel = null;
        try {
            this.m_Result = this.m_SQLExecutor.loadResult(p_ResultName);
            if (null == this.m_Result) {
                return "[ERROR]  m_SQLExecutor.loadResult is NULL ! Not implemented ? ResultName=" + p_ResultName;
            }
            this.m_SQLTableModel = this.m_Result.getValue();
            this.initPaging("none selected");
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception while loading result {0}: {1}", (Object)p_ResultName, (Object)ex.getMessage());
            return "[EXCEPTION] MODEL:loadResult  p_ResultName=" + p_ResultName + " " + ex.getMessage();
        }
        return "";
    }

    public Vector getResultList(String p_Result, int col, SortType sorttype) {
        Vector v = new Vector();
        this.setMessage("");
        try {
            v = this.m_SQLExecutor.getResultList(null);
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            this.setMessage("[ERROR] MODEL:getResultList Exception occurred  view_type=" + p_Result + " " + ex.getMessage());
        }
        Sorter sorter = new Sorter();
        if (-1 == col) {
            sorter.sort(v, 3, 0, sorttype);
        } else {
            sorter.sort(v, col, sorttype);
        }
        int size = v.size();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, this.getRequestLocale());
        for (int ii = 0; ii < size; ++ii) {
            ListObject lo = (ListObject)v.get(ii);
            if (lo.getDateObj() == null) continue;
            lo.setDate(df.format(lo.getDateObj()));
        }
        return v;
    }

    public void setResultMode(boolean p_ResultMode) {
        this.m_bIsResultMode = p_ResultMode;
    }

    public boolean getResultMode() {
        return this.m_bIsResultMode;
    }

    public String getQueryType() {
        return this.m_QueryType;
    }

    public void setQueryType(String p_QueryType) {
        this.m_QueryType = p_QueryType;
        if (this.m_SQLExecutor != null) {
            SimpleQuery simpleQuery = new SimpleQuery(this.m_SQLExecutor.getDbConnectionPool().getSQLGenerator());
            simpleQuery.setBaseTable(this.m_QueryType);
            this.setSimpleQuery(simpleQuery);
            this.setInitialvaluesForViewConfiguration();
        } else {
            this.setSimpleQuery(null);
        }
        this.setQueryName("");
        this.setQueryCategory("");
        this.m_AdvancedQuery = new AdvancedQuery();
        this.m_AdvancedQuery.setBaseTable(this.m_QueryType);
    }

    public String setQueryType(String p_QueryType, String p_SQLStatement) {
        this.m_QueryType = p_QueryType;
        if (null == this.m_AdvancedQuery) {
            this.m_AdvancedQuery = new AdvancedQuery();
        }
        try {
            this.m_AdvancedQuery.setBaseTable(this.m_QueryType);
            if (null != p_SQLStatement) {
                this.m_AdvancedQuery.setSQL(p_SQLStatement);
                this.setAdvancedSQLStatement(p_SQLStatement);
            }
        }
        catch (ArcoException ae) {
            return ae.getMessage();
        }
        return "";
    }

    public void setResultType(String p_ResultType) {
        this.m_ResultType = p_ResultType;
    }

    public String setResultDefaults() {
        if (this.getResultMode()) {
            if (null != this.m_Result) {
                QueryProperties qp = this.m_Result.getProperties();
                this.setResultName("");
                this.setResultCategory(qp.getCategory());
                this.setResultDescription(qp.getDescription());
                return "";
            }
            this.setResultName("Result is null");
            this.setResultCategory("Result is null");
            this.setResultDescription("Result is null");
            return "[ERROR] MODEL:setResultDefaults() Result is null!";
        }
        if (this.isAdvancedQuery()) {
            if (null != this.m_AdvancedQuery) {
                QueryProperties qp = this.m_AdvancedQuery.getQueryProperties();
                this.setResultName("");
                this.setResultCategory(qp.getCategory());
                this.setResultDescription(qp.getDescription());
                return "";
            }
            this.setResultName("AdvancedQuery is null");
            this.setResultCategory("AdvancedQuery is null");
            this.setResultDescription("AdvancedQuery is null");
            return "[ERROR] MODEL:setResultDefaults() AdvancedQuery is null!";
        }
        if (null != this.m_SimpleQuery) {
            QueryProperties qp = this.m_SimpleQuery.getQueryProperties();
            this.setResultName("");
            this.setResultCategory(qp.getCategory());
            this.setResultDescription(qp.getDescription());
            return "";
        }
        this.setResultName("SimpleQuery is null");
        this.setResultCategory("SimpleQuery is null");
        this.setResultDescription("SimpleQuery is null");
        return "[ERROR] MODEL:setResultDefaults() SimpleQuery is null!";
    }

    public String getResultType() {
        return this.m_ResultType;
    }

    public String getCategory() {
        String category_value = "";
        QueryProperties qp = null;
        qp = this.getResultMode() ? this.m_Result.getProperties() : (this.isAdvancedQuery() ? this.m_AdvancedQuery.getQueryProperties() : this.m_SimpleQuery.getQueryProperties());
        if (null != qp.getCategory() && !qp.getCategory().equals("")) {
            category_value = qp.getCategory();
        }
        return category_value;
    }

    public void setQueryCategory(String p_QueryCategory) {
        this.m_QueryCategory = p_QueryCategory;
    }

    public String getQueryCategory() {
        return this.m_QueryCategory;
    }

    private String getCategoryAndValue() {
        String category = " Category: ";
        String tmp = "";
        String category_value = "UNKNOWN";
        tmp = this.getCategory();
        if (null != tmp && !tmp.equals("")) {
            category_value = tmp;
        }
        return category + category_value;
    }

    public String getIsModified() {
        if (this.getResultMode()) {
            return "";
        }
        boolean dataChanged = false;
        dataChanged = this.isAdvancedQuery() ? this.m_AdvancedQuery.hasDataChanged() : this.m_SimpleQuery.hasDataChanged();
        return dataChanged ? " ***" : "";
    }

    public String getStatus() {
        if (this.getResultMode()) {
            return "Result:" + this.getResultName() + "&nbsp;&nbsp;&nbsp;" + this.getCategoryAndValue();
        }
        return "Query: " + (this.getQueryName().equals("") ? "UNKNOWN" : this.getQueryName()) + "&nbsp;&nbsp;&nbsp;" + this.getCategoryAndValue() + this.getIsModified();
    }

    public void setActiveQuery(boolean pActiveQuery) {
        this.m_bActiveQuery = pActiveQuery;
    }

    public void setTabularView(boolean p_Flag) {
        this.bTabular = p_Flag;
        this.bGraph = !p_Flag;
    }

    public void setGraphView(boolean p_Flag) {
        this.bTabular = !p_Flag;
        this.bGraph = p_Flag;
    }

    public boolean isTabular() {
        return this.bTabular;
    }

    public boolean isGraphical() {
        return this.bGraph;
    }

    private void initPaging(String p_HeaderName) {
        this.setCurrentPage(0);
        this.m_Result.setActualPage(this.getCurrentPage());
        this.setSelectedSortableHeaderName(p_HeaderName, SortType.ASC);
        this.createIndexer(this.getFieldListFromResult());
    }

    public boolean isTable(int p_view) {
        String viewConfigurationName = this.getVisibleViewconfiguration(p_view);
        if (viewConfigurationName.equals("none selected")) {
            return 0 == p_view;
        }
        return viewConfigurationName.equals("Database table");
    }

    public boolean isPagable(int p_index) {
        String viewConfigurationName = this.getVisibleViewconfiguration(p_index);
        if (viewConfigurationName.equals("none selected")) {
            if (0 == p_index) {
                return this.isResultPageable();
            }
            return false;
        }
        if (viewConfigurationName.equals("Database table")) {
            return this.isResultPageable();
        }
        return false;
    }

    private boolean isResultPageable() {
        SQLTableModel stm = new SQLTableModel();
        if (null == this.m_Result) {
            return false;
        }
        stm = this.m_Result.getValue();
        if (null == stm) {
            return false;
        }
        return stm.getRowCount() > 50;
    }

    public String getHtmlTabular() {
        return this.getPageableHtmlTabular();
    }

    public String getEmptyHtmlTable(String p_message) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table width=\"100%\" border=\"1\" spacing=\"1\" class=\"Tbl\">");
        sb.append("<tr>");
        sb.append("<td>");
        sb.append(p_message);
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public String getPageableHtmlTabular() {
        StringBuffer sb = new StringBuffer();
        SQLTableModel tmp_SQLTableModel = new SQLTableModel();
        this.m_Result.setActualPage(this.getCurrentPage());
        tmp_SQLTableModel = this.m_Result.getValue();
        if (null == tmp_SQLTableModel) {
            return this.getEmptyHtmlTable("Sorry - No Data: SQLTableModel is null !");
        }
        if (!tmp_SQLTableModel.hasData()) {
            return this.getEmptyHtmlTable("Sorry - No Data.");
        }
        int rows = tmp_SQLTableModel.getRowCount();
        int cols = tmp_SQLTableModel.getColumnCount();
        sb.append("<table width=\"100%\" border=\"1\" spacing=\"1\" class=\"Tbl\">");
        sb.append("<thead  valign=\"top\">");
        sb.append("<tr>");
        sb.append("<thead  valign=\"top\">");
        for (int ii = 0; ii < cols; ++ii) {
            sb.append("<th class=\"TblColHdrSrt\">");
            String s = tmp_SQLTableModel.getColumnName(ii);
            sb.append(s);
            sb.append("</th>");
        }
        sb.append("</thead>");
        sb.append("</tr>");
        sb.append("</thead>");
        sb.append("<tbody>");
        String ss = null;
        for (int ii = 0; ii < this.m_Result.getVisibleLineCount(); ++ii) {
            sb.append("<tr>");
            for (int iii = 0; iii < cols; ++iii) {
                try {
                    Object o = this.m_Result.getValueAt(ii, iii);
                    ss = o == null ? "" : ResultConverter.objToStr(o);
                    sb.append("<td>");
                    sb.append(ss);
                    sb.append("</td>");
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aiobex) {
                    iii = cols;
                    ii = this.m_Result.getVisibleLineCount();
                }
            }
            sb.append("</tr>");
        }
        sb.append("</tbody>");
        sb.append("</table>");
        return sb.toString();
    }

    public String getPageableHtmlDataBaseTable() {
        DataObject dob;
        int ii;
        StringBuffer sb = new StringBuffer();
        SQLTableModel tmp_SQLTableModel = new SQLTableModel();
        this.m_Result.setActualPage(this.getCurrentPage());
        tmp_SQLTableModel = this.m_Result.getValue();
        Vector<DataObject> vpos = new Vector<DataObject>();
        Vector v = this.getSelectedDbColumns();
        if (null == v) {
            return "[INFO] There is no data to show - no colums selected!";
        }
        int selectedSize = v.size();
        if (SGELog.isLoggable(Level.FINE)) {
            for (int iii = 0; iii < selectedSize; ++iii) {
                String s = (String)v.get(iii);
                SGELog.fine("selected #={0}", (Object)s);
            }
        }
        if (null == tmp_SQLTableModel) {
            return this.getEmptyHtmlTable("Sorry - No Data: SQLTableModel is null !");
        }
        if (!tmp_SQLTableModel.hasData()) {
            return this.getEmptyHtmlTable("Sorry - No Data.");
        }
        int rows = tmp_SQLTableModel.getRowCount();
        int cols = tmp_SQLTableModel.getColumnCount();
        if (SGELog.isLoggable(Level.FINE)) {
            SGELog.fine("cols #={0}", new Integer(cols));
        }
        sb.append("<table width=\"100%\" border=\"1\" spacing=\"1\" class=\"Tbl\">");
        sb.append("<thead  valign=\"top\">");
        sb.append("<tr>");
        sb.append("<thead  valign=\"top\">");
        for (int n = 0; n < selectedSize; ++n) {
            String sel = (String)v.get(n);
            for (ii = 0; ii < cols; ++ii) {
                String s = tmp_SQLTableModel.getColumnName(ii);
                if (!sel.equalsIgnoreCase(s)) continue;
                sb.append("<th class=\"TblColHdrSrt\">");
                sb.append(s);
                sb.append("</th>");
                dob = new DataObject();
                dob.setIndex(ii);
                dob.setValue1(sel);
                vpos.add(dob);
            }
        }
        if (vpos.size() != selectedSize) {
            if (SGELog.isLoggable(Level.FINE)) {
                SGELog.fine("vpos = {0}, sel = {1}", new Integer(vpos.size()), (Object)new Integer(selectedSize));
            }
            selectedSize = vpos.size();
        }
        sb.append("</thead>");
        sb.append("</tr>");
        sb.append("</thead>");
        sb.append("<tbody>");
        String ss = null;
        Object o = null;
        for (ii = 0; ii < this.m_Result.getVisibleLineCount(); ++ii) {
            sb.append("<tr>");
            for (int n = 0; n < selectedSize; ++n) {
                try {
                    dob = (DataObject)vpos.get(n);
                    for (int iii = 0; iii < cols; ++iii) {
                        if (iii != dob.getIndex()) continue;
                        try {
                            o = this.m_Result.getValueAt(ii, iii);
                            ss = o == null ? "" : ResultConverter.objToStr(o);
                            sb.append("<td>");
                            sb.append(ss);
                            sb.append("</td>");
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException aiobex) {
                            iii = cols;
                            ii = this.m_Result.getVisibleLineCount();
                        }
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ioex) {
                    SGELog.severe(ioex, "DefaultViewConfiguration not invalidated!");
                    return "[EXCEPTION] MODEL: KNOWN BUG in getHtmlDataBaseTable() DefaultViewConfiguration not invalidated!";
                }
            }
            sb.append("</tr>");
        }
        sb.append("</tbody>");
        sb.append("</table>");
        return sb.toString();
    }

    public String getHtmlDataBaseTable() {
        return this.getPageableHtmlDataBaseTable();
    }

    private Vector getFieldListFromViewConfiguration() {
        Vector v = new Vector();
        ViewConfigurationManager vcm = null;
        DBTableViewConfiguration dbtvc = null;
        try {
            vcm = this.getResultMode() ? this.m_Result.getViewConfigurationManager() : (this.isAdvancedQuery() ? this.m_AdvancedQuery.getViewConfigurationManager() : this.m_SimpleQuery.getViewConfigurationManager());
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            v.add("[EXCEPTION] MODEL getFieldListFromViewConfiguration()");
            return v;
        }
        try {
            dbtvc = (DBTableViewConfiguration)vcm.getViewConfiguration(1);
            v = dbtvc.getColumns();
        }
        catch (IllegalArgumentException iaex) {
            SGELog.severe((Throwable)iaex, "Exception {0}", (Object)iaex);
        }
        return v;
    }

    private Vector getFieldListFromResult() {
        Vector<String> v = new Vector<String>();
        if (null == this.m_Result) {
            v.add("[ERROR] Result is null");
            return v;
        }
        SQLTableModel tmp_SQLTableModel = this.m_Result.getValue();
        if (null == tmp_SQLTableModel) {
            v.add("[INFO] SQLTableModel is empty");
            return v;
        }
        int cols = tmp_SQLTableModel.getColumnCount();
        for (int ii = 0; ii < cols; ++ii) {
            v.add(tmp_SQLTableModel.getColumnName(ii));
        }
        return v;
    }

    public List getSortableHeaderNames() {
        Vector v = new Vector();
        String view_1 = this.getVisibleViewconfiguration(0);
        String view_2 = this.getVisibleViewconfiguration(1);
        String view_3 = this.getVisibleViewconfiguration(2);
        if (view_1.equals("none selected")) {
            v = this.getFieldListFromResult();
        }
        if (view_1.equals("Database table")) {
            v = this.getFieldListFromViewConfiguration();
        }
        if (view_2.equals("Database table")) {
            v = this.getFieldListFromViewConfiguration();
        }
        if (view_3.equals("Database table")) {
            v = this.getFieldListFromViewConfiguration();
        }
        return v;
    }

    public void setSelectedSortDirection(SortType p_sortType) {
        this.m_SortType = p_sortType;
    }

    private SortType getSelectedSortDirection() {
        return this.m_SortType;
    }

    public String getSelectedSortableHeaderName() {
        return this.m_SelectedSortableHeaderName;
    }

    public void setSelectedSortableHeaderName(String p_headerName) {
        this.m_SelectedSortableHeaderName = p_headerName;
    }

    public void setSelectedSortableHeaderName(String p_headerName, SortType p_SortType) {
        if (this.getSelectedSortableHeaderName().equals(p_headerName) && p_SortType == this.getSelectedSortDirection()) {
            return;
        }
        int col = this.getIndex4HeaderName(p_headerName);
        if (col > -1) {
            this.m_SelectedSortableHeaderName = p_headerName;
            this.setSelectedSortDirection(p_SortType);
            this.m_Result.setSortWrapper(this.setSortWrapperList(col));
        } else {
            this.m_Result.setSortWrapper(null);
        }
        this.setCurrentPage(0);
        this.m_Result.setActualPage(this.getCurrentPage());
    }

    public Vector setSortWrapperList(int p_col) {
        Vector<DataObject> v = new Vector<DataObject>();
        SQLTableModel tmp_SQLTableModel = new SQLTableModel();
        tmp_SQLTableModel = this.m_Result.getValue();
        int rows = tmp_SQLTableModel.getRowCount();
        for (int ii = 0; ii < rows; ++ii) {
            String value = tmp_SQLTableModel.getValueAt(ii, p_col).toString();
            DataObject dob = new DataObject();
            dob.setIndex(ii);
            dob.setValue1(value);
            v.add(dob);
        }
        Sorter sorter = new Sorter();
        sorter.sort(v, 0, this.getSelectedSortDirection());
        return v;
    }

    private void createIndexer(Vector p_Vector) {
        this.m_Indexer = new Vector();
        SQLTableModel tmp_SQLTableModel = new SQLTableModel();
        tmp_SQLTableModel = this.m_Result.getValue();
        if (null == p_Vector || p_Vector.isEmpty()) {
            return;
        }
        if (null == tmp_SQLTableModel) {
            return;
        }
        int cols = tmp_SQLTableModel.getColumnCount();
        int size = p_Vector.size();
        for (int ii = 0; ii < size; ++ii) {
            String sel = (String)p_Vector.get(ii);
            for (int iii = 0; iii < cols; ++iii) {
                String s = tmp_SQLTableModel.getColumnName(iii);
                if (!sel.equals(s)) continue;
                DataObject dob = new DataObject();
                dob.setIndex(iii);
                dob.setValue1(sel);
                this.m_Indexer.add(dob);
            }
        }
    }

    private int getIndex4HeaderName(String p_HeaderName) {
        if (null == this.m_Indexer) {
            return -1;
        }
        int size = this.m_Indexer.size();
        for (int ii = 0; ii < size; ++ii) {
            DataObject dob = new DataObject();
            dob = (DataObject)this.m_Indexer.get(ii);
            if (!dob.getValue1().equals(p_HeaderName)) continue;
            return ii;
        }
        return -1;
    }

    public void setCurrentPage(int p_currentPage) {
        if (p_currentPage >= 0) {
            this.m_currentPage = p_currentPage;
        }
    }

    public void increaseCurrentPage() {
        if (this.m_currentPage < this.getMaxPages()) {
            ++this.m_currentPage;
        }
    }

    private int getMaxPages() {
        SQLTableModel tmp_SQLTableModel = this.m_Result.getValue();
        int rows = tmp_SQLTableModel.getRowCount();
        int pages = 0;
        pages = rows / this.m_Result.getVisibleLineCount();
        int mod = 0;
        mod = rows % this.m_Result.getVisibleLineCount();
        if (0 == mod) {
            --pages;
        }
        return pages;
    }

    public void maxCurrentPage() {
        this.m_currentPage = this.getMaxPages();
    }

    public void decreaseCurrentPage() {
        --this.m_currentPage;
        if (0 > this.m_currentPage) {
            this.m_currentPage = 0;
        }
    }

    public int getCurrentPage() {
        return this.m_currentPage;
    }

    public String getPivot() {
        SGELog.fine("entry");
        if (this.m_PivotViewConfiguration == null) {
            SGELog.warning("no pivot configuration available");
            return "[ERROR] MODEL:getPivot can't reate pivot table -  null == m_PivotViewConfiguration";
        }
        try {
            SGELog.fine("try to get pivot");
            if (null == this.m_SQLTableModel) {
                SGELog.info("Result is empty !");
                return "[INFO] MODEL:getPivot Result is empty !";
            }
            this.m_PivotViewConfiguration.setSQLTableModel(this.m_SQLTableModel);
            this.m_PivotViewConfiguration.buildTree();
            return this.m_PivotViewConfiguration.getHtmlPivotTable("BORDER=\"1\"");
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Error {0}", (Object)ex.getMessage());
            return "[EXCEPTION] MODEL:getPivot " + ex.getMessage();
        }
    }

    private Result getResultView() {
        Result result;
        if (this.m_bIsResultMode) {
            result = this.m_Result;
        } else {
            QueryProperties qp = this.isAdvancedQuery() || this.getParentURL().equals("/jsp/reportingmodule/AdvancedQuery.jsp") ? this.m_AdvancedQuery.getQueryProperties() : this.m_SimpleQuery.getQueryProperties();
            result = new Result();
            result.setProperties(qp);
        }
        return result;
    }

    public String getResultViewDescription() {
        return this.getResultView().getProperties().getDescription();
    }

    public String getResultViewFilterconditions() {
        String retVal = "";
        Result result = this.getResultView();
        if (result.getParameterList() != null && result.getParameterList().size() > 0) {
            Iterator listIt = result.getParameterList().iterator();
            while (listIt.hasNext()) {
                retVal = retVal + (String)listIt.next();
            }
        } else {
            retVal = "No Filters declared.";
        }
        return retVal;
    }

    public String getResultViewSQLStatement() {
        Result result;
        if (this.m_bIsResultMode) {
            result = this.m_Result;
        } else {
            String sql = this.isAdvancedQuery() || this.getParentURL().equals("/jsp/reportingmodule/AdvancedQuery.jsp") ? this.m_AdvancedQuery.getSQL() : this.m_SimpleQuery.getSQL();
            result = new Result();
            result.setSQLStatement(sql);
        }
        return result.getSQLStatement();
    }

    public void setResultName(String p_ResultName) {
        if (null != p_ResultName) {
            this.m_ResultName = p_ResultName;
        }
    }

    public void setResultCategory(String p_ResultCategory) {
        this.m_ResultCategory = p_ResultCategory;
    }

    public void setResultDescription(String p_ResultDescription) {
        this.m_ResultDescription = p_ResultDescription;
    }

    public String getResultName() {
        if (null == this.m_ResultName) {
            return "[ERROR] known bug ! ResultName is not defined !";
        }
        return this.m_ResultName;
    }

    public String getResultCategory() {
        if (null == this.m_ResultCategory) {
            return "[ERROR] ResultCategory is not defined !";
        }
        return this.m_ResultCategory;
    }

    public String getResultDescription() {
        if (null == this.m_ResultDescription) {
            return "[ERROR] ResultDescription is not defined !";
        }
        return this.m_ResultDescription;
    }

    public String saveResult() {
        String msg;
        String sql;
        Result result = new Result();
        QueryProperties properties = new QueryProperties();
        properties.setName(this.getResultName());
        properties.setCategory(this.getResultCategory());
        properties.setDescription(this.getResultDescription());
        result.setProperties(properties);
        result.setValue(this.m_SQLTableModel);
        if (this.isAdvancedQuery()) {
            sql = this.m_AdvancedQuery.getSQL();
            SGELog.warning("not implemented : m_AdvancedQuery.generateParameterArray()");
        } else {
            sql = this.m_SimpleQuery.getSQL();
            String[] paramList = this.m_SimpleQuery.generateParameterArray();
            result.setParameterList(paramList);
        }
        result.setSQLStatement(sql);
        if (null == this.m_ViewConfigurationManager && !(msg = this.setInitialvaluesForViewConfiguration()).equals("")) {
            return msg;
        }
        result.setViewConfigurationManager(this.getViewConfiguration());
        try {
            this.m_SQLExecutor.saveResult(result);
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            return "[EXCEPTION] while writing result:" + ex.getMessage();
        }
        this.m_Result = result;
        return "";
    }

    public String transformToAdvanced() {
        try {
            this.m_AdvancedQuery = this.m_SimpleQuery.transformToAdvanced();
            this.setAdvancedQuery(true);
            this.setSimpleQuery(null);
        }
        catch (Exception ex) {
            SGELog.severe((Throwable)ex, "Exception {0}", (Object)ex.getMessage());
            return ex.getMessage();
        }
        return "";
    }

    public void createFieldList4Advanced(String sqlStatement) throws ArcoException {
        if (this.m_AdvancedQuery == null) {
            this.m_AdvancedQuery = new AdvancedQuery();
        }
        this.m_AdvancedQuery.setSQL(sqlStatement);
    }
}

