/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.ModelTypeMap;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.sun.grid.arco.ArcoVersion;
import com.sun.grid.logging.CompositeFilter;
import com.sun.grid.logging.RegExFilter;
import com.sun.grid.logging.SGEFormatter;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.ModelTypeMapImpl;
import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.web.common.ConsoleServletBase;
import java.io.File;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class AcroServletBase
extends ConsoleServletBase
implements ArcoVersion {
    public static final String PROPERTY_LOGGING_FILTER = "arco_logging_filter";
    public static final String PROPERTY_LOGGING_LEVEL = "arco_logging_level";
    public static final String PROPERTY_CONFIG_FILE = "arco_config_file";
    private String configFile;
    private static ModelTypeMapImpl MODEL_TYPE_MAP;
    public static final String APPL_NAME = "com.sun.grid.arco_6u1";
    private static File applDir;
    static /* synthetic */ Class class$com$sun$grid$reporting$AcroServletBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getApplDir() {
        if (applDir == null) {
            Class clazz = class$com$sun$grid$reporting$AcroServletBase == null ? (class$com$sun$grid$reporting$AcroServletBase = AcroServletBase.class$("com.sun.grid.reporting.AcroServletBase")) : class$com$sun$grid$reporting$AcroServletBase;
            synchronized (clazz) {
                if (applDir == null) {
                    MgmtAppRegistrationService regService = MgmtAppRegistrationServiceFactory.getRegistrationService();
                    String applStr = regService.getRegisteredAppDir(APPL_NAME);
                    if (applStr == null) {
                        throw new IllegalStateException("application com.sun.grid.arco_6u1 is not registered");
                    }
                    applDir = new File(applStr);
                }
            }
        }
        return applDir;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initLogging();
        this.initConfigFile();
        SGELog.info("application {0} is installed at {1}", (Object)APPL_NAME, (Object)AcroServletBase.getApplDir().getAbsoluteFile());
        MODEL_TYPE_MAP = new ModelTypeMapImpl();
    }

    public String getConfigFile() {
        return this.configFile;
    }

    private void initConfigFile() throws ServletException {
        this.configFile = ConsoleConfiguration.getEnvProperty((String)PROPERTY_CONFIG_FILE);
        if (this.configFile == null) {
            throw new ServletException("property arco_config_file not found");
        }
        File file = new File(this.configFile);
        if (!file.exists() || !file.canRead()) {
            throw new ServletException("Can't open config file '" + this.configFile + "', please check the property " + PROPERTY_CONFIG_FILE);
        }
    }

    private void initLogging() {
        Level level;
        Logger logger = Logger.getLogger("arcoLogger");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        SGEFormatter formatter = new SGEFormatter("arco", true);
        consoleHandler.setFormatter(formatter);
        logger.addHandler(consoleHandler);
        logger.setUseParentHandlers(false);
        SGELog.init(logger);
        String levelStr = ConsoleConfiguration.getEnvProperty((String)PROPERTY_LOGGING_LEVEL);
        if (levelStr == null) {
            level = Level.INFO;
        } else {
            try {
                level = Level.parse(levelStr.toUpperCase());
            }
            catch (IllegalArgumentException ilse) {
                SGELog.warning("system report PROPERTY_LOGGING_LEVEL does not define a valid log level");
                level = Level.INFO;
            }
        }
        SGELog.info("Set logging level to {0}", level);
        logger.setLevel(level);
        consoleHandler.setLevel(level);
        String filterStr = ConsoleConfiguration.getEnvProperty((String)PROPERTY_LOGGING_FILTER);
        if (filterStr != null) {
            StringTokenizer st = new StringTokenizer(filterStr, ";");
            if (st.countTokens() > 1) {
                CompositeFilter compFilter = new CompositeFilter(st.countTokens());
                while (st.hasMoreTokens()) {
                    compFilter.addFilter(AcroServletBase.parseRegExFilter(st.nextToken()));
                }
                logger.setFilter(compFilter);
            } else if (st.countTokens() == 1) {
                logger.setFilter(AcroServletBase.parseRegExFilter(st.nextToken()));
            }
        }
    }

    private static RegExFilter parseRegExFilter(String filter) {
        RegExFilter ret = new RegExFilter();
        StringTokenizer st = new StringTokenizer(filter, ",");
        String token = null;
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!token.equals("*")) {
                ret.setSourceClassPattern(token);
            }
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                if (!token.equals("*")) {
                    ret.setSourceMethodPattern(token);
                }
                if (st.hasMoreTokens() && !(token = st.nextToken()).equals("*")) {
                    ret.setLevel(Level.parse(token));
                }
            }
        }
        return ret;
    }

    protected void initializeRequestContext(RequestContext requestContext) {
        super.initializeRequestContext(requestContext);
        ModelManager modelManager = new ModelManager(requestContext, (ModelTypeMap)MODEL_TYPE_MAP);
        ((RequestContextImpl)requestContext).setModelManager(modelManager);
    }

    public String getServletInfo() {
        return "AcroServletBase";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

