/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SGEFormatter
extends Formatter {
    private static final String NL = System.getProperty("line.separator");
    private static final int DEFAULT_STACKTRACE_INDENT = 30;
    private static final int MAX_STACKTRACE_LEN = 10;
    private static final int DEFAULT_SOURCE_COL_WIDTH = 30;
    private MessageFormat mf;
    private String thrownPrefix;
    private boolean withStackTraceFlag;
    private int[] columns;
    private Date date = new Date();
    private Object[] args = new Object[]{this.date, null, null, null};
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);
    public static final int COL_TIME = 1;
    public static final int COL_HOST = 2;
    public static final int COL_NAME = 3;
    public static final int COL_THREAD = 4;
    public static final int COL_LEVEL = 5;
    public static final int COL_MESSAGE = 6;
    public static final int COL_SOURCE = 7;
    public static final int COL_LEVEL_LONG = 8;
    public static final int[] DEFAULT_COLUMNS = new int[]{1, 2, 7, 5, 6};
    private String name;
    private String delimiter = "|";
    private static HashMap levelMap = new HashMap();

    public SGEFormatter(String aName) {
        this(aName, true);
    }

    public SGEFormatter(String aName, boolean withStackTrace) {
        this(aName, withStackTrace, DEFAULT_COLUMNS);
    }

    public SGEFormatter(String aName, boolean withStackTrace, int[] aColumns) {
        this.name = aName;
        this.setWithStackTrace(withStackTrace);
        this.columns = aColumns;
    }

    private void clear() {
        this.mf = null;
        this.args = null;
    }

    private void init() {
        StringBuffer message = new StringBuffer();
        int argsCount = 0;
        int dateCol = -1;
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                message.append(this.delimiter);
            }
            switch (this.columns[i]) {
                case 1: {
                    message.append("{");
                    message.append(argsCount);
                    message.append(",date,dd/MM/yyyy HH:mm:ss}");
                    dateCol = argsCount++;
                    break;
                }
                case 2: {
                    String host;
                    try {
                        host = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unhe) {
                        host = "unknown";
                    }
                    message.append(host);
                    break;
                }
                case 3: {
                    message.append(this.name);
                    break;
                }
                default: {
                    message.append("{" + argsCount + "}");
                    ++argsCount;
                }
            }
            this.args = new Object[argsCount];
            if (dateCol < 0) continue;
            this.args[dateCol] = this.date;
        }
        StringBuffer prefix = new StringBuffer();
        int prefixLen = 30;
        for (int i = 0; i < prefixLen; ++i) {
            prefix.append(' ');
        }
        this.thrownPrefix = prefix.toString();
        this.mf = new MessageFormat(message.toString());
    }

    public final void setDelimiter(String aDelimiter) {
        this.clear();
        this.delimiter = aDelimiter;
    }

    public final void setColumns(int[] aColumns) {
        this.clear();
        this.columns = aColumns;
    }

    public final void setWithStackTrace(boolean withStackTrace) {
        this.withStackTraceFlag = withStackTrace;
    }

    public final boolean getWithStackTrace() {
        return this.withStackTraceFlag;
    }

    private String getFixStr(String str, int length, boolean rightAlign) {
        int len;
        if (str.length() > length) {
            return str.substring(str.length() - length);
        }
        StringBuffer ret = new StringBuffer(length);
        if (rightAlign) {
            ret.append(str);
            for (len = length - str.length(); len >= 0; --len) {
                ret.append(' ');
            }
        } else {
            while (len >= 0) {
                ret.append(' ');
                --len;
            }
            ret.append(str);
        }
        return ret.toString();
    }

    private String getMessage(LogRecord record) {
        String message = null;
        if (record.getResourceBundle() != null) {
            try {
                message = record.getMessage();
                message = record.getResourceBundle().getString(message);
            }
            catch (MissingResourceException mre) {
                message = record.getMessage();
            }
        }
        if (message == null) {
            message = record.getMessage();
        }
        if (message != null && record.getParameters() != null) {
            message = MessageFormat.format(message, record.getParameters());
        }
        return message;
    }

    public final String format(LogRecord record) {
        if (this.mf == null) {
            this.init();
        }
        this.sw.getBuffer().setLength(0);
        int argIndex = 0;
        block9: for (int i = 0; i < this.columns.length; ++i) {
            switch (this.columns[i]) {
                case 1: {
                    this.date.setTime(record.getMillis());
                    ++argIndex;
                    continue block9;
                }
                case 2: 
                case 3: {
                    continue block9;
                }
                case 7: {
                    this.args[argIndex] = this.getFixStr(record.getSourceClassName() + '.' + record.getSourceMethodName(), 30, true);
                    ++argIndex;
                    continue block9;
                }
                case 6: {
                    this.args[argIndex] = this.getMessage(record);
                    ++argIndex;
                    continue block9;
                }
                case 5: {
                    this.args[argIndex] = SGEFormatter.levelToStr(record.getLevel());
                    ++argIndex;
                    continue block9;
                }
                case 4: {
                    this.args[argIndex] = Integer.toString(record.getThreadID());
                    ++argIndex;
                    continue block9;
                }
                case 8: {
                    this.args[argIndex] = record.getLevel();
                    ++argIndex;
                    continue block9;
                }
                default: {
                    throw new IllegalStateException("unknown column " + this.columns[i]);
                }
            }
        }
        String message = this.mf.format(this.args);
        this.pw.println(message);
        if (this.withStackTraceFlag && record.getThrown() != null) {
            StackTraceElement[] stack = null;
            boolean first = true;
            int len = 0;
            for (Throwable th = record.getThrown(); th != null; th = th.getCause()) {
                this.pw.print(this.thrownPrefix);
                if (first) {
                    first = false;
                } else {
                    this.pw.print("Caused by ");
                }
                this.pw.println(th.toString());
                stack = th.getStackTrace();
                len = Math.min(10, stack.length);
                for (int i = 0; i < len; ++i) {
                    this.pw.print(this.thrownPrefix);
                    this.pw.print("  ");
                    this.pw.println(stack[i].toString());
                }
            }
        }
        this.pw.flush();
        return this.sw.getBuffer().toString();
    }

    private static String levelToStr(Level level) {
        String ret = (String)levelMap.get(level);
        if (ret == null) {
            return "U";
        }
        return ret;
    }

    static {
        levelMap.put(Level.CONFIG, "C");
        levelMap.put(Level.INFO, "I");
        levelMap.put(Level.SEVERE, "E");
        levelMap.put(Level.WARNING, "W");
        levelMap.put(Level.FINE, "D");
        levelMap.put(Level.FINER, "D");
        levelMap.put(Level.FINEST, "D");
    }
}

