/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExFilter
implements Filter {
    private Pattern sourceClassPattern = null;
    private Pattern sourceMethodPattern = null;
    private Level level = null;

    public RegExFilter() {
    }

    public RegExFilter(Level aLevel) {
        this(null, null, aLevel);
    }

    public RegExFilter(String aSourceClassPattern, Level aLevel) {
        this(aSourceClassPattern, null, aLevel);
    }

    public RegExFilter(String aSourceClassPattern, String aSourceMethodPattern, Level aLevel) {
        this.setSourceClassPattern(aSourceClassPattern);
        this.setSourceMethodPattern(aSourceMethodPattern);
        this.setLevel(aLevel);
    }

    public final void setSourceClassPattern(String pattern) {
        this.sourceClassPattern = this.compile(pattern);
    }

    public final String getSourceClassPattern() {
        if (this.sourceClassPattern != null) {
            return this.sourceClassPattern.pattern();
        }
        return null;
    }

    public final void setSourceMethodPattern(String pattern) {
        this.sourceMethodPattern = this.compile(pattern);
    }

    public final String getSourceMethodPattern() {
        if (this.sourceMethodPattern != null) {
            return this.sourceMethodPattern.pattern();
        }
        return null;
    }

    private Pattern compile(String pattern) {
        if (pattern != null) {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException pse) {
                IllegalArgumentException iae = new IllegalArgumentException("Syntax error in pattern (" + pattern + ")");
                iae.initCause(pse);
                throw iae;
            }
        }
        return null;
    }

    public final void setLevel(Level aLevel) {
        this.level = aLevel;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final boolean isLoggable(LogRecord logRecord) {
        if (this.level != null && logRecord.getLevel().intValue() < this.level.intValue()) {
            return false;
        }
        if (this.sourceClassPattern != null && !this.sourceClassPattern.matcher(logRecord.getSourceClassName()).matches()) {
            return false;
        }
        return this.sourceMethodPattern == null || this.sourceMethodPattern.matcher(logRecord.getSourceMethodName()).matches();
    }
}

