/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.arco;

import com.sun.grid.arco.QueryConverter;
import com.sun.grid.arco.ResultManager;
import com.sun.grid.arco.model.ObjectFactory;
import com.sun.grid.arco.model.Result;
import com.sun.grid.arco.model.ResultType;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.sql.SQLTableModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class ResultConverter {
    private static Map converterNameMap = new HashMap();
    private static Map converterTypeMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static Result toXML(com.sun.grid.reporting.model.Result result) {
        try {
            ObjectFactory faq = ResultManager.getInstance().getObjectFactory();
            Result xmlResult = faq.createResult();
            Iterator iter = null;
            QueryConverter.toXML(result.getProperties(), xmlResult);
            if (result.getParameterList() != null) {
                iter = result.getParameterList().iterator();
                while (iter.hasNext()) {
                    xmlResult.getFilter().add(iter.next());
                }
            }
            if (result.getViewConfigurationManager() != null) {
                xmlResult.setView(QueryConverter.ViewConverter.toXML(result.getViewConfigurationManager()));
                xmlResult.getView().getDescription().setValue(result.getProperties().getDescription());
            }
            xmlResult.setSql(result.getSQLStatement());
            SQLTableModel sqlTM = result.getValue();
            ResultType.ColumnType column = null;
            for (int i = 0; i < sqlTM.getColumnCount(); ++i) {
                column = faq.createResultTypeColumnType();
                column.setName(sqlTM.getColumnName(i));
                column.setType(ResultConverter.getConverter(sqlTM.getColumnClass(i)).getName());
                xmlResult.getColumn().add(column);
            }
            ResultType.RowType row = null;
            Object obj = null;
            for (int rowIndex = 0; rowIndex < sqlTM.getRowCount(); ++rowIndex) {
                row = faq.createResultTypeRowType();
                for (int colIndex = 0; colIndex < sqlTM.getColumnCount(); ++colIndex) {
                    obj = sqlTM.getValueAt(rowIndex, colIndex);
                    row.getValue().add(ResultConverter.objToStr(obj));
                }
                xmlResult.getRow().add(row);
            }
            xmlResult.setRowCount(sqlTM.getRowCount());
            xmlResult.setColCount(sqlTM.getColumnCount());
            return xmlResult;
        }
        catch (JAXBException jxbe) {
            IllegalStateException ilse = new IllegalStateException("Can't create instanceof result");
            ilse.initCause(jxbe);
            throw ilse;
        }
    }

    public static com.sun.grid.reporting.model.Result fromXML(Result xmlResult) {
        List filter;
        com.sun.grid.reporting.model.Result ret = new com.sun.grid.reporting.model.Result();
        ret.setProperties(QueryConverter.fromXML(xmlResult));
        if (xmlResult.getView() != null) {
            ret.setViewConfigurationManager(QueryConverter.ViewConverter.fromXML(xmlResult.getView()));
            ret.getProperties().setDescription(xmlResult.getView().getDescription().getValue());
        }
        if ((filter = xmlResult.getFilter()) != null && !filter.isEmpty()) {
            String[] paramList = new String[filter.size()];
            filter.toArray(paramList);
            ret.setParameterList(paramList);
        }
        ret.setSQLStatement(xmlResult.getSql());
        SQLTableModel sqlTM = new SQLTableModel();
        sqlTM.setRowCount(xmlResult.getRow().size());
        sqlTM.setColumnCount(xmlResult.getColumn().size());
        List columns = xmlResult.getColumn();
        String[] columnTypes = new String[columns.size()];
        Object[] columnNames = new String[columns.size()];
        ResultType.ColumnType column = null;
        for (int i = 0; i < columns.size(); ++i) {
            column = (ResultType.ColumnType)columns.get(i);
            columnTypes[i] = column.getType();
            columnNames[i] = column.getName();
        }
        sqlTM.setColumnIdentifiers(columnNames);
        Iterator iter = xmlResult.getRow().iterator();
        ResultType.RowType row = null;
        Iterator valueIter = null;
        String value = null;
        int rowIndex = 0;
        int colIndex = 0;
        while (iter.hasNext()) {
            row = (ResultType.RowType)iter.next();
            SGELog.fine("process row {0}", new Integer(rowIndex));
            valueIter = row.getValue().iterator();
            colIndex = 0;
            while (valueIter.hasNext()) {
                SGELog.fine("process col {0}", new Integer(colIndex));
                value = (String)valueIter.next();
                sqlTM.setValueAt(ResultConverter.strToObj(value, columnTypes[colIndex]), rowIndex, colIndex);
                ++colIndex;
            }
            ++rowIndex;
        }
        ret.setValue(sqlTM);
        return ret;
    }

    public static String objToStr(Object obj) {
        return ResultConverter.getConverter(obj.getClass()).toStr(obj);
    }

    private static Object strToObj(String str, String name) {
        return ResultConverter.getConverter(name).toObj(str);
    }

    private static AbstractConverter getConverter(String name) {
        AbstractConverter ret = (AbstractConverter)converterNameMap.get(name);
        if (ret == null) {
            throw new IllegalArgumentException("Converter for name " + name + " not registered");
        }
        return ret;
    }

    private static AbstractConverter getConverter(Class type) {
        AbstractConverter ret = (AbstractConverter)converterTypeMap.get(type);
        if (ret == null) {
            throw new IllegalArgumentException("Converter for type " + type + " not registered");
        }
        return ret;
    }

    private static void reg(AbstractConverter conv) {
        converterNameMap.put(conv.getName(), conv);
        converterTypeMap.put(conv.getType(), conv);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ResultConverter.reg(new StringConverter());
        ResultConverter.reg(new WrapperConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = ResultConverter.class$("java.lang.Integer")) : class$java$lang$Integer, "int"));
        ResultConverter.reg(new WrapperConverter(class$java$lang$Long == null ? (class$java$lang$Long = ResultConverter.class$("java.lang.Long")) : class$java$lang$Long, "long"));
        ResultConverter.reg(new WrapperConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ResultConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, "boolean"));
        ResultConverter.reg(new WrapperConverter(class$java$lang$Double == null ? (class$java$lang$Double = ResultConverter.class$("java.lang.Double")) : class$java$lang$Double, "double"));
        ResultConverter.reg(new WrapperConverter(class$java$lang$Float == null ? (class$java$lang$Float = ResultConverter.class$("java.lang.Float")) : class$java$lang$Float, "float"));
        ResultConverter.reg(new BigDecimalConverter());
        ResultConverter.reg(new DateConverter(class$java$util$Date == null ? (class$java$util$Date = ResultConverter.class$("java.util.Date")) : class$java$util$Date, "date", "yyyy-MM-dd HH:mm:ss"));
        ResultConverter.reg(new DateConverter(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ResultConverter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, "timestamp", "yyyy-MM-dd HH:mm:ss"));
        ResultConverter.reg(new DateConverter(class$java$sql$Time == null ? (class$java$sql$Time = ResultConverter.class$("java.sql.Time")) : class$java$sql$Time, "time", "HH:mm:ss"));
        ResultConverter.reg(new DateConverter(class$java$sql$Date == null ? (class$java$sql$Date = ResultConverter.class$("java.sql.Date")) : class$java$sql$Date, "sqlDate", "yyyy-MM-dd HH:mm:ss"));
    }

    static class BigDecimalConverter
    extends AbstractConverter {
        public BigDecimalConverter() {
            super(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ResultConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, "bigdecimal");
        }

        public Object toObj(String str) {
            return new BigDecimal(str);
        }

        public String toStr(Object obj) {
            return obj.toString();
        }
    }

    static class WrapperConverter
    extends AbstractConverter {
        private Method valueOfMethod;

        public WrapperConverter(Class type, String name) {
            super(type, name);
            try {
                this.valueOfMethod = type.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = ResultConverter.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("type " + type + " has no valueOf method");
            }
        }

        public Object toObj(String str) {
            try {
                return this.valueOfMethod.invoke((Object)this.type, str);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("has no acces on valueOf method of type " + this.type);
            }
            catch (InvocationTargetException ivte) {
                IllegalStateException ilse = new IllegalStateException("can't convert str '" + str + " to object: " + ivte.getTargetException().getMessage());
                ilse.initCause(ivte.getTargetException());
                throw ilse;
            }
        }

        public String toStr(Object obj) {
            return obj.toString();
        }
    }

    static class DateConverter
    extends AbstractConverter {
        private SimpleDateFormat format;
        private Constructor constructor;

        public DateConverter(Class type, String name, String format) {
            super(type, name);
            this.format = new SimpleDateFormat(format);
            if (!type.equals(class$java$util$Date == null ? (class$java$util$Date = ResultConverter.class$("java.util.Date")) : class$java$util$Date)) {
                try {
                    this.constructor = type.getConstructor(Long.TYPE);
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalArgumentException("constructor in class " + type + " not found");
                }
            }
        }

        public Object toObj(String str) {
            try {
                Date d = this.format.parse(str);
                if (this.constructor == null) {
                    return d;
                }
                return this.constructor.newInstance(new Long(d.getTime()));
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(str + " is not a valid date");
            }
            catch (InstantiationException ise) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof of class " + this.type);
                ilse.initCause(ise);
                throw ilse;
            }
            catch (IllegalAccessException iae) {
                IllegalStateException ilse = new IllegalStateException("Have o access on constructor of class " + this.type);
                ilse.initCause(iae);
                throw ilse;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException ilse = new IllegalStateException("Error in constructor of class " + this.type);
                ilse.initCause(ite.getTargetException());
                throw ilse;
            }
        }

        public String toStr(Object obj) {
            return this.format.format(obj);
        }
    }

    static class StringConverter
    extends AbstractConverter {
        public StringConverter() {
            super(class$java$lang$String == null ? (class$java$lang$String = ResultConverter.class$("java.lang.String")) : class$java$lang$String, "string");
        }

        public Object toObj(String str) {
            return str;
        }

        public String toStr(Object obj) {
            return (String)obj;
        }
    }

    static abstract class AbstractConverter {
        protected Class type;
        protected String name;

        public AbstractConverter(Class type, String name) {
            this.type = type;
            this.name = name;
        }

        public abstract String toStr(Object var1);

        public abstract Object toObj(String var1);

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }
    }
}

