/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.arco;

import com.sun.grid.arco.QueryManager;
import com.sun.grid.arco.model.Bar;
import com.sun.grid.arco.model.Field;
import com.sun.grid.arco.model.Filter;
import com.sun.grid.arco.model.Graphic;
import com.sun.grid.arco.model.Line;
import com.sun.grid.arco.model.ObjectFactory;
import com.sun.grid.arco.model.Pie;
import com.sun.grid.arco.model.Pivot;
import com.sun.grid.arco.model.Query;
import com.sun.grid.arco.model.ReportingObject;
import com.sun.grid.arco.model.StackedLine;
import com.sun.grid.arco.model.Table;
import com.sun.grid.arco.model.ViewConfiguration;
import com.sun.grid.arco.model.Vstring;
import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.exception.ArcoException;
import com.sun.grid.reporting.model.AdvancedQuery;
import com.sun.grid.reporting.model.DBTableViewConfiguration;
import com.sun.grid.reporting.model.GraphicalViewConfiguration;
import com.sun.grid.reporting.model.PivotViewConfiguration;
import com.sun.grid.reporting.model.QueryField;
import com.sun.grid.reporting.model.QueryFieldManager;
import com.sun.grid.reporting.model.QueryFilter;
import com.sun.grid.reporting.model.QueryFilterManager;
import com.sun.grid.reporting.model.QueryProperties;
import com.sun.grid.reporting.model.QuerySortPair;
import com.sun.grid.reporting.model.SimpleQuery;
import com.sun.grid.reporting.model.ViewConfigurationManager;
import com.sun.grid.reporting.sql.SQLGenerator;
import com.sun.grid.reporting.util.FilterType;
import com.sun.grid.reporting.util.LogicalConnection;
import com.sun.grid.reporting.util.SortType;
import com.sun.grid.reporting.viewconfiguration.ChartTypes;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;

public class QueryConverter {
    public static QueryProperties fromXML(ReportingObject obj) {
        QueryProperties props = new QueryProperties();
        props.setName(obj.getName());
        props.setCategory(obj.getCategory());
        if (obj.getLastModified() > 0L) {
            props.setCreationDate(new Date(obj.getLastModified()));
        }
        props.setDescription(null);
        try {
            props.setImageURL(obj.getImgURL());
        }
        catch (MalformedURLException mue) {
            SGELog.warning("Invalid ImageURL of reporting object {0}: {1}", (Object)obj.getName(), (Object)obj.getImgURL());
        }
        return props;
    }

    public static void toXML(QueryProperties props, ReportingObject obj) {
        obj.setName(props.getName());
        obj.setCategory(props.getCategory());
        if (props.getImageURL() != null) {
            obj.setImgURL(props.getImageURL().toString());
        }
    }

    public static Query queryToXml(com.sun.grid.reporting.model.Query query) {
        Query xmlQuery = QueryManager.getInstance().createQuery();
        QueryConverter.toXML(query.getQueryProperties(), xmlQuery);
        xmlQuery.setTableName(query.getBaseTable());
        if (query instanceof SimpleQuery) {
            SimpleQuery sq = (SimpleQuery)query;
            xmlQuery.setLimit(sq.getRowLimit());
            xmlQuery.setType("simple");
            QueryFilterManager filterManager = sq.getFilterManager();
            for (int i = 0; i < filterManager.getFilterCount(); ++i) {
                xmlQuery.getFilter().add(FilterConverter.toXML(filterManager.getFilter(i)));
            }
        } else {
            xmlQuery.setType("advanced");
        }
        xmlQuery.setSql(query.getUnparsedSQL());
        QueryFieldManager qfm = query.getFieldManager();
        Iterator iter = qfm.fields();
        Object field = null;
        Field xmlField = null;
        Object sortField = null;
        QuerySortPair sort = null;
        if (!query.isAdvancedQuery()) {
            sort = ((SimpleQuery)query).getSort();
        }
        while (iter.hasNext()) {
            xmlField = FieldConverter.toXML((QueryField)iter.next());
            xmlQuery.getField().add(xmlField);
            if (sort == null || sort.getField() == null || sort.getDirection() == null || xmlField.getReportName() == null || !sort.getField().getName(true).equals(xmlField.getReportName())) continue;
            xmlField.setSort(sort.getDirection().getName());
        }
        if (query.getViewConfigurationManager() != null) {
            xmlQuery.setView(ViewConverter.toXML(query.getViewConfigurationManager()));
            xmlQuery.getView().getDescription().setValue(query.getQueryProperties().getDescription());
        }
        return xmlQuery;
    }

    public static com.sun.grid.reporting.model.Query xmlToQuery(Query xmlQuery, SQLGenerator sqlGenerator) {
        String queryName = xmlQuery.getName();
        com.sun.grid.reporting.model.Query query = null;
        Iterator iter = null;
        if (xmlQuery.getType().equals("simple")) {
            SGELog.fine("query {0} is a simple query", (Object)queryName);
            SimpleQuery sq = new SimpleQuery(sqlGenerator);
            sq.setRowLimit(xmlQuery.getLimit());
            query = sq;
        } else {
            SGELog.fine("query {0} is a advanced query", (Object)queryName);
            AdvancedQuery aq = new AdvancedQuery();
            SGELog.fine("SQL for query {0} is {1}", (Object)queryName, (Object)xmlQuery.getSql());
            try {
                aq.setSQL(xmlQuery.getSql());
            }
            catch (ArcoException ae) {
                IllegalStateException ilse = new IllegalStateException("parse error in sql");
                ilse.initCause(ae);
                throw ilse;
            }
            query = aq;
        }
        if (xmlQuery.getTableName() != null) {
            query.setBaseTable(xmlQuery.getTableName().trim());
        }
        query.setQueryProperties(QueryConverter.fromXML(xmlQuery));
        QueryFieldManager fieldManager = query.getFieldManager();
        fieldManager.removeAllFields();
        iter = xmlQuery.getField().iterator();
        QueryField field = null;
        Field xmlField = null;
        QueryField sortField = null;
        SortType sortType = null;
        while (iter.hasNext()) {
            xmlField = (Field)iter.next();
            field = FieldConverter.fromXML(xmlField);
            fieldManager.addField(field);
            if (xmlField.getSort() == null) continue;
            SGELog.fine("field {0} will be sorted, direction is {1}", (Object)xmlField.getReportName(), (Object)xmlField.getSort());
            sortField = field;
            sortType = SortType.getSortTypeByName(xmlField.getSort());
        }
        if (sortField != null) {
            if (query.isAdvancedQuery()) {
                throw new IllegalStateException("For adcanced queries sorting is not allowed");
            }
            ((SimpleQuery)query).setSort(sortField, sortType);
        }
        query.setViewConfigurationManager(ViewConverter.fromXML(xmlQuery.getView()));
        query.getQueryProperties().setDescription(xmlQuery.getView().getDescription().getValue());
        if (!query.isAdvancedQuery()) {
            SimpleQuery sq = (SimpleQuery)query;
            iter = xmlQuery.getFilter().iterator();
            QueryFilterManager filterManager = new QueryFilterManager();
            QueryFilter filter = null;
            while (iter.hasNext()) {
                filter = FilterConverter.fromXML(sq, (Filter)iter.next());
                filterManager.addFilter(filter);
            }
            sq.setFilterManager(filterManager);
        }
        return query;
    }

    static class FieldConverter {
        FieldConverter() {
        }

        public static Field toXML(QueryField field) {
            try {
                Field xmlField = QueryManager.getInstance().getObjectFactory().createField();
                xmlField.setReportName(field.getName(true).trim());
                xmlField.setDbName(field.getDbFieldName().trim());
                if (field.getAggregateFunction() != null) {
                    xmlField.setFunction(field.getAggregateFunction().getName());
                }
                xmlField.setParameter(field.getAdditionalParameter());
                return xmlField;
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof field");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }

        public static QueryField fromXML(Field xmlField) {
            QueryField field = new QueryField();
            if (xmlField.getReportName() != null) {
                field.setName(xmlField.getReportName().trim());
            }
            field.setDbFieldName(xmlField.getDbName().trim());
            if (xmlField.getFunction() != null) {
                field.setAggregateFunction(xmlField.getFunction().trim());
            }
            if (xmlField.getParameter() != null) {
                field.setAdditionalParameter(xmlField.getParameter().trim());
            }
            return field;
        }
    }

    static class TableConverter {
        TableConverter() {
        }

        public static Table toXML(DBTableViewConfiguration dbtvc) {
            try {
                Table table = QueryManager.getInstance().getObjectFactory().createTable();
                Vector columns = dbtvc.getColumns();
                if (columns != null && !columns.isEmpty()) {
                    Iterator iter = columns.iterator();
                    while (iter.hasNext()) {
                        table.getColumn().add(((String)iter.next()).trim());
                    }
                }
                return table;
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof table");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }

        public static DBTableViewConfiguration fromXML(Table table) {
            DBTableViewConfiguration dbtvc = new DBTableViewConfiguration();
            if (table.getColumn() != null) {
                Iterator iter = table.getColumn().iterator();
                while (iter.hasNext()) {
                    dbtvc.addColumn(((String)iter.next()).trim());
                }
            }
            return dbtvc;
        }
    }

    static class GraphicConverter {
        GraphicConverter() {
        }

        public static Graphic toXML(GraphicalViewConfiguration gvc) {
            try {
                ObjectFactory faq = QueryManager.getInstance().getObjectFactory();
                Graphic graphic = faq.createGraphic();
                Iterator iter = null;
                graphic.setLegendVisible(!gvc.isHideLegend());
                if (gvc.getChartType().getName().equals(ChartTypes.BAR_CHART.getName())) {
                    Bar bar = faq.createBar();
                    iter = gvc.getXValues().iterator();
                    String value = null;
                    while (iter.hasNext()) {
                        value = (String)iter.next();
                        bar.getXaxis().add(value.trim());
                    }
                    bar.getYaxis().add(gvc.getYValue());
                    graphic.setBar(bar);
                } else if (gvc.getChartType().getName().equals(ChartTypes.LINE_CHART.getName())) {
                    Line line = faq.createLine();
                    iter = gvc.getXValues().iterator();
                    if (!iter.hasNext()) {
                        throw new IllegalArgumentException("no xaxis for line chart defined");
                    }
                    line.setXaxis(((String)iter.next()).trim());
                    line.setYaxis(gvc.getYValue());
                    line.setType(gvc.getType());
                    graphic.setLine(line);
                } else if (gvc.getChartType().getName().equals(ChartTypes.PIE_CHART.getName())) {
                    Pie pie = faq.createPie();
                    iter = gvc.getXValues().iterator();
                    if (!iter.hasNext()) {
                        throw new IllegalArgumentException("no xaxis for line chart defined");
                    }
                    pie.setXaxis(((String)iter.next()).trim());
                    pie.setYaxis(gvc.getYValue());
                    graphic.setPie(pie);
                } else if (gvc.getChartType().getName().equals(ChartTypes.STACKED_LINE_CHART.getName())) {
                    StackedLine stackedLine = faq.createStackedLine();
                    iter = gvc.getXValues().iterator();
                    if (!iter.hasNext()) {
                        throw new IllegalArgumentException("no xaxis for stacked line chart defined");
                    }
                    stackedLine.setXaxis(((String)iter.next()).trim());
                    stackedLine.setYaxis(gvc.getYValue());
                    stackedLine.setType(gvc.getType());
                    graphic.setStackedline(stackedLine);
                }
                return graphic;
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof graphic");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static GraphicalViewConfiguration fromXML(Graphic graphic) {
            SGELog.fine("entry");
            GraphicalViewConfiguration gvc = new GraphicalViewConfiguration();
            Iterator iter = null;
            String value = null;
            if (graphic.getBar() != null) {
                SGELog.fine("found a bar chart");
                gvc.setCharType(ChartTypes.BAR_CHART);
                if (graphic.getBar().getXaxis() == null) throw new IllegalStateException("no xaxis for bar chart defined");
                iter = graphic.getBar().getXaxis().iterator();
                while (iter.hasNext()) {
                    value = ((String)iter.next()).trim();
                    SGELog.fine("add xValue {0}", (Object)value);
                    gvc.addXValue(value);
                }
                iter = graphic.getBar().getYaxis().iterator();
                while (iter.hasNext()) {
                    value = ((String)iter.next()).trim();
                    SGELog.fine("yValue  = {0}", (Object)value);
                    gvc.setYValue(value);
                }
            } else if (graphic.getLine() != null) {
                gvc.setCharType(ChartTypes.LINE_CHART);
                SGELog.fine("found a line chart");
                if (graphic.getLine().getXaxis() == null) {
                    throw new IllegalStateException("no xaxis for line chart defined");
                }
                value = graphic.getLine().getXaxis().trim();
                SGELog.fine("xAxis = {0}", (Object)value);
                gvc.addXValue(value);
                if (graphic.getLine().getYaxis() == null) {
                    throw new IllegalStateException("no yaxis for line chart defined");
                }
                value = graphic.getLine().getYaxis().trim();
                SGELog.fine("yAxis = {0}", (Object)value);
                gvc.setYValue(value);
                if (graphic.getLine().getType() != null) {
                    value = graphic.getLine().getType().trim();
                    SGELog.fine("type = {1}");
                    gvc.setType(value);
                }
            } else if (graphic.getStackedline() != null) {
                gvc.setCharType(ChartTypes.STACKED_LINE_CHART);
                SGELog.fine("found a stacked line chart");
                StackedLine stackedLine = graphic.getStackedline();
                if (stackedLine.getXaxis() == null) {
                    throw new IllegalStateException("no xaxis for stacked line chart defined");
                }
                value = stackedLine.getXaxis().trim();
                SGELog.fine("xAxis = {0}", (Object)value);
                gvc.addXValue(value);
                if (stackedLine.getYaxis() == null) {
                    throw new IllegalStateException("no yaxis for stacked line chart defined");
                }
                value = stackedLine.getYaxis().trim();
                SGELog.fine("yAxis = {0}", (Object)value);
                gvc.setYValue(value);
                if (stackedLine.getType() != null) {
                    value = stackedLine.getType().trim();
                    SGELog.fine("type = {1}");
                    gvc.setType(value);
                }
            } else {
                if (graphic.getPie() == null) throw new IllegalStateException("bar, line or pie must be set");
                SGELog.fine("found a pie chart");
                gvc.setCharType(ChartTypes.PIE_CHART);
                if (graphic.getPie().getXaxis() == null) {
                    throw new IllegalStateException("no xaxis for pie chart defined");
                }
                value = graphic.getPie().getXaxis().trim();
                SGELog.fine("xAxis = {0}", (Object)value);
                gvc.addXValue(graphic.getPie().getXaxis());
                if (graphic.getPie().getYaxis() == null) throw new IllegalStateException("no yaxis for pie chart defined");
                value = graphic.getPie().getYaxis().trim();
                SGELog.fine("xAxis = {0}", (Object)value);
                gvc.setYValue(value);
            }
            gvc.setHideLegend(!graphic.isLegendVisible());
            SGELog.fine("exit");
            return gvc;
        }
    }

    static class PivotConverter {
        PivotConverter() {
        }

        public static Pivot toXML(PivotViewConfiguration pvc) {
            try {
                ObjectFactory faq = QueryManager.getInstance().getObjectFactory();
                Pivot ret = faq.createPivot();
                Iterator iter = pvc.rowAttributes();
                List list = ret.getRow();
                while (iter.hasNext()) {
                    list.add(((String)iter.next()).trim());
                }
                iter = pvc.columnAttributes();
                list = ret.getColumn();
                while (iter.hasNext()) {
                    list.add(((String)iter.next()).trim());
                }
                iter = pvc.dataAttributes();
                list = ret.getData();
                while (iter.hasNext()) {
                    list.add(((String)iter.next()).trim());
                }
                return ret;
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof pivot");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }

        public static PivotViewConfiguration fromXML(Pivot pivot) {
            PivotViewConfiguration pvc = new PivotViewConfiguration();
            Iterator iter = null;
            if (pivot.getRow() != null) {
                iter = pivot.getRow().iterator();
                while (iter.hasNext()) {
                    pvc.addRowAttribute(((String)iter.next()).trim());
                }
            }
            if (pivot.getColumn() != null) {
                iter = pivot.getColumn().iterator();
                while (iter.hasNext()) {
                    pvc.addColumnAttribute(((String)iter.next()).trim());
                }
            }
            if (pivot.getData() != null) {
                iter = pivot.getData().iterator();
                while (iter.hasNext()) {
                    pvc.addDataAttribute(((String)iter.next()).trim());
                }
            }
            return pvc;
        }
    }

    static class ViewConverter {
        ViewConverter() {
        }

        private static Vstring createVStr(boolean visible) throws JAXBException {
            try {
                Vstring vstring = QueryManager.getInstance().getObjectFactory().createVstring();
                vstring.setVisible(visible);
                return vstring;
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof vstring");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }

        public static ViewConfiguration toXML(ViewConfigurationManager vcm) {
            try {
                ViewConfiguration view = QueryManager.getInstance().getObjectFactory().createViewConfiguration();
                view.setDescription(ViewConverter.createVStr(!vcm.isHideDescription()));
                view.setParameter(ViewConverter.createVStr(!vcm.isHideParameter()));
                view.setSql(ViewConverter.createVStr(!vcm.isHideSQLStatement()));
                com.sun.grid.reporting.model.ViewConfiguration vc = null;
                int type = 0;
                block7: for (int i = 0; i < 3; ++i) {
                    vc = vcm.getViewConfigurationAt(i);
                    type = vcm.getViewConfigurationTypeAt(i);
                    switch (type) {
                        case 1: {
                            view.setTable(TableConverter.toXML((DBTableViewConfiguration)vc));
                            view.getTable().setOrder(i);
                            continue block7;
                        }
                        case 3: {
                            view.setGraphic(GraphicConverter.toXML((GraphicalViewConfiguration)vc));
                            view.getGraphic().setOrder(i);
                            continue block7;
                        }
                        case 2: {
                            view.setPivot(PivotConverter.toXML((PivotViewConfiguration)vc));
                            view.getPivot().setOrder(i);
                        }
                    }
                }
                return view;
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof view");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }

        public static ViewConfigurationManager fromXML(ViewConfiguration xmlVC) {
            ViewConfigurationManager vcm = new ViewConfigurationManager();
            Object iter = null;
            vcm.setHideDescription(xmlVC.getDescription() == null || !xmlVC.getDescription().isVisible());
            vcm.setHideParameter(xmlVC.getParameter() == null || !xmlVC.getParameter().isVisible());
            vcm.setHideSQLStatement(xmlVC.getSql() == null || !xmlVC.getSql().isVisible());
            int dbOrder = -1;
            int graphicOrder = -1;
            int pivotOrder = -1;
            if (xmlVC.getTable() != null) {
                Table table = xmlVC.getTable();
                DBTableViewConfiguration dbtvc = TableConverter.fromXML(table);
                vcm.setViewConfiguration(dbtvc, 1);
                dbOrder = table.getOrder();
                SGELog.fine("view at point {0} is table", new Integer(table.getOrder()));
            }
            if (xmlVC.getGraphic() != null) {
                GraphicalViewConfiguration gvc = GraphicConverter.fromXML(xmlVC.getGraphic());
                vcm.setViewConfiguration(gvc, 3);
                graphicOrder = xmlVC.getGraphic().getOrder();
                SGELog.fine("view at point {0} is graphic", new Integer(xmlVC.getGraphic().getOrder()));
            }
            if (xmlVC.getPivot() != null) {
                PivotViewConfiguration pvc = PivotConverter.fromXML(xmlVC.getPivot());
                vcm.setViewConfiguration(pvc, 2);
                pivotOrder = xmlVC.getPivot().getOrder();
                SGELog.fine("view at point {0} is pivot", new Integer(xmlVC.getPivot().getOrder()));
            }
            if (dbOrder >= 0) {
                vcm.setVisibleViewconfiguration(1, dbOrder);
            }
            if (graphicOrder >= 0) {
                vcm.setVisibleViewconfiguration(3, graphicOrder);
            }
            if (pivotOrder >= 0) {
                vcm.setVisibleViewconfiguration(2, pivotOrder);
            }
            return vcm;
        }
    }

    static class FilterConverter {
        FilterConverter() {
        }

        public static Filter toXML(QueryFilter filter) {
            try {
                Filter ret = QueryManager.getInstance().getObjectFactory().createFilter();
                ret.setActive(filter.isActivated());
                ret.setLateBinding(filter.isLateBinding());
                ret.setParameter(filter.getParameter());
                ret.setCondition(filter.getFilterType().getName());
                ret.setName(filter.getField().getName(true));
                if (filter.getLogicalConnection() != null) {
                    ret.setLogicalConnection(filter.getLogicalConnection().getName());
                }
                return ret;
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instanceof filter");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }

        public static QueryFilter fromXML(SimpleQuery query, Filter xmlFilter) {
            QueryField field = query.getFieldManager().getFieldByUserName(xmlFilter.getName());
            if (field == null) {
                throw new IllegalStateException("filtered field '" + xmlFilter.getName() + "' is unknown");
            }
            QueryFilter filter = new QueryFilter();
            filter.setActivated(xmlFilter.isActive());
            filter.setLateBinding(xmlFilter.isLateBinding());
            filter.setParameter(xmlFilter.getParameter());
            filter.setField(field);
            filter.setFilterType(FilterType.getFilterTypeByName(xmlFilter.getCondition()));
            if (xmlFilter.getLogicalConnection() != null) {
                filter.setLogicalConnection(LogicalConnection.getLogicalConnectionByName(xmlFilter.getLogicalConnection()));
            }
            return filter;
        }
    }
}

