/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.arco;

import com.sun.grid.arco.model.NamedObject;
import com.sun.grid.arco.model.ObjectFactory;
import com.sun.grid.arco.model.TOCEntry;
import com.sun.grid.arco.model.Toc;
import com.sun.grid.logging.SGELog;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;

public class AbstractXMLFileManager {
    private List namedObjectList = new ArrayList();
    private File dir;
    private JAXBContext jc;
    private ObjectFactory faq;
    private Object sync = new Object();
    Thread scanThread;
    private Class type;
    private Toc toc;
    private File tocFile;
    private static final FileFilter XML_FILE_FILTER = new QueryFileFilter();
    static /* synthetic */ Class class$com$sun$grid$arco$model$NamedObject;
    static /* synthetic */ Class class$com$sun$grid$arco$model$Toc;

    protected AbstractXMLFileManager(Class type, File dir, ClassLoader classLoader) {
        if (!(class$com$sun$grid$arco$model$NamedObject == null ? (class$com$sun$grid$arco$model$NamedObject = AbstractXMLFileManager.class$("com.sun.grid.arco.model.NamedObject")) : class$com$sun$grid$arco$model$NamedObject).isAssignableFrom(type)) {
            throw new IllegalArgumentException("type has to be a NamedObject(" + type.getName() + ")");
        }
        this.type = type;
        this.dir = dir;
        this.tocFile = new File(dir, "toc.xml");
        try {
            this.jc = JAXBContext.newInstance((String)"com.sun.grid.arco.model", (ClassLoader)classLoader);
            this.faq = new ObjectFactory();
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("Can't create JAXBContext");
            ilse.initCause(jaxbe);
            throw ilse;
        }
    }

    public ObjectFactory getObjectFactory() {
        return this.faq;
    }

    protected JAXBContext getJAXBContext() {
        return this.jc;
    }

    protected static TOCEntry getTOCEntryByFile(List list, File file) {
        Iterator iter = list.iterator();
        TOCEntry entry = null;
        while (iter.hasNext()) {
            entry = (TOCEntry)iter.next();
            if (!entry.getFile().equals(file.getName())) continue;
            return entry;
        }
        return null;
    }

    protected static TOCEntry getTOCEntryByName(List list, String name) {
        Iterator iter = list.iterator();
        TOCEntry elem = null;
        while (iter.hasNext()) {
            elem = (TOCEntry)iter.next();
            if (!elem.getName().equals(name)) continue;
            return elem;
        }
        return null;
    }

    protected TOCEntry getTOCEntryByName(String name) {
        return AbstractXMLFileManager.getTOCEntryByName(this.getTOC().getEntry(), name);
    }

    private Toc getTOC() {
        if (this.toc == null) {
            this.parseTOC();
        }
        return this.toc;
    }

    protected boolean validate(NamedObject object) {
        Validator validator = null;
        try {
            validator = this.getJAXBContext().createValidator();
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("Can't create validator");
            ilse.initCause(jaxbe);
            throw ilse;
        }
        try {
            return validator.validate((Object)object);
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("validate error");
            ilse.initCause(jaxbe);
            throw ilse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        Object object = this.sync;
        synchronized (object) {
            TOCEntry entry = this.getTOCEntryByName(name);
            if (entry != null) {
                this.getTOC().getEntry().remove(entry);
                File file = new File(this.dir, entry.getFile());
                if (!file.delete()) {
                    SGELog.warning("Can't delete file for entry with name '{0}'", (Object)name);
                }
                this.save((Object)this.getTOC(), this.tocFile);
                SGELog.info("entry with name '{0}' removed", (Object)name);
            } else {
                SGELog.warning("entry with name '{0}' is unknown, can't remove it", (Object)name);
            }
        }
    }

    protected NamedObject load(String name) {
        TOCEntry entry = this.getTOCEntryByName(name);
        if (entry != null) {
            File file = new File(this.dir, entry.getFile());
            return (NamedObject)this.parse(file, class$com$sun$grid$arco$model$NamedObject == null ? (class$com$sun$grid$arco$model$NamedObject = AbstractXMLFileManager.class$("com.sun.grid.arco.model.NamedObject")) : class$com$sun$grid$arco$model$NamedObject);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(NamedObject obj) {
        if (!this.type.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("obj must be an instance of " + this.type);
        }
        TOCEntry entry = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.scanThread != null) {
                try {
                    SGELog.fine("wait for end of scan thread before obj is stored");
                    this.sync.wait();
                }
                catch (InterruptedException ire) {
                    SGELog.warning("saveObject was interupted, can''t store query {0}", (Object)obj.getName());
                    return;
                }
            }
            if ((entry = this.getTOCEntryByName(obj.getName())) == null) {
                entry = this.createTOCEntry();
                entry.setFile(this.generateFilename(obj));
                this.getTOC().getEntry().add(entry);
            }
            entry.setName(obj.getName());
            entry.setImgURL(obj.getImgURL());
            entry.setCategory(obj.getCategory());
            entry.setType(obj.getType());
            this.save((Object)obj, new File(this.dir, entry.getFile()));
            entry.setLastModified(System.currentTimeMillis());
            this.save((Object)this.getTOC(), this.tocFile);
        }
    }

    private String generateFilename(NamedObject obj) {
        String name = obj.getName().replace(' ', '_').replace('/', '_');
        String filename = name + ".xml";
        File file = new File(this.dir, filename);
        int i = 0;
        while (file.exists()) {
            filename = name + ++i + ".xml";
            file = new File(this.dir, filename);
        }
        return filename;
    }

    public void save(Object obj, Writer writer) {
        Marshaller marshaller = null;
        try {
            marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("Can't create marshaller");
            ilse.initCause(jaxbe);
            throw ilse;
        }
        try {
            marshaller.marshal(obj, writer);
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("marshal error");
            ilse.initCause(jaxbe);
            throw ilse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object obj, File file) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
        }
        catch (IOException ioe) {
            IllegalStateException ilse = new IllegalStateException("Can't open file " + file.getAbsolutePath() + " for writting");
            ilse.initCause(ioe);
            throw ilse;
        }
        try {
            this.save(obj, fw);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                fw.close();
            }
            catch (IOException ioe) {
                IllegalStateException ilse = new IllegalStateException("Closing file " + file.getAbsolutePath() + " failed");
                ilse.initCause(ioe);
                throw ilse;
            }
            throw throwable;
        }
        try {
            fw.close();
        }
        catch (IOException ioe) {
            IllegalStateException ilse = new IllegalStateException("Closing file " + file.getAbsolutePath() + " failed");
            ilse.initCause(ioe);
            throw ilse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan() {
        block14: {
            boolean iAmIn = false;
            try {
                Object object;
                Object object2 = this.sync;
                synchronized (object2) {
                    if (this.scanThread == null) {
                        iAmIn = true;
                        this.scanThread = Thread.currentThread();
                    } else {
                        this.sync.wait();
                    }
                }
                if (!iAmIn) break block14;
                try {
                    this.scanDir();
                    Object var5_5 = null;
                    this.scanThread = null;
                    object = this.sync;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.scanThread = null;
                    Object object3 = this.sync;
                    synchronized (object3) {
                        this.sync.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (object) {
                    this.sync.notifyAll();
                }
            }
            catch (InterruptedException ire) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedObject[] getAvailableObjects() {
        NamedObject[] ret;
        this.scan();
        Object object = this.sync;
        synchronized (object) {
            Toc toc = this.getTOC();
            ret = new NamedObject[toc.getEntry().size()];
            toc.getEntry().toArray(ret);
        }
        return ret;
    }

    private Object parse(File file, Class expectedType) {
        try {
            SGELog.fine("parse file {0}", file);
            Unmarshaller um = this.getJAXBContext().createUnmarshaller();
            Object obj = um.unmarshal(file);
            if (!expectedType.isAssignableFrom(obj.getClass())) {
                SGELog.warning("file {0} does not contain an instance of {1}", file, (Object)this.type.getName());
                return null;
            }
            return obj;
        }
        catch (Exception e) {
            SGELog.warning((Throwable)e, "Error while parsing query file {0}", (Object)file);
            return null;
        }
    }

    private void parseTOC() {
        if (this.tocFile.exists()) {
            SGELog.fine("toc file exists, parse it");
            this.toc = (Toc)this.parse(this.tocFile, class$com$sun$grid$arco$model$Toc == null ? (class$com$sun$grid$arco$model$Toc = AbstractXMLFileManager.class$("com.sun.grid.arco.model.Toc")) : class$com$sun$grid$arco$model$Toc);
            SGELog.fine("toc has {0} entries", new Integer(this.toc.getEntry().size()));
        }
        if (this.toc == null) {
            SGELog.info("toc file does not exist, create an empty toc");
            try {
                this.toc = this.getObjectFactory().createToc();
            }
            catch (JAXBException jaxbe) {
                IllegalStateException ilse = new IllegalStateException("Can't create instancoef Toc");
                ilse.initCause(jaxbe);
                throw ilse;
            }
        }
    }

    private void scanDir() {
        SGELog.info("scanning directory {0}", this.dir);
        if (this.toc == null) {
            this.parseTOC();
        }
        File[] files = this.dir.listFiles(XML_FILE_FILTER);
        String name = null;
        if (files != null && files.length > 0) {
            SGELog.fine("found {0} xml files", new Integer(files.length));
            ArrayList tmpList = new ArrayList(this.toc.getEntry().size());
            tmpList.addAll(this.toc.getEntry());
            TOCEntry entry = null;
            long lastModified = 0L;
            NamedObject obj = null;
            boolean newEntry = false;
            boolean tocModified = false;
            for (int i = 0; i < files.length; ++i) {
                newEntry = false;
                entry = AbstractXMLFileManager.getTOCEntryByFile(this.toc.getEntry(), files[i]);
                if (entry == null) {
                    try {
                        entry = this.getObjectFactory().createTOCEntry();
                    }
                    catch (JAXBException jaxbe) {
                        IllegalStateException ilse = new IllegalStateException("Can't create instancoef TOCEntry");
                        ilse.initCause(jaxbe);
                        throw ilse;
                    }
                    entry.setFile(files[i].getName());
                    newEntry = true;
                } else {
                    tmpList.remove(entry);
                }
                if (entry.getLastModified() < files[i].lastModified()) {
                    obj = (NamedObject)this.parse(files[i], class$com$sun$grid$arco$model$NamedObject == null ? AbstractXMLFileManager.class$("com.sun.grid.arco.model.NamedObject") : class$com$sun$grid$arco$model$NamedObject);
                    if (obj == null) {
                        entry.setName(this.generateUniqueName("Unknown"));
                        entry.setCategory("Error");
                        entry.setLastModified(files[i].lastModified());
                        entry.setType("Error");
                        tocModified = true;
                    } else {
                        TOCEntry tmpEntry = this.getTOCEntryByName(obj.getName());
                        if (tmpEntry == null) {
                            entry.setName(obj.getName());
                        } else if (entry != tmpEntry) {
                            entry.setName(this.generateUniqueName(name));
                        }
                        entry.setCategory(obj.getCategory());
                        entry.setImgURL(obj.getImgURL());
                        entry.setType(obj.getType());
                        entry.setLastModified(files[i].lastModified());
                        tocModified = true;
                    }
                }
                if (!newEntry) continue;
                this.toc.getEntry().add(entry);
                tocModified = true;
            }
            SGELog.fine("Found {0} removed files", new Integer(tmpList.size()));
            Iterator iter = tmpList.iterator();
            while (iter.hasNext()) {
                entry = (TOCEntry)iter.next();
                SGELog.info("remove entry " + entry.getName());
                this.getTOC().getEntry().remove(entry);
                tocModified = true;
            }
            if (tocModified) {
                this.save((Object)this.toc, this.tocFile);
            }
        } else {
            SGELog.fine("No xml files found");
        }
    }

    private String generateUniqueName(String name) {
        String currentName = name;
        int i = 0;
        while (this.getTOCEntryByName(currentName) != null) {
            currentName = name + ++i;
        }
        return currentName;
    }

    private TOCEntry createTOCEntry() {
        try {
            return this.getObjectFactory().createTOCEntry();
        }
        catch (JAXBException jaxbe) {
            IllegalStateException ilse = new IllegalStateException("Can't create instancoef TOCEntry");
            ilse.initCause(jaxbe);
            throw ilse;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class QueryFileFilter
    implements FileFilter {
        QueryFileFilter() {
        }

        public boolean accept(File pathname) {
            return !pathname.isDirectory() && pathname.getName().toLowerCase().endsWith(".xml") && !pathname.getName().equals("toc.xml");
        }
    }
}

