package storage;

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;


public class SessionDispatcher extends HttpServlet implements Serializable {
    
    /** Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        
    }
    
    /** Destroys the servlet.
     */
    public void destroy() {
        
    }
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        
        // Do I need this???
        HttpSession session = request.getSession(true);
        if (session.isNew()) {
            System.out.println("This is NEW SESSION");
            session = request.getSession(false);
        }
        else {
            System.out.println("Dispatcher: session invalidated");
            session.invalidate();
        }
        // -----------------
        
        String mode = (String)request.getParameter("choice");

        if (mode.equals("single")) {
            response.sendRedirect("/SessionStorage/SessionWithBigObject");
        }
        else if (mode.equals("multiple")) {
            request.getRequestDispatcher("/AttributeData.jsp").forward(request,response);
        }

        out.close();
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Session Dispatcher";
    }
    
}
