<%--
 
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
 * DAMAGES OR LIABILITIES SUFFERED BY LICENSEE AS A RESULT OF OR
 * RELATING TO USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE OR
 * ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT,
 * SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF
 * THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
  
--%>

<%@ include file="initdestroy.jsp" %>
<%@ page import="java.util.*, bookstore.cart.*" %>
<%
   ResourceBundle messages = (ResourceBundle)session.getAttribute("messages");
%>

<jsp:useBean id="bookDB" class="bookstore.database.BookDB" scope="page" >
  <jsp:setProperty name="bookDB" property="database" value="<%=bookDBAO%>" />
</jsp:useBean>

<jsp:useBean id="currency" class="bookstore.util.Currency" scope="session">
  <jsp:setProperty name="currency" property="locale" value="<%=request.getLocale()%>"/>
</jsp:useBean>

<jsp:useBean id="cart" class="bookstore.cart.ShoppingCart" scope="session"/>

<%
  String bookId = request.getParameter("Remove");
  if (bookId != null) {
    cart.remove(bookId);
    bookDB.setBookId(bookId);
      BookDetails book = bookDB.getBookDetails();
%>
<font color="red" size="+2"><%=messages.getString("CartRemoved")%><em><%=book.getTitle()%></em>
<br>&nbsp;<br></font>
<%
  }
if (request.getParameter("Clear") != null) {
  cart.clear();
%>

<font color="red" size="+2"><strong><%=messages.getString("CartCleared")%></strong><br>&nbsp;<br></font>

<%
  }
  // Print a summary of the shopping cart
  int num = cart.getNumberOfItems();
  if (num > 0) {
%>

<font size="+2"><%=messages.getString("CartContents")%><%=num%> <%=(num==1 ? messages.getString("CartItem") : messages.getString("CartItems"))%>
</font><br>&nbsp;

<table>
<tr>
<th align=left><%=messages.getString("ItemQuantity")%></TH>
<th align=left><%=messages.getString("ItemTitle")%></TH>
<th align=left><%=messages.getString("ItemPrice")%></TH>
</tr>

<%
    Iterator i = cart.getItems().iterator();
    while (i.hasNext()) {
      ShoppingCartItem item = (ShoppingCartItem)i.next();
      BookDetails book = (BookDetails)item.getItem();
%>

<tr>
<td align="right" bgcolor="#ffffff"><%=item.getQuantity()%></td>
<td bgcolor="#ffffaa">
<strong><a href="<%=request.getContextPath()%>/bookdetails?bookId=<%=book.getBookId()%>">
<%=book.getTitle()%></a></strong>
</td>

<td bgcolor="#ffffaa" align="right">
<jsp:setProperty name="currency" property="amount" value="<%=book.getPrice()%>"/>
<jsp:getProperty name="currency" property="format"/>&nbsp;</td>

<td bgcolor="#ffffaa">
<strong>
<a href="<%=request.getContextPath()%>/showcart?Remove=<%=book.getBookId()%>"><%=messages.getString("RemoveItem")%></a></strong>
</td></tr>

<%
    // End of while
      }
%>
<tr><td colspan="5" bgcolor="#ffffff">
<br></td></tr>

<tr>
<td colspan="2" align="right" "bgcolor="#ffffff">
<%=messages.getString("Subtotal")%></td>
<td bgcolor="#ffffaa" align="right">
<jsp:setProperty name="currency" property="amount" value="<%=cart.getTotal()%>"/>
<jsp:getProperty name="currency" property="format"/>
</td>
</td><td><br></td></tr></table>

<p>&nbsp;<p>
<strong><a href="<%=request.getContextPath()%>/catalog"><%=messages.getString("ContinueShopping")%></a>&nbsp;&nbsp;&nbsp;
<a href="<%=request.getContextPath()%>/cashier"><%=messages.getString("Checkout")%></a>&nbsp;&nbsp;&nbsp;
<a href="<%=request.getContextPath()%>/showcart?Clear=clear"><%=messages.getString("ClearCart")%></a></strong>
<%
} else {
%>

<font size="+2"><%=messages.getString("CartEmpty")%></font>
<br>&nbsp;<br>
<a href="<%=request.getContextPath()%>/catalog"><%=messages.getString("Catalog")%></a>
<BR>&nbsp;<BR>
<%
  // End of if
  }
%>
