<%--
 
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
 * DAMAGES OR LIABILITIES SUFFERED BY LICENSEE AS A RESULT OF OR
 * RELATING TO USE, MODIFICATION OR DISTRIBUTION OF THIS SOFTWARE OR
 * ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT,
 * SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
 * CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF
 * THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS
 * BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
  
--%>

<%@ include file="initdestroy.jsp" %>
<%@ page import="java.util.*" %>

<%
   ResourceBundle messages = (ResourceBundle)session.getAttribute("messages");
%>

<jsp:useBean id="bookDB" class="bookstore.database.BookDB" scope="page" >
  <jsp:setProperty name="bookDB" property="database" value="<%=bookDBAO%>" />
</jsp:useBean>

<jsp:useBean id="currency" class="bookstore.util.Currency" scope="session">
  <jsp:setProperty name="currency" property="locale" value="<%=request.getLocale()%>"/>
</jsp:useBean>

<html>
<head><title><%=messages.getString("TitleBookDescription")%></title></head>
<%-- <%@ include file="banner.jsp" %>
<br>&nbsp; --%>
<%
    //Get the identifier of the book to display
    String bookId = request.getParameter("bookId");
    bookDB.setBookId(bookId);
    BookDetails book = bookDB.getBookDetails();
%>

<h2><%=book.getTitle()%></h2>

&nbsp;<%=messages.getString("By")%> <em><%=book.getFirstName()%> <%=book.getSurname()%></em>&nbsp;&nbsp;
(<%=book.getYear()%>)<br> &nbsp; <br>

<h4><%=messages.getString("Critics")%></h4>
<blockquote><%=book.getDescription()%></blockquote>
<jsp:setProperty name="currency" property="amount" value="<%=book.getPrice()%>"/>
<h4><%=messages.getString("Price")%><%=currency.getFormat()%></h4>

<p><strong><a href="<%=request.getContextPath()%>/catalog?Add=<%=bookId%>"><%=messages.getString("CartAdd")%></a>
&nbsp; &nbsp; &nbsp;
<a href="<%=request.getContextPath()%>/catalog"><%=messages.getString("ContinueShopping")%></a></p></strong>

