/*
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
 * OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
 * FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that Software is not designed, licensed or intended
 * for use in the design, construction, operation or maintenance of
 * any nuclear facility.
 */
package com.sun.j2ee.blueprints.waf.controller.web;

import java.util.Collection;
import java.util.HashMap;



import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.ServletException;
import com.sun.j2ee.blueprints.waf.util.JNDINames;

import com.sun.j2ee.blueprints.util.tracer.Debug;
import com.sun.j2ee.blueprints.waf.controller.web.util.WebKeys;
import com.sun.j2ee.blueprints.waf.event.Event;
import com.sun.j2ee.blueprints.waf.event.EventException;
import com.sun.j2ee.blueprints.waf.event.EventResponse;
import com.sun.j2ee.blueprints.waf.controller.web.action.HTMLAction;
import com.sun.j2ee.blueprints.waf.controller.web.action.HTMLActionException;
import com.sun.j2ee.blueprints.waf.controller.web.ServiceLocator;

/**
 * This is the web tier controller for the sample application.
 *
 * This class is responsible for processing all requests received from
 * the Main.jsp and generating necessary events to modify data which
 * are sent to the ShoppingClientControllerWebImpl.
 *
 */
public class RequestProcessor implements java.io.Serializable {

    private ServletContext context;
    private HashMap urlMappings;

    /** Empty constructor for use by the JSP engine. */
    public RequestProcessor() {}


    public void init(ServletContext context) {
        this.context = context;
        urlMappings = (HashMap)context.getAttribute(WebKeys.URL_MAPPINGS);
    }

    /**
     * The UrlMapping object contains information that will match
     * a url to a mapping object that contains information about
     * the current screen, the HTMLAction that is needed to
     * process a request, and the HTMLAction that is needed
     * to insure that the propper screen is displayed.
    */

    private URLMapping getURLMapping(String urlPattern) {
        if ((urlMappings != null) && urlMappings.containsKey(urlPattern)) {
            return (URLMapping)urlMappings.get(urlPattern);
        } else {
            return null;
        }
    }


    /**
    * This method is the core of the RequestProcessor. It receives all requests
    *  and generates the necessary events.
    */
    public void processRequest(HttpServletRequest request) throws HTMLActionException, EventException, ServletException {
        Event ev = null;
        String fullURL = request.getRequestURI();
        // get the screen name
        String selectedURL = null;
        int lastPathSeparator = fullURL.lastIndexOf("/") + 1;
        if (lastPathSeparator != -1) {
            selectedURL = fullURL.substring(lastPathSeparator, fullURL.length());
        }


       HTMLAction action = getAction(selectedURL);
       if (action != null) {
           action.setServletContext(context);
           action.doStart(request);
           ev = action.perform(request);
           EventResponse eventResponse = null;
           if (ev != null) {
               ServiceLocator sl = (ServiceLocator)request.getSession().getAttribute(WebKeys.SERVICE_LOCATOR);
               WebClientController wcc =  sl.getWebClientController();
               eventResponse  = wcc.handleEvent(ev);
           }
           action.doEnd(request, eventResponse);
        }
    }

    /**
     * This method load the necessary HTMLAction class necessary to process a the
     * request for the specified URL.
     */

    private HTMLAction getAction(String selectedUrl) {
        HTMLAction handler = null;
        URLMapping urlMapping = getURLMapping(selectedUrl);
        String actionClassString = null;
        if (urlMapping != null) {
            actionClassString = urlMapping.getAction();
            if (urlMapping.isAction()) {
                try {
                    handler = (HTMLAction)getClass().getClassLoader().loadClass(actionClassString).newInstance();
                } catch (Exception ex) {
                    System.err.println("RequestProcessor caught loading action: " + ex);
                }
            }
        }
        return handler;
    }

}

