#
# Copyright C 2003 Sun Microsystems, Inc.
# All rights reserved. Use is subject to license terms.
#
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#

#
# $Revision: 1.9 $ $Date: 2003/05/30 20:07:43 $
#

namespace eval dps52svrUninstall {
    
    proc getInstallBreadCrumbID { xName } {
	upvar $xName x

	set id ""

	set iName [file join $x(root) setup dps admserv.txt]

	if [catch {open $iName r} iFile] {
	} else {
	    gets $iFile id_class
	    close $iFile
	    set id [lindex [split $id_class ":"] 0]
	}

	return $id
    }

    proc main { xName } {
	upvar $xName x

	set rc [expr 0]

	if [unix] {
	    set skipAS [expr [string first $x(root) $x(java.home)] == 0]
	} else {
	    set skipAS [expr [string first [string tolower $x(root)] [string tolower $x(java.home)]] == 0]
	}

	set skipAS [expr 0]

	if {$skipAS} {
	    puts stdout "Skipping Administration Server removal since Java used to uninstall is the java owned by the Administration Server."
	} else {
	    if [catch {findAdminUninstaller x} pathToUninstall] {
		puts stdout "Skipping Administration Server removal since more than one uninstall class was found (suggesting other products may be using this server instance)."
	    } else {
		if [catch {fetchSetupID x $pathToUninstall} uninstallID] {
		    puts stderr $uninstallID
		    set rc [expr 4]
		} else {
		    if [string equal $uninstallID [getInstallBreadCrumbID x]] {
			#
			# if we are here, then our install process installed the A.S. too
			#
			set cwd [pwd]
			cd [file join $x(root) setup]
			catch {glob *.class} result
			cd $cwd
			if [expr [llength $result] == 1] {
			    #
			    # the only class file remaining must be the A.S.
			    # uninstaller as no one else has joined the "party"
			    # and left a "class" calling card.
			    #			
			    if [catch {emitASStateFile x $uninstallID} stateFileName] {
				puts stderr $stateFileName
				set rc [expr 1]
			    } else {
				if [catch {uninstallAdminServer x $pathToUninstall $stateFileName} uninstallText] {
				    puts stderr $uninstallText
				    puts stderr "Unhappy Admin Server uninstaller...."
				    set rc [expr 2]
				} else {
				    puts stdout $uninstallText			
				}
				file delete $stateFileName
			    }
			}
		    } else {
			puts stdout "Skipping Administration Server removal since it does not appear that DPS installed it."
		    }
		}
	    }
	}
	 
	return $rc
    }

    proc uninstallAdminServer { xName classFile stateFile } {
	upvar $xName x

	set cwd [pwd]
	cd [file dirname $classFile]
	set className [dropClass [file tail $classFile]]
	set cmd [list exec [pathToJava x] [javaLibraryPath x] -cp . $className -state $stateFile -noconsole -nodisplay]
	puts stdout $cmd
	if [catch $cmd result] {
	    cd $cwd
	    error $result
	}
	cd $cwd
	file delete -force [file join $x(root) setup/locale]
	
	return $result
    }
}
