#
# Copyright C 2003 Sun Microsystems, Inc.
# All rights reserved. Use is subject to license terms.
#
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#

#
# $Revision: 1.12 $ $Date: 2003/05/30 20:07:43 $
#

#
# This installer's charter is to determine if we need to silently install
# an Admin Server at our server root.
#

namespace eval dps52svr {
	
    proc installAdminServer { xName classFile stateFile } {
	upvar $xName x

	set cwd [pwd]

	cd [file dirname $classFile]

	set classPath [pwd]

	#
	# We copy the resources first as the installer builds an
	# empty locale/resources directory structure that will
	# cause the tclsh copy to fail when done after the fact.
	#

	set setup [file join $x(root) setup]

	file mkdir $setup

	file copy locale $setup

	if [file writable .] {
	    set scratch ""
	} else {
	    #
	    # we need to run java with a current working directory
	    # which allows java to create temp files (for stderr
	    # and stdout).
	    #
	    set scratch [file join $x(root) bin dps scratch]
	    file mkdir $scratch
	    file copy setup_data $scratch
	    if [unix] {
		cd $setup
		fixPermissions [expr 00755] [expr 00600]
		cd $scratch
		fixPermissions [expr 00755] [expr 00600]
	    } else {
		cd $scratch
	    }
	}

	set className [dropClass [file tail $classFile]]
	set cmd [list exec [pathToJava x] [javaLibraryPath x] -cp $classPath $className -state $stateFile -noconsole -nodisplay]
	puts stdout $cmd

	set rc [catch $cmd result]

	cd $cwd

	if [string length $scratch] {
	    file delete -force $scratch
	}

	if { $rc } {
	    error $result
	}

	return $result
    }

    proc main { xName } {
	upvar $xName x

	set rc [expr 0]

	if [info exist x(installAdminServer)] {
	} else {
	    set x(installAdminServer) [expr 0]
	}

	if {$x(installAdminServer)} {
	    if [catch {findAdminInstaller x} pathToClass] {
		puts stderr $pathToClass
		set rc [expr 1]
	    } else {
		if [catch {fetchSetupID x $pathToClass} setupID]  {
		    puts stderr $setupID
		    set rc [expr 2]
		} else {
		    if [catch {emitASStateFile x $setupID} stateFileName] {
			puts stderr $stateFileName
			set rc [expr 3]
		    } else {
			if [catch {installAdminServer x $pathToClass $stateFileName} installText] {
			    puts stderr $installText
			    puts stderr "Unhappy Admin Server installer...."
			    set rc [expr 4]
			} else {
			    puts stdout $installText
			    if [catch {findAdminUninstaller x} pathToUninstall] {
			    } else {
				if [catch {fetchSetupID x $pathToUninstall} uninstallID] {
				} else {
				    set oName [file join $x(root) setup dps admserv.txt]
				    set oFile [open $oName w]
				    puts $oFile "$uninstallID:$pathToUninstall"
				    close $oFile
				}
			    }
			}
			file delete $stateFileName
		    }
		}
	    }
	}

	return $rc
    }
}
