#
# Copyright C 2002-2003 Sun Microsystems, Inc.
# All rights reserved. Use is subject to license terms.
#
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#

#
# $Revision: 1.9 $ $Date: 2003/05/30 20:07:43 $
#

namespace eval dps52insUnix {
    
    proc convert { xName } {
	upvar $xName x
	
	return [ootb x]
    }
    
    proc emitTailor { xName } {
	upvar $xName x
	
	set oFile [dpsWriteOpen [file join $x(instanceRoot) tailor] 0744]
	puts $oFile "#!/bin/sh"
	puts $oFile "#"
	puts $oFile "# PROPRIETARY/CONFIDENTIAL. Use of this product is subject to"
	puts $oFile "# license terms. Copyright C 2002-2003 Sun Microsystems, Inc."
	puts $oFile "# All rights reserved."
	puts $oFile "#"
	puts $oFile ""
	puts $oFile ". \"[file join $x(instanceRoot) environment-dps]\""
	puts $oFile ""
	puts $oFile "\"\${DPS_TCLSH}\" \"\${DPS_CID}/bin/dps/server/script/tailor.tcl\" \"\$@\""
	puts $oFile ""
	close $oFile
    }
    
    proc emitWrap { xName wrap {perm 0744} } {
	upvar $xName x
	
	set oFile [dpsWriteOpen [file join $x(instanceRoot) $wrap-dps] $perm]
	puts $oFile "#!/bin/sh"
	puts $oFile "#"
	puts $oFile "# PROPRIETARY/CONFIDENTIAL. Use of this product is subject to"
	puts $oFile "# license terms. Copyright C 2002-2003 Sun Microsystems, Inc."
	puts $oFile "# All rights reserved."
	puts $oFile "#"
	puts $oFile ""
	puts $oFile ". \"[file join $x(instanceRoot) environment-dps]\""
	puts $oFile ""
	puts $oFile ". \"\${DPS_CID}/bin/dps/server/script/$wrap\" \"\$@\""
	puts $oFile ""
	puts $oFile "# This line is never reached as $wrap always exits."    
	puts $oFile ""
	close $oFile
    }
    
    proc main { xName } {
	upvar $xName x
	
	if [file exist [file join $x(instanceRoot) environment-dps]] {
	    set rc [patch x]
	} else {
	    set rc [ootb x]
	}
	
	return $rc
    }
    
    proc ootb { xName } {
	upvar $xName x
	
	# emitTailor x
	
	foreach i [list hup restart start stop] {
	    emitWrap x $i
	}
	
	foreach {i perm} [list status 0755] {
	    emitWrap x $i $perm
	}
	
	return 0
    }
    
    proc patch { xName } {
	upvar $xName x
	
	stopDps x

	return 0
    }
    
}
