#
# Copyright C 2003 Sun Microsystems, Inc.
# All rights reserved. Use is subject to license terms.
#
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#

#
# $Revision: 1.2 $ $Date: 2003/05/30 20:07:42 $
#

namespace eval dps52cfgUninstall {

    proc backoutJVMConf { xName } {
	upvar $xName x

	if [unix] {
	    set sep ":"
	} else {
	    set sep ";"
	}

	set iName [file join $x(root) admin-serv config jvm12.conf]
	set iFile [open $iName r]
	
	set data [list]
	
	while {[gets $iFile line] >= 0} {
	    if [regexp -nocase "^jvm.classpath\[ \]*=" $line] {
		lappend data "#$line"
		set path [string range $line [expr [string first "=" $line 0] + 1] end]
		set paths [list]
		set line ""
		foreach i [split $path $sep] {
		    if [regexp -nocase "bin/dps/admin" $i] {
		    } else {
			if [string length $line] {
			    append line $sep $i
			} else {
			    append line "jvm.classpath=" $i
			}
		    }
		}
		if [string length $line] {
		    lappend data $line
		}
	    } else {
		lappend data $line
	    }
	}
	
	close $iFile
	set oFile [open $iName w]
	
	foreach i $data {
	    puts $oFile $i
	}

	close $oFile
    }
    
    proc main { xName } {
	upvar $xName x
	
	set rc [expr 0]

	if [catch {backoutJVMConf x} result] {
	    puts stderr $result
	}

	if [catch {restartAdmin x} result] {
	    error $result
	}
	
	return $rc
    }
}
