#
# Copyright C 2002-2003 Sun Microsystems, Inc.
# All rights reserved. Use is subject to license terms.
#
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#

#
# $Revision: 1.6 $ $Date: 2003/05/30 20:07:42 $
#

namespace eval dps52cfg {
    
    proc tweakJVM { xName } {
	upvar $xName x
	global tcl_platform
	
	#
	# assume that the admin server is stopped.
	#
	
	set iName [file join $x(root) admin-serv config jvm12.conf]
	set oName [file join $x(root) admin-serv config new.jvm12.conf]
	
	set iFile [open $iName r]
	
	if [unix] {
	    set perm [file attributes $iName -permissions]
	    set oFile [open $oName w $perm]
	} else {
	    set oFile [open $oName w]
	}
	
	set classpath ""
	
	while {[gets $iFile line] >= 0} {
	    if [regexp -nocase "^jvm\.classpath=" $line] {
		set classpath $line
	    } else {
		puts $oFile $line
	    }
	}
	
	set newpath ""
	
	foreach i [list servlets \
		[file join servlets xtl-admin-engine.jar] \
		[file join servlets jakarta-oro-2.0.jar] \
		[file join servlets dps-server52.jar] \
		] {
	    set j [file join $x(root) bin dps admin $i]
	    if [regexp $j $classpath] {
	    } else {
		append newpath "[javaSeperator]$j"
	    }
	}
	
	if [string length $classpath] {
	    puts $oFile "$classpath$newpath"
	} else {
	    puts $oFile "jvm.classpath=[string range $newpath 1 end]"
	}
	
	close $oFile
	close $iFile
	
	file delete $iName
	file rename $oName $iName

    }
    
    proc main { xName } {
	upvar $xName x
	
	tweakJVM x

	restartAdmin x

	return 0
    }
}
