#!/bin/sh
#
# (c) 2004 Sun Microsystems, Inc. Use is subject to license terms.  

# ----------------------------------------
#
# example for a load sensor script
#
# Be careful: Load sensor scripts are started with root permissions.
# In an admin_user system euid=0 and uid=admin_user
#

PATH=/bin:/usr/bin


ARCH=`$SGE_ROOT/util/arch`
HOST=`$SGE_ROOT/utilbin/$ARCH/gethostname -name`

end=false
while [ $end = false ]; do

   # ---------------------------------------- 
   # wait for an input
   #
   read input
   result=$?
   if [ $result != 0 ]; then
      end=true
      break
   fi
   
   if [ "$input" = "quit" ]; then
      end=true
      break
   fi

   # ---------------------------------------- 
   # send mark for begin of load report
   echo "begin"

   # ---------------------------------------- 
   # send load value arch
   #
   echo "$HOST:arch:$ARCH"
   load=`uptime |cut -f4- -d"," |cut -f2 -d":"`

   # ---------------------------------------- 
   # send load value load.5m
   #
   echo "$HOST:load.5m:`echo $load|cut -f1 -d","`"

   # ---------------------------------------- 
   # send load value load.10m
   #
   echo "$HOST:load.10m:`echo $load|cut -f2 -d","`"

   # ---------------------------------------- 
   # send load value load.15m
   #
   echo "$HOST:load.15m:`echo $load|cut -f3 -d","`"

   # ---------------------------------------- 
   # send mark for end of load report
   echo "end"
done
