#!/bin/ksh

# (c) 2004 Sun Microsystems, Inc. Use is subject to license terms.  

# example for a interix load sensor script
#
# Be careful: Load sensor scripts are started with Administartor permissions.
# In an admin_user system euid=0 and uid=admin_user

PATH=/bin:/usr/bin
ARCH=`$SGE_ROOT/util/arch`

# start the loadsensor.exe binary as co-process
#
#  TODO: add additional parameter if necessary
#        use "qloadsensor.exe -help"
#        or read the man page if you need additional help
#
$SGE_ROOT/bin/$ARCH/qloadsensor.exe -set-load-fac 0.8 |&

end=false
while [ $end = false ]; do
   # wait for an input
   read input
   result=$?
   if [ $result != 0 ]; then
      end=true
      break
   fi

   if [ "$input" = "quit" ]; then

      # quit co-process
      print -p "quit"

      end=true
      break
   fi

   # send mark for begin of load report
   echo "begin"

   # send additional load values
   #
   #  TODO: add additional loadvalues to be reported 
   #
   echo "$HOST:arch:$ARCH"

   # send the co-process a \n
   print -p ""
  
   # handle co-process output 
   co_end=false
   while [ $co_end = false ]; do

      # wait for input of co-process
      read -p co_output
      co_result=$?
      if [ $co_result != 0 ]; then
         co_end=true
         end=true
         break
      fi

      # skip "begin" keyword
      if [ "$co_output" = "begin" ]; then
         continue
      fi

      # skip "end" keyword and terminate 
      if [ "$co_output" = "end" ]; then
         co_end=true
         break
      fi
      
      # print remaining input from co-process to stdout
      echo $co_output
   done


   # send mark for end of load report
   echo "end"
done
