#!/bin/sh
#
#
# (c) 2004 Sun Microsystems, Inc. Use is subject to license terms.  

#
# Usage: worker.sh [[time [nprocs] [ntimes] [work_parameter]]]
#        default for time is 120 seconds
#        default for nprocs is 1
#        default for work_parameter is ""

# request "bin/sh" as shell for job
#$ -S /bin/sh

trap "echo 'got sigxcpu'" 24

time=120
procs=1
ntimes=1
wparam=""
if [ $# -ge 1 ]; then
   time=$1
fi
if [ $# -ge 2 ]; then
   procs=$2
fi
if [ $# -ge 3 ]; then
   ntimes=$3
fi
if [ $# -ge 4 ]; then
   wparam=$4
fi

echo "Doing this $ntimes times"

if [ ! -x $SGE_ROOT/examples/jobsbin/$ARC/work ]; then
   echo "worker.sh: can't execute $SGE_ROOT/examples/jobsbin/$ARC/work" >&2
   exit 1
fi

cd $SGE_ROOT/examples/jobsbin/$ARC

while [ $ntimes != '0' ]; do
  ntimes=`expr $ntimes - 1`
  echo "Running $time seconds"
  echo "Using $procs processes"
  ./work -f $procs -w $time $wparam &
done

wait               
