/**
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * Patents Pending.Use is subject to license terms.
 */

/* ldap_msg.h - repository of error messages numbers */

/************************************************************** */
/* *********** ONCE ADDED DO NOT MODIFY MESSAGES ID *********** */
/************************************************************** */

#ifndef _LDAPMSG
#define _LDAPMSG

/* Common (and though potentially reusable!) subsystem */
#define SLAPI_BOOTSTRAP_CONF		"Bootstrap config " 
#define SLAPI_CONF					"Config " 
#define SLAPI_SUBSYS_STARTUP		"Startup " 
#define SLAPI_SUBSYS_CONNECTION		"Connection " 
#define SLAPI_SUBSYS_REPLICATION	"Replication "
#define SLAPI_SUBSYS_REPL_TRS		"Repl. Transport "
#define SLAPI_SUBSYS_WHOAMI         "WhoAmI Extended Op."
#define SLAPI_SUBSYS_REPL_INC 		"Incremental Protocol"
#define SLAPI_SUBSYS_REPL_TOT 		"Total Protocol"
#define	SLAPI_SUBSYS_FILTER_SP		"Filter SP"
#define SLAPI_SUBSYS_BE_DB         	"Backend Database"
#define SLAPI_SUBSYS_OPERATION		"Operation "
#define SLAPI_SUBSYS_VATTR              "Virtual Attributes"
#define SLAPI_SUBSYS_RESLIMIT           "Resource Limit"
#define SLAPI_SUBSYS_SASL               "SASL"
#define SLAPI_SUBSYS_STARTTLS           "Start Tls"
#define SLAPI_SUBSYS_SSL                "SSL"
#define SLAPI_SUBSYS_TASK               "Tasks"
#define SLAPI_SUBSYS_BULK_IMPORT         "Bulk Import"
#define SLAPI_SUBSYS_DN             "DN "
#define SLAPI_SUBSYS_ID_MAPPING		"Identity Mapping"
#define SLAPI_SUBSYS_ENTRY      	"Entry"
#define SLAPI_SUBSYS_MAPPING_TREE	"Mapping Tree"
#define SLAPI_SUBSYS_AUTHENTICATION	"Authentication"
#define SLAPI_SUBSYS_FACTORY		"Factory"
#define SLAPI_SUBSYS_FILTER		"Filter"
#define SLAPI_SUBSYS_LOCK_FOPEN		"Lock Fopen"
#define SLAPI_SUBSYS_LOG		"Log"
#define SLAPI_SUBSYS_PBLOCK		"PBlock"
#define SLAPI_SUBSYS_ATTR_SYNTAX	"Attribute Syntax"
#define SLAPI_SUBSYS_SCHEMA		"Schema "
#define SLAPI_SUBSYS_COMMAND_LINE	"Command line"
#define SLAPI_SUBSYS_PLUGINS	"Plugins"
#define SLAPI_SUBSYS_ENCRYPTION		"Encryption"
#define SLAPI_SUBSYS_CSN		"CSN Generation"
#define SLAPI_SUBSYS_UPGRADE		"Auto-Upgrade"
#define SLAPI_SUBSYS_RETROCL	"RetroChangeLog"

/* Common (and though potentially reusable!) humanReadableString */
#define SLAPI_INTERNAL_ERROR		"Internal error " 
#define SLAPI_CONFIGURATION_ERROR	"Configuration error "
#define SLAPI_SYSTEM_ERROR		"System error "
#define SLAPI_DECODING_ERROR		"Decoding error "
#define SLAPI_ENCODING_ERROR		"Encoding error "
#define SLAPI_SYSTEM_ERROR_RESOURCE_SHORTAGE	"System error: resource shortage "
#define SLAPI_CONFIGURATION_WARNING	"Configuration warning "
#define SLAPI_MEMORY_ERROR		"Memory allocation error "
#define SLAPI_ACCESS_REFUSED_ERROR "Access refused error "
#define SLAPI_USER_ERROR		"User error: "
#define SLAPI_CL_ERROR					"Changelog error"
#define SLAPI_PARTIAL_CONF_ERROR		"Partial Configuration Error"
#define SLAPI_SEND_UPDATE_ERROR			"Unable to replay update"
#define SLAPI_ENTRY_ERROR			"Entry error"
#define SLAPI_ARGUMENT_ERROR		"Argument error"
#define SLAPI_PLUGIN_ERROR		"Plugin error"
#define SLAPI_NO_DESC_ERROR		""

/* Core range numbers */
#define SLAPI_LOG_CORE_BASE          0x1000
#define SLAPI_LOG_ERROR_PLUGIN_EP	(SLAPI_LOG_CORE_BASE+2)
#define SLAPI_LOG_ERROR_PLUGIN_SEP	(SLAPI_LOG_CORE_BASE+3)
#define SLAPI_LOG_ERROR_UNABLE_ADD_AUTH	(SLAPI_LOG_CORE_BASE+4)
#define SLAPI_LOG_ERROR_BULK_NULL_PB	(SLAPI_LOG_CORE_BASE+5)
#define SLAPI_LOG_ERROR_BULK_NULL_ENTRY	(SLAPI_LOG_CORE_BASE+6)
#define SLAPI_LOG_ERROR_BULK_BAD_BE	(SLAPI_LOG_CORE_BASE+7)
#define SLAPI_LOG_ERROR_BULK_NULL_BE	(SLAPI_LOG_CORE_BASE+8)
#define SLAPI_LOG_ERROR_BULK_NOT_SUP	(SLAPI_LOG_CORE_BASE+9)
#define SLAPI_LOG_ERROR_BULK_FAILED	(SLAPI_LOG_CORE_BASE+10)
#define SLAPI_LOG_ERROR_GETTING_CONF_VAL	(SLAPI_LOG_CORE_BASE+11)
#define SLAPI_LOG_ERROR_ACCESS_CONF_FILE	(SLAPI_LOG_CORE_BASE+12)
#define SLAPI_LOG_ERROR_OPEN_CONF_FILE	(SLAPI_LOG_CORE_BASE+13)
#define SLAPI_LOG_ERROR_READ_CONF_FILE	(SLAPI_LOG_CORE_BASE+14)
#define SLAPI_LOG_ERROR_MISSING_SSHA			(SLAPI_LOG_CORE_BASE+15)
#define SLAPI_LOG_ERROR_LOADING_PLUGIN	(SLAPI_LOG_CORE_BASE+16)
#define SLAPI_LOG_ERROR_REALEASE_CONN	(SLAPI_LOG_CORE_BASE+17)
#define SLAPI_LOG_ERROR_REALEASE_CONN2	(SLAPI_LOG_CORE_BASE+18)
#define SLAPI_LOG_ERROR_INCOMING_BER_CON	(SLAPI_LOG_CORE_BASE+19)
#define SLAPI_LOG_ERROR_BAD_VERSION			(SLAPI_LOG_CORE_BASE+20)
#define SLAPI_LOG_ERROR_CREATE_LOCK		(SLAPI_LOG_CORE_BASE+21)
#define SLAPI_LOG_WARNING_ROLES_FILTER_REWRITE_INIT_FALIED	(SLAPI_LOG_CORE_BASE+22)
#define SLAPI_LOG_ERROR_NO_SCHEME		(SLAPI_LOG_CORE_BASE+23)
#define SLAPI_LOG_ERROR_SCHEME_UNDEFINED		(SLAPI_LOG_CORE_BASE+24)
#define SLAPI_LOG_ERROR_SCHEME_UNDEFINED_2		(SLAPI_LOG_CORE_BASE+25)
#define SLAPI_LOG_ERROR_BOOTSTRAP_FAILED		(SLAPI_LOG_CORE_BASE+26)
#define SLAPI_LOG_ERROR_BOOTSTRAP_FAILED_2		(SLAPI_LOG_CORE_BASE+27)
#define SLAPI_LOG_ERROR_CONFIG_SET_ATTR		(SLAPI_LOG_CORE_BASE+28)
#define SLAPI_LOG_ERROR_BACKUP_FAILED		(SLAPI_LOG_CORE_BASE+29)
#define SLAPI_LOG_ERROR_CREATING_SASL_LOCK		(SLAPI_LOG_CORE_BASE+30)
#define SLAPI_LOG_ERROR_CREATING_EXT_OP_LOCK		(SLAPI_LOG_CORE_BASE+31)
#define SLAPI_LOG_ERROR_READING_DSE		(SLAPI_LOG_CORE_BASE+32)
#define SLAPI_LOG_ERROR_SETTING_UP_BE		(SLAPI_LOG_CORE_BASE+33)
#define SLAPI_LOG_ERROR_CREATING_START_OK		(SLAPI_LOG_CORE_BASE+34)
#define SLAPI_LOG_ERROR_READ_DSE_ENTRY		(SLAPI_LOG_CORE_BASE+35)
#define SLAPI_LOG_ERROR_PARSE_DSE_ENTRY		(SLAPI_LOG_CORE_BASE+36)
#define SLAPI_LOG_ERROR_WRITE_DSE_ENTRY		(SLAPI_LOG_CORE_BASE+37)
#define SLAPI_LOG_ERROR_RENAME_FILE		(SLAPI_LOG_CORE_BASE+38)
#define SLAPI_LOG_ERROR_RENAME_FILE_2		(SLAPI_LOG_CORE_BASE+39)
#define SLAPI_LOG_ERROR_BAD_VALUE_FOR_PLUGIN_ACTION		(SLAPI_LOG_CORE_BASE+40)
#define SLAPI_LOG_ERROR_BAD_NUMSORB		(SLAPI_LOG_CORE_BASE+41)
#define SLAPI_LOG_ERROR_STARTING_PLUGIN	(SLAPI_LOG_CORE_BASE+42)
#define SLAPI_LOG_ERROR_PLUGIN_DEP	(SLAPI_LOG_CORE_BASE+43)
#define SLAPI_LOG_ERROR_LOADING_SYMBOL_PLUGIN	(SLAPI_LOG_CORE_BASE+44)
#define SLAPI_LOG_ERROR_PWD_BAD_MAX_AGE			(SLAPI_LOG_CORE_BASE+45)
#define SLAPI_LOG_ERROR_PWD_BAD_MIN_AGE			(SLAPI_LOG_CORE_BASE+46)
#define SLAPI_LOG_ERROR_PWD_BAD_WARNING			(SLAPI_LOG_CORE_BASE+47)
#define SLAPI_LOG_ERROR_PWD_HISTORY_LEN			(SLAPI_LOG_CORE_BASE+48)
#define SLAPI_LOG_ERROR_PWD_BAD_MAXFAILURE		(SLAPI_LOG_CORE_BASE+49)
#define SLAPI_LOG_ERROR_PWD_BAD_LOCKDURATION	(SLAPI_LOG_CORE_BASE+50)
#define SLAPI_LOG_ERROR_PWD_BAD_RESETFAIL		(SLAPI_LOG_CORE_BASE+51)
#define SLAPI_LOG_ERROR_PWD_INVALID_SCHEME		(SLAPI_LOG_CORE_BASE+52)
#define SLAPI_LOG_ERROR_PWD_CONFIG_NULL_VALUE	(SLAPI_LOG_CORE_BASE+53)
#define SLAPI_LOG_ERROR_PWD_NOT_ON_OFF			(SLAPI_LOG_CORE_BASE+54)
#define SLAPI_LOG_ERROR_PWD_BAD_MIN_LEN			(SLAPI_LOG_CORE_BASE+55)
#define SLAPI_LOG_ERROR_PLUGIN_TYPE_UNKNOWN	(SLAPI_LOG_CORE_BASE+56)
#define SLAPI_LOG_ERROR_PLUGIN_TYPE_SINGLE	(SLAPI_LOG_CORE_BASE+57)
#define SLAPI_LOG_WARNING_LAZY_DN_NORMALIZE	(SLAPI_LOG_CORE_BASE+58)
#define SLAPI_LOG_WARNING_PWD_MODIFY_ENTRY              (SLAPI_LOG_CORE_BASE+59)
#define SLAPI_LOG_WARNING_PWD_RETRY_GET_ENTRY           (SLAPI_LOG_CORE_BASE+60)
#define SLAPI_LOG_WARNING_PWRETRY_APPLY_MODS            (SLAPI_LOG_CORE_BASE+61)
#define SLAPI_LOG_ERROR_UNBIND_DECODE	(SLAPI_LOG_CORE_BASE+62)
#define SLAPI_LOG_ERROR_UNBIND_CONTROLS	(SLAPI_LOG_CORE_BASE+63)
#define SLAPI_LOG_ERROR_AUTH_CANNOT_GET_SEARCH_STATUS	(SLAPI_LOG_CORE_BASE+64)
#define SLAPI_LOG_ERROR_AUTH_CANNOT_ALLOC_PBLOCK_FOR_SEARCH	(SLAPI_LOG_CORE_BASE+65)
#define SLAPI_LOG_ERROR_AUTH_GET_CERT_SUBJECT_DN_FAILS	(SLAPI_LOG_CORE_BASE+66)
#define SLAPI_LOG_ERROR_AUTH_GET_CERT_ISSUER_DN_FAILS	(SLAPI_LOG_CORE_BASE+67)
#define SLAPI_LOG_ERROR_AVA_BAD_BER_DECODING		(SLAPI_LOG_CORE_BASE+68)
#define SLAPI_LOG_ERROR_CONNECTION_BAD_MSGID		(SLAPI_LOG_CORE_BASE+69)
#define SLAPI_LOG_ERROR_CONNECTION_BAD_OPERATION_TAG	(SLAPI_LOG_CORE_BASE+70)
#define SLAPI_LOG_ERROR_DYNLIB_LOAD_FAILURE		(SLAPI_LOG_CORE_BASE+71)
#define SLAPI_LOG_ERROR_FILTER_CHOICE_NOT_VALID_HASH	(SLAPI_LOG_CORE_BASE+72)
#define SLAPI_LOG_ERROR_FILTER_CHOICE_NOT_VALID_COMPARE	(SLAPI_LOG_CORE_BASE+73)
#define SLAPI_LOG_ERROR_FILTER_EX_CHOICE_NOT_VALID	(SLAPI_LOG_CORE_BASE+74)
#define SLAPI_LOG_ERROR_FILTER_EX_CHOICE_NOT_VALID_VATTR	(SLAPI_LOG_CORE_BASE+75)
#define SLAPI_LOG_ERROR_INIT_WINDOWS_SOCKETS_FAILS	(SLAPI_LOG_CORE_BASE+76)
#define SLAPI_LOG_ERROR_CANNOT_CREATE_INIT_LOCKS	(SLAPI_LOG_CORE_BASE+77)
#define SLAPI_LOG_ERROR_CANNOT_CREATE_TIME_LOCK		(SLAPI_LOG_CORE_BASE+78)
#define SLAPI_LOG_ERROR_FRONTEND_CONFIG_INIT_FAILS	(SLAPI_LOG_CORE_BASE+79)
#define SLAPI_LOG_ERROR_CANNOT_MODIFY_RO_VALUE		(SLAPI_LOG_CORE_BASE+80)
#define SLAPI_LOG_ERROR_LOCK_CANNOT_OPEN_LOCK_FILE	(SLAPI_LOG_CORE_BASE+81)
#define SLAPI_LOG_ERROR_LOCK_CANNOT_OPEN_FILE		(SLAPI_LOG_CORE_BASE+82)
#define SLAPI_LOG_ERROR_LOG_BAD_MAX_SIZE		(SLAPI_LOG_CORE_BASE+83)
#define SLAPI_LOG_ERROR_LOG_CANNOT_OPEN_AUDIT_FILE	(SLAPI_LOG_CORE_BASE+84)
#define SLAPI_LOG_ERROR_LOG_CANNOT_OPEN_ACCESS_FILE	(SLAPI_LOG_CORE_BASE+85)
#define SLAPI_LOG_ERROR_LOG_CANNOT_OPEN_ACCESS_INFO_FILE	(SLAPI_LOG_CORE_BASE+86)
#define SLAPI_LOG_ERROR_LOG_UNABLE_TO_GET_FREE_SPACE_INFO	(SLAPI_LOG_CORE_BASE+87)
#define SLAPI_LOG_ERROR_LOG_CANNOT_SET_MAX_NO_LOGFILES	(SLAPI_LOG_CORE_BASE+88)
#define SLAPI_LOG_ERROR_MAIN_CANNOT_ALLOC_LOCK		(SLAPI_LOG_CORE_BASE+89)
#define SLAPI_LOG_ERROR_OPERATION_DISK_FULL		(SLAPI_LOG_CORE_BASE+90)
#define SLAPI_LOG_ERROR_PBLOCK_GET_UNKNOWN_ID		(SLAPI_LOG_CORE_BASE+91)
#define SLAPI_LOG_ERROR_PBLOCK_SET_UNKNOWN_ID		(SLAPI_LOG_CORE_BASE+92)
#define SLAPI_LOG_ERROR_ERRMAP_MESSAGES_NOT_ORDERED	(SLAPI_LOG_CORE_BASE+93)
#define SLAPI_LOG_ERROR_AUTH_INTERNAL_SEARCH_FAILS	(SLAPI_LOG_CORE_BASE+94)
#define SLAPI_LOG_ERROR_BOOTSTRAP_ID_FAILED		(SLAPI_LOG_CORE_BASE+95)
#define SLAPI_LOG_ERROR_CONNECTION_BAD_BER		(SLAPI_LOG_CORE_BASE+96)
#define SLAPI_LOG_WARNING_PLUGIN_ERROR (SLAPI_LOG_CORE_BASE+97)
#define SLAPI_LOG_WARNING_PWD_IN_HISTORY_BYPASS (SLAPI_LOG_CORE_BASE+98)
#define SLAPI_LOG_WARNING_PWD_MINLENGTH_BYPASS (SLAPI_LOG_CORE_BASE+99)
#define SLAPI_LOG_WARNING_PWD_TRIVIALITY_BYPASS (SLAPI_LOG_CORE_BASE+100)
#define SLAPI_LOG_ERROR_MEMORY_HARD (SLAPI_LOG_CORE_BASE+101)
#define SLAPI_LOG_ERROR_MEMORY_OUTOF (SLAPI_LOG_CORE_BASE+102)
#define SLAPI_LOG_ERROR_MEMORY_TOOLONG (SLAPI_LOG_CORE_BASE+103)
#define SLAPI_LOG_ERROR_MEMORY_HARDCHG (SLAPI_LOG_CORE_BASE+104)
#define SLAPI_LOG_ERROR_MEMORY_INVALID_HIGH (SLAPI_LOG_CORE_BASE+105)
#define SLAPI_LOG_ERROR_MEMORY_INVALID_LOW (SLAPI_LOG_CORE_BASE+106)
#define SLAPI_LOG_ERROR_MEMORY_NOSH (SLAPI_LOG_CORE_BASE+107)
/* NPCTE Fix for RFE 4972234 <M.O.Parissis> <June,13 2005>
 * new feature backported from DSEE.
 */
#define SLAPI_LOG_ERROR_ACCOUNT_USABLE_NOTCRITICAL	(SLAPI_LOG_CORE_BASE+114)
/* End of NPCTE Fix for RFE 4972234" */

#define SLAPI_LOG_CORE_BASE_BOOTSTRAP     0x1200

#define SLAPI_LOG_WARNING_BOOTSTRAP_CREATE_PID_FILE        (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 1)
#define SLAPI_LOG_ERROR_BOOTSTRAP_GETPWNAM_USER            (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 2)
#define SLAPI_LOG_WARNING_BOOTSTRAP_CHOWN_PID_FILE         (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 3)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_SERVER_DUE_TO_SERVER  (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 4)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_SERVER_DUE_TO_IMPORT  (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 5)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_DB2LDIFR_DUE_TO_USE   (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 6)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_DB2LDIF_DUE_TO_IMPORT (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 7)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_DB2BAK_DUE_TO_IMPORT  (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 8)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_IMPORT_DUE_TO_USE     (SLAPI_LOG_CORE_BASE_BOOTSTRAP+ 9)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_DB2INDEX_DUE_TO_USE   (SLAPI_LOG_CORE_BASE_BOOTSTRAP+10)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_TEST_DUE_TO_USE       (SLAPI_LOG_CORE_BASE_BOOTSTRAP+11)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CREATE_INSTANCE_MUTEX    (SLAPI_LOG_CORE_BASE_BOOTSTRAP+12)
#define SLAPI_LOG_ERROR_BOOTSTRAP_WAIT_INSTANCE_MUTEX      (SLAPI_LOG_CORE_BASE_BOOTSTRAP+13)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_SERVER_DUE_TO_USE     (SLAPI_LOG_CORE_BASE_BOOTSTRAP+14)
#define SLAPI_LOG_ERROR_PATH_TOO_LONG                      (SLAPI_LOG_CORE_BASE_BOOTSTRAP+15)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_EXPORT_DUE_TO_IMPORT  (SLAPI_LOG_CORE_BASE_BOOTSTRAP+16)
#define SLAPI_LOG_ERROR_NO_CURRENT_DIRECTORY               (SLAPI_LOG_CORE_BASE_BOOTSTRAP+17)
#define SLAPI_LOG_ERROR_ENTRY_ADD_VALUE                    (SLAPI_LOG_CORE_BASE_BOOTSTRAP+18)
#define SLAPI_LOG_ERROR_BOOTSTRAP_NO_DBTEST_DUE_TO_USE     (SLAPI_LOG_CORE_BASE_BOOTSTRAP+19)
#define SLAPI_LOG_ERROR_BOOTSTRAP_SLAPI2STR_INIT           (SLAPI_LOG_CORE_BASE_BOOTSTRAP+20)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CREATE_DIR               (SLAPI_LOG_CORE_BASE_BOOTSTRAP+21)
#define SLAPI_LOG_ERROR_REFERRAL_CREATE_LOCK               (SLAPI_LOG_CORE_BASE_BOOTSTRAP+22)
#define SLAPI_LOG_ERROR_REFERRAL_REF_ADJUST                (SLAPI_LOG_CORE_BASE_BOOTSTRAP+23)
#define SLAPI_LOG_ERROR_BOOTSTRAP_DB2LDIF_CANNOT_EXPORT_REPLICA_WITH_ENCRYPTED_ATTRS (SLAPI_LOG_CORE_BASE_BOOTSTRAP+24)
#define SLAPI_LOG_ERROR_LDIF2DB_KEYDBPWD_MISSING	   (SLAPI_LOG_CORE_BASE_BOOTSTRAP+25)
#define SLAPI_LOG_ERROR_ATTR_ENCR_INIT_FAILED		   (SLAPI_LOG_CORE_BASE_BOOTSTRAP+26)

#define SLAPI_LOG_CORE_BASE_SEC          0x1280

#define SLAPI_LOG_ERROR_SSL_SECINIT                      (SLAPI_LOG_CORE_BASE_SEC+ 1)
#define SLAPI_LOG_ERROR_SSL_OPEN_KEY_DB                  (SLAPI_LOG_CORE_BASE_SEC+ 2)
#define SLAPI_LOG_ERROR_SSL_GET_KEYCERT_FILES            (SLAPI_LOG_CORE_BASE_SEC+ 3)
#define SLAPI_LOG_ERROR_SSL_NSS_INIT                     (SLAPI_LOG_CORE_BASE_SEC+ 4)
#define SLAPI_LOG_ERROR_SSL_NSS_NODB_INIT                (SLAPI_LOG_CORE_BASE_SEC+ 5)
#define SLAPI_LOG_ERROR_SSL_GET_SESSION_TIMEOUT          (SLAPI_LOG_CORE_BASE_SEC+ 6)
#define SLAPI_LOG_ERROR_SSL_CREATE_FILEPINOBJ            (SLAPI_LOG_CORE_BASE_SEC+ 7)
#define SLAPI_LOG_ERROR_SSL_GET_TOKEN                    (SLAPI_LOG_CORE_BASE_SEC+ 8)
#define SLAPI_LOG_ERROR_SSL_FIND_SLOT                    (SLAPI_LOG_CORE_BASE_SEC+ 9)
#define SLAPI_LOG_ERROR_SSL_CREATE_TMP                     (SLAPI_LOG_CORE_BASE_SEC+10)
#define SLAPI_LOG_ERROR_SSL_SET_SSL_EXPORT               (SLAPI_LOG_CORE_BASE_SEC+11)
#define SLAPI_LOG_WARNING_SSL_SET_SSL_CIPHER               (SLAPI_LOG_CORE_BASE_SEC+12)
#define SLAPI_LOG_ERROR_SSL_IMPORT_FD_INTO_SSL           (SLAPI_LOG_CORE_BASE_SEC+13)
#define SLAPI_LOG_ERROR_SSL_PK11_GETINTSLOT              (SLAPI_LOG_CORE_BASE_SEC+14)
#define SLAPI_LOG_ERROR_SSL_PK11_AUTH                    (SLAPI_LOG_CORE_BASE_SEC+15)
#define SLAPI_LOG_WARNING_SSL_PARSE_CIPHER                 (SLAPI_LOG_CORE_BASE_SEC+16)
#define SLAPI_LOG_WARNING_SSL_CERT_FOR_FAMILY              (SLAPI_LOG_CORE_BASE_SEC+17)
#define SLAPI_LOG_WARNING_SSL_PRIVKEY_CERT_OF_FAMILY       (SLAPI_LOG_CORE_BASE_SEC+18)
#define SLAPI_LOG_WARNING_SSL_SERVER_KEYCERT_IS_BAD        (SLAPI_LOG_CORE_BASE_SEC+19)
#define SLAPI_LOG_ERROR_SSL_NO_VALID_CIPHER                (SLAPI_LOG_CORE_BASE_SEC+20)
#define SLAPI_LOG_ERROR_SSL_NONCE_CACHE_OUT_OF_DISK        (SLAPI_LOG_CORE_BASE_SEC+21)
#define SLAPI_LOG_ERROR_SSL_NONCE_CACHE_FAILED             (SLAPI_LOG_CORE_BASE_SEC+22)
#define SLAPI_LOG_ERROR_SSL_ENABLE_SEC_ON_SOCKET           (SLAPI_LOG_CORE_BASE_SEC+23)
#define SLAPI_LOG_ERROR_SSL_ENABLE_SSLV3_ON_SOCKET         (SLAPI_LOG_CORE_BASE_SEC+24)
#define SLAPI_LOG_ERROR_SSL_ENABLE_TLS_ON_SOCKET         (SLAPI_LOG_CORE_BASE_SEC+25)
#define SLAPI_LOG_WARNING_SSL_NO_SSL_CLIENT_AUTH           (SLAPI_LOG_CORE_BASE_SEC+26)
#define SLAPI_LOG_WARNING_SET_SSL_CLIENT_AUTH              (SLAPI_LOG_CORE_BASE_SEC+27)
#define SLAPI_LOG_WARNING_SSL_OPTIONSET_FALSE              (SLAPI_LOG_CORE_BASE_SEC+28)
#define SLAPI_LOG_WARNING_SSL_OPTIONSET_TRUE               (SLAPI_LOG_CORE_BASE_SEC+29)
#define SLAPI_LOG_ERROR_SSL_ALIAS_NOT_CONFIGURED         (SLAPI_LOG_CORE_BASE_SEC+30)
#define SLAPI_LOG_WARNING_SSL_GET_SSLSERVERAUTH            (SLAPI_LOG_CORE_BASE_SEC+31)
#define SLAPI_LOG_WARNING_SSL_SET_SSLSERVERAUTH            (SLAPI_LOG_CORE_BASE_SEC+32)
#define SLAPI_LOG_ERROR_SSL_ADV_CLIENTAUTH_INIT          (SLAPI_LOG_CORE_BASE_SEC+33)
#define SLAPI_LOG_WARNING_SSL_MISS_NSSSLTOKEN            (SLAPI_LOG_CORE_BASE_SEC+34)
#define SLAPI_LOG_WARNING_SSL_MISS_NSSSLTOKEN_PK11       (SLAPI_LOG_CORE_BASE_SEC+35)
#define SLAPI_LOG_ERROR_SSL_CANT_USE_CLIENT_AUTH         (SLAPI_LOG_CORE_BASE_SEC+36)
#define SLAPI_LOG_ERROR_SSL_CANT_ENABLE_CLIENT_AUTH      (SLAPI_LOG_CORE_BASE_SEC+37)
#define SLAPI_LOG_ERROR_SSL_SIMPLE_BIND_S                (SLAPI_LOG_CORE_BASE_SEC+38)
#define SLAPI_LOG_ERROR_SSL_SASL_BIND                    (SLAPI_LOG_CORE_BASE_SEC+39)
#define SLAPI_LOG_ERROR_SASL_CB                          (SLAPI_LOG_CORE_BASE_SEC+40)
#define SLAPI_LOG_ERROR_SSL_CREATE_ALTPINOBJ             (SLAPI_LOG_CORE_BASE_SEC+41)
#define SLAPI_LOG_ERROR_SSL_CREATE_NTUSERPINOBJ          (SLAPI_LOG_CORE_BASE_SEC+42)
#define SLAPI_LOG_ERROR_SSL_CREATE_PINOBJ                (SLAPI_LOG_CORE_BASE_SEC+43)
#define SLAPI_LOG_ERROR_SSL_AUTH_SLOT                    (SLAPI_LOG_CORE_BASE_SEC+44)
#define SLAPI_LOG_ERROR_SSL_NO_TRUSTED_SSL_CLIENT_CA     (SLAPI_LOG_CORE_BASE_SEC+45)
#define SLAPI_LOG_ERROR_ATTR_ENCR_CREATE_CONTEXT	 (SLAPI_LOG_CORE_BASE_SEC+46)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_ENCRYPTION_OUTPUT	 (SLAPI_LOG_CORE_BASE_SEC+47)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_CLEARTEXT_INPUT	 (SLAPI_LOG_CORE_BASE_SEC+48)
#define SLAPI_LOG_ERROR_ATTR_ENCR_CIPHER_OP		 (SLAPI_LOG_CORE_BASE_SEC+49)
#define SLAPI_LOG_ERROR_ATTR_ENCR_INVALID_MECHANISM	 (SLAPI_LOG_CORE_BASE_SEC+50)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_CLEARTEXT_OUTPUT	 (SLAPI_LOG_CORE_BASE_SEC+51)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_DECRYPTION_INPUT (SLAPI_LOG_CORE_BASE_SEC+52)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_PWITEM		 (SLAPI_LOG_CORE_BASE_SEC+53)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_PWITEM_DATA	 (SLAPI_LOG_CORE_BASE_SEC+54)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_SALT		 (SLAPI_LOG_CORE_BASE_SEC+55)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_SALT_DATA	 (SLAPI_LOG_CORE_BASE_SEC+56)
#define SLAPI_LOG_ERROR_ATTR_ENCR_KEY_GENERATION	 (SLAPI_LOG_CORE_BASE_SEC+57)
#define SLAPI_LOG_ERROR_ATTR_ENCR_ALLOC_PARAM_DATA	 (SLAPI_LOG_CORE_BASE_SEC+58)
#define SLAPI_LOG_ERROR_ATTR_ENCR_PARAMETER_MAP		 (SLAPI_LOG_CORE_BASE_SEC+59)
#define SLAPI_LOG_ERROR_ATTR_ENCR_PRIVKEY_FROM_CERT    	 (SLAPI_LOG_CORE_BASE_SEC+60)
#define SLAPI_LOG_ERROR_ATTR_ENCR_PRIVKEY_SIGN_FAILURE	 (SLAPI_LOG_CORE_BASE_SEC+61)
#define SLAPI_LOG_ERROR_ATTR_ENCR_KEYDB_PWD_REJECTED	 (SLAPI_LOG_CORE_BASE_SEC+62)
#define SLAPI_LOG_ERROR_ATTR_ENCR_READ_KEYDB_PWD_FAILURE (SLAPI_LOG_CORE_BASE_SEC+63)
#define SLAPI_LOG_ERROR_ATTR_ENCR_NO_KEYDB_PWD		 (SLAPI_LOG_CORE_BASE_SEC+64)
#define SLAPI_LOG_ERROR_ATTR_ENCR_PWDFILE_READ_FAILURE   (SLAPI_LOG_CORE_BASE_SEC+65)
#define SLAPI_LOG_ERROR_ATTR_ENCR_PWDFILE_NO_COLON	 (SLAPI_LOG_CORE_BASE_SEC+66)
#define SLAPI_LOG_ERROR_ATTR_ENCR_PWDFILE_BAD_TOKEN	 (SLAPI_LOG_CORE_BASE_SEC+67)
#define SLAPI_LOG_ERROR_ATTR_ENCR_MISSING_INIT		 (SLAPI_LOG_CORE_BASE_SEC+68)
#define SLAPI_LOG_ERROR_ATTR_ENCR_CONFIG_CHECK_FAILURE	 (SLAPI_LOG_CORE_BASE_SEC+69)
#define SLAPI_LOG_ERROR_ATTR_ENCR_NO_KEY		 (SLAPI_LOG_CORE_BASE_SEC+70)
#define SLAPI_LOG_ERROR_STARTTLS_INIT_NO_MODEL_SOCKET    (SLAPI_LOG_CORE_BASE_SEC+71)
#define SLAPI_LOG_ERROR_STARTTLS_INIT_NEW_MODEL_SOCKET   (SLAPI_LOG_CORE_BASE_SEC+72)

#define SLAPI_LOG_CORE_BASE_VATTR          0x1300

#define SLAPI_LOG_ERROR_VATTR_LOOP_IN_GET         (SLAPI_LOG_CORE_BASE_VATTR+ 1)
#define SLAPI_LOG_ERROR_VATTR_MALLOC_INSERT_DUP   (SLAPI_LOG_CORE_BASE_VATTR+ 2)
#define SLAPI_LOG_ERROR_VATTR_LOOP_IN_COMPARE     (SLAPI_LOG_CORE_BASE_VATTR+ 3)
#define SLAPI_LOG_ERROR_VATTR_MALLOC_FAIL_SP      (SLAPI_LOG_CORE_BASE_VATTR+ 4)
#define SLAPI_LOG_ERROR_VATTR_MALLOC_FAIL_SPH     (SLAPI_LOG_CORE_BASE_VATTR+ 5)
#define SLAPI_LOG_ERROR_VATTR_MALLOC_CREATE_MAP   (SLAPI_LOG_CORE_BASE_VATTR+ 6)
#define SLAPI_LOG_ERROR_VATTR_MALLOC_NEWHASHTABLE (SLAPI_LOG_CORE_BASE_VATTR+ 7)
#define SLAPI_LOG_ERROR_VATTR_NEWLOCK             (SLAPI_LOG_CORE_BASE_VATTR+ 8)
#define SLAPI_LOG_WARNING_VATTR_FAILED_TO_LOCATE_SUFFIX  (SLAPI_LOG_CORE_BASE_VATTR+ 9)

#define SLAPI_LOG_CORE_BASE_TASK          0x1380

#define SLAPI_LOG_WARNING_TASK_GET_ENTRY                (SLAPI_LOG_CORE_BASE_TASK+ 1)
#define SLAPI_LOG_ERROR_TASK_IMPORT_MULTIPLE_BACKEND    (SLAPI_LOG_CORE_BASE_TASK+ 2)
#define SLAPI_LOG_ERROR_TASK_IMPORT_PREV3_BACKEND       (SLAPI_LOG_CORE_BASE_TASK+ 3)
#define SLAPI_LOG_ERROR_TASK_IMPORT_NO_LDIF2DB          (SLAPI_LOG_CORE_BASE_TASK+ 4)
#define SLAPI_LOG_ERROR_TASK_IMPORT_ALLOC               (SLAPI_LOG_CORE_BASE_TASK+ 5)
#define SLAPI_LOG_ERROR_TASK_EXPORT_BACKEND_NOT_FOUND   (SLAPI_LOG_CORE_BASE_TASK+ 6)
#define SLAPI_LOG_ERROR_TASK_EXPORT_FAILED              (SLAPI_LOG_CORE_BASE_TASK+ 7)
#define SLAPI_LOG_ERROR_TASK_EXPORT_NO_BACKEND          (SLAPI_LOG_CORE_BASE_TASK+ 8)
#define SLAPI_LOG_ERROR_TASK_EXPORT_NOEXISTENT_BACKEND  (SLAPI_LOG_CORE_BASE_TASK+10)
#define SLAPI_LOG_ERROR_TASK_EXPORT_PREV3_BACKEND       (SLAPI_LOG_CORE_BASE_TASK+11)
#define SLAPI_LOG_ERROR_TASK_EXPORT_NO_LDIF2DB          (SLAPI_LOG_CORE_BASE_TASK+12)
#define SLAPI_LOG_ERROR_TASK_EXPORT_ALLOC               (SLAPI_LOG_CORE_BASE_TASK+13)
#define SLAPI_LOG_ERROR_TASK_EXPORT_THREAD              (SLAPI_LOG_CORE_BASE_TASK+14)
#define SLAPI_LOG_ERROR_TASK_BACKUP_FAIL                (SLAPI_LOG_CORE_BASE_TASK+15)
#define SLAPI_LOG_ERROR_TASK_BACKUP_NO_DB2ARCHIVE_FN    (SLAPI_LOG_CORE_BASE_TASK+16)
#define SLAPI_LOG_ERROR_TASK_BACKUP_PREV3_BACKEND       (SLAPI_LOG_CORE_BASE_TASK+17)
#define SLAPI_LOG_ERROR_TASK_BACKUP_ALLOC               (SLAPI_LOG_CORE_BASE_TASK+18)
#define SLAPI_LOG_ERROR_TASK_BACKUP_THREAD              (SLAPI_LOG_CORE_BASE_TASK+19)
#define SLAPI_LOG_ERROR_TASK_RESTORE_FAIL               (SLAPI_LOG_CORE_BASE_TASK+20)
#define SLAPI_LOG_ERROR_TASK_RESTORE_NO_LDIF2DB         (SLAPI_LOG_CORE_BASE_TASK+21)
#define SLAPI_LOG_ERROR_TASK_RESTORE_PREV3_BACKEND      (SLAPI_LOG_CORE_BASE_TASK+22)
#define SLAPI_LOG_ERROR_TASK_RESTORE_ALLOC              (SLAPI_LOG_CORE_BASE_TASK+23)
#define SLAPI_LOG_ERROR_TASK_RESTORE_THREAD             (SLAPI_LOG_CORE_BASE_TASK+24)
#define SLAPI_LOG_ERROR_TASK_RESTORE_INDEX              (SLAPI_LOG_CORE_BASE_TASK+25)
#define SLAPI_LOG_ERROR_TASK_INDEX_NOEXISTENT_BACKEND   (SLAPI_LOG_CORE_BASE_TASK+26)
#define SLAPI_LOG_ERROR_TASK_INDEX_NO_DB2INDEX_FN       (SLAPI_LOG_CORE_BASE_TASK+27)
#define SLAPI_LOG_ERROR_TASK_INDEX_ALLOC                (SLAPI_LOG_CORE_BASE_TASK+28)
#define SLAPI_LOG_ERROR_TASK_INDEX_THREAD               (SLAPI_LOG_CORE_BASE_TASK+29)
#define SLAPI_LOG_WARNING_TASK_MOD_ENTRY                (SLAPI_LOG_CORE_BASE_TASK+30)
#define SLAPI_LOG_ERROR_TASK_CREATE_NODE                (SLAPI_LOG_CORE_BASE_TASK+31)
#define SLAPI_LOG_ERROR_TASK_CREATE_LOCK                (SLAPI_LOG_CORE_BASE_TASK+32)
#define SLAPI_LOG_ERROR_TASK_IMPORT_LOOKUP_BACKEND      (SLAPI_LOG_CORE_BASE_TASK+33)
#define SLAPI_LOG_ERROR_TASK_IMPORT_BACKEND_COUNT       (SLAPI_LOG_CORE_BASE_TASK+34)
#define SLAPI_LOG_ERROR_TASK_IMPORT_BACKEND_NOT_FOUND   (SLAPI_LOG_CORE_BASE_TASK+35)
#define SLAPI_LOG_ERROR_TASK_EXPORT_LOOKUP_BACKEND      (SLAPI_LOG_CORE_BASE_TASK+36)
#define SLAPI_LOG_ERROR_TASK_EXPORT_BACKEND_COUNT       (SLAPI_LOG_CORE_BASE_TASK+37)
#define SLAPI_LOG_ERROR_TASK_RESTORE_NO_ARCHIVE2DB      (SLAPI_LOG_CORE_BASE_TASK+38)
#define SLAPI_LOG_ERROR_TASK_INDEX_BACKEND_NOT_FOUND    (SLAPI_LOG_CORE_BASE_TASK+39)
#define SLAPI_LOG_WARNING_TASK_CLEAN_TREE_NOT_FOUND     (SLAPI_LOG_CORE_BASE_TASK+40)
#define SLAPI_LOG_WARNING_TASK_CLEAN_ENTRIES_NOT_FOUND  (SLAPI_LOG_CORE_BASE_TASK+41)
#define SLAPI_LOG_ERROR_TASK_EXPORT_CANNOT_DUMP_REPLICA_WITH_ENCRYPTED_ATTRS (SLAPI_LOG_CORE_BASE_TASK+42)

#define SLAPI_LOG_CORE_BASE_RESLIMIT         0x1400

#define SLAPI_LOG_ERROR_RESLIMIT_REGISTER_OBJEXT   (SLAPI_LOG_CORE_BASE_RESLIMIT+ 1)
#define SLAPI_LOG_ERROR_RESLIMIT_CREATE_LOCK       (SLAPI_LOG_CORE_BASE_RESLIMIT+ 2)
#define SLAPI_LOG_ERROR_RESLIMIT_INIT              (SLAPI_LOG_CORE_BASE_RESLIMIT+ 3)
#define SLAPI_LOG_ERROR_RESLIMIT_GET_OBJEXT        (SLAPI_LOG_CORE_BASE_RESLIMIT+ 4)
#define SLAPI_LOG_WARNING_RESLIMIT_MULT_VALUES     (SLAPI_LOG_CORE_BASE_RESLIMIT+ 5)
#define SLAPI_LOG_ERROR_RESLIMIT_ATT_REGISTERED    (SLAPI_LOG_CORE_BASE_RESLIMIT+ 6)
#define SLAPI_LOG_ERROR_RESLIMIT_PARAM             (SLAPI_LOG_CORE_BASE_RESLIMIT+ 7)
#define SLAPI_LOG_ERROR_RESLIMIT_HANDLE            (SLAPI_LOG_CORE_BASE_RESLIMIT+ 8)
#define SLAPI_LOG_ERROR_RESLIMIT_MALLOC_NEGVALUE   (SLAPI_LOG_CORE_BASE_RESLIMIT+ 9)
#define SLAPI_LOG_ERROR_RESLIMIT_MALLOC_FAILS      (SLAPI_LOG_CORE_BASE_RESLIMIT+10)
#define SLAPI_LOG_ERROR_RESLIMIT_REALLOC_NEGVALUE  (SLAPI_LOG_CORE_BASE_RESLIMIT+11)
#define SLAPI_LOG_ERROR_RESLIMIT_REALLOC_FAILS     (SLAPI_LOG_CORE_BASE_RESLIMIT+12)
#define SLAPI_LOG_ERROR_RESLIMIT_CALLOC_NEGVALUE   (SLAPI_LOG_CORE_BASE_RESLIMIT+13)
#define SLAPI_LOG_ERROR_RESLIMIT_CALLOC_NEGELEM    (SLAPI_LOG_CORE_BASE_RESLIMIT+14)
#define SLAPI_LOG_ERROR_RESLIMIT_CALLOC_FAILS      (SLAPI_LOG_CORE_BASE_RESLIMIT+15)
#define SLAPI_LOG_ERROR_RESLIMIT_STRDUP_FAILS      (SLAPI_LOG_CORE_BASE_RESLIMIT+16)
#define SLAPI_LOG_ERROR_RESLIMIT_BVDUP_FAILS       (SLAPI_LOG_CORE_BASE_RESLIMIT+17)

#define SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG  0x1480

#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_ENTRY_EMPTY             (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 1)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_BAD_ON_OFF_ATTR         (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 2)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_BAD_ERRLOG_ATTR         (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 3)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_BAD_ERRLEVEL_ATTR       (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 4)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_BAD_MAXDESCRIPTORS_ATTR (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 5)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_IGNORE_D_OPTION         (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 6)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_INVALID_ENTRY           (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 7)
#define SLAPI_LOG_ERROR_BOOTSTRAP_CONFIG_BAD_MAXCONNS_ATTR  	 (SLAPI_LOG_CORE_BASE_BOOTSTRAP_CONFIG+ 8)

#define SLAPI_LOG_CORE_BASE_ENTRY  0x1500

#define SLAPI_LOG_ERROR_ENTRY_MULTIPLE_DN                      (SLAPI_LOG_CORE_BASE_ENTRY+ 1)
#define SLAPI_LOG_ERROR_ENTRY_MULTIPLE_UNIQUEID                (SLAPI_LOG_CORE_BASE_ENTRY+ 2)
#define SLAPI_LOG_ERROR_ENTRY_NON_CONTIGUOUS_ATTR              (SLAPI_LOG_CORE_BASE_ENTRY+ 3)
#define SLAPI_LOG_ERROR_ENTRY_NON_CONTIGUOUS_DEL_ATTR          (SLAPI_LOG_CORE_BASE_ENTRY+ 4)
#define SLAPI_LOG_ERROR_ENTRY_MULTIPLE_DN_FAST                 (SLAPI_LOG_CORE_BASE_ENTRY+ 5)
#define SLAPI_LOG_ERROR_ENTRY_MULTIPLE_UNIQUEID_FAST           (SLAPI_LOG_CORE_BASE_ENTRY+ 6)
#define SLAPI_LOG_ERROR_ENTRY_NON_CONTIGUOUS_ATTR_FAST         (SLAPI_LOG_CORE_BASE_ENTRY+ 7)
#define SLAPI_LOG_ERROR_ENTRY_NON_CONTIGUOUS_DEL_ATTR_FAST     (SLAPI_LOG_CORE_BASE_ENTRY+ 8)
#define SLAPI_LOG_ERROR_ENTRY_NO_DN                            (SLAPI_LOG_CORE_BASE_ENTRY+ 9)
#define SLAPI_LOG_ERROR_ENTRY_MULTIPLE_DN_DUPCHECK             (SLAPI_LOG_CORE_BASE_ENTRY+10)
#define SLAPI_LOG_ERROR_ENTRY_MULTIPLE_UNIQUEID_DUPCHECK       (SLAPI_LOG_CORE_BASE_ENTRY+11)
#define SLAPI_LOG_ERROR_ENTRY_NON_CONTIGUOUS_ATTR_DUPCHECK     (SLAPI_LOG_CORE_BASE_ENTRY+12)
#define SLAPI_LOG_ERROR_ENTRY_NON_CONTIGUOUS_DEL_ATTR_DUPCHECK (SLAPI_LOG_CORE_BASE_ENTRY+13)
#define SLAPI_LOG_ERROR_ENTRY_NO_DN_DUPCHECK                   (SLAPI_LOG_CORE_BASE_ENTRY+14)
#define SLAPI_LOG_ERROR_ENTRY_DUPLICATE_VALUE                  (SLAPI_LOG_CORE_BASE_ENTRY+15)
#define SLAPI_LOG_ERROR_ENTRY_CANNOT_REMOVE_VALUE_ATTR         (SLAPI_LOG_CORE_BASE_ENTRY+16)
#define SLAPI_LOG_ERROR_ENTRY_CANNOT_ADD_VALUE_ATTR            (SLAPI_LOG_CORE_BASE_ENTRY+17)
#define SLAPI_LOG_ERROR_ENTRY_DUPLICATE_VALUE_WSI              (SLAPI_LOG_CORE_BASE_ENTRY+18)
#define SLAPI_LOG_ERROR_ENTRY_NOT_ROOT_USER                    (SLAPI_LOG_CORE_BASE_ENTRY+19)
#define SLAPI_LOG_ERROR_ENTRY_MISSING_PBLOCK                   (SLAPI_LOG_CORE_BASE_ENTRY+20)
#define SLAPI_LOG_ERROR_ENTRY_ATTR_DUP_ALREADY                 (SLAPI_LOG_CORE_BASE_ENTRY+21)
#define SLAPI_LOG_ERROR_ENTRY_ATTR_DUP_ADD                 	   (SLAPI_LOG_CORE_BASE_ENTRY+22)

#define SLAPI_LOG_CORE_BASE_FACTORY  0x1580

#define SLAPI_LOG_ERROR_FACTORY_EXTENSION_IN_USE                  (SLAPI_LOG_CORE_BASE_FACTORY+ 1)
#define SLAPI_LOG_ERROR_FACTORY_EXTENSION_ALREADY_REGISTERED      (SLAPI_LOG_CORE_BASE_FACTORY+ 2)
#define SLAPI_LOG_ERROR_FACTORY_NEGATIVE_NO_EXTENSIONS            (SLAPI_LOG_CORE_BASE_FACTORY+ 3)
#define SLAPI_LOG_ERROR_FACTORY_NO_MORE_FREE_SLOT                 (SLAPI_LOG_CORE_BASE_FACTORY+ 4)
#define SLAPI_LOG_ERROR_FACTORY_GET_EXT_UNREGISTERED_OBJECT_TYPE  (SLAPI_LOG_CORE_BASE_FACTORY+ 5)
#define SLAPI_LOG_ERROR_FACTORY_REL_EXT_UNREGISTERED_OBJECT_TYPE  (SLAPI_LOG_CORE_BASE_FACTORY+ 6)
#define SLAPI_LOG_ERROR_FACTORY_UNKNOWN_OBJECT_TYPE               (SLAPI_LOG_CORE_BASE_FACTORY+ 7)

#define SLAPI_LOG_CORE_BASE_MAPPING_TREE  0x1600

#define SLAPI_LOG_ERROR_MAPPING_TREE_UNKNOWN_PTN_STATE                     (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 1)
#define SLAPI_LOG_ERROR_MAPPING_TREE_REFERRAL_ATTR_HAS_NO_VALUE            (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 2)
#define SLAPI_LOG_ERROR_MAPPING_TREE_BACKEND_USED_TWICE_BY_MTN             (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 3)
#define SLAPI_LOG_ERROR_MAPPING_TREE_CANNOT_DETERMINE_SUBTREE              (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 4)
#define SLAPI_LOG_ERROR_MAPPING_TREE_BACKEND_ATTR_HAS_NO_VALUE             (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 5)
#define SLAPI_LOG_ERROR_MAPPING_TREE_STATE_ATTR_HAS_NO_VALUE               (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 6)
#define SLAPI_LOG_ERROR_MAPPING_TREE_DISTRIB_PLUGIN_ATTR_HAS_NO_VALUE      (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 7)
#define SLAPI_LOG_ERROR_MAPPING_TREE_DISTRIB_FUNCTION_ATTR_HAS_NO_VALUE    (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 8)
#define SLAPI_LOG_ERROR_MAPPING_TREE_CANNOT_FIND_PARENT_NODE               (SLAPI_LOG_CORE_BASE_MAPPING_TREE+ 9)
#define SLAPI_LOG_ERROR_MAPPING_TREE_MISSING_BACKEND_ATTR                  (SLAPI_LOG_CORE_BASE_MAPPING_TREE+10)
#define SLAPI_LOG_ERROR_MAPPING_TREE_MISSING_REFERRAL_ATTR                 (SLAPI_LOG_CORE_BASE_MAPPING_TREE+11)
#define SLAPI_LOG_ERROR_MAPPING_TREE_CANNOT_LOAD_DISTRIB_PLUGIN_LIB        (SLAPI_LOG_CORE_BASE_MAPPING_TREE+12)
#define SLAPI_LOG_ERROR_MAPPING_TREE_MISSING_ATTR_FOR_DISTRIB_PLUGIN       (SLAPI_LOG_CORE_BASE_MAPPING_TREE+13)
#define SLAPI_LOG_ERROR_MAPPING_TREE_CANNOT_FIND_CHILDREN_OF_MTN           (SLAPI_LOG_CORE_BASE_MAPPING_TREE+14)
#define SLAPI_LOG_ERROR_MAPPING_TREE_FIND_NO_ENTRY_WITH_NSMAPPINGTREE_ATTR (SLAPI_LOG_CORE_BASE_MAPPING_TREE+15)
#define SLAPI_LOG_ERROR_MAPPING_TREE_CANNOT_CREATE_MTN                     (SLAPI_LOG_CORE_BASE_MAPPING_TREE+16)
#define SLAPI_LOG_ERROR_MAPPING_TREE_MTN_IS_NOT_A_RIGHT_CHILD              (SLAPI_LOG_CORE_BASE_MAPPING_TREE+17)
#define SLAPI_LOG_ERROR_MAPPING_TREE_CANNOT_DETERMINE_NEW_PARENT           (SLAPI_LOG_CORE_BASE_MAPPING_TREE+18)
#define SLAPI_LOG_ERROR_MAPPING_TREE_DISTRIB_FUNCTION_ATTR_HAS_NO_VALUE_2  (SLAPI_LOG_CORE_BASE_MAPPING_TREE+19)
#define SLAPI_LOG_ERROR_MAPPING_TREE_DISTRIB_PLUGIN_ATTR_HAS_NO_VALUE_2    (SLAPI_LOG_CORE_BASE_MAPPING_TREE+20)
#define SLAPI_LOG_ERROR_MAPPING_TREE_BAD_BACKEND_RETURNED                  (SLAPI_LOG_CORE_BASE_MAPPING_TREE+21)
#define SLAPI_LOG_ERROR_MAPPING_TREE_NO_DISTRIB_PLUGIN_CONFIGURED          (SLAPI_LOG_CORE_BASE_MAPPING_TREE+22)
#define SLAPI_LOG_ERROR_MAPPING_TREE_UNKNOWN_BACKEND                       (SLAPI_LOG_CORE_BASE_MAPPING_TREE+23)
#define SLAPI_LOG_ERROR_MAPPING_TREE_BACKEND_IS_OFFLINE                    (SLAPI_LOG_CORE_BASE_MAPPING_TREE+24)
#define SLAPI_LOG_ERROR_MAPPING_TREE_BACKEND_NOT_DECLARED_IN_MAPPING_TREE  (SLAPI_LOG_CORE_BASE_MAPPING_TREE+25)
#define SLAPI_LOG_ERROR_MAPPING_TREE_BACKEND_NOT_DECLARED_IN_MTN           (SLAPI_LOG_CORE_BASE_MAPPING_TREE+26)
#define SLAPI_LOG_ERROR_MAPPING_TREE_CANNOT_FIND_DISTRIB_FUNCTION          (SLAPI_LOG_CORE_BASE_MAPPING_TREE+27)


#define SLAPI_LOG_CORE_BASE_ATTRSYNTAX  0x1680

#define SLAPI_LOG_ERROR_ATTRSYNTAX_NULL_PARAMETER_FOR_CHECK_OID  (SLAPI_LOG_CORE_BASE_ATTRSYNTAX+ 1)
#define SLAPI_LOG_ERROR_ATTRSYNTAX_BAD_OID_PARAM_FOR_CHECK_OID   (SLAPI_LOG_CORE_BASE_ATTRSYNTAX+ 2)
#define SLAPI_LOG_ERROR_ATTRSYNTAX_NON_NUMERIC_OID_FOR_CHECK_OID (SLAPI_LOG_CORE_BASE_ATTRSYNTAX+ 3)
#define SLAPI_LOG_ERROR_ATTRSYNTAX_OID_MUST_START_END_WITH_DIGIT (SLAPI_LOG_CORE_BASE_ATTRSYNTAX+ 4)
#define SLAPI_LOG_ERROR_ATTRSYNTAX_BAD_OID                       (SLAPI_LOG_CORE_BASE_ATTRSYNTAX+ 5)

#define SLAPI_LOG_CORE_BASE_SCHEMA	0x1700

#define SLAPI_LOG_ERROR_SCHEMA_DSE_NEWLOCK		(SLAPI_LOG_CORE_BASE_SCHEMA+1)
#define SLAPI_LOG_ERROR_SCHEMA_NOFILE			(SLAPI_LOG_CORE_BASE_SCHEMA+2)
#define SLAPI_LOG_ERROR_SCHEMA_ADD_OCFAIL		(SLAPI_LOG_CORE_BASE_SCHEMA+3)
#define SLAPI_LOG_ERROR_SCHEMA_ADD_ACIFAIL		(SLAPI_LOG_CORE_BASE_SCHEMA+4)
#define SLAPI_LOG_ERROR_SCHEMA_OC_MISSING		(SLAPI_LOG_CORE_BASE_SCHEMA+5)
#define SLAPI_LOG_ERROR_SCHEMA_OC_UNKNOWN		(SLAPI_LOG_CORE_BASE_SCHEMA+6)
#define SLAPI_LOG_ERROR_SCHEMA_ATTR_SINGLEVALUED	(SLAPI_LOG_CORE_BASE_SCHEMA+7)
#define SLAPI_LOG_ERROR_SCHEMA_ATTR_REQUIRED	(SLAPI_LOG_CORE_BASE_SCHEMA+8)
#define SLAPI_LOG_ERROR_SCHEMA_ATTR_NOTALLOWED	(SLAPI_LOG_CORE_BASE_SCHEMA+9)
#define SLAPI_LOG_ERROR_SCHEMA_NO_ATTR_IN_ENUM	(SLAPI_LOG_CORE_BASE_SCHEMA+10)
#define SLAPI_LOG_ERROR_SCHEMA_NO_OC_IN_ENUM	(SLAPI_LOG_CORE_BASE_SCHEMA+11)
#define SLAPI_LOG_ERROR_SCHEMA_OC_EMPTYLDIF		(SLAPI_LOG_CORE_BASE_SCHEMA+12)
#define SLAPI_LOG_ERROR_SCHEMA_CHECK_NO_OID		(SLAPI_LOG_CORE_BASE_SCHEMA+13)
#define SLAPI_LOG_WARNING_SCHEMA_STRIPOPT_REQATTR	(SLAPI_LOG_CORE_BASE_SCHEMA+14)
#define SLAPI_LOG_WARNING_SCHEMA_STRIPOPT_ALLATTR	(SLAPI_LOG_CORE_BASE_SCHEMA+15)
#define SLAPI_LOG_WARNING_SCHEMA_NO_ORIGIN		(SLAPI_LOG_CORE_BASE_SCHEMA+16)
#define SLAPI_LOG_WARNING_SCHEMA_NO_DS_USE		(SLAPI_LOG_CORE_BASE_SCHEMA+17)


/* Replication range numbers */
#define SLAPI_LOG_REPLICATION_BASE						0x2000
#define SLAPI_LOG_REPLICATION_NORUV						(SLAPI_LOG_REPLICATION_BASE+1)
#define SLAPI_LOG_REPLICATION_INC_CONS_DISABLE		(SLAPI_LOG_REPLICATION_BASE+2)
#define SLAPI_LOG_REPLICATION_CL5_TRAVERSAL				(SLAPI_LOG_REPLICATION_BASE+3)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_WINDOWSIZE		(SLAPI_LOG_REPLICATION_BASE+4)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_GROUPSIZE		(SLAPI_LOG_REPLICATION_BASE+5)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_COMPLEVEL		(SLAPI_LOG_REPLICATION_BASE+6)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_FORBIDDEN_ATTR	(SLAPI_LOG_REPLICATION_BASE+7)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_FORCE51PROT		(SLAPI_LOG_REPLICATION_BASE+8)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_ENABLE			(SLAPI_LOG_REPLICATION_BASE+9)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_AUTOINIT			(SLAPI_LOG_REPLICATION_BASE+10)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_PARTCHKSUM		(SLAPI_LOG_REPLICATION_BASE+11)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_PARTIAL_CHKSUM_NOT_ALLOWED		(SLAPI_LOG_REPLICATION_BASE+12)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_BINDMETHOD		(SLAPI_LOG_REPLICATION_BASE+13)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_TRANSPORTINFO	(SLAPI_LOG_REPLICATION_BASE+14)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_BINDDN			(SLAPI_LOG_REPLICATION_BASE+15)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_TIMEOUT			(SLAPI_LOG_REPLICATION_BASE+16)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_CREDENTIALS		(SLAPI_LOG_REPLICATION_BASE+17)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_NOVAL			(SLAPI_LOG_REPLICATION_BASE+18)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_INVALID_VALUE	(SLAPI_LOG_REPLICATION_BASE+19)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_SCHEDULE			(SLAPI_LOG_REPLICATION_BASE+20)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_PARTIALREPLCONF	(SLAPI_LOG_REPLICATION_BASE+21)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_PARTIALREPLCONF2	(SLAPI_LOG_REPLICATION_BASE+22)
#define SLAPI_LOG_REPLICATION_PARTIAL_CONF_NOT_STARTED	(SLAPI_LOG_REPLICATION_BASE+23)
#define SLAPI_LOG_REPLICATION_PARTIAL_CONF_MODIF_ERROR	(SLAPI_LOG_REPLICATION_BASE+24)
#define SLAPI_LOG_REPLICATION_PARTIAL_RE_ALLOC_ERROR	(SLAPI_LOG_REPLICATION_BASE+25)
#define SLAPI_LOG_REPLICATION_INC_BIND_ERROR			(SLAPI_LOG_REPLICATION_BASE+26)
#define SLAPI_LOG_REPLICATION_INC_START_ERROR			(SLAPI_LOG_REPLICATION_BASE+27)
#define SLAPI_LOG_REPLICATION_SKEW_TIME_ERROR			(SLAPI_LOG_REPLICATION_BASE+28)
#define SLAPI_LOG_REPLICATION_INC_FATAL_ERROR			(SLAPI_LOG_REPLICATION_BASE+29)
#define SLAPI_LOG_REPLICATION_REPLICA_MOD_NOVAL			(SLAPI_LOG_REPLICATION_BASE+30)
#define SLAPI_LOG_REPLICATION_REPLICA_MOD_INVALID_VALUE	(SLAPI_LOG_REPLICATION_BASE+31)
#define SLAPI_LOG_REPLICATION_INC_FATAL_AGMT_DISABLED	(SLAPI_LOG_REPLICATION_BASE+32)
#define SLAPI_LOG_REPLICATION_CHECKSUM_UPDATE_FAILURE	(SLAPI_LOG_REPLICATION_BASE+33)
#define SLAPI_LOG_REPLICATION_LAST_INIT_UPDATE_FAILURE	(SLAPI_LOG_REPLICATION_BASE+34)
#define SLAPI_LOG_REPLICATION_SCHEMA_READ				(SLAPI_LOG_REPLICATION_BASE+35)
#define SLAPI_LOG_REPLICATION_TOT_BIND_ERROR			(SLAPI_LOG_REPLICATION_BASE+36)
#define SLAPI_LOG_REPLICATION_TOT_START_ERROR			(SLAPI_LOG_REPLICATION_BASE+37)
#define SLAPI_LOG_REPLICATION_CL5_CREATEDIR_ERROR		(SLAPI_LOG_REPLICATION_BASE+38)
#define SLAPI_LOG_REPLICATION_CL5_OPENDIR_ERROR			(SLAPI_LOG_REPLICATION_BASE+39)
#define SLAPI_LOG_REPLICATION_CL5_DBREMOVE_ERROR		(SLAPI_LOG_REPLICATION_BASE+40)
#define SLAPI_LOG_REPLICATION_CL5_REMOVE_ERROR			(SLAPI_LOG_REPLICATION_BASE+41)
#define SLAPI_LOG_REPLICATION_CL5_NOT_INIT_ERROR		(SLAPI_LOG_REPLICATION_BASE+42)
#define SLAPI_LOG_REPLICATION_CL5_INIT_ERROR			(SLAPI_LOG_REPLICATION_BASE+43)
#define SLAPI_LOG_REPLICATION_CL5_OPEN_ERROR			(SLAPI_LOG_REPLICATION_BASE+44)
#define SLAPI_LOG_REPLICATION_CL5_BADSTATE_ERROR		(SLAPI_LOG_REPLICATION_BASE+45)
#define SLAPI_LOG_REPLICATION_CL5_START_THREADS_ERROR	(SLAPI_LOG_REPLICATION_BASE+46)
#define SLAPI_LOG_REPLICATION_CL5_EXIST_AFTER_REMOVE_ERROR	(SLAPI_LOG_REPLICATION_BASE+47)
#define SLAPI_LOG_REPLICATION_CL5_ENTRY_ALLOC_ERROR		(SLAPI_LOG_REPLICATION_BASE+48)
#define SLAPI_LOG_REPLICATION_CL5_BAD_DATA_VERSION		(SLAPI_LOG_REPLICATION_BASE+49)
#define SLAPI_LOG_REPLICATION_CL5_BAD_DATA_OPERATION	(SLAPI_LOG_REPLICATION_BASE+50)
#define SLAPI_LOG_REPLICATION_CL5_TRIM_TXN_BEGIN_ERROR	(SLAPI_LOG_REPLICATION_BASE+51)
#define SLAPI_LOG_REPLICATION_CL5_TRIM_TXN_ABORT_ERROR	(SLAPI_LOG_REPLICATION_BASE+52)
#define SLAPI_LOG_REPLICATION_CL5_TRIM_TXN_COMMIT_ERROR	(SLAPI_LOG_REPLICATION_BASE+53)
#define SLAPI_LOG_REPLICATION_CL5_WRUV_TXN_BEGIN_ERROR	(SLAPI_LOG_REPLICATION_BASE+54)
#define SLAPI_LOG_REPLICATION_CL5_WRUV_TXN_ABORT_ERROR	(SLAPI_LOG_REPLICATION_BASE+55)
#define SLAPI_LOG_REPLICATION_CL5_WRUV_TXN_COMMIT_ERROR	(SLAPI_LOG_REPLICATION_BASE+56)
#define SLAPI_LOG_REPLICATION_CL5_WRUV_ERROR			(SLAPI_LOG_REPLICATION_BASE+57)
#define SLAPI_LOG_REPLICATION_CL5_WEC_TXN_BEGIN_ERROR	(SLAPI_LOG_REPLICATION_BASE+58)
#define SLAPI_LOG_REPLICATION_CL5_WEC_TXN_ABORT_ERROR	(SLAPI_LOG_REPLICATION_BASE+59)
#define SLAPI_LOG_REPLICATION_CL5_WEC_TXN_COMMIT_ERROR	(SLAPI_LOG_REPLICATION_BASE+60)
#define SLAPI_LOG_REPLICATION_CL5_WEC_ERROR				(SLAPI_LOG_REPLICATION_BASE+61)
#define SLAPI_LOG_REPLICATION_CL5_LDIFBUF_ALLOC_ERROR	(SLAPI_LOG_REPLICATION_BASE+62)
#define SLAPI_LOG_REPLICATION_CL5_BAD_DATA_LDIF			(SLAPI_LOG_REPLICATION_BASE+63)
#define SLAPI_LOG_REPLICATION_CL5_WOP_TXN_BEGIN_ERROR	(SLAPI_LOG_REPLICATION_BASE+64)
#define SLAPI_LOG_REPLICATION_CL5_WOP_TXN_ABORT_ERROR	(SLAPI_LOG_REPLICATION_BASE+65)
#define SLAPI_LOG_REPLICATION_CL5_WOP_TXN_COMMIT_ERROR	(SLAPI_LOG_REPLICATION_BASE+66)
#define SLAPI_LOG_REPLICATION_CL5_WOP_ERROR				(SLAPI_LOG_REPLICATION_BASE+67)
#define SLAPI_LOG_REPLICATION_CL5_GET1CHANGE_CURSOR_ERROR	(SLAPI_LOG_REPLICATION_BASE+68)
#define SLAPI_LOG_REPLICATION_CL5_GET1CHANGE_ERROR		(SLAPI_LOG_REPLICATION_BASE+69)
#define SLAPI_LOG_REPLICATION_CL5_GETNCHANGE_ERROR		(SLAPI_LOG_REPLICATION_BASE+70)
#define SLAPI_LOG_REPLICATION_CL5_DELETE_ENTRY_ERROR	(SLAPI_LOG_REPLICATION_BASE+71)
#define SLAPI_LOG_REPLICATION_CL5_POSITION_DB_ERROR		(SLAPI_LOG_REPLICATION_BASE+72)
#define SLAPI_LOG_REPLICATION_CL5_NEW_DBFILE_MEM_ERROR	(SLAPI_LOG_REPLICATION_BASE+73)
#define SLAPI_LOG_REPLICATION_CL5_NEW_DBFILE_OPEN_ERROR	(SLAPI_LOG_REPLICATION_BASE+74)
#define SLAPI_LOG_REPLICATION_CL5_NEW_DBFILE_COUNT_ERROR	(SLAPI_LOG_REPLICATION_BASE+75)
#define SLAPI_LOG_REPLICATION_CL5_CLOSE_ERROR			(SLAPI_LOG_REPLICATION_BASE+76)
#define SLAPI_LOG_REPLICATION_CL5_EXPORT_WRITE_ERROR	(SLAPI_LOG_REPLICATION_BASE+77)
#define SLAPI_LOG_REPLICATION_CL5_EXPORT_GET_ERROR		(SLAPI_LOG_REPLICATION_BASE+78)
#define SLAPI_LOG_REPLICATION_EXAMINE_RUV_ERROR			(SLAPI_LOG_REPLICATION_BASE+79)
#define SLAPI_LOG_REPLICATION_TOT_CONS_DISABLE			(SLAPI_LOG_REPLICATION_BASE+80)
#define SLAPI_LOG_REPLICATION_TOMBSTONE_TO_GLUE_ERROR	(SLAPI_LOG_REPLICATION_BASE+81)
#define SLAPI_LOG_REPLICATION_TOMBSTONE_PARENT_MISSING	(SLAPI_LOG_REPLICATION_BASE+82)
#define SLAPI_LOG_REPLICATION_INCOMING_SESSION_FAILURE	(SLAPI_LOG_REPLICATION_BASE+83)
#define SLAPI_LOG_REPLICATION_REPLICA_BEING_CONFIGURED	(SLAPI_LOG_REPLICATION_BASE+84)
#define SLAPI_LOG_REPLICATION_NO_REPLICA	(SLAPI_LOG_REPLICATION_BASE+85)
#define SLAPI_LOG_REPLICATION_LEGACY_CONSUMER	(SLAPI_LOG_REPLICATION_BASE+86)
#define SLAPI_LOG_REPLICATION_PERMISSION_DENIED	(SLAPI_LOG_REPLICATION_BASE+87)
#define SLAPI_LOG_REPLICATION_INTERNAL_ERROR	(SLAPI_LOG_REPLICATION_BASE+88)
#define SLAPI_LOG_REPLICATION_REPLICA_NOT_INITIALIZED	(SLAPI_LOG_REPLICATION_BASE+89)
#define SLAPI_LOG_REPLICATION_DUPLICATE_REPLICAID	(SLAPI_LOG_REPLICATION_BASE+90)
#define SLAPI_LOG_REPLICATION_REPLICA_BUSY	(SLAPI_LOG_REPLICATION_BASE+91)
#define SLAPI_LOG_REPLICATION_PARTIAL_NOT_ALLOWED	(SLAPI_LOG_REPLICATION_BASE+92)
#define SLAPI_LOG_REPLICATION_MAPPING_TREE_ERROR	(SLAPI_LOG_REPLICATION_BASE+93)
#define SLAPI_LOG_REPLICATION_PROTOCOL_VIOLATION	(SLAPI_LOG_REPLICATION_BASE+94)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_GRPKTSIZE	(SLAPI_LOG_REPLICATION_BASE+95)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_CCLEVEL		(SLAPI_LOG_REPLICATION_BASE+96)
#define SLAPI_LOG_REPLICATION_AGMT_MOD_PUBLISHER 	(SLAPI_LOG_REPLICATION_BASE+99)
#define SLAPI_LOG_REPLICATION_TOT_ERROR_EMPTY_DB		(SLAPI_LOG_REPLICATION_BASE+100)
#define SLAPI_LOG_REPLICATION_FATAL_CONSUMER_ERROR		(SLAPI_LOG_REPLICATION_BASE+101)
#define SLAPI_LOG_REPLICATION_CL5_DBREMOVE_ERROR2		(SLAPI_LOG_REPLICATION_BASE+102)
#define SLAPI_LOG_REPLICATION_CL5_DBREMOVE_ERROR3		(SLAPI_LOG_REPLICATION_BASE+103)
#define SLAPI_LOG_REPLICATION_MODDN_UNSUPPORTED_BY_CONSUMER		(SLAPI_LOG_REPLICATION_BASE+104)
#define SLAPI_LOG_REPLICATION_CONS_START_BAD_TAG		(SLAPI_LOG_REPLICATION_BASE+105)
#define SLAPI_LOG_REPLICATION_CONS_START_DECODE_END		(SLAPI_LOG_REPLICATION_BASE+106)
#define SLAPI_LOG_REPLICATION_CONS_OPT_CSN_DEC			(SLAPI_LOG_REPLICATION_BASE+107)
#define SLAPI_LOG_REPLICATION_CONS_OPT_CSN_PARSE		(SLAPI_LOG_REPLICATION_BASE+108)
#define SLAPI_LOG_REPLICATION_CONS_OPT_CSN_END_DEC		(SLAPI_LOG_REPLICATION_BASE+109)
#define SLAPI_LOG_REPLICATION_CONS_ENTRY_DEC			(SLAPI_LOG_REPLICATION_BASE+110)
#define SLAPI_LOG_REPLICATION_CONS_SCHEMA_MOD			(SLAPI_LOG_REPLICATION_BASE+111)
#define SLAPI_LOG_REPLICATION_CONS_CONTROL_DEC			(SLAPI_LOG_REPLICATION_BASE+112)
#define SLAPI_LOG_REPLICATION_CONS_CONTROL_DEC_TYPE		(SLAPI_LOG_REPLICATION_BASE+113)
#define SLAPI_LOG_REPLICATION_CONS_DB_ENTRIES_END_DEC	(SLAPI_LOG_REPLICATION_BASE+114)
#define SLAPI_LOG_REPLICATION_CONS_DB_ENTRY_IMPORT		(SLAPI_LOG_REPLICATION_BASE+115)
#define SLAPI_LOG_REPLICATION_CONS_UPDATES_INVALID_OP	(SLAPI_LOG_REPLICATION_BASE+116)
#define SLAPI_LOG_REPLICATION_CONS_UPDATES_ALLOC_PB		(SLAPI_LOG_REPLICATION_BASE+117)
#define SLAPI_LOG_REPLICATION_CONS_UPDATES_UNSUP_OP		(SLAPI_LOG_REPLICATION_BASE+118)
#define SLAPI_LOG_REPLICATION_CONS_UPDATES_UNEXPECT		(SLAPI_LOG_REPLICATION_BASE+119)
#define SLAPI_LOG_REPLICATION_CONS_UPDATES_FAIL		(SLAPI_LOG_REPLICATION_BASE+120)
#define SLAPI_LOG_REPLICATION_CONS_GROUP_FAIL		(SLAPI_LOG_REPLICATION_BASE+121)
#define SLAPI_LOG_REPLICATION_EXTOP_RESP			(SLAPI_LOG_REPLICATION_BASE+122)
#define SLAPI_LOG_REPLICATION_CONS_DEP_RUV			(SLAPI_LOG_REPLICATION_BASE+123)
#define SLAPI_LOG_REPLICATION_EXTOP_INIT_ERROR	 		(SLAPI_LOG_REPLICATION_BASE+124)
#define SLAPI_LOG_REPLICATION_PLUGIN_REGISTER_ERROR		(SLAPI_LOG_REPLICATION_BASE+125)
#define SLAPI_LOG_REPLICATION_TRS_BIND_ERROR			(SLAPI_LOG_REPLICATION_BASE+126)
#define SLAPI_LOG_REPLICATION_TRS_START_ERROR			(SLAPI_LOG_REPLICATION_BASE+127)
#define SLAPI_LOG_REPLICATION_TRS_END_ERROR				(SLAPI_LOG_REPLICATION_BASE+128)
/*** CL5 ***/
#define SLAPI_LOG_REPLICATION_CONNECTION_TIMEOUT		(SLAPI_LOG_REPLICATION_BASE+132)
#define SLAPI_LOG_REPLICATION_CL5_DBPUT_ERROR			(SLAPI_LOG_REPLICATION_BASE+133)


#define SLAPI_LOG_WARNING_REPL_BASE						0x2800
#define SLAPI_LOG_WARNING_REPL_RA_NO_CL					(SLAPI_LOG_WARNING_REPL_BASE+1)
#define SLAPI_LOG_WARNING_REPL_AGMT_IGNORE_WINDOWSIZE	(SLAPI_LOG_WARNING_REPL_BASE+2)
#define SLAPI_LOG_WARNING_REPL_AGMT_IGNORE_GROUPSIZE	(SLAPI_LOG_WARNING_REPL_BASE+3)
#define SLAPI_LOG_WARNING_REPL_AGMT_IGNORE_COMPRESSION_LEVEL	(SLAPI_LOG_WARNING_REPL_BASE+4)
#define SLAPI_LOG_WARNING_REPL_AGMT_MOD_REPLINIT		(SLAPI_LOG_WARNING_REPL_BASE+5)
#define SLAPI_LOG_WARNING_REPL_BAD_EVENT				(SLAPI_LOG_WARNING_REPL_BASE+6)
#define SLAPI_LOG_WARNING_REPL_SCHEMA					(SLAPI_LOG_WARNING_REPL_BASE+7)
#define SLAPI_LOG_WARNING_REPL_BAD_RUV					(SLAPI_LOG_WARNING_REPL_BASE+8)
#define SLAPI_LOG_WARNING_REPL_REPLAY_RESULT_ERROR		(SLAPI_LOG_WARNING_REPL_BASE+9)
#define SLAPI_LOG_WARNING_REPL_INC_ACQUIRE_FAILED		(SLAPI_LOG_WARNING_REPL_BASE+10)
#define SLAPI_LOG_WARNING_REPL_INC_RELEASE_FAILED		(SLAPI_LOG_WARNING_REPL_BASE+11)
#define SLAPI_LOG_WARNING_REPL_INC_END_SESS_FAILED		(SLAPI_LOG_WARNING_REPL_BASE+12)
#define SLAPI_LOG_WARNING_REPL_INC_FAILED_TO_REPLAY		(SLAPI_LOG_WARNING_REPL_BASE+13)
#define SLAPI_LOG_WARNING_REPL_INC_NO_CREDIT_TO_REPLAY	(SLAPI_LOG_WARNING_REPL_BASE+14)
#define SLAPI_LOG_WARNING_REPL_INC_INVALID_UPDATE		(SLAPI_LOG_WARNING_REPL_BASE+15)
#define SLAPI_LOG_WARNING_REPL_INC_INVALID_OP_TYPE		(SLAPI_LOG_WARNING_REPL_BASE+16)
#define SLAPI_LOG_WARNING_REPL_INC_LOST_CONN			(SLAPI_LOG_WARNING_REPL_BASE+17)
#define SLAPI_LOG_WARNING_REPL_INC_INVALID_CL_ACCESS	(SLAPI_LOG_WARNING_REPL_BASE+18)
#define SLAPI_LOG_WARNING_REPL_INC_NOT_STOPPED			(SLAPI_LOG_WARNING_REPL_BASE+19)
#define SLAPI_LOG_WARNING_REPL_UNEXPECTED_EVT			(SLAPI_LOG_WARNING_REPL_BASE+20)
#define SLAPI_LOG_WARNING_REPL_REPLICA_MOD_RWINIT		(SLAPI_LOG_WARNING_REPL_BASE+21)
#define SLAPI_LOG_WARNING_REPL_OVERWRITEREF_CONF_MISMATCH		(SLAPI_LOG_WARNING_REPL_BASE+23)
#define SLAPI_LOG_WARNING_REPL_FINITE_REFERRAL_AFTER_INIT		(SLAPI_LOG_WARNING_REPL_BASE+24)
#define SLAPI_LOG_WARNING_REPL_INFINITE_REFERRAL_AFTER_INIT		(SLAPI_LOG_WARNING_REPL_BASE+25)
#define SLAPI_LOG_WARNING_REPL_RUV_ENTRY_UPDATE_FAILURE	(SLAPI_LOG_WARNING_REPL_BASE+26)
#define SLAPI_LOG_WARNING_REPL_RUV_ENTRY_NOT_FOUND		(SLAPI_LOG_WARNING_REPL_BASE+27)
#define SLAPI_LOG_WARNING_REPL_AGMT_OFF_ABORTS_TOTAL	(SLAPI_LOG_WARNING_REPL_BASE+28)
#define SLAPI_LOG_WARNING_REPL_TOT_END_SESS_FAILED		(SLAPI_LOG_WARNING_REPL_BASE+29)
#define SLAPI_LOG_WARNING_REPL_TOT_UPDATE_ABORTED		(SLAPI_LOG_WARNING_REPL_BASE+30)
#define SLAPI_LOG_WARNING_REPL_ERR_PARTIAL_REJECT		(SLAPI_LOG_WARNING_REPL_BASE+31)
#define SLAPI_LOG_WARNING_REPL_ERR_PARTIAL_CONF			(SLAPI_LOG_WARNING_REPL_BASE+32)
#define SLAPI_LOG_WARNING_REPL_CL5_CL_ALREADY_OPEN		(SLAPI_LOG_WARNING_REPL_BASE+33)
#define SLAPI_LOG_WARNING_REPL_CL5_LDIF2OP_PARSE		(SLAPI_LOG_WARNING_REPL_BASE+34)
#define SLAPI_LOG_WARNING_REPL_EXAMINE_RUV_MISSING		(SLAPI_LOG_WARNING_REPL_BASE+35)
#define SLAPI_LOG_WARNING_REPL_EXAMINE_RUV_GENID		(SLAPI_LOG_WARNING_REPL_BASE+36)
#define SLAPI_LOG_WARNING_REPL_EXAMINE_RUV_TOOOLD		(SLAPI_LOG_WARNING_REPL_BASE+37)
#define SLAPI_LOG_WARNING_REPL_AGMT_IGNORE_GRPKTSIZE	(SLAPI_LOG_WARNING_REPL_BASE+38)
#define SLAPI_LOG_WARNING_REPL_AGMT_IGNORE_CCLEVEL		(SLAPI_LOG_WARNING_REPL_BASE+39)
#define SLAPI_LOG_WARNING_REPL_ENTRY_TO_GLUE			(SLAPI_LOG_WARNING_REPL_BASE+40)
#define SLAPI_LOG_WARNING_REPL_TOMBSTONE_TO_GLUE		(SLAPI_LOG_WARNING_REPL_BASE+41)
#define SLAPI_LOG_WARNING_REPL_CNX_CLEANUP_NOT_STARTED	(SLAPI_LOG_WARNING_REPL_BASE+42)
#define SLAPI_LOG_WARNING_REPL_CNX_DISCARD_START		(SLAPI_LOG_WARNING_REPL_BASE+43)
#define SLAPI_LOG_WARNING_REPL_LOCKED_RIDS			(SLAPI_LOG_WARNING_REPL_BASE+44)
#define SLAPI_LOG_WARNING_REPL_AGMT_ALREADY_STARTED	(SLAPI_LOG_WARNING_REPL_BASE+45)
#define SLAPI_LOG_WARNING_REPL_NEWER_PROT_VERSION	(SLAPI_LOG_WARNING_REPL_BASE+46)
#define SLAPI_LOG_WARNING_REPL_CNX_NO_DATA			(SLAPI_LOG_WARNING_REPL_BASE+47)
#define SLAPI_LOG_WARNING_REPL_CONS_DEP_REPLAY		(SLAPI_LOG_WARNING_REPL_BASE+48)
#define SLAPI_LOG_WARNING_REPL_CSN_DEP_CLEANUP			(SLAPI_LOG_WARNING_REPL_BASE+49)
#define SLAPI_LOG_WARNING_REPL_LDAP_RESULT_ERROR		(SLAPI_LOG_WARNING_REPL_BASE+50)
#define SLAPI_LOG_WARNING_REPL_PARSE_RESULT_ERROR		(SLAPI_LOG_WARNING_REPL_BASE+51)
#define SLAPI_LOG_WARNING_REPL_LDAP_READ_ERROR			(SLAPI_LOG_WARNING_REPL_BASE+52)
#define SLAPI_LOG_WARNING_REPL_TRS_START_52_ERROR		(SLAPI_LOG_WARNING_REPL_BASE+53)
#define SLAPI_LOG_WARNING_REPL_TRS_INVALID_START_RESP_TAG	(SLAPI_LOG_WARNING_REPL_BASE+54)
#define SLAPI_LOG_WARNING_REPL_TRS_ACK_DECODING_ERROR		(SLAPI_LOG_WARNING_REPL_BASE+55)
#define SLAPI_LOG_WARNING_REPL_TRS_ACQUIRE_DECODING_ERROR	(SLAPI_LOG_WARNING_REPL_BASE+56)
#define SLAPI_LOG_WARNING_REPL_TRS_RELEASE_DECODING_ERROR	(SLAPI_LOG_WARNING_REPL_BASE+57)
#define SLAPI_LOG_WARNING_REPL_TRS_ENCODING_MODRDN_ERROR	(SLAPI_LOG_WARNING_REPL_BASE+58)
#define SLAPI_LOG_WARNING_REPL_SEND_EXTOP_ERROR			(SLAPI_LOG_WARNING_REPL_BASE+59)
#define SLAPI_LOG_WARNING_REPL_SEND_PUSH_SCHEMA_ERROR	(SLAPI_LOG_WARNING_REPL_BASE+60)
#define SLAPI_LOG_WARNING_REPL_TRS_ACQUIRE_FAILED		(SLAPI_LOG_WARNING_REPL_BASE+61)
#define SLAPI_LOG_WARNING_REPL_TRS_RELEASE_FAILED		(SLAPI_LOG_WARNING_REPL_BASE+62)
#define SLAPI_LOG_WARNING_REPL_TRS_PUSH_SCHEMA_FAILED	(SLAPI_LOG_WARNING_REPL_BASE+63)
#define SLAPI_LOG_WARNING_REPL_TRS_ADD_OP_ERROR			(SLAPI_LOG_WARNING_REPL_BASE+64)
#define SLAPI_LOG_WARNING_REPL_TRS_SEND_ERROR			(SLAPI_LOG_WARNING_REPL_BASE+65)
#define SLAPI_LOG_WARNING_REPL_TIMEOUT_WAITING_ACK		(SLAPI_LOG_WARNING_REPL_BASE+66)

/* Frontend range numbers */
#define SLAPI_LOG_FRONTEND_BASE 0x3000
#define SLAPI_LOG_ERROR_FRONTEND_ACCEPT_FAILED                      (SLAPI_LOG_FRONTEND_BASE+ 1)
#define SLAPI_LOG_ERROR_FRONTEND_GETHOSTBYNAME                      (SLAPI_LOG_FRONTEND_BASE+ 2)
#define SLAPI_LOG_ERROR_FRONTEND_NOPORTS                            (SLAPI_LOG_FRONTEND_BASE+ 3)
#define SLAPI_LOG_ERROR_FRONTEND_CREATE_THREAD                      (SLAPI_LOG_FRONTEND_BASE+ 4)
#define SLAPI_LOG_ERROR_FRONTEND_FDS                                (SLAPI_LOG_FRONTEND_BASE+ 5)
#define SLAPI_LOG_ERROR_FRONTEND_FDS_2                              (SLAPI_LOG_FRONTEND_BASE+ 6)
#define SLAPI_LOG_ERROR_FRONTEND_LOCK_INIT_FAILED                   (SLAPI_LOG_FRONTEND_BASE+ 7)
#define SLAPI_LOG_ERROR_FRONTEND_LOCK_CREATE_FAILED                 (SLAPI_LOG_FRONTEND_BASE+ 8)
#define SLAPI_LOG_ERROR_FRONTEND_CONDVAR_CREATE_FAILED              (SLAPI_LOG_FRONTEND_BASE+ 9)
#define SLAPI_LOG_ERROR_FRONTEND_SETNETADDR                         (SLAPI_LOG_FRONTEND_BASE+10)
#define SLAPI_LOG_ERROR_FRONTEND_GETHOSTBYNAME2                     (SLAPI_LOG_FRONTEND_BASE+11)
#define SLAPI_LOG_ERROR_FRONTEND_GETHOSTNAME                        (SLAPI_LOG_FRONTEND_BASE+12)
#define SLAPI_LOG_ERROR_FRONTEND_NSS_INIT_FAILED                    (SLAPI_LOG_FRONTEND_BASE+13)
#define SLAPI_LOG_ERROR_FRONTEND_SLAPD_CONFLICT                     (SLAPI_LOG_FRONTEND_BASE+14)
#define SLAPI_LOG_ERROR_FRONTEND_OBSOLETED_PB                       (SLAPI_LOG_FRONTEND_BASE+15)
#define SLAPI_LOG_ERROR_FRONTEND_SLAPD_USER_PB                      (SLAPI_LOG_FRONTEND_BASE+16)

#define SLAPI_LOG_ERROR_FRONTEND_BER_ENCODING_FAILED                (SLAPI_LOG_FRONTEND_BASE+20)
#define SLAPI_LOG_WARNING_FRONTEND_IPV6_NOT_SUPPORTED               (SLAPI_LOG_FRONTEND_BASE+21)
#define SLAPI_LOG_WARNING_FRONTEND_CONN_CLOSURE                     (SLAPI_LOG_FRONTEND_BASE+22)
                                                                   
#define SLAPI_LOG_ERROR_FRONTEND_BASE64_DECODE                      (SLAPI_LOG_FRONTEND_BASE+30)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOT_PUSH_BACK_DATA              (SLAPI_LOG_FRONTEND_BASE+31)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOT_RETRIEVE_HDSML_CONFIG       (SLAPI_LOG_FRONTEND_BASE+32)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOT_RETRIEVE_PLUGIN             (SLAPI_LOG_FRONTEND_BASE+33)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOT_START_PARSE                 (SLAPI_LOG_FRONTEND_BASE+34)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOT_STORE_WORKER_CONTEXT        (SLAPI_LOG_FRONTEND_BASE+35)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOTE_REGISTER_HTTP_PORT         (SLAPI_LOG_FRONTEND_BASE+36)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOTE_REGISTER_HTTPS_PORT        (SLAPI_LOG_FRONTEND_BASE+37)
#define SLAPI_LOG_ERROR_FRONTEND_CONFIG_POOL_SIZE                   (SLAPI_LOG_FRONTEND_BASE+38)
#define SLAPI_LOG_ERROR_FRONTEND_CREATE_UTF8_TRANSCODER             (SLAPI_LOG_FRONTEND_BASE+39)
#define SLAPI_LOG_ERROR_FRONTEND_DSMLW_INIT_FAILED                  (SLAPI_LOG_FRONTEND_BASE+40)
#define SLAPI_LOG_ERROR_FRONTEND_EXTRA_DATA_COPY                    (SLAPI_LOG_FRONTEND_BASE+41)
#define SLAPI_LOG_ERROR_FRONTEND_HTTP_CONTEXT_KEY_CREATION          (SLAPI_LOG_FRONTEND_BASE+42)
#define SLAPI_LOG_ERROR_FRONTEND_HTTP_PROTOCOL_ERROR                (SLAPI_LOG_FRONTEND_BASE+43)
#define SLAPI_LOG_ERROR_FRONTEND_INIT_ERROR                         (SLAPI_LOG_FRONTEND_BASE+44)
#define SLAPI_LOG_ERROR_FRONTEND_INSTANCE_ERROR                     (SLAPI_LOG_FRONTEND_BASE+45)
#define SLAPI_LOG_ERROR_FRONTEND_INTERNAL                           (SLAPI_LOG_FRONTEND_BASE+46)
#define SLAPI_LOG_ERROR_FRONTEND_INVALID_ATTRIBUTE                  (SLAPI_LOG_FRONTEND_BASE+47)
#define SLAPI_LOG_ERROR_FRONTEND_INVALID_ATTRIBUTE_SYNTAX           (SLAPI_LOG_FRONTEND_BASE+48)
#define SLAPI_LOG_ERROR_FRONTEND_IO_ERROR                           (SLAPI_LOG_FRONTEND_BASE+49)
#define SLAPI_LOG_ERROR_FRONTEND_MEM_ALLOCATION                     (SLAPI_LOG_FRONTEND_BASE+50)
#define SLAPI_LOG_ERROR_FRONTEND_MEM_USAGE                          (SLAPI_LOG_FRONTEND_BASE+51)
#define SLAPI_LOG_ERROR_FRONTEND_NO_DSML_SCHEMA_LOCATION            (SLAPI_LOG_FRONTEND_BASE+52)
#define SLAPI_LOG_ERROR_FRONTEND_NO_DSML_URN                        (SLAPI_LOG_FRONTEND_BASE+53)
#define SLAPI_LOG_ERROR_FRONTEND_NO_SOAP_SCHEMA_LOCATION            (SLAPI_LOG_FRONTEND_BASE+54)
#define SLAPI_LOG_ERROR_FRONTEND_NO_SOAP_URN                        (SLAPI_LOG_FRONTEND_BASE+55)
#define SLAPI_LOG_ERROR_FRONTEND_NO_FREELIST_LOCK                   (SLAPI_LOG_FRONTEND_BASE+56)
#define SLAPI_LOG_ERROR_FRONTEND_NO_MORE_PARSER                     (SLAPI_LOG_FRONTEND_BASE+57)
#define SLAPI_LOG_ERROR_FRONTEND_RETURN_SOAP_FAULT                  (SLAPI_LOG_FRONTEND_BASE+58)
#define SLAPI_LOG_ERROR_FRONTEND_SECURE_ID_METHOD                   (SLAPI_LOG_FRONTEND_BASE+59)
#define SLAPI_LOG_ERROR_FRONTEND_XMLSTRING_TRANSCODE                (SLAPI_LOG_FRONTEND_BASE+60)
#define SLAPI_LOG_ERROR_FRONTEND_CANNOT_RELEASE_PARSER              (SLAPI_LOG_FRONTEND_BASE+61)
#define SLAPI_LOG_ERROR_FRONTEND_PARSER_DOES_NOT_EXIST              (SLAPI_LOG_FRONTEND_BASE+62)
#define SLAPI_LOG_ERROR_FRONTEND_INVALID_PARSER_ID                  (SLAPI_LOG_FRONTEND_BASE+63)
#define SLAPI_LOG_ERROR_FRONTEND_BAD_DSML_REQUEST                   (SLAPI_LOG_FRONTEND_BASE+64)
#define SLAPI_LOG_ERROR_FRONTEND_PARSE_FAKE_REQ_FAILS               (SLAPI_LOG_FRONTEND_BASE+65)
#define SLAPI_LOG_ERROR_FRONTEND_PARSE_FAKE_REQ_FAILS2              (SLAPI_LOG_FRONTEND_BASE+66)
#define SLAPI_LOG_ERROR_FRONTEND_SCHEMA_FILE_IS_MISSING             (SLAPI_LOG_FRONTEND_BASE+67)
#define SLAPI_LOG_ERROR_FRONTEND_BAD_SOAP_ACTION_HEADER             (SLAPI_LOG_FRONTEND_BASE+68)
#define SLAPI_LOG_ERROR_FRONTEND_PARSER_LIST_IS_FULL                (SLAPI_LOG_FRONTEND_BASE+69)
#define SLAPI_LOG_ERROR_FRONTEND_UNEXPECTED_EVENT_IN_START_PARSE    (SLAPI_LOG_FRONTEND_BASE+70)
#define SLAPI_LOG_ERROR_FRONTEND_UNKNOWN_EVENT_IN_START_PARSE       (SLAPI_LOG_FRONTEND_BASE+71)
#define SLAPI_LOG_ERROR_FRONTEND_UNEXPECTED_EVENT_IN_GET_NEXT_REQ   (SLAPI_LOG_FRONTEND_BASE+72)
#define SLAPI_LOG_ERROR_FRONTEND_UNKNOWN_EVENT_IN_GET_NEXT_REQ      (SLAPI_LOG_FRONTEND_BASE+73)
#define SLAPI_LOG_ERROR_FRONTEND_PRBIND_FAILED                      (SLAPI_LOG_FRONTEND_BASE+74)
#define SLAPI_LOG_ERROR_ATTR_ENCR_SECURITY_OFF			    (SLAPI_LOG_FRONTEND_BASE+75)

/* Backend range numbers */
#if 0
#define SLAPI_LOG_BACKEND_BASE_2			0x5000
#endif

#define	SLAPI_LOG_BACKEND_BASE_0	0x5000

#define	SLAPI_LOG_ERROR_BACKEND_FS1		(SLAPI_LOG_BACKEND_BASE_0+1)
#define	SLAPI_LOG_ERROR_BACKEND_FS2		(SLAPI_LOG_BACKEND_BASE_0+2)
#define	SLAPI_LOG_ERROR_BACKEND_FS3		(SLAPI_LOG_BACKEND_BASE_0+3)
#define	SLAPI_LOG_ERROR_BACKEND_SETMALLOC		(SLAPI_LOG_BACKEND_BASE_0+4)
#define	SLAPI_LOG_ERROR_BACKEND_NOPERM		(SLAPI_LOG_BACKEND_BASE_0+5)
#define	SLAPI_LOG_ERROR_BACKEND_ENV		(SLAPI_LOG_BACKEND_BASE_0+6)
#define	SLAPI_LOG_ERROR_BACKEND_ALREADY_STARTED		(SLAPI_LOG_BACKEND_BASE_0+7)
#define	SLAPI_LOG_ERROR_BACKEND_RECOVER		(SLAPI_LOG_BACKEND_BASE_0+8)
#define	SLAPI_LOG_ERROR_BACKEND_RECOVER_ARCHIVE		(SLAPI_LOG_BACKEND_BASE_0+9)
#define	SLAPI_LOG_ERROR_BACKEND_RECOVER_FAIL		(SLAPI_LOG_BACKEND_BASE_0+10)
#define	SLAPI_LOG_ERROR_BACKEND_LOG_BUFFER		(SLAPI_LOG_BACKEND_BASE_0+11)
#define	SLAPI_LOG_ERROR_BACKEND_THREAD		(SLAPI_LOG_BACKEND_BASE_0+12)
#define	SLAPI_LOG_ERROR_BACKEND_DB		(SLAPI_LOG_BACKEND_BASE_0+13)
#define	SLAPI_LOG_ERROR_BACKEND_DB_VERSION		(SLAPI_LOG_BACKEND_BASE_0+14)
#define	SLAPI_LOG_ERROR_BACKEND_DB_VER_READ		(SLAPI_LOG_BACKEND_BASE_0+15)
#define	SLAPI_LOG_ERROR_BACKEND_DB_CREATE		(SLAPI_LOG_BACKEND_BASE_0+16)
#define	SLAPI_LOG_ERROR_BACKEND_DB_PAGESIZE		(SLAPI_LOG_BACKEND_BASE_0+17)
#define	SLAPI_LOG_ERROR_BACKEND_DB_OPEN		(SLAPI_LOG_BACKEND_BASE_0+18)
#define	SLAPI_LOG_ERROR_BACKEND_NEXTID		(SLAPI_LOG_BACKEND_BASE_0+19)
#define	SLAPI_LOG_ERROR_BACKEND_WAIT		(SLAPI_LOG_BACKEND_BASE_0+20)
#define	SLAPI_LOG_ERROR_BACKEND_TXN_BEGIN		(SLAPI_LOG_BACKEND_BASE_0+21)
#define	SLAPI_LOG_ERROR_BACKEND_TXN_COMMIT		(SLAPI_LOG_BACKEND_BASE_0+22)
#define	SLAPI_LOG_ERROR_BACKEND_TXN_ABORT		(SLAPI_LOG_BACKEND_BASE_0+23)
#define	SLAPI_LOG_ERROR_BACKEND_DEADLOCK		(SLAPI_LOG_BACKEND_BASE_0+24)
#define	SLAPI_LOG_ERROR_BACKEND_CHKPOINT		(SLAPI_LOG_BACKEND_BASE_0+25)
#define	SLAPI_LOG_ERROR_BACKEND_TRICKLE		(SLAPI_LOG_BACKEND_BASE_0+26)
#define	SLAPI_LOG_ERROR_BACKEND_GUARDIAN_CREAT	(SLAPI_LOG_BACKEND_BASE_0+27)
#define	SLAPI_LOG_ERROR_BACKEND_DB_EXISTS		(SLAPI_LOG_BACKEND_BASE_0+28)
#define	SLAPI_LOG_ERROR_BACKEND_NODIR		(SLAPI_LOG_BACKEND_BASE_0+29)
#define	SLAPI_LOG_ERROR_BACKEND_NOLOG		(SLAPI_LOG_BACKEND_BASE_0+30)
#define	SLAPI_LOG_ERROR_BACKEND_COPYDB		(SLAPI_LOG_BACKEND_BASE_0+31)
#define	SLAPI_LOG_ERROR_BACKEND_GUARDIAN_WRITE	(SLAPI_LOG_BACKEND_BASE_0+32)
#define	SLAPI_LOG_ERROR_BACKEND_GUARDIAN_DEL	(SLAPI_LOG_BACKEND_BASE_0+33)
#define	SLAPI_LOG_ERROR_BACKEND_DB_RECNUM	(SLAPI_LOG_BACKEND_BASE_0+34)
#define	SLAPI_LOG_ERROR_NO_RUV_WHILE_DB2LDIF	(SLAPI_LOG_BACKEND_BASE_0+35)
#define	SLAPI_LOG_ERROR_BACKEND_RESIZE		(SLAPI_LOG_BACKEND_BASE_0+36)
#define	SLAPI_LOG_ERROR_BACKUP_OPEN_FAIL		(SLAPI_LOG_BACKEND_BASE_0+37)
#define	SLAPI_LOG_ERROR_BACKUP_WRITE_FAIL		(SLAPI_LOG_BACKEND_BASE_0+38)
#define SLAPI_LOG_ERROR_RESTORE_OPEN_FAIL		(SLAPI_LOG_BACKEND_BASE_0+39)
#define SLAPI_LOG_ERROR_RESTORE_INDEX			(SLAPI_LOG_BACKEND_BASE_0+40)
#define SLAPI_LOG_ERROR_RESTORE_BACKEND1		(SLAPI_LOG_BACKEND_BASE_0+41)
#define SLAPI_LOG_ERROR_RESTORE_BACKEND2		(SLAPI_LOG_BACKEND_BASE_0+42)

#define	SLAPI_LOG_BACKEND_BASE_1	0x5100
#define SLAPI_LOG_ERROR_BACKEND_NEXTID_NOT_INITIALIZED (SLAPI_LOG_BACKEND_BASE_1+1)
#define SLAPI_LOG_ERROR_BACKEND_NEXTID_OVERFLOW (SLAPI_LOG_BACKEND_BASE_1+2)
#define SLAPI_LOG_ERROR_BACKEND_NEXTID_LOW (SLAPI_LOG_BACKEND_BASE_1+3)
#define SLAPI_LOG_ERROR_BACKEND_WRONG_NUMSUBORDINATE (SLAPI_LOG_BACKEND_BASE_1+4)
#define SLAPI_LOG_ERROR_BACKEND_PERFCTRS_INIT (SLAPI_LOG_BACKEND_BASE_1+5)
#define SLAPI_LOG_ERROR_BACKEND_PERFCTRS_INIT_1 (SLAPI_LOG_BACKEND_BASE_1+6)
#define SLAPI_LOG_ERROR_BACKEND_PERFCTRS_INIT_2 (SLAPI_LOG_BACKEND_BASE_1+7)
#define SLAPI_LOG_ERROR_BACKEND_PERFCTRS_INIT_3 (SLAPI_LOG_BACKEND_BASE_1+8)
#define SLAPI_LOG_ERROR_BACKEND_SEQ_ENTRY_MISSING (SLAPI_LOG_BACKEND_BASE_1+9)
#define SLAPI_LOG_ERROR_BACKEND_SEQ_INDEX_MISSING (SLAPI_LOG_BACKEND_BASE_1+10)
#define SLAPI_LOG_ERROR_BACKEND_COMPARE_ENTRIES (SLAPI_LOG_BACKEND_BASE_1+11)
#define SLAPI_LOG_ERROR_BACKEND_RES_LIMIT (SLAPI_LOG_BACKEND_BASE_1+12)
#define SLAPI_LOG_ERROR_BACKEND_DATABASE_INIT (SLAPI_LOG_BACKEND_BASE_1+13)
#define SLAPI_LOG_ERROR_BACKEND_DATABASE_INSTANCE_INIT (SLAPI_LOG_BACKEND_BASE_1+14)
#define SLAPI_LOG_ERROR_BACKEND_VERSION_MISMATCH (SLAPI_LOG_BACKEND_BASE_1+15)
#define SLAPI_LOG_ERROR_BACKEND_VLV_FILE_NOT_FOUND (SLAPI_LOG_BACKEND_BASE_1+16)
#define SLAPI_LOG_ERROR_BACKEND_VLV_CURSOR (SLAPI_LOG_BACKEND_BASE_1+17)
#define SLAPI_LOG_ERROR_BACKEND_VLV_NOMEM (SLAPI_LOG_BACKEND_BASE_1+18)
#define SLAPI_LOG_ERROR_BACKEND_VLV_NO_FILE (SLAPI_LOG_BACKEND_BASE_1+19)
#define SLAPI_LOG_ERROR_BACKEND_VLV_NO_CURSOR (SLAPI_LOG_BACKEND_BASE_1+20)
#define SLAPI_LOG_ERROR_BACKEND_VLV_NO_ENTRY (SLAPI_LOG_BACKEND_BASE_1+21)
#define SLAPI_LOG_ERROR_BACKEND_VLV_NO_CANDIDATE (SLAPI_LOG_BACKEND_BASE_1+22)
#define SLAPI_LOG_ERROR_BACKEND_VLV_NO_INDEX (SLAPI_LOG_BACKEND_BASE_1+23)
#define SLAPI_LOG_ERROR_BACKEND_VLV_INVALID_NAME (SLAPI_LOG_BACKEND_BASE_1+24)
#define SLAPI_LOG_ERROR_BACKEND_ADD_MAXID_REACHED (SLAPI_LOG_BACKEND_BASE_1+25)
#define SLAPI_LOG_ERROR_BACKEND_ADD_INDEXATION_FAILED (SLAPI_LOG_BACKEND_BASE_1+26)
#define SLAPI_LOG_ERROR_BACKEND_ADD_RETRY_EXCEEDED (SLAPI_LOG_BACKEND_BASE_1+27)
#define SLAPI_LOG_ERROR_BACKEND_ATTRINFO_INIT_FAILED (SLAPI_LOG_BACKEND_BASE_1+28)
#define SLAPI_LOG_ERROR_BACKEND_DELETE_NONTOMBSTONE_ENTRY (SLAPI_LOG_BACKEND_BASE_1+29)
#define SLAPI_LOG_ERROR_BACKEND_TOMBSTONE_TOMBSTONE_ENTRY (SLAPI_LOG_BACKEND_BASE_1+30)
#define SLAPI_LOG_ERROR_BACKEND_URP_NAMING_COLLISION_RETURNED_ALLIDS (SLAPI_LOG_BACKEND_BASE_1+31)
#define SLAPI_LOG_ERROR_BACKEND_DELETE_RETRY_EXCEEDED (SLAPI_LOG_BACKEND_BASE_1+32)
#define SLAPI_LOG_ERROR_BACKEND_INDEX_MALFORMED_ENTRY (SLAPI_LOG_BACKEND_BASE_1+33)
#define SLAPI_LOG_ERROR_BACKEND_INDEX_NO_INSTANCE_FOR_DEFAULT_USERINDEX_INITIALIZATION (SLAPI_LOG_BACKEND_BASE_1+34)
#define SLAPI_LOG_ERROR_BACKEND_ATTR_ENCR_MALFORMED_ENTRY (SLAPI_LOG_BACKEND_BASE_1+35)
#define SLAPI_LOG_ERROR_BACKEND_MODIFY_RETRY_EXCEEDED (SLAPI_LOG_BACKEND_BASE_1+36)
#define SLAPI_LOG_ERROR_BACKEND_MODRDN_RETRY_EXCEEDED (SLAPI_LOG_BACKEND_BASE_1+37)
#define SLAPI_LOG_ERROR_BACKEND_MODRDN_INDEXATION_FAILED (SLAPI_LOG_BACKEND_BASE_1+38)
#define SLAPI_LOG_ERROR_BACKEND_SEARCH_DB_ERROR (SLAPI_LOG_BACKEND_BASE_1+39)
#define SLAPI_LOG_ERROR_BACKEND_SEARCH_NULL_REFERRAL (SLAPI_LOG_BACKEND_BASE_1+40) 
#define SLAPI_LOG_ERROR_BACKEND_SEARCH_FILTER_BYPASS_FAILURE (SLAPI_LOG_BACKEND_BASE_1+41)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ENTRIES_ADD_FAILURE (SLAPI_LOG_BACKEND_BASE_1+42)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_READ_FAILURE (SLAPI_LOG_BACKEND_BASE_1+43)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_INSTANCEDIR_READ_FAILURE (SLAPI_LOG_BACKEND_BASE_1+44)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_CACHE_TOO_SMALL (SLAPI_LOG_BACKEND_BASE_1+45)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_NEGATIVE_MAXPASSBEFOREMERGE (SLAPI_LOG_BACKEND_BASE_1+46)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_NEGATIVE_NCACHE (SLAPI_LOG_BACKEND_BASE_1+47)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_NEGATIVE_DISKLOWTHRESHOLD (SLAPI_LOG_BACKEND_BASE_1+48)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_NEGATIVE_DISKFULLTHRESHOLD (SLAPI_LOG_BACKEND_BASE_1+49)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_INVALID_DBTRICKLEPERCENTAGE (SLAPI_LOG_BACKEND_BASE_1+50)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ATTR_CANNOT_MODIFY_WHILE_SERVER_RUNNING (SLAPI_LOG_BACKEND_BASE_1+51)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ATTR_NOT_NUMERICAL (SLAPI_LOG_BACKEND_BASE_1+52)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ATTR_TOO_BIG (SLAPI_LOG_BACKEND_BASE_1+53)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ATTR_TOO_SMALL (SLAPI_LOG_BACKEND_BASE_1+54)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ATTR_OUT_OF_RANGE (SLAPI_LOG_BACKEND_BASE_1+55)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ATTR_SET_FAILURE (SLAPI_LOG_BACKEND_BASE_1+56)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_ACCESS_FAILURE (SLAPI_LOG_BACKEND_BASE_1+57) 
#define SLAPI_LOG_ERROR_BACKEND_INSTANCE_ALREADY_EXISTS (SLAPI_LOG_BACKEND_BASE_1+58)
#define SLAPI_LOG_ERROR_BACKEND_INSTANCE_NON_EXISTENT (SLAPI_LOG_BACKEND_BASE_1+59)
#define SLAPI_LOG_ERROR_BACKEND_INSTANCE_BUSY (SLAPI_LOG_BACKEND_BASE_1+60)
#define SLAPI_LOG_ERROR_BACKEND_INSTANCE_MODIFY_SUFFIX_NOT_ALLOWED (SLAPI_LOG_BACKEND_BASE_1+61)
#define SLAPI_LOG_ERROR_BACKEND_PRIORITY_TO_NONE_INDEX_TYPE (SLAPI_LOG_BACKEND_BASE_1+62)
#define SLAPI_LOG_ERROR_BACKEND_INDEX_TYPE_UNKOWN (SLAPI_LOG_BACKEND_BASE_1+63)
#define SLAPI_LOG_ERROR_BACKEND_BAD_INDEX_RULE_OID (SLAPI_LOG_BACKEND_BASE_1+64)
#define SLAPI_LOG_ERROR_BACKEND_INDEX_RULE_UNKNOWN (SLAPI_LOG_BACKEND_BASE_1+65)
#define SLAPI_LOG_WARNING_BACKEND_NEW_DBCACHESIZE_IGNORED_UNTIL_RESTART (SLAPI_LOG_BACKEND_BASE_1+66)
#define SLAPI_LOG_WARNING_BACKEND_NEW_DBNCACHE_IGNORED_UNTIL_RESTART (SLAPI_LOG_BACKEND_BASE_1+67)
#define SLAPI_LOG_ERROR_BACKEND_CONFIG_CACHE_SIZE_INVALID (SLAPI_LOG_BACKEND_BASE_1+68)
#define SLAPI_LOG_ERROR_BACKEND_SEARCH_UNINDEXED (SLAPI_LOG_BACKEND_BASE_1+69)
#define SLAPI_LOG_ERROR_BACKEND_SYSINFO_MISMATCH (SLAPI_LOG_BACKEND_BASE_1+70)
#define SLAPI_LOG_ERROR_BACKEND_SYSINFO_GET (SLAPI_LOG_BACKEND_BASE_1+71)
#define SLAPI_LOG_ERROR_BACKEND_MODRDN_ENTRYID_LOOKUP_FAILED (SLAPI_LOG_BACKEND_BASE_1+72)
#define SLAPI_LOG_ERROR_BACKEND_MODRDN_RESOURCE_LIMIT_FAILURE (SLAPI_LOG_BACKEND_BASE_1+73)


#define SLAPI_LOG_BACKEND_BASE_2			0x5200

#define SLAPI_LOG_ERROR_BACKEND_DISK_LOW		   (SLAPI_LOG_BACKEND_BASE_2+1)
#define SLAPI_LOG_ERROR_BACKEND_DISK_FULL		   (SLAPI_LOG_BACKEND_BASE_2+2)
#define SLAPI_LOG_ERROR_BACKEND_ENTRY_DB_GET		   (SLAPI_LOG_BACKEND_BASE_2+3)
#define SLAPI_LOG_ERROR_BACKEND_ENTRY_PARSE		   (SLAPI_LOG_BACKEND_BASE_2+4)
#define SLAPI_LOG_ERROR_BACKEND_ENTRY_INDEX_INCONSISTENT   (SLAPI_LOG_BACKEND_BASE_2+5)
#define SLAPI_LOG_ERROR_BACKEND_ENTRY_FETCH	           (SLAPI_LOG_BACKEND_BASE_2+6)
#define SLAPI_LOG_ERROR_BACKEND_DN_RETRY_EXCEEDED	   (SLAPI_LOG_BACKEND_BASE_2+7)
#define SLAPI_LOG_ERROR_BACKEND_UNIQUEID_RETRY_EXCEEDED	   (SLAPI_LOG_BACKEND_BASE_2+8)
#define SLAPI_LOG_ERROR_BACKEND_IDL2_VALUE_TOO_BIG	   (SLAPI_LOG_BACKEND_BASE_2+9)
#define SLAPI_LOG_ERROR_BACKEND_IDL2_VALUE_WRONG_SIZE	   (SLAPI_LOG_BACKEND_BASE_2+10)
#define SLAPI_LOG_ERROR_BACKEND_IDL2_INSERT_CANNOT_COUNT   (SLAPI_LOG_BACKEND_BASE_2+11)
#define SLAPI_LOG_ERROR_BACKEND_IDL2_STORE_CANNOT_COUNT    (SLAPI_LOG_BACKEND_BASE_2+12)
#define SLAPI_LOG_ERROR_BACKEND_INDEX_OPEN_FOR_UPDATE      (SLAPI_LOG_BACKEND_BASE_2+13)
#define SLAPI_LOG_ERROR_BACKEND_INDEX_OPEN_FOR_RANGE       (SLAPI_LOG_BACKEND_BASE_2+14)
#define SLAPI_LOG_ERROR_BACKEND_INIT_DATABASE              (SLAPI_LOG_BACKEND_BASE_2+15)
#define SLAPI_LOG_ERROR_BACKEND_INIT_LOCK                  (SLAPI_LOG_BACKEND_BASE_2+16)
#define SLAPI_LOG_ERROR_BACKEND_INIT_CONDVAR               (SLAPI_LOG_BACKEND_BASE_2+17)
#define SLAPI_LOG_ERROR_BACKEND_INIT_PLUGIN                (SLAPI_LOG_BACKEND_BASE_2+18)
#define SLAPI_LOG_ERROR_BACKEND_INSTANCE_INIT_LOCK         (SLAPI_LOG_BACKEND_BASE_2+19)
#define SLAPI_LOG_ERROR_BACKEND_INSTANCE_INIT_CONDVAR      (SLAPI_LOG_BACKEND_BASE_2+20)
#define SLAPI_LOG_ERROR_BACKEND_INSTANCE_STOP_WRONG_STATE  (SLAPI_LOG_BACKEND_BASE_2+21)
#define SLAPI_LOG_ERROR_BACKEND_ANCESTORID_HASH_REMOVE     (SLAPI_LOG_BACKEND_BASE_2+22)
#define SLAPI_LOG_ERROR_BACKEND_ANCESTORID_HASH_ADD        (SLAPI_LOG_BACKEND_BASE_2+23)
#define SLAPI_LOG_ERROR_BACKEND_ANCESTORID_CREATE          (SLAPI_LOG_BACKEND_BASE_2+24)
#define SLAPI_LOG_ERROR_BACKEND_ANCESTORID_PARENTID_CHECK  (SLAPI_LOG_BACKEND_BASE_2+25)
#define SLAPI_LOG_ERROR_BACKEND_CACHE_INIT_LOCK            (SLAPI_LOG_BACKEND_BASE_2+26)
#define SLAPI_LOG_ERROR_BACKEND_CACHE_REMOVE               (SLAPI_LOG_BACKEND_BASE_2+27)
#define SLAPI_LOG_ERROR_BACKEND_CACHE_NOT_EMPTY            (SLAPI_LOG_BACKEND_BASE_2+28)
#define SLAPI_LOG_ERROR_BACKEND_CACHE_SIZE_TOO_SMALL       (SLAPI_LOG_BACKEND_BASE_2+29)
#define SLAPI_LOG_ERROR_BACKEND_CACHE_SIZE_TOO_BIG         (SLAPI_LOG_BACKEND_BASE_2+30)
#define SLAPI_LOG_ERROR_BACKEND_IDL_INCONSISTENT           (SLAPI_LOG_BACKEND_BASE_2+31)
#define SLAPI_LOG_ERROR_BACKEND_MALLOC_FAIL		           (SLAPI_LOG_BACKEND_BASE_2+32)
#define SLAPI_LOG_ERROR_BACKEND_INVALID_PATH		       (SLAPI_LOG_BACKEND_BASE_2+33)
#define SLAPI_LOG_ERROR_BACKEND_INVALID_FILENAME	       (SLAPI_LOG_BACKEND_BASE_2+34)

#define SLAPI_LOG_BACKEND_ENCRYPTION_BASE			0x5300

#define SLAPI_LOG_ERROR_BACKEND_ENCRYPTION_FAILURE     	   (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+1)
#define SLAPI_LOG_ERROR_BACKEND_DECRYPTION_FAILURE     	   (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+2)
#define SLAPI_LOG_ERROR_BACKEND_ENCRYPTION_ALGORITHM_CONFLICT    (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+3)
#define SLAPI_LOG_ERROR_BACKEND_ENCRYPTION_ALGORITHM_UNKNOWN     (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+4)
#define SLAPI_LOG_ERROR_BACKEND_INDEXKEY_ENCRYPTION_FAILURE      (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+5)
#define SLAPI_LOG_ERROR_BACKEND_ATTRIBUTE_ENCRYPTION_FAILURE     (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+6)
#define SLAPI_LOG_ERROR_BACKEND_ENCRYPTION_PLUGIN_ENCRYPTION_FAILURE (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+7)
#define SLAPI_LOG_ERROR_BACKEND_ENCRYPTION_PLUGIN_DECRYPTION_FAILURE (SLAPI_LOG_BACKEND_ENCRYPTION_BASE+8)


/* Bulk Import range numbers */
#define SLAPI_BULK_IMPORT_BASE                              0x6000
#define SLAPI_LOG_ERROR_BULK_IMPORT_PROCESS_OP_FAILED          (SLAPI_BULK_IMPORT_BASE +1)

/* Filter SP range numbers */
#define SLAPI_LOG_FILTER_SP_BASE			0x7000
#define SLAPI_LOG_ERROR_FILTER_SP_CANT_UPDATE_CKS	   (SLAPI_LOG_FILTER_SP_BASE+1)

/* Roles plugin range number */
#define SLAPI_LOG_ROLE_BASE         0x8000
#define SLAPI_LOG_ERROR_ROLE_REGISTER_TO_SP             (SLAPI_LOG_ROLE_BASE+1)
#define SLAPI_LOG_ERROR_ROLE_REGISTER_VATTR_TO_SP       (SLAPI_LOG_ROLE_BASE+2)
#define SLAPI_LOG_ERROR_ROLE_NO_MEMORY_FOR_CACHE        (SLAPI_LOG_ROLE_BASE+3)
#define SLAPI_LOG_ERROR_ROLE_CANNOT_CREATE_LOCK         (SLAPI_LOG_ROLE_BASE+4)
#define SLAPI_LOG_ERROR_ROLE_CANNOT_CREATE_COND_VAR     (SLAPI_LOG_ROLE_BASE+5)
#define SLAPI_LOG_ERROR_ROLE_CANNOT_CREATE_THREAD       (SLAPI_LOG_ROLE_BASE+6)
#define SLAPI_LOG_ERROR_ROLE_MISSING_OBJECTCLASS        (SLAPI_LOG_ROLE_BASE+7)
#define SLAPI_LOG_ERROR_ROLE_BAD_OPERATION              (SLAPI_LOG_ROLE_BASE+8)
#define SLAPI_LOG_ERROR_ROLE_MAX_NESTING_EXEEDED        (SLAPI_LOG_ROLE_BASE+9)
#define SLAPI_LOG_ERROR_ROLE_MAX_NESTING_EXEEDED_2      (SLAPI_LOG_ROLE_BASE+10)
#define SLAPI_LOG_ERROR_ROLE_MISSING_ENTRY              (SLAPI_LOG_ROLE_BASE+11)
#define SLAPI_LOG_ERROR_ROLE_INIT_FAILED                (SLAPI_LOG_ROLE_BASE+12)
#define SLAPI_LOG_ERROR_ROLE_UNKNOWN_ROLE_TYPE          (SLAPI_LOG_ROLE_BASE+13)

/* Attribute Uniqueness plugin, single and multiple server version */
#define SLAPI_LOG_UID_BASE    0x8100
#define SLAPI_LOG_FAILURE_UID_PBLOCK (SLAPI_LOG_UID_BASE+1)
#define SLAPI_LOG_FAILURE_UID_PBGET  (SLAPI_LOG_UID_BASE+2)
#define SLAPI_LOG_FAILURE_UID_PBSRC  (SLAPI_LOG_UID_BASE+3)
#define SLAPI_LOG_FAILURE_UID_PBGET2 (SLAPI_LOG_UID_BASE+4)
#define SLAPI_LOG_FAILURE_UID_ARGC   (SLAPI_LOG_UID_BASE+5)
#define SLAPI_LOG_FAILURE_UID_ARGV   (SLAPI_LOG_UID_BASE+6)
#define SLAPI_LOG_FAILURE_UID_ARGS   (SLAPI_LOG_UID_BASE+7)
#define SLAPI_LOG_FAILURE_UID_REPL   (SLAPI_LOG_UID_BASE+8)
#define SLAPI_LOG_FAILURE_UID_GETDN  (SLAPI_LOG_UID_BASE+9)
#define SLAPI_LOG_FAILURE_UID_ENTRY  (SLAPI_LOG_UID_BASE+10)
#define SLAPI_LOG_FAILURE_UID_MODS   (SLAPI_LOG_UID_BASE+11)
#define SLAPI_LOG_FAILURE_UID_BVALS  (SLAPI_LOG_UID_BASE+12)
#define SLAPI_LOG_FAILURE_UID_DNSUP  (SLAPI_LOG_UID_BASE+13)
#define SLAPI_LOG_FAILURE_UID_NEWDN  (SLAPI_LOG_UID_BASE+14)
#define SLAPI_LOG_FAILURE_UID_ALLOC  (SLAPI_LOG_UID_BASE+15)
#define SLAPI_LOG_FAILURE_UID_UNTAG  (SLAPI_LOG_UID_BASE+16)
#define SLAPI_LOG_FAILURE_UID_ADD    (SLAPI_LOG_UID_BASE+17)
#define SLAPI_LOG_FAILURE_UID_MOD    (SLAPI_LOG_UID_BASE+18)
#define SLAPI_LOG_FAILURE_UID_MODN   (SLAPI_LOG_UID_BASE+19)
#define SLAPI_LOG_FAILURE_UID_MODN2  (SLAPI_LOG_UID_BASE+20)
#define SLAPI_LOG_FAILURE_UID_INIT   (SLAPI_LOG_UID_BASE+21)

#define SLAPI_LOG_FAILURE_UID_MMINI  (SLAPI_LOG_UID_BASE+22)
#define SLAPI_LOG_FAILURE_UID_MMNULL (SLAPI_LOG_UID_BASE+23)
#define SLAPI_LOG_FAILURE_UID_MMNARQ (SLAPI_LOG_UID_BASE+24)
#define SLAPI_LOG_FAILURE_UID_MMLSID (SLAPI_LOG_UID_BASE+25)
#define SLAPI_LOG_FAILURE_UID_MMPCHG (SLAPI_LOG_UID_BASE+26)
#define SLAPI_LOG_FAILURE_UID_MMPSLP (SLAPI_LOG_UID_BASE+27)
#define SLAPI_LOG_FAILURE_UID_MMLURL (SLAPI_LOG_UID_BASE+28)
#define SLAPI_LOG_FAILURE_UID_MMENAM (SLAPI_LOG_UID_BASE+29)
#define SLAPI_LOG_FAILURE_UID_MMSHA1 (SLAPI_LOG_UID_BASE+30)
#define SLAPI_LOG_FAILURE_UID_MMSEND (SLAPI_LOG_UID_BASE+32)
#define SLAPI_LOG_FAILURE_UID_MMBIND (SLAPI_LOG_UID_BASE+33)
#define SLAPI_LOG_FAILURE_UID_MMVDBL (SLAPI_LOG_UID_BASE+34)
#define SLAPI_LOG_FAILURE_UID_MMPOST (SLAPI_LOG_UID_BASE+35)
#define SLAPI_LOG_FAILURE_UID_MMPREG (SLAPI_LOG_UID_BASE+36)
#define SLAPI_LOG_FAILURE_UID_MMEREG (SLAPI_LOG_UID_BASE+37)
#define SLAPI_LOG_FAILURE_UID_MMENEW (SLAPI_LOG_UID_BASE+38)
#define SLAPI_LOG_FAILURE_UID_MMCONF (SLAPI_LOG_UID_BASE+39)
#define SLAPI_LOG_FAILURE_UID_MMVDUP (SLAPI_LOG_UID_BASE+40)
#define SLAPI_LOG_FAILURE_UID_MMSRCH (SLAPI_LOG_UID_BASE+41)
#define SLAPI_LOG_FAILURE_UID_MMNOAT (SLAPI_LOG_UID_BASE+42)
#define SLAPI_LOG_FAILURE_UID_MMDBOP (SLAPI_LOG_UID_BASE+43)
#define SLAPI_LOG_FAILURE_UID_MMBERR (SLAPI_LOG_UID_BASE+44)
#define SLAPI_LOG_FAILURE_UID_MMHALF (SLAPI_LOG_UID_BASE+45)
#define SLAPI_LOG_FAILURE_UID_MMDBLD (SLAPI_LOG_UID_BASE+46)
#define SLAPI_LOG_FAILURE_UID_MMSUFF (SLAPI_LOG_UID_BASE+47)
#define SLAPI_LOG_FAILURE_UID_MMUNSP (SLAPI_LOG_UID_BASE+48)
#define SLAPI_LOG_FAILURE_UID_MMSIDM (SLAPI_LOG_UID_BASE+49)
#define SLAPI_LOG_FAILURE_UID_MMPCNF (SLAPI_LOG_UID_BASE+50)
#define SLAPI_LOG_FAILURE_UID_MMSECU (SLAPI_LOG_UID_BASE+51)
#define SLAPI_LOG_FAILURE_UID_MMCRAT (SLAPI_LOG_UID_BASE+52)
#define SLAPI_LOG_ERROR_7BITS (SLAPI_LOG_UID_BASE+53)
#define SLAPI_LOG_FAILURE_UID_INVALID_ARG	(SLAPI_LOG_UID_BASE+54)
#define SLAPI_LOG_FAILURE_UID_DIFFERENT_SYNTAX	(SLAPI_LOG_UID_BASE+55)
#define SLAPI_LOG_FAILURE_UID_INVALID_ARGS	(SLAPI_LOG_UID_BASE+56)


/* COS plugin range number */
#define SLAPI_LOG_COS_BASE         0x8400
#define SLAPI_LOG_ERROR_COS_MUTEX_FAIL             	(SLAPI_LOG_COS_BASE+1)
#define SLAPI_LOG_ERROR_COS_REGISTER_TO_SP_FAIL    	(SLAPI_LOG_COS_BASE+2)
#define SLAPI_LOG_ERROR_COS_CREATE_THREAD_FAIL    	(SLAPI_LOG_COS_BASE+3)
#define SLAPI_LOG_ERROR_COS_SCHEMA_CACHE_FAIL		(SLAPI_LOG_COS_BASE+4)
#define SLAPI_LOG_ERROR_COS_INDEX_CACHE_FAIL		(SLAPI_LOG_COS_BASE+5)
#define SLAPI_LOG_ERROR_COS_MALLOC_FAIL				(SLAPI_LOG_COS_BASE+6)
#define SLAPI_LOG_ERROR_COS_SUFFIX_LIST_FAIL		(SLAPI_LOG_COS_BASE+7)
#define SLAPI_LOG_WARNING_COS_NO_TEMPLATES_FOUND_FOR_DEF	(SLAPI_LOG_COS_BASE+8)
#define SLAPI_LOG_ERROR_COS_CONFIG_DEF_ERROR		(SLAPI_LOG_COS_BASE+9)
#define SLAPI_LOG_ERROR_COS_FAILED_TO_ADD_TEMPLATE	(SLAPI_LOG_COS_BASE+10)
#define SLAPI_LOG_ERROR_COS_FAILED_TO_GET_TARGET_DN	(SLAPI_LOG_COS_BASE+11)
#define SLAPI_LOG_ERROR_COS_FAILED_TO_GET_OBJECTCLASS	(SLAPI_LOG_COS_BASE+12)
#define SLAPI_LOG_WARNING_COS_TARGET_ENTRY_IS_NULL	(SLAPI_LOG_COS_BASE+13)
#define SLAPI_LOG_ERROR_COS_FAILED_TO_START				(SLAPI_LOG_COS_BASE+14)
#define SLAPI_LOG_ERROR_COS_FAILED_TO_REGISTER_PLUGIN	(SLAPI_LOG_COS_BASE+15)
#define SLAPI_LOG_ERROR_COS_CONFIG_DEF_ERROR_NO_DN		(SLAPI_LOG_COS_BASE+16)
#define SLAPI_LOG_ERROR_COS_FAILED_TO_GET_TARGET_DN_CHANGED_ENTRY		(SLAPI_LOG_COS_BASE+17)
#define SLAPI_LOG_WARNING_COS_FAILED_TO_INDEX_CLASSIC_SCHEME		(SLAPI_LOG_COS_BASE+18)
#define SLAPI_LOG_WARNING_COS_FAILED_TO_GET_SYNTAX_PLUGIN		(SLAPI_LOG_COS_BASE+19)
#define SLAPI_LOG_WARNING_COS_FAILED_TO_CREATE_KEY	(SLAPI_LOG_COS_BASE+20)
#define SLAPI_LOG_WARNING_COS_FAILED_TO_USE_CLASSIC_HASH (SLAPI_LOG_COS_BASE+21)
#define SLAPI_LOG_WARNING_COS_COMPETING_DEFINITIONS (SLAPI_LOG_COS_BASE+22)
#define SLAPI_LOG_WARNING_COS_COMPETING_DEFINITIONS_AND_TMPL (SLAPI_LOG_COS_BASE+23)

/* LDAP Extended Operations */
#define SLAPI_LOG_EXTENSIONS_BASE		0x8600
#define SLAPI_LOG_ERROR_EXTENDED_SETOID    (SLAPI_LOG_EXTENSIONS_BASE +1)
#define SLAPI_LOG_ERROR_WHOAMI_INIT        (SLAPI_LOG_EXTENSIONS_BASE +2)
#define SLAPI_LOG_ERROR_WHOAMI_OIDMISMATCH (SLAPI_LOG_EXTENSIONS_BASE +3)
#define SLAPI_LOG_ERROR_WHOAMI_PROXYAUTH_NOTCRITICAL (SLAPI_LOG_EXTENSIONS_BASE+4)
#define SLAPI_LOG_ERROR_WHOAMI_PROXYAUTH_DECODE (SLAPI_LOG_EXTENSIONS_BASE+5)

/* ACL plugin range number */
#define SLAPI_LOG_ACL_BASE         0x8800
#define SLAPI_LOG_ERROR_ACL_INIT_FAIL             (SLAPI_LOG_ACL_BASE+1)
#define SLAPI_LOG_ERROR_ACL_INIT_MUTEX_FAIL             (SLAPI_LOG_ACL_BASE+2)
#define SLAPI_LOG_ERROR_ACL_MALLOC_FAIL             (SLAPI_LOG_ACL_BASE+3)
#define SLAPI_LOG_ERROR_ACL_INTERNAL_ERROR          (SLAPI_LOG_ACL_BASE+4)
#define SLAPI_LOG_WARNING_ACL_IGNORING_ACI          (SLAPI_LOG_ACL_BASE+5)
#define SLAPI_LOG_ERROR_ACL_ACLLIST_FAIL			(SLAPI_LOG_ACL_BASE+6)
#define SLAPI_LOG_ERROR_ACL_ACIS_NOT_DELETED			(SLAPI_LOG_ACL_BASE+7)
#define SLAPI_LOG_ERROR_ACL_INTERNAL_INIT_FAIL		(SLAPI_LOG_ACL_BASE+8)
#define SLAPI_LOG_WARNING_ACL_DBRETRY_STOPPING_ACLLIST_EVAL (SLAPI_LOG_ACL_BASE+9)
#define SLAPI_LOG_ERROR_ACL_ACI_UPDATE_FAIL             (SLAPI_LOG_ACL_BASE+10)
#define SLAPI_LOG_ERROR_ACL_MACRO_PARSING_FAIL             (SLAPI_LOG_ACL_BASE+11)
#define SLAPI_LOG_ERROR_ACL_ACI_FILTER_PARSING_FAIL      (SLAPI_LOG_ACL_BASE+12)
#define SLAPI_LOG_ERROR_ACL_ACI_PARSING_FAIL           (SLAPI_LOG_ACL_BASE+13)
#define SLAPI_LOG_ERROR_ACL_UPDATE_FAIL_WITH_DN      (SLAPI_LOG_ACL_BASE+14)
#define SLAPI_LOG_ERROR_ACL_RUNTIME_MUTEX_FAIL      (SLAPI_LOG_ACL_BASE+15)
#define SLAPI_LOG_ERROR_ACL_OPEXT_INIT_FAIL      (SLAPI_LOG_ACL_BASE+16)
#define SLAPI_LOG_ERROR_ACL_ACLCB_LOCK_RELEASED      (SLAPI_LOG_ACL_BASE+17)
#define SLAPI_LOG_ERROR_ACL_INVALID_ACLPB_TYPE      (SLAPI_LOG_ACL_BASE+18)
#define SLAPI_LOG_ERROR_ACL_INTERNAL_ACLPB_ERROR      (SLAPI_LOG_ACL_BASE+19)
#define SLAPI_LOG_WARNING_ACL_DONT_SUPPORT_IPV6_CLIENTS      (SLAPI_LOG_ACL_BASE+20)
#define SLAPI_LOG_WARNING_ACL_SYNTAX_ERROR_WITH_STRING      (SLAPI_LOG_ACL_BASE+21)
#define SLAPI_LOG_ERROR_USERATTR_PARENT_LEVELS_ERROR     (SLAPI_LOG_ACL_BASE+22)
#define SLAPI_LOG_WARNING_ACL_DBRETRY_STOPPING_USERATTR_EVAL_LEVELS (SLAPI_LOG_ACL_BASE+23)
#define SLAPI_LOG_WARNING_ACL_DBRETRY_STOPPING_GROUP_EVAL (SLAPI_LOG_ACL_BASE+24)
#define SLAPI_LOG_WARNING_ACL_DBRETRY_STOPPING_EVAL_STRING (SLAPI_LOG_ACL_BASE+25)
#define SLAPI_LOG_ERROR_ACL_NO_ACCESS_TO_CONTROL	(SLAPI_LOG_ACL_BASE+26)
#define SLAPI_LOG_ERROR_ACLRIGHTS_INTERNAL_ACLPB_ERROR      (SLAPI_LOG_ACL_BASE+27)
#define SLAPI_LOG_ERROR_ACLRIGHTS_PARSING_CONTROL_ERROR      (SLAPI_LOG_ACL_BASE+28)
#define SLAPI_LOG_WARNING_ACL_NO_ACCESS_TO_ACRIGHTS_ATTRIBUTE (SLAPI_LOG_ACL_BASE+29)
#define SLAPI_LOG_ERROR_ACL_REFERENTIAL_INTEGRITY_ERROR	(SLAPI_LOG_ACL_BASE+30)

/* Collation plugin range number */
#define SLAPI_LOG_COLLATION_BASE	0x9000
#define SLAPI_LOG_ERROR_COLLATION_LOCK_RELEASE	(SLAPI_LOG_COLLATION_BASE+1)
#define SLAPI_LOG_ERROR_COLLATION_LOCK_CREATE	(SLAPI_LOG_COLLATION_BASE+2)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_NLS	(SLAPI_LOG_COLLATION_BASE+3)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_COLLATION	(SLAPI_LOG_COLLATION_BASE+4)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_COLLATION_STRENGTH	(SLAPI_LOG_COLLATION_BASE+5)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_COLLATION_DECOMPOSITION	(SLAPI_LOG_COLLATION_BASE+6)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_TOKENS	(SLAPI_LOG_COLLATION_BASE+7)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_FILE	(SLAPI_LOG_COLLATION_BASE+8)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_LINE	(SLAPI_LOG_COLLATION_BASE+9)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_PATH	(SLAPI_LOG_COLLATION_BASE+10)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_DN		(SLAPI_LOG_COLLATION_BASE+11)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_ENTRY	(SLAPI_LOG_COLLATION_BASE+12)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_ATTR	(SLAPI_LOG_COLLATION_BASE+13)
#define SLAPI_LOG_ERROR_COLLATION_CONFIG_VALUE	(SLAPI_LOG_COLLATION_BASE+14)


/* Syntax plugin range number */
#define SLAPI_LOG_SYNTAX_BASE	0x9100
#define SLAPI_LOG_ERROR_SYNTAX_REGEX_TOO_LONG	(SLAPI_LOG_SYNTAX_BASE+1)
#define SLAPI_LOG_ERROR_SYNTAX_REGEX_COMPILE	(SLAPI_LOG_SYNTAX_BASE+2)
#define SLAPI_LOG_ERROR_SYNTAX_FILTER_TYPE	(SLAPI_LOG_SYNTAX_BASE+3)


/* State change plugin range number */
#define SLAPI_LOG_STATECHANGE_BASE	0x9200
#define SLAPI_LOG_ERROR_STATECHANGE_REGISTER	(SLAPI_LOG_STATECHANGE_BASE+1)
#define SLAPI_LOG_ERROR_STATECHANGE_LOCK_CREATE	(SLAPI_LOG_STATECHANGE_BASE+2)
#define SLAPI_LOG_ERROR_STATECHANGE_PUBLISH_INTERFACE	(SLAPI_LOG_STATECHANGE_BASE+3)
#define SLAPI_LOG_ERROR_STATECHANGE_GET_DN	(SLAPI_LOG_STATECHANGE_BASE+4)


/* Passthru auth plugin range number */
#define SLAPI_LOG_PASSTHRU_BASE	0x9300
#define SLAPI_LOG_ERROR_PASSTHRU_MULTIPLE_INIT	(SLAPI_LOG_PASSTHRU_BASE+1)
#define SLAPI_LOG_ERROR_PASSTHRU_NO_REMOTE_SERVERS	(SLAPI_LOG_PASSTHRU_BASE+2)
#define SLAPI_LOG_ERROR_PASSTHRU_REMOTE_CONFIG	(SLAPI_LOG_PASSTHRU_BASE+3)
#define SLAPI_LOG_ERROR_PASSTHRU_BAD_LDAP_VERSION	(SLAPI_LOG_PASSTHRU_BASE+4)
#define SLAPI_LOG_ERROR_PASSTHRU_BAD_MAX_CONNS	(SLAPI_LOG_PASSTHRU_BASE+5)
#define SLAPI_LOG_ERROR_PASSTHRU_BAD_MAX_CONCURRENCY	(SLAPI_LOG_PASSTHRU_BASE+6)
#define SLAPI_LOG_ERROR_PASSTHRU_BAD_URL	(SLAPI_LOG_PASSTHRU_BASE+7)
#define SLAPI_LOG_ERROR_PASSTHRU_NO_SUFFIX_IN_URL	(SLAPI_LOG_PASSTHRU_BASE+8)
#define SLAPI_LOG_ERROR_PASSTHRU_SPLITTING_SUFFIXES	(SLAPI_LOG_PASSTHRU_BASE+9)
#define SLAPI_LOG_ERROR_PASSTHRU_LOCAL_SUFFIX	(SLAPI_LOG_PASSTHRU_BASE+10)
#define SLAPI_LOG_ERROR_PASSTHRU_VERBOSE_SUFFIX_LIST	(SLAPI_LOG_PASSTHRU_BASE+11)
#define SLAPI_LOG_ERROR_PASSTHRU_LOCAL_SUFFIX_LIST	(SLAPI_LOG_PASSTHRU_BASE+12)
#define SLAPI_LOG_ERROR_PASSTHRU_NO_ACTIVE_LOCAL_SUFFIXES	(SLAPI_LOG_PASSTHRU_BASE+13)
#define SLAPI_LOG_ERROR_PASSTHRU_INIT_FAILED	(SLAPI_LOG_PASSTHRU_BASE+14)
#define SLAPI_LOG_ERROR_PASSTHRU_BIND_PREOP_GET_ARGS	(SLAPI_LOG_PASSTHRU_BASE+15)
#define SLAPI_LOG_ERROR_PASSTHRU_BIND_PREOP_CONFIG	(SLAPI_LOG_PASSTHRU_BASE+16)
#define SLAPI_LOG_ERROR_PASSTHRU_BIND_ARGS	(SLAPI_LOG_PASSTHRU_BASE+17)
#define SLAPI_LOG_ERROR_PASSTHRU_BIND_CONTROLS	(SLAPI_LOG_PASSTHRU_BASE+18)
#define SLAPI_LOG_ERROR_PASSTHRU_BIND_SET_CONN_INFO	(SLAPI_LOG_PASSTHRU_BASE+19)


/* Referential integrity plugin range number */
#define SLAPI_LOG_REFERINT_BASE	0x9400
#define SLAPI_LOG_ERROR_REFERINT_INIT_FAILED	(SLAPI_LOG_REFERINT_BASE+1)
#define SLAPI_LOG_ERROR_REFERINT_GET_DELETE_ARGS	(SLAPI_LOG_REFERINT_BASE+2)
#define SLAPI_LOG_ERROR_REFERINT_DELETE_GET_PLUGIN_ARGC	(SLAPI_LOG_REFERINT_BASE+3)
#define SLAPI_LOG_ERROR_REFERINT_DELETE_GET_PLUGIN_ARGV	(SLAPI_LOG_REFERINT_BASE+4)
#define SLAPI_LOG_ERROR_REFERINT_DELETE_NO_ARGV	(SLAPI_LOG_REFERINT_BASE+5)
#define SLAPI_LOG_ERROR_REFERINT_DELETE_INSUFFICIENT_ARGV	(SLAPI_LOG_REFERINT_BASE+6)
#define SLAPI_LOG_ERROR_REFERINT_GET_MODRDN_ARGS	(SLAPI_LOG_REFERINT_BASE+7)
#define SLAPI_LOG_ERROR_REFERINT_MODRDN_GET_PLUGIN_ARGC	(SLAPI_LOG_REFERINT_BASE+8)
#define SLAPI_LOG_ERROR_REFERINT_MODRDN_GET_PLUGIN_ARGV	(SLAPI_LOG_REFERINT_BASE+9)
#define SLAPI_LOG_ERROR_REFERINT_MODRDN_NO_ARGV	(SLAPI_LOG_REFERINT_BASE+10)
#define SLAPI_LOG_ERROR_REFERINT_MODRDN_INSUFFICIENT_ARGV	(SLAPI_LOG_REFERINT_BASE+11)
#define SLAPI_LOG_ERROR_REFERINT_UPDATE_INTEGRITY_GET_PLUGIN_ARGV	(SLAPI_LOG_REFERINT_BASE+12)
#define SLAPI_LOG_ERROR_REFERINT_UPDATE_INTEGRITY_SEARCH_FAILED	(SLAPI_LOG_REFERINT_BASE+13)
#define SLAPI_LOG_ERROR_REFERINT_POSTOP_START_GET_PLUGIN_ARGC	(SLAPI_LOG_REFERINT_BASE+14)
#define SLAPI_LOG_ERROR_REFERINT_POSTOP_START_GET_PLUGIN_ARGV	(SLAPI_LOG_REFERINT_BASE+15)
#define SLAPI_LOG_ERROR_REFERINT_POSTOP_START_NO_ARGV	(SLAPI_LOG_REFERINT_BASE+16)
#define SLAPI_LOG_ERROR_REFERINT_CREATE_THREAD	(SLAPI_LOG_REFERINT_BASE+17)
#define SLAPI_LOG_ERROR_REFERINT_POSTOP_START_INSUFFICIENT_ARGV	(SLAPI_LOG_REFERINT_BASE+18)
#define SLAPI_LOG_ERROR_REFERINT_REFERINT_FUNC_GET_ARGV	(SLAPI_LOG_REFERINT_BASE+19)
#define SLAPI_LOG_ERROR_REFERINT_DELETE_LOG	(SLAPI_LOG_REFERINT_BASE+20)
#define SLAPI_LOG_ERROR_REFERINT_OPEN_LOG	(SLAPI_LOG_REFERINT_BASE+21)
#define SLAPI_LOG_ERROR_REFERINT_LOG_LINE_LENGTH	(SLAPI_LOG_REFERINT_BASE+22)
#define SLAPI_LOG_ERROR_REFERINT_WRITE_LOG	(SLAPI_LOG_REFERINT_BASE+23)
#define SLAPI_LOG_ERROR_REFERINT_CLOSE_LOG	(SLAPI_LOG_REFERINT_BASE+24)
#define SLAPI_LOG_WARNING_REFERINT_UNINDEXED_ATTR     (SLAPI_LOG_REFERINT_BASE+25)

#define SLAPI_LOG_ID_MAPPING_BASE 0x9600
#define SLAPI_LOG_ERROR_ID_MAPPING_COMPILE_REGERROR             (SLAPI_LOG_ID_MAPPING_BASE+1)
#define SLAPI_LOG_ERROR_ID_MAPPING_CONFIGURATION_ERROR          (SLAPI_LOG_ID_MAPPING_BASE+2)
#define SLAPI_LOG_ERROR_ID_MAPPING_SYNTAX_ERROR                 (SLAPI_LOG_ID_MAPPING_BASE+3)
#define SLAPI_LOG_ERROR_ID_MAPPING_CONFIGURATION_MISSING        (SLAPI_LOG_ID_MAPPING_BASE+4)
#define SLAPI_LOG_ERROR_ID_MAPPING_PROTOCOL_NAME_MISSING        (SLAPI_LOG_ID_MAPPING_BASE+5)
#define SLAPI_LOG_ERROR_ID_MAPPING_SUPPORTED_PROTOCOL_MISSING   (SLAPI_LOG_ID_MAPPING_BASE+6)
#define SLAPI_LOG_ERROR_ID_MAPPING_NO_MAPPING                   (SLAPI_LOG_ID_MAPPING_BASE+7)
#define SLAPI_LOG_ERROR_ID_MAPPING_NO_VALID_MAPPING             (SLAPI_LOG_ID_MAPPING_BASE+8)
#define SLAPI_LOG_ERROR_ID_MAPPING_UNSUPPORTED_PROTOCOL         (SLAPI_LOG_ID_MAPPING_BASE+9)
#define SLAPI_LOG_ERROR_ID_MAPPING_ADD_CONFIG_ENTRY_FAILED      (SLAPI_LOG_ID_MAPPING_BASE+10)

#define SLAPI_LOG_SASL_BASE 0x9800
#define SLAPI_LOG_ERROR_SASL_CONFIG_MISSING		(SLAPI_LOG_SASL_BASE+1)
#define SLAPI_LOG_ERROR_SASL_MEM_ALLOC_FAILED		(SLAPI_LOG_SASL_BASE+2)
#define SLAPI_LOG_ERROR_SASL_PLUGINS_PATH_MISSING	(SLAPI_LOG_SASL_BASE+3)
#define SLAPI_LOG_ERROR_SASL_PLUGINS_ENABLE_MISSING	(SLAPI_LOG_SASL_BASE+4)
#define SLAPI_LOG_ERROR_SASL_LOCALHOST_MISSING		(SLAPI_LOG_SASL_BASE+5)
#define SLAPI_LOG_ERROR_SASL_INIT_FAILED		(SLAPI_LOG_SASL_BASE+6)

#define SLAPI_LOG_CSN_BASE 0x9850
#define SLAPI_LOG_ERROR_CSN_WRONG_SEQUENCE (SLAPI_LOG_CSN_BASE+1)
#define SLAPI_LOG_ERROR_CSN_TIME_DIFFERENCE (SLAPI_LOG_CSN_BASE+2)

/* 0x9700 - 0x97FF RESERVED FOR WPS PLUGIN */
#define SLAPI_LOG_WPS_BASE 0x9700

/* 0x9900 - 0x99FF RESERVED FOR AUTO-UPGRADE */
#define SLAPI_LOG_UPGRADE_BASE 0x9900
#define SLAPI_LOG_WARNING_UPGRADE_ENCRYPTION_ENTRY	(SLAPI_LOG_UPGRADE_BASE+1)
#define SLAPI_LOG_ERROR_UPGRADE_PHASE1_FAILED		(SLAPI_LOG_UPGRADE_BASE+2)
#define SLAPI_LOG_ERROR_UPGRADE_PHASE2_FAILED		(SLAPI_LOG_UPGRADE_BASE+3)
#define SLAPI_LOG_ERROR_UPGRADE_SCRIPT_FAILURE		(SLAPI_LOG_UPGRADE_BASE+4)

/* ... to be continued */

#endif

