/*
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * Use of this product is subject to license terms.
 */
/************************************************************

 hello.c

 This source file provides an example of a minimal server plug-in.

 TRYING THIS PLUG-IN
 -------------------
 1. Build the library containing the plug-in.
 
 2. Configure the server to load the plug-in and log the message.
 
    Set the nsslapd-infolog-area attribute on the configuration entry,
    dn: cn=config, to turn on logging of information messages from
    plug-ins. The value is that of SLAPI_LOG_INFO_AREA_PLUGIN in
    slapi-plugin.h. One way of doing this:

    $ ldapmodify -p <port> -D "cn=directory manager" -w <password>
    dn: cn=config
    changetype: modify
    replace: nsslapd-infolog-area
    nsslapd-infolog-area: 65536

    Create a file containing the following entry, named hello.ldif,
    replacing the value of nsslapd-pluginPath with the path
    appropriate for your installation:

dn: cn=Hello World,cn=plugins,cn=config
objectClass: top
objectClass: nsSlapdPlugin
objectClass: extensibleObject
cn: Hello World
nsslapd-pluginPath: <ServerRoot>/plugins/slapd/slapi/examples/<LibName>
nsslapd-pluginInitfunc: hello_init
nsslapd-pluginType: object
nsslapd-pluginId: Hello, World
nsslapd-pluginEnabled: on
nsslapd-pluginVersion: 5.2
nsslapd-pluginVendor: Sun Microsystems, Inc.
nsslapd-pluginDescription: My first plug-in

    Add the configuration entry to the directory. For example:

    $ ldapmodify -a -p <port> -D "cn=directory manager" -w <password> -f hello.ldif
 
 3. Restart the server.

 4. Search <server_root>/slapd-<server_id>/logs/errors for Hello, World!

************************************************************/
#include "slapi-plugin.h"

Slapi_PluginDesc desc = { 
    "Hello, World",                    /* plug-in identifier      */
    "Sun Microsystems, Inc.",          /* vendor name             */
    "5.2",                             /* plug-in revision number */
    "My first plug-in"                 /* plug-in description     */
};

/* Log a greeting at server startup if info logging is on for plug-ins */
int
hello()
{
    slapi_log_info_ex(
        SLAPI_LOG_INFO_AREA_PLUGIN,    /* Log if info logging is  */
        SLAPI_LOG_INFO_LEVEL_DEFAULT,  /* set for plug-ins.       */
        SLAPI_LOG_NO_MSGID,            /* No client at startup    */
        SLAPI_LOG_NO_CONNID,           /* No conn.  at startup    */
        SLAPI_LOG_NO_OPID,             /* No op.    at startup    */
        "hello() in My first plug-in", /* Origin of this message  */
        "Hello, World!\n"              /* Informational message   */
    );
    return 0;
}

/* Register the plug-in with the server */
#ifdef _WIN32
__declspec(dllexport)
#endif
int
hello_init(Slapi_PBlock * pb)
{
    int rc = 0;                        /* 0 means success         */
    rc |= slapi_pblock_set(            /* Plug-in API version     */
        pb,
        SLAPI_PLUGIN_VERSION,
        SLAPI_PLUGIN_CURRENT_VERSION
    );
    rc |= slapi_pblock_set(            /* Plug-in description     */
        pb,
        SLAPI_PLUGIN_DESCRIPTION,
        (void *) &desc
    );
    rc |= slapi_pblock_set(            /* Startup function        */
        pb,
        SLAPI_PLUGIN_START_FN,
        (void *) hello
    );
    return rc;
}
