/**
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * Patents Pending.Use is subject to license terms.
 */
/**
 * PROPRIETARY/CONFIDENTIAL. Use of this product is subject to
 * license terms. Copyright 2001 Sun Microsystems, Inc.
 * Some preexisting portions Copyright 2001 Netscape Communications Corp.
 * All rights reserved.
 */
/*
 * Microsoft Windows specifics for sample plug-ins DLL
 */
#include "ldap.h"
#include "lber.h"

#ifdef _WIN32
BOOL WINAPI DllMain (HANDLE hHandle, DWORD fdwEven, LPVOID lpWinPrivate)
{
  WSADATA wsadata;
  
  switch (fdwEven)
    {
    case DLL_PROCESS_ATTACH:
      /*   Return TRUE = keep the library loaded. 
	   Return FALSE = fail to load the library. 
	   
	   For each process that loads the DLL, your library will be 
	   called with DLL_PROCESS_ATTACH, instead of once in your 
	   original LibMain during the DLL loading. 
	   Static allocated data, shared data and one time init will 
	   need special management here. Even in 16 bit mode the 
	   system may apply this behavior by default. It is recommended 
	   that you make these changes in your LibMain. 

	   As the concept of segments no longer exists in 32 bit mode, 
	   all segment calls such as UnlockData() (16 bit only), 
	   UnlockSegment() and GlobalUnfix() should not exist here.
      */

      if( errno = WSAStartup(0x0101, &wsadata ) != 0 )
	return FALSE;
      
      break;

    case DLL_THREAD_ATTACH:
      /* Called on thread creation in processes that have loaded the 
	 library. Not called if the thread existed before the process 
	 loaded the library.
	 
	 Thread-specific initialization should be done here.
      */
      break;

    case DLL_THREAD_DETACH:
      /* Called on thread exit in processes that have loaded the 
	 library. Not called if the thread existed before the process 
	 loaded the library.
	 
	 Thread-specific cleanup should be done here.
       */
      break;

    case DLL_PROCESS_DETACH:
      /*  If the operating system does not perform this function, 
	  code from _WEP should be inserted here.
       */
      WSACleanup();
      
      break;
    }
  /*   Return value used for DLL_PROCESS_ATTACH only.  */
  return TRUE;   /* successful DLL_PROCESS_ATTACH */
}
#else
int CALLBACK
LibMain( HINSTANCE hinst, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine )
{
  return( 1 );
}
#endif

#ifndef _WIN32
/* The 16-bit version of the RTL does not implement perror() */
#include <stdio.h>

void perror( const char *msg )
{
		char buf[128];
		wsprintf( buf, "%s: error %d\n", msg, WSAGetLastError()) ;
		OutputDebugString( buf );
}

#endif
