/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;

public class ResourceControlValue
implements Cloneable {
    public static final BigInteger MIN_VALUE = BigInteger.valueOf(0L);
    public static final BigInteger MAX_VALUE = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.valueOf(1L));
    public static final String BASIC = "basic";
    public static final String PRIV = "priv";
    public static final String PRIVILEGED = "privileged";
    public static final String SYSTEM = "system";
    public static final String NOACTION = "none";
    public static final String DENY = "deny";
    public static final String SIGNAL_PREFIX = "SIG";
    private ThresholdValue threshold;
    private String privilege;
    private String action;
    private String signal;
    private ISOSignal isoSignal = new ISOSignal();
    private String controlType = "generic_control";

    public ResourceControlValue() {
        this(MIN_VALUE, "", "", "", "", "");
    }

    public ResourceControlValue(BigInteger bigInteger, String string, String string2, String string3, String string4, String string5) {
        this.threshold = new ThresholdValue(bigInteger, string);
        this.privilege = string2;
        this.signal = string3;
        this.action = string4;
        this.controlType = string5;
    }

    public Object clone() {
        try {
            ResourceControlValue resourceControlValue = (ResourceControlValue)super.clone();
            resourceControlValue.threshold = (ThresholdValue)this.threshold.clone();
            return resourceControlValue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public BigInteger getThreshold() {
        return this.threshold.getValue();
    }

    public ThresholdValue getThresholdValue() {
        return this.threshold;
    }

    public String getThresholdStr() {
        return this.threshold.toString();
    }

    public void setThreshold(BigInteger bigInteger) {
        this.threshold.setValue(bigInteger);
    }

    public void setThreshold(BigInteger bigInteger, String string) {
        this.threshold.setValue(bigInteger);
        this.threshold.setUnits(string);
    }

    public void setThreshold(String string, String string2) throws Exception {
        this.threshold.parse(string, string2);
    }

    public String getThresholdUnits() {
        String string = this.threshold.getUnits();
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return this.threshold.getDefaultUnits(this.controlType);
    }

    public void setThresholdUnits(String string) {
        this.threshold.setUnits(string);
    }

    public String[] getAllTimeUnits() {
        return this.threshold.getAllTimeUnits();
    }

    public String[] getAllSizeUnits() {
        return this.threshold.getAllSizeUnits();
    }

    public String getPrivilege() {
        if (this.privilege.equals(PRIV)) {
            return PRIVILEGED;
        }
        return this.privilege;
    }

    public void setPrivilege(String string) {
        this.privilege = string;
    }

    public String getAction() {
        return this.action;
    }

    public String getActionString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.signal != null && this.signal.trim().length() > 0) {
            stringBuffer.append("signal=");
            stringBuffer.append(this.getSignalStr());
        }
        if (this.action == null) {
            this.action = NOACTION;
        }
        if (this.action.equals(DENY)) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(DENY);
        } else if (this.action.equals(NOACTION)) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(NOACTION);
        }
        return stringBuffer.toString();
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getSignal() {
        return this.signal;
    }

    public int getSignalInt() {
        try {
            return Integer.parseInt(this.signal);
        }
        catch (NumberFormatException numberFormatException) {
            return this.isoSignal.str2Sig(this.signal);
        }
    }

    public String getSignalStr() {
        try {
            return this.isoSignal.sig2Str(Integer.parseInt(this.signal));
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.signal.equals("") && !this.signal.startsWith(SIGNAL_PREFIX)) {
                this.signal = SIGNAL_PREFIX + this.signal;
            }
            return this.signal;
        }
    }

    public String[] getAllSignals(String string) {
        return this.isoSignal.getAllSignals(string);
    }

    public void setSignal(String string) {
        this.signal = string;
    }

    public String getControlType() {
        return this.controlType;
    }

    public void setControlType(String string) {
        this.controlType = string;
    }

    public void validateValue(BigInteger bigInteger) throws Exception {
        this.threshold.validateValue(bigInteger);
    }

    public void validateUnits(String string) throws Exception {
        this.threshold.validateUnits(string, this.controlType);
    }

    public void validatePrivilege(String string) throws Exception {
        if (!(string.equalsIgnoreCase(BASIC) || string.equalsIgnoreCase(PRIV) || string.equalsIgnoreCase(PRIVILEGED))) {
            throw new Exception("EXM_RCTL_BAD_PRIV");
        }
    }

    public void validateAction(String string) throws Exception {
        if (!(string = string.trim().toLowerCase()).equals(NOACTION) && !string.equals(DENY)) {
            throw new Exception("EXM_RCTL_BAD_ACTION");
        }
    }

    public void validateSignal(String string) throws Exception {
        try {
            int n = Integer.parseInt(string);
            if (this.isoSignal.isValidSignal(n, this.controlType)) {
                return;
            }
            throw new Exception("EXM_RCTL_BAD_SIG");
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.isoSignal.isValidSignal(string, this.controlType)) {
                throw new Exception("EXM_RCTL_BAD_SIG");
            }
            return;
        }
    }

    public void validateSignal(String string, String string2) throws Exception {
        try {
            int n = Integer.parseInt(string);
            if (this.isoSignal.isValidSignal(n, string2)) {
                return;
            }
            throw new Exception("EXM_RCTL_BAD_SIG");
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.isoSignal.isValidSignal(string, string2)) {
                throw new Exception("EXM_RCTL_BAD_SIG");
            }
            return;
        }
    }

    public boolean equals(Object object) {
        ResourceControlValue resourceControlValue = (ResourceControlValue)object;
        if (!this.getPrivilege().equalsIgnoreCase(resourceControlValue.getPrivilege())) {
            return false;
        }
        if (!this.action.equalsIgnoreCase(resourceControlValue.getAction())) {
            return false;
        }
        if (!this.isoSignal.equals(this.signal, resourceControlValue.getSignal())) {
            return false;
        }
        if (!this.controlType.equals(resourceControlValue.getControlType())) {
            return false;
        }
        return this.threshold.equals(resourceControlValue.getThresholdValue(), this.controlType);
    }

    public boolean equals(ResourceControlValue resourceControlValue) {
        if (!this.getPrivilege().equalsIgnoreCase(resourceControlValue.getPrivilege())) {
            return false;
        }
        if (!this.controlType.equals(resourceControlValue.getControlType())) {
            return false;
        }
        return this.threshold.equals(resourceControlValue.getThresholdValue(), this.controlType);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(").append(this.privilege);
        stringBuffer.append(",").append(this.threshold.toString());
        stringBuffer.append(",").append(this.getActionString()).append(")");
        return stringBuffer.toString();
    }

    class ISOSignal {
        public final String[][] SIGNALS = new String[][]{{"SIGHUP", "1"}, {"SIGABRT", "6"}, {"SIGKILL", "9"}, {"SIGTERM", "15"}, {"SIGSTOP", "23"}, {"SIGXCPU", "30"}, {"SIGXFSZ", "31"}, {"SIGXRES", "38"}};
        private static final int CPU_TIME_INDEX = 5;
        private static final int FILE_SIZE_INDEX = 6;

        ISOSignal() {
        }

        public String[] getAllSignals(String string) {
            int n = string == "file_size_control" || string == "cpu_time_control" ? this.SIGNALS.length - 1 : this.SIGNALS.length - 2;
            String[] stringArray = new String[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.SIGNALS.length) {
                if (n3 == 5) {
                    if (string == "cpu_time_control") {
                        stringArray[n2++] = this.SIGNALS[n3][0];
                    }
                } else if (n3 == 6) {
                    if (string == "file_size_control") {
                        stringArray[n2++] = this.SIGNALS[n3][0];
                    }
                } else {
                    stringArray[n2++] = this.SIGNALS[n3][0];
                }
                ++n3;
            }
            return stringArray;
        }

        public String sig2Str(int n) {
            String string = String.valueOf(n);
            int n2 = 0;
            while (n2 < this.SIGNALS.length) {
                if (string.equals(this.SIGNALS[n2][1])) {
                    return this.SIGNALS[n2][0];
                }
                ++n2;
            }
            return null;
        }

        public int str2Sig(String string) {
            if (string == null || string.trim().length() == 0) {
                return -1;
            }
            if (!(string = string.trim().toUpperCase()).startsWith(ResourceControlValue.SIGNAL_PREFIX)) {
                string = ResourceControlValue.SIGNAL_PREFIX + string;
            }
            int n = 0;
            while (n < this.SIGNALS.length) {
                if (string.equals(this.SIGNALS[n][0])) {
                    return Integer.parseInt(this.SIGNALS[n][1]);
                }
                ++n;
            }
            return -1;
        }

        public boolean isValidSignal(String string, String string2) {
            if (string == null) {
                return false;
            }
            if (!(string = string.trim().toUpperCase()).startsWith(ResourceControlValue.SIGNAL_PREFIX)) {
                string = ResourceControlValue.SIGNAL_PREFIX + string;
            }
            return this.isValidSignal(0, string, string2);
        }

        public boolean isValidSignal(int n, String string) {
            return this.isValidSignal(1, String.valueOf(n), string);
        }

        private boolean isValidSignal(int n, String string, String string2) {
            if (string2 != "cpu_time_control" && string.equals(this.SIGNALS[5][n])) {
                return false;
            }
            if (string2 != "file_size_control" && string.equals(this.SIGNALS[6][n])) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.SIGNALS.length) {
                if (string.equals(this.SIGNALS[n2][n])) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean equals(String string, String string2) {
            block7: {
                int n;
                block6: {
                    if (string == null) {
                        return string2 == null;
                    }
                    if (string2 == null) {
                        return false;
                    }
                    try {
                        n = Integer.parseInt(string);
                        string = this.sig2Str(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = string.toUpperCase();
                        if (string.startsWith(ResourceControlValue.SIGNAL_PREFIX)) break block6;
                        string = ResourceControlValue.SIGNAL_PREFIX + string;
                    }
                }
                try {
                    n = Integer.parseInt(string2);
                    string2 = this.sig2Str(n);
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = string2.toUpperCase();
                    if (string2.startsWith(ResourceControlValue.SIGNAL_PREFIX)) break block7;
                    string2 = ResourceControlValue.SIGNAL_PREFIX + string2;
                }
            }
            return string.equals(string2);
        }
    }

    class ThresholdValue
    implements Cloneable {
        public final String[] TIME_UNITS = new String[]{"s", "ms", "ks", "Ms", "Gs"};
        public final int DEF_TIME_INDEX = 1;
        private final BigDecimal ONE = new BigDecimal(1.0);
        private final BigDecimal[] TIME_MULTIPLIERS = new BigDecimal[]{BigDecimal.valueOf(1000L), this.ONE, new BigDecimal(0.001), new BigDecimal(1.0E-6), new BigDecimal(1.0E-9)};
        private Hashtable timeMultipliers;
        public final String[] SIZE_UNITS = new String[]{"b", "kb", "mb", "gb", "tb"};
        public final int DEF_SIZE_INDEX = 0;
        private final BigInteger[] SIZE_MULTIPLIERS = new BigInteger[]{BigInteger.valueOf(2L).pow(0), BigInteger.valueOf(2L).pow(10), BigInteger.valueOf(2L).pow(20), BigInteger.valueOf(2L).pow(30), BigInteger.valueOf(2L).pow(40)};
        private Hashtable sizeMultipliers;
        private BigInteger value;
        private String units;

        public ThresholdValue(BigInteger bigInteger, String string) {
            this.value = bigInteger;
            this.units = string;
            this.timeMultipliers = new Hashtable(this.TIME_UNITS.length);
            int n = 0;
            while (n < this.TIME_UNITS.length) {
                this.timeMultipliers.put(this.TIME_UNITS[n], this.TIME_MULTIPLIERS[n]);
                ++n;
            }
            this.sizeMultipliers = new Hashtable(this.SIZE_UNITS.length);
            int n2 = 0;
            while (n2 < this.SIZE_UNITS.length) {
                this.sizeMultipliers.put(this.SIZE_UNITS[n2], this.SIZE_MULTIPLIERS[n2]);
                ++n2;
            }
        }

        public Object clone() {
            try {
                ThresholdValue thresholdValue = (ThresholdValue)super.clone();
                thresholdValue.timeMultipliers = (Hashtable)this.timeMultipliers.clone();
                thresholdValue.sizeMultipliers = (Hashtable)this.sizeMultipliers.clone();
                thresholdValue.value = new BigInteger(this.value.toString());
                return thresholdValue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public BigInteger getValue() {
            return this.value;
        }

        public void setValue(BigInteger bigInteger) {
            this.value = bigInteger;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String string) {
            this.units = string;
        }

        public String getDefaultUnits(String string) {
            if (string == "cpu_time_control" || string == "time_control") {
                return this.TIME_UNITS[1];
            }
            if (string == "file_size_control" || string == "size_control") {
                return this.SIZE_UNITS[0];
            }
            return "";
        }

        public String[] getAllTimeUnits() {
            return this.TIME_UNITS;
        }

        public String[] getAllSizeUnits() {
            return this.SIZE_UNITS;
        }

        public void validateValue(BigInteger bigInteger) throws Exception {
            if (bigInteger.compareTo(MIN_VALUE) == -1 || bigInteger.compareTo(MAX_VALUE) == 1) {
                throw new Exception("EXM_RCTL_BAD_VAL");
            }
        }

        public void validateUnits(String string, String string2) throws Exception {
            if (string == null || string.trim().length() == 0) {
                return;
            }
            if (string2 == "generic_control" && string != null && string.trim().length() != 0) {
                throw new Exception("EXM_RCTL_BAD_UNITS");
            }
            if (string2 == "cpu_time_control" || string2 == "time_control") {
                if (this.timeMultipliers.get(string) == null) {
                    throw new Exception("EXM_RCTL_BAD_UNITS");
                }
                return;
            }
            if (string2 == "file_size_control" || string2 == "size_control") {
                if (this.sizeMultipliers.get(string) == null) {
                    throw new Exception("EXM_RCTL_BAD_UNITS");
                }
                return;
            }
        }

        public void parse(String string, String string2) throws Exception {
            if (string == null) {
                throw new Exception("EXM_RCTL_BAD_THRESHOLD");
            }
            StringBuffer stringBuffer = new StringBuffer(10);
            boolean bl = false;
            int n = string.length();
            int n2 = 0;
            while (n2 < n && !bl) {
                char c = string.charAt(n2);
                if (Character.isDigit(c)) {
                    stringBuffer.append(c);
                } else {
                    bl = true;
                }
                ++n2;
            }
            if (stringBuffer.length() == 0) {
                throw new Exception("EXM_RCTL_BAD_THRESHOLD");
            }
            String string3 = "";
            if (string.length() > stringBuffer.length()) {
                string3 = string.substring(n2 - 1).trim();
            }
            if (string3.equals("")) {
                if (string2 == "cpu_time_control" || string2 == "time_control") {
                    string3 = this.TIME_UNITS[1];
                } else if (string2 == "file_size_control" || string2 == "size_control") {
                    string3 = this.SIZE_UNITS[0];
                }
            }
            this.value = new BigInteger(stringBuffer.toString());
            this.units = string3;
        }

        public boolean equals(ThresholdValue thresholdValue, String string) {
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            if (string == "cpu_time_control" || string == "time_control") {
                bigDecimal = (BigDecimal)this.timeMultipliers.get(this.units);
                bigDecimal2 = (BigDecimal)this.timeMultipliers.get(thresholdValue.getUnits());
            } else if (string == "file_size_control" || string == "size_control") {
                bigDecimal = new BigDecimal((BigInteger)this.sizeMultipliers.get(this.units));
                bigDecimal2 = new BigDecimal((BigInteger)this.sizeMultipliers.get(thresholdValue.getUnits()));
            } else {
                bigDecimal = this.ONE;
                bigDecimal2 = this.ONE;
            }
            BigInteger bigInteger = new BigDecimal(this.value).multiply(bigDecimal).toBigInteger();
            BigInteger bigInteger2 = new BigDecimal(thresholdValue.getValue()).multiply(bigDecimal2).toBigInteger();
            return bigInteger.equals(bigInteger2);
        }

        public String toString() {
            return this.value.toString() + this.units;
        }
    }
}

