/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.common;

import com.sun.admin.projmgr.common.ResourceControlValue;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ResourceControl
implements Cloneable {
    public static final String GEN_RCTL = "generic_control";
    public static final String CPU_TIME_RCTL = "cpu_time_control";
    public static final String TIME_RCTL = "time_control";
    public static final String FILE_SIZE_RCTL = "file_size_control";
    public static final String SIZE_RCTL = "size_control";
    public static final String[] RCTL_CATEGORIES = new String[]{"process", "project", "task"};
    public static final String[][] RCTLS = new String[][]{{"process.max-address-space", "size_control"}, {"process.max-core-size", "size_control"}, {"process.max-cpu-time", "cpu_time_control"}, {"process.max-data-size", "size_control"}, {"process.max-file-descriptor", "generic_control"}, {"process.max-file-size", "file_size_control"}, {"process.max-stack-size", "size_control"}, {"project.cpu-shares", "generic_control"}, {"task.max-cpu-time", "cpu_time_control"}, {"task.max-lwps", "generic_control"}};
    public static final String ASSIGN_DELIM = "=";
    public static final String VALUE_DELIM = ",";
    public static final String NAME_DELIM = ".,";
    public static final String CPU_TIME = "cpu-time";
    public static final String FILE_SIZE = "file-size";
    private String rctlName;
    private String category;
    private String control;
    private String controlType;
    private ArrayList rctlValues;

    public ResourceControl(String string) {
        this.rctlName = string;
        this.parseName();
        this.controlType = this.getControlType(string);
        this.rctlValues = new ArrayList(3);
    }

    public Object clone() {
        try {
            ResourceControl resourceControl = (ResourceControl)super.clone();
            resourceControl.rctlValues = (ArrayList)this.rctlValues.clone();
            return resourceControl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.rctlName;
    }

    public void setName(String string) {
        this.rctlName = string;
        this.parseName();
        this.controlType = this.getControlType(string);
    }

    public String getCategory() {
        return this.category;
    }

    public String getControl() {
        return this.control;
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getControlType(String string) {
        int n = 0;
        while (n < RCTLS.length) {
            if (string.equalsIgnoreCase(RCTLS[n][0])) {
                return RCTLS[n][1];
            }
            ++n;
        }
        return GEN_RCTL;
    }

    public void setControlType(String string) {
        this.controlType = string;
    }

    public ArrayList getValues() {
        return this.rctlValues;
    }

    public ResourceControlValue getValueAt(int n) {
        if (n < 0 || n >= this.getNumValues()) {
            return null;
        }
        return (ResourceControlValue)this.rctlValues.get(n);
    }

    public int getNumValues() {
        return this.rctlValues.size();
    }

    public void addValue(ResourceControlValue resourceControlValue) {
        this.rctlValues.add(resourceControlValue);
    }

    public void addValue(int n, ResourceControlValue resourceControlValue) {
        if (n < 0 || n > this.rctlValues.size()) {
            return;
        }
        this.rctlValues.add(n, resourceControlValue);
    }

    public void setValueAt(int n, ResourceControlValue resourceControlValue) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.getNumValues()) {
            throw new IndexOutOfBoundsException();
        }
        this.rctlValues.set(n, resourceControlValue);
    }

    public void removeValues() {
        this.rctlValues.clear();
    }

    public int removeValue(ResourceControlValue resourceControlValue) {
        return this.removeValue(this.rctlValues.indexOf(resourceControlValue));
    }

    public int removeValue(int n) {
        if (n < 0 || n >= this.getNumValues()) {
            return -1;
        }
        this.rctlValues.remove(n);
        return 0;
    }

    private void parseName() {
        if (this.rctlName == null) {
            return;
        }
        this.rctlName = this.rctlName.trim();
        if (this.rctlName.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.rctlName, NAME_DELIM);
        if (stringTokenizer.countTokens() != 2) {
            return;
        }
        this.category = stringTokenizer.nextToken();
        this.control = stringTokenizer.nextToken();
    }

    public void validateName(String string) throws Exception {
        if (string == null) {
            throw new Exception("EXM_RCTL_BAD_CTLNAME");
        }
        if ((string = string.trim().toLowerCase()).length() == 0) {
            throw new Exception("EXM_RCTL_BAD_CTLNAME");
        }
        int n = 0;
        while (n < RCTLS.length) {
            if (string.equals(RCTLS[n][0])) {
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < NAME_DELIM.length()) {
            int n3 = string.indexOf(NAME_DELIM.charAt(n2));
            if (n3 > 0 && string.length() >= n3) {
                return;
            }
            ++n2;
        }
        throw new Exception("EXM_RCTL_BAD_CTLNAME");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.rctlName);
        stringBuffer.append(ASSIGN_DELIM);
        if (this.getNumValues() > 0) {
            stringBuffer.append(this.rctlValues.get(0).toString());
        }
        int n = 1;
        while (n < this.getNumValues()) {
            stringBuffer.append(VALUE_DELIM);
            stringBuffer.append(this.rctlValues.get(n).toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

