/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.common;

import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.projmgr.common.ProjMgrException;
import com.sun.admin.projmgr.common.ResourceControl;
import com.sun.admin.projmgr.common.ResourceControlParser;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ProjectObj
implements Serializable,
Cloneable {
    public static final int MAX_PROJ_INTEGER_VALUE = Integer.MAX_VALUE;
    public static final int PROJECT_NAME_LIMIT = 64;
    public static final int MIN_PROJ_USER_INTEGER_VALUE = 100;
    public static final String DEFAULT = "default";
    public static final String DEFAULT_ID = "3";
    private String strName = null;
    private String strPid = null;
    private String strDesc = null;
    private String[] strUsers;
    private String[] strGroups;
    private String[] strRoles;
    private String[] strUsersAndRoles;
    private ProjectAttributeList attributes = new ProjectAttributeList();

    public ProjectObj() {
    }

    public ProjectObj(String string) {
        this.strName = string;
    }

    public Object clone() {
        try {
            ProjectObj projectObj = (ProjectObj)super.clone();
            projectObj.attributes = (ProjectAttributeList)this.attributes.clone();
            return projectObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(ProjectObj projectObj) {
        String string = projectObj.getProjectName();
        if (!this.stringComp(this.strName, string)) {
            return false;
        }
        String string2 = projectObj.getProjectID();
        if (!this.stringComp(this.strPid, string2)) {
            return false;
        }
        String string3 = projectObj.getProjectDescription();
        if (!this.stringComp(this.strDesc, string3)) {
            return false;
        }
        if (!this.attributes.equals(projectObj.getAllProjectAttributes())) {
            return false;
        }
        String[] stringArray = projectObj.getProjectUsers();
        if (!this.stringComp(this.strUsers, stringArray)) {
            return false;
        }
        String[] stringArray2 = projectObj.getProjectGroups();
        if (!this.stringComp(this.strGroups, stringArray2)) {
            return false;
        }
        String[] stringArray3 = projectObj.getProjectRoles();
        if (!this.stringComp(this.strRoles, stringArray3)) {
            return false;
        }
        String[] stringArray4 = projectObj.getProjectUsersAndRoles();
        return this.stringComp(this.strUsersAndRoles, stringArray4);
    }

    public boolean stringComp(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public boolean stringComp(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        int n = stringArray.length;
        if (n != stringArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.stringComp(stringArray[n2], stringArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getProjectName() {
        return this.strName;
    }

    public void setProjectName(String string) {
        this.strName = string;
    }

    public String getProjectDescription() {
        if (this.strDesc == null) {
            this.strDesc = "";
        }
        return this.strDesc;
    }

    public void setProjectDescription(String string) {
        this.strDesc = string;
    }

    public void setProjectUsers(String[] stringArray) {
        this.strUsers = stringArray;
    }

    public String[] getProjectUsers() {
        if (this.strUsers == null) {
            this.strUsers = new String[0];
        }
        return this.strUsers;
    }

    public void setProjectRoles(String[] stringArray) {
        this.strRoles = stringArray;
    }

    public String[] getProjectRoles() {
        if (this.strRoles == null) {
            this.strRoles = new String[0];
        }
        return this.strRoles;
    }

    public String[] getProjectUsersAndRoles() {
        if (this.strUsers == null) {
            this.strUsers = new String[0];
        }
        if (this.strRoles == null) {
            this.strRoles = new String[0];
        }
        int n = Array.getLength(this.strUsers);
        int n2 = Array.getLength(this.strRoles);
        int n3 = n + n2;
        this.strUsersAndRoles = new String[n3];
        int n4 = 0;
        n4 = 0;
        while (n4 < n) {
            String string;
            this.strUsersAndRoles[n4] = string = new String(this.strUsers[n4]);
            ++n4;
        }
        int n5 = n4;
        while (n5 < n3) {
            String string;
            this.strUsersAndRoles[n5] = string = new String(this.strRoles[n5 - n4]);
            ++n5;
        }
        return this.strUsersAndRoles;
    }

    public void setProjectGroups(String[] stringArray) {
        this.strGroups = stringArray;
    }

    public String[] getProjectGroups() {
        if (this.strGroups == null) {
            this.strGroups = new String[0];
        }
        return this.strGroups;
    }

    public String getProjectID() {
        return this.strPid;
    }

    public void setProjectID(String string) {
        this.strPid = string;
    }

    public String[] getProjectAttributes() {
        return this.attributes.getProjectAttributes();
    }

    public void setProjectAttributes(String[] stringArray) throws ProjMgrException {
        this.attributes.setProjectAttributes(stringArray);
    }

    public ResourceControl[] getProjectAttributeObjs() {
        return this.attributes.getResourceControls();
    }

    public HashMap getAllProjectAttributes() {
        return this.attributes.getAllProjectAttributes();
    }

    public void setProjectAttribute(String string, ResourceControl resourceControl) throws ProjMgrException {
        this.attributes.setProjectAttribute(string, resourceControl);
    }

    public ArrayList getUnrecognizedAttributes() {
        return this.attributes.getUnrecognizedAttributes();
    }

    public boolean isTheDefault() {
        return this.strPid != null && this.strName != null && this.strPid.equals(DEFAULT_ID) && this.strName.equals(DEFAULT);
    }

    public void debugPrint() {
        String[] stringArray;
        int n;
        System.out.println("--------------------------------");
        System.out.println("Project name:  " + this.strName);
        System.out.println("Project ID:    " + this.strPid);
        if (this.strDesc != null) {
            System.out.println("Description:   " + this.strDesc);
        }
        if (this.strUsers != null) {
            System.out.println("List of users:");
            n = 0;
            while (n < this.strUsers.length) {
                System.out.println("      " + this.strUsers[n]);
                ++n;
            }
        }
        if (this.strGroups != null) {
            System.out.println("List of groups:");
            n = 0;
            while (n < this.strGroups.length) {
                System.out.println("      " + this.strGroups[n]);
                ++n;
            }
        }
        if (this.strRoles != null) {
            System.out.println("List of Roles:");
            n = 0;
            while (n < this.strRoles.length) {
                System.out.println("      " + this.strRoles[n]);
                ++n;
            }
        }
        if (this.strUsersAndRoles != null) {
            System.out.println("List of Users and Roles:");
            n = 0;
            while (n < this.strUsersAndRoles.length) {
                System.out.println("      " + this.strUsersAndRoles[n]);
                ++n;
            }
        }
        if ((stringArray = this.attributes.getProjectAttributes()) != null && stringArray.length > 0) {
            System.out.println("List of Attributes:");
            int n2 = 0;
            while (n2 < stringArray.length) {
                System.out.println("      " + stringArray[n2]);
                ++n2;
            }
        }
        System.out.println("--------------------------------");
    }

    private class ProjectAttributeList
    implements Cloneable {
        private ArrayList rctlKeys = null;
        private HashMap rctls = null;
        private ResourceControlParser parser = new ResourceControlParser();
        private ArrayList unrecognizedAttributes = new ArrayList(0);
        private final String UNRECOGNIZED_ATTR = "com.sun.admin.projmgr.common.unrecognized";

        public ProjectAttributeList() {
            this.rctlKeys = new ArrayList(0);
            this.rctls = new HashMap(0);
        }

        public String[] getProjectAttributes() {
            int n = this.unrecognizedAttributes.size();
            String[] stringArray = new String[this.rctls.size() + n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.rctlKeys.size()) {
                String string = (String)this.rctlKeys.get(n3);
                stringArray[n2++] = this.rctls.get(string).toString();
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                stringArray[n2++] = (String)this.unrecognizedAttributes.get(n4);
                ++n4;
            }
            return stringArray;
        }

        public void setProjectAttributes(String[] stringArray) throws ProjMgrException {
            if (stringArray == null) {
                this.rctlKeys = new ArrayList(0);
                this.rctls = new HashMap(0);
                return;
            }
            this.rctlKeys = new ArrayList(stringArray.length);
            this.rctls = new HashMap(stringArray.length);
            this.unrecognizedAttributes = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>(ResourceControl.RCTLS.length);
            int n = 0;
            while (n < ResourceControl.RCTLS.length) {
                arrayList.add(ResourceControl.RCTLS[n][0]);
                ++n;
            }
            ResourceControl resourceControl = null;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string;
                try {
                    resourceControl = this.parser.parseValue(stringArray[n2]);
                    string = resourceControl.getName();
                    if (arrayList.contains(string) && !this.rctlKeys.contains(string)) {
                        this.rctlKeys.add(string);
                        this.rctls.put(string, resourceControl);
                    } else {
                        this.unrecognizedAttributes.add(stringArray[n2]);
                    }
                }
                catch (Exception exception) {
                    string = "com.sun.admin.projmgr.common.unrecognized";
                    this.unrecognizedAttributes.add(stringArray[n2]);
                }
                ++n2;
            }
            this.sortKeys();
            if (this.unrecognizedAttributes.size() > 0) {
                throw new ProjMgrException("EXM_RCTL_UNRECOGNIZED_VALUE");
            }
        }

        public void setProjectAttribute(String string, ResourceControl resourceControl) throws ProjMgrException {
            if (resourceControl != null && resourceControl.getNumValues() > 0) {
                this.rctls.put(string, resourceControl);
                if (!this.rctlKeys.contains(string)) {
                    this.rctlKeys.add(string);
                }
                this.sortKeys();
            } else {
                this.rctls.remove(string);
                this.rctlKeys.remove(string);
            }
        }

        public HashMap getAllProjectAttributes() {
            return this.rctls;
        }

        public ResourceControl[] getResourceControls() {
            ResourceControl[] resourceControlArray = new ResourceControl[this.rctls.size()];
            int n = 0;
            while (n < this.rctlKeys.size()) {
                try {
                    resourceControlArray[n] = (ResourceControl)this.rctls.get((String)this.rctlKeys.get(n));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            return resourceControlArray;
        }

        public ArrayList getUnrecognizedAttributes() {
            return this.unrecognizedAttributes;
        }

        public boolean equals(HashMap hashMap) {
            if (this.rctls.size() != hashMap.size()) {
                return false;
            }
            int n = 0;
            while (n < this.rctls.size()) {
                String string = (String)this.rctlKeys.get(n);
                ResourceControl resourceControl = (ResourceControl)this.rctls.get(string);
                ResourceControl resourceControl2 = (ResourceControl)hashMap.get(string);
                if (resourceControl != null) {
                    if (resourceControl2 == null) {
                        return false;
                    }
                    if (!resourceControl.equals(resourceControl2)) {
                        return false;
                    }
                } else if (resourceControl2 != null) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public Object clone() {
            try {
                ProjectAttributeList projectAttributeList = (ProjectAttributeList)super.clone();
                projectAttributeList.rctls = (HashMap)this.rctls.clone();
                projectAttributeList.rctlKeys = (ArrayList)this.rctlKeys.clone();
                projectAttributeList.unrecognizedAttributes = (ArrayList)this.unrecognizedAttributes.clone();
                return projectAttributeList;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        private void sortKeys() {
            Vector vector = new Vector(this.rctlKeys);
            Sort.sort(vector, (int)0);
            this.rctlKeys = new ArrayList(vector);
        }
    }
}

