/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.projmgr.client.ServiceWrapper;
import com.sun.admin.projmgr.client.WBEMClient.ProjMgrClientProxy;
import com.sun.admin.projmgr.common.ProjMgrException;
import com.sun.admin.projmgr.common.ProjectObj;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolInfrastructure;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;

public class WbemServiceWrapper
extends ServiceWrapper {
    private CIMClient cimClient = null;
    private CIMObjectPath projMgr = null;
    WbemMgmtScope wbemMgmtScope = null;
    ToolInfrastructure tinf;
    private String currentServer;

    public void init(Object object, Object object2, AdminMgmtScope adminMgmtScope) throws Exception {
        super.init(object, object2, adminMgmtScope);
        this.cimClient = (CIMClient)object;
        this.wbemMgmtScope = new WbemMgmtScope(adminMgmtScope.getMgmtScopeType(), adminMgmtScope.getMgmtDomainName());
        this.currentServer = adminMgmtScope.getMgmtServerName();
        this.tinf = (ToolInfrastructure)object2;
    }

    public CIMClient getCIMClient() {
        return this.cimClient;
    }

    public WbemMgmtScope getWbemMgmtScope() {
        return this.wbemMgmtScope;
    }

    public String getNextProjectID() throws AdminException {
        ProjMgrClientProxy projMgrClientProxy = new ProjMgrClientProxy();
        projMgrClientProxy.init(this.cimClient, this.wbemMgmtScope);
        String string = null;
        string = projMgrClientProxy.getNextProjectID();
        return string;
    }

    public ProjectObj getAllMembers(ProjectObj projectObj) throws AdminException {
        ProjMgrClientProxy projMgrClientProxy = new ProjMgrClientProxy();
        projMgrClientProxy.init(this.cimClient, this.wbemMgmtScope);
        projectObj = projMgrClientProxy.getAllMembers(projectObj);
        return projectObj;
    }

    public Vector getAllProjects() throws AdminException {
        Vector vector = new Vector();
        ProjMgrClientProxy projMgrClientProxy = new ProjMgrClientProxy();
        projMgrClientProxy.init(this.cimClient, this.wbemMgmtScope);
        vector = projMgrClientProxy.getAllProjects();
        return vector;
    }

    public void addProject(ProjectObj projectObj) throws AdminException {
        ProjMgrClientProxy projMgrClientProxy = new ProjMgrClientProxy();
        projMgrClientProxy.init(this.cimClient, this.wbemMgmtScope);
        if (projectObj.getProjectName().equals("default") && !projectObj.getProjectID().equals("3")) {
            throw new ProjMgrException("EXM_DEF_RESV");
        }
        projMgrClientProxy.addProject(projectObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProjectObj modifyProject(ProjectObj projectObj, ProjectObj projectObj2) throws AdminException {
        String string = projectObj.getProjectName();
        String string2 = projectObj2.getProjectName();
        if (projectObj == null || projectObj2 == null) {
            throw new ProjMgrException("EXM_MODPROJ_NULL");
        }
        if (projectObj.equals(projectObj2)) {
            return projectObj;
        }
        ProjMgrClientProxy projMgrClientProxy = new ProjMgrClientProxy();
        projMgrClientProxy.init(this.cimClient, this.wbemMgmtScope);
        if (!string.equals(string2)) {
            if (string.equals("default") && !projectObj.getProjectID().equals("3")) {
                throw new ProjMgrException("EXM_DEF_RESV");
            }
            if (this.doesProjectNameAlreadyExist(string)) throw new ProjMgrException("EXM_DUP_PROJ");
            projMgrClientProxy.deleteProject(projectObj2);
            projMgrClientProxy.addProject(projectObj);
            return projectObj;
        } else {
            projMgrClientProxy.modifyProject(projectObj, projectObj2);
        }
        return projectObj;
    }

    public void deleteProject(ProjectObj projectObj) throws AdminException {
        ProjMgrClientProxy projMgrClientProxy = new ProjMgrClientProxy();
        projMgrClientProxy.init(this.cimClient, this.wbemMgmtScope);
        projMgrClientProxy.deleteProject(projectObj);
    }

    private boolean doesProjectNameAlreadyExist(String string) throws AdminException {
        boolean bl = false;
        Vector vector = this.getAllProjects();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ProjectObj projectObj = (ProjectObj)enumeration.nextElement();
            if (!string.equals(projectObj.getProjectName())) continue;
            return true;
        }
        return bl;
    }
}

