/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.projmgr.client.WBEMClient.ClientProxyException;
import com.sun.admin.projmgr.common.PartialSuccessObj;
import com.sun.admin.projmgr.common.ProjMgrException;
import com.sun.admin.projmgr.common.ProjMgrPartialSuccessException;
import com.sun.admin.projmgr.common.ProjectObj;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMSecurityException;

public class ProjMgrClientProxy
implements WbemClientProxy {
    private static final String PROJECT_CLASS = "Solaris_Project";
    private static final String USER_CLASS = "Solaris_UserAccount";
    private static final String GROUP_CLASS = "Solaris_UserGroup";
    private static final String PROJECT_USER_CLASS = "Solaris_ProjectUser";
    private static final String PROJECT_GROUP_CLASS = "Solaris_ProjectGroup";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private static final String USER_NAME = "Name";
    private static final String GROUP_NAME = "GroupName";
    private static final String USER_FIELD = "User";
    private static final String GROUP_FIELD = "Group";
    private static final String PROJECT_REF = "Project";
    private static final String PROJECT_ID = "ProjectID";
    private static final String PROJECT_NAME = "ProjectName";
    private static final String PROJECT_DESCRIPTION = "Description";
    private static final String PROJECT_ATTRIBUTES = "ProjectAttributes";
    private static final String SET_USERS_METHOD = "setProjectUsers";
    private static final String SET_GROUPS_METHOD = "setProjectGroups";
    private static final String SPACE = " ";
    private CIMClient cimClient = null;
    private WbemMgmtScope wScope;

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) {
        this.cimClient = cIMClient;
        this.wScope = wbemMgmtScope;
    }

    public void deleteProject(ProjectObj projectObj) throws AdminException {
        CIMObjectPath cIMObjectPath = this.buildProjectOP(projectObj);
        this.deleteProjectEntry(cIMObjectPath, projectObj.getProjectName());
    }

    public void addProject(ProjectObj projectObj) throws AdminException {
        CIMObjectPath cIMObjectPath = this.buildProjectOP(projectObj);
        CIMInstance cIMInstance = this.buildProjectCI(projectObj);
        this.addProjectEntry(cIMObjectPath, cIMInstance, projectObj.getProjectName());
        PartialSuccessObj partialSuccessObj = null;
        try {
            this.modMembers(cIMObjectPath, projectObj, PROJECT_USER_CLASS);
        }
        catch (AdminException adminException) {
            if (partialSuccessObj == null) {
                partialSuccessObj = new PartialSuccessObj();
            }
            partialSuccessObj.setUserRoleFailed(true);
            partialSuccessObj.setUserRoleException((Exception)((Object)new ProjMgrException("EXM_USER_ROLE_ADD_ERR", projectObj.getProjectName())));
        }
        try {
            this.modMembers(cIMObjectPath, projectObj, PROJECT_GROUP_CLASS);
        }
        catch (AdminException adminException) {
            if (partialSuccessObj == null) {
                partialSuccessObj = new PartialSuccessObj();
            }
            partialSuccessObj.setGroupFailed(true);
            partialSuccessObj.setGroupException((Exception)((Object)new ProjMgrException("EXM_GROUP_ADD_ERR", projectObj.getProjectName())));
        }
        if (partialSuccessObj != null) {
            throw new ProjMgrPartialSuccessException("EXM_PARTIAL_ADD_ERR", partialSuccessObj);
        }
    }

    public void modifyProject(ProjectObj projectObj, ProjectObj projectObj2) throws AdminException {
        CIMObjectPath cIMObjectPath = this.buildProjectOP(projectObj);
        CIMInstance cIMInstance = this.buildProjectCI(projectObj);
        this.modifyProjectEntry(cIMObjectPath, cIMInstance, projectObj2.getProjectName());
        PartialSuccessObj partialSuccessObj = null;
        try {
            this.modMembers(cIMObjectPath, projectObj, PROJECT_USER_CLASS);
        }
        catch (AdminException adminException) {
            if (partialSuccessObj == null) {
                partialSuccessObj = new PartialSuccessObj();
            }
            partialSuccessObj.setUserRoleFailed(true);
            partialSuccessObj.setUserRoleException((Exception)((Object)new ProjMgrException("EXM_USER_ROLE_MOD_ERR", projectObj.getProjectName())));
        }
        try {
            this.modMembers(cIMObjectPath, projectObj, PROJECT_GROUP_CLASS);
        }
        catch (AdminException adminException) {
            if (partialSuccessObj == null) {
                partialSuccessObj = new PartialSuccessObj();
            }
            partialSuccessObj.setGroupFailed(true);
            partialSuccessObj.setGroupException((Exception)((Object)new ProjMgrException("EXM_GROUP_MOD_ERR", projectObj.getProjectName())));
        }
        if (partialSuccessObj != null) {
            throw new ProjMgrPartialSuccessException("EXM_PARTIAL_ADD_ERR", partialSuccessObj);
        }
    }

    public ProjectObj getAllMembers(ProjectObj projectObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJECT_CLASS);
        cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
        String string = projectObj.getProjectName();
        if (string == null || string.trim().length() == 0) {
            throw new ClientProxyException("EXM_PROJ_GET_BAD_NAME");
        }
        cIMObjectPath.addKey(PROJECT_NAME, new CIMValue((Object)string));
        CIMValue cIMValue = null;
        CIMValue cIMValue2 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            cIMValue = this.cimClient.invokeMethod(cIMObjectPath, "getProjectUsers", vector, vector2);
            cIMValue2 = this.cimClient.invokeMethod(cIMObjectPath, "getProjectGroups", vector, vector2);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_PROJ_GET_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJ_GET_UNEXP", string, exception.getMessage());
        }
        String string3 = "";
        if (cIMValue != null) {
            string3 = cIMValue.toString();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
        }
        String string4 = "";
        if (cIMValue2 != null) {
            string4 = cIMValue2.toString();
            if (string4.startsWith("\"")) {
                string4 = string4.substring(1);
            }
            if (string4.endsWith("\"")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
        }
        String string5 = ",; ";
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string5);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, string5);
        while (stringTokenizer2.hasMoreTokens()) {
            arrayList2.add(stringTokenizer2.nextToken());
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)arrayList.get(n2);
            ++n2;
        }
        int n3 = arrayList2.size();
        String[] stringArray2 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray2[n4] = (String)arrayList2.get(n4);
            ++n4;
        }
        projectObj.setProjectUsers(stringArray);
        projectObj.setProjectGroups(stringArray2);
        return projectObj;
    }

    public Vector getAllProjects() throws AdminException {
        Vector<ProjectObj> vector = new Vector<ProjectObj>();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJECT_CLASS);
        cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
        Enumeration enumeration = null;
        try {
            enumeration = this.cimClient.enumerateInstances(cIMObjectPath, false, false, false, false, null);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_PROJ_READNAMES_UNEXP", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJ_READNAMES_UNEXP", exception.getMessage());
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                ProjectObj projectObj = new ProjectObj();
                String string = (String)cIMInstance.getProperty(PROJECT_NAME).getValue().getValue();
                if (string == null) {
                    throw new ClientProxyException("EXM_PROJ_NAME_UNEXP_NULL");
                }
                projectObj.setProjectName(string);
                String string2 = cIMInstance.getProperty(PROJECT_ID).getValue().getValue().toString();
                if (string2 == null) {
                    throw new ClientProxyException("EXM_PROJ_ID_UNEXP_NULL");
                }
                projectObj.setProjectID(string2);
                String string3 = cIMInstance.getProperty(PROJECT_DESCRIPTION).getValue().getValue().toString();
                if (string3 == null) {
                    throw new ClientProxyException("EXM_PROJ_DESC_UNEXP_NULL");
                }
                projectObj.setProjectDescription(string3);
                Vector vector2 = (Vector)cIMInstance.getProperty(PROJECT_ATTRIBUTES).getValue().getValue();
                if (vector2 != null) {
                    String[] stringArray = new String[vector2.size()];
                    stringArray = vector2.toArray(stringArray);
                    try {
                        projectObj.setProjectAttributes(stringArray);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                vector.addElement(projectObj);
            }
        }
        return vector;
    }

    public String getNextProjectID() throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJECT_CLASS);
        cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        CIMValue cIMValue = null;
        try {
            cIMValue = this.cimClient.invokeMethod(cIMObjectPath, "getNextProjectID", vector, vector2);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string);
            }
            throw new ClientProxyException("EXM_GET_NEXT_PID_ERR", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_GET_NEXT_PID_ERR", exception.getMessage());
        }
        String string = null;
        if (cIMValue != null) {
            string = cIMValue.toString();
        }
        return string;
    }

    private void addProjectEntry(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, String string) throws AdminException {
        try {
            this.cimClient.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            if (cIMException.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                throw new ClientProxyException("EXM_PROJ_DUP_NAME", string);
            }
            throw new ClientProxyException("EXM_PROJ_ADD_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJ_ADD_UNEXP", string, exception.getMessage());
        }
    }

    private void deleteProjectEntry(CIMObjectPath cIMObjectPath, String string) throws AdminException {
        try {
            this.cimClient.deleteInstance(cIMObjectPath);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_PROJ_DEL_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJ_DEL_UNEXP", string, exception.getMessage());
        }
    }

    private void modifyProjectEntry(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, String string) throws AdminException {
        try {
            this.cimClient.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_PROJ_MOD_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJ_MOD_UNEXP", string, exception.getMessage());
        }
    }

    private CIMObjectPath buildProjectOP(ProjectObj projectObj) throws AdminException {
        String string = projectObj.getProjectName();
        if (string == null || string.trim().length() == 0) {
            throw new ClientProxyException("EXM_PROJ_BAD_NAME");
        }
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_PROJ_BAD_SCOPE");
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJECT_CLASS);
        cIMObjectPath = this.addMgmtKeys(cIMObjectPath);
        cIMObjectPath.addKey(PROJECT_NAME, new CIMValue((Object)string));
        return cIMObjectPath;
    }

    private CIMInstance buildProjectCI(ProjectObj projectObj) throws AdminException {
        String string = projectObj.getProjectName();
        String string2 = projectObj.getProjectID();
        String string3 = projectObj.getProjectDescription();
        String[] stringArray = projectObj.getProjectAttributes();
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        String string4 = this.wScope.getScopeClassType();
        String string5 = this.wScope.getDomainName();
        CIMObjectPath cIMObjectPath = new CIMObjectPath(PROJECT_CLASS);
        CIMClass cIMClass = null;
        try {
            cIMClass = this.cimClient.getClass(cIMObjectPath, false);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string6 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string6);
            }
            throw new ClientProxyException("EXM_NO_MESSAGE");
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty(PROJECT_NAME, new CIMValue((Object)string));
        cIMInstance.setProperty(PROJECT_ID, new CIMValue((Object)new UnsignedInt32(string2)));
        cIMInstance.setProperty(PROJECT_DESCRIPTION, new CIMValue((Object)string3));
        cIMInstance.setProperty(PROJECT_ATTRIBUTES, new CIMValue(vector));
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)string4));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)string5));
        return cIMInstance;
    }

    private CIMValue modMembers(CIMObjectPath cIMObjectPath, ProjectObj projectObj, String string) throws AdminException {
        try {
            if (projectObj == null) {
                return null;
            }
            String string2 = "";
            CIMValue cIMValue = null;
            if (string.equals(PROJECT_USER_CLASS)) {
                string2 = SET_USERS_METHOD;
                cIMValue = new CIMValue((Object)this.arrayToString(projectObj.getProjectUsersAndRoles()));
            } else if (string.equals(PROJECT_GROUP_CLASS)) {
                string2 = SET_GROUPS_METHOD;
                cIMValue = new CIMValue((Object)this.arrayToString(projectObj.getProjectGroups()));
            }
            if (cIMValue == null) {
                return null;
            }
            Vector vector = new Vector(1);
            Vector<CIMValue> vector2 = new Vector<CIMValue>(1);
            vector2.addElement(cIMValue);
            CIMValue cIMValue2 = null;
            cIMValue2 = this.cimClient.invokeMethod(cIMObjectPath, string2, vector2, vector);
            return cIMValue2;
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_PROJ_SCTY_VIOLATION");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string3 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string3);
            }
            throw new ClientProxyException("EXM_PROJ_ADD_MEM_UNEXP", cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJ_ADD_MEM_UNEXP", exception.getMessage());
        }
    }

    private CIMObjectPath addMgmtKeys(CIMObjectPath cIMObjectPath) throws AdminException {
        if (this.wScope == null) {
            throw new ClientProxyException("EXM_PROJ_BAD_SCOPE");
        }
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)this.wScope.getScopeClassType()));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)this.wScope.getDomainName()));
        return cIMObjectPath;
    }

    private String arrayToString(String[] stringArray) throws AdminException {
        try {
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            String string = new String();
            int n = 0;
            while (n < stringArray.length) {
                string = string.concat(SPACE + stringArray[n]);
                ++n;
            }
            string = string.trim();
            return string;
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_PROJ_ADD_MEM_UNEXP", exception.getMessage());
        }
    }
}

