/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.admin.usermgr.common.WBEMClient.GroupListFormatSQL;
import com.sun.admin.usermgr.common.WBEMClient.GroupProxy;
import com.sun.admin.usermgr.common.WBEMClient.UserClientProxy;
import com.sun.admin.usermgr.common.WBEMClient.UserListFormatSQL;
import java.util.Vector;
import javax.wbem.client.CIMClient;

public class UserMgrUtility {
    private VProjMgr theApp;
    private CIMClient cimClient;
    private WbemMgmtScope wbemMgmtScope;
    private UserClientProxy ucp;
    private GroupProxy groupProxy;

    public UserMgrUtility(VProjMgr vProjMgr) {
        this.theApp = vProjMgr;
        this.ucp = new UserClientProxy();
        this.groupProxy = new GroupProxy();
        this.cimClient = vProjMgr.getProjMgr().getCIMClient();
        this.wbemMgmtScope = vProjMgr.getProjMgr().getWbemMgmtScope();
    }

    public Vector getAllUsers(ListProperties listProperties) throws AdminException {
        Vector vector = new Vector();
        this.ucp.init(this.cimClient, this.wbemMgmtScope);
        if (listProperties != null) {
            UserListFormatSQL userListFormatSQL = new UserListFormatSQL();
            String string = userListFormatSQL.formatQuery(listProperties);
            vector = this.ucp.getAllUsers(string);
        } else {
            vector = this.theApp.getAllUsersCache();
            if (vector == null) {
                try {
                    vector = this.ucp.getAllUsers();
                    this.theApp.setAllUsersCache(vector);
                }
                catch (AdminException adminException) {
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                }
            }
        }
        return vector;
    }

    public Vector getUserNames(ListProperties listProperties) throws AdminException {
        Vector<String> vector = new Vector<String>();
        String string = "";
        Vector vector2 = this.getAllUsers(listProperties);
        int n = 0;
        while (n < vector2.size()) {
            UserObj userObj = (UserObj)vector2.elementAt(n);
            string = userObj.getUserName();
            vector.addElement(string);
            ++n;
        }
        return vector;
    }

    public Vector getAllUsers() throws AdminException {
        Vector vector = this.theApp.getAllUsersCache();
        if (vector == null) {
            vector = new Vector();
            try {
                this.ucp.init(this.cimClient, this.wbemMgmtScope);
                vector = this.ucp.getAllUsers();
                this.theApp.setAllUsersCache(vector);
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
        return vector;
    }

    public Vector getAllRoles(ListProperties listProperties) throws AdminException {
        Vector vector = new Vector();
        this.ucp.init(this.cimClient, this.wbemMgmtScope);
        if (listProperties != null) {
            UserListFormatSQL userListFormatSQL = new UserListFormatSQL();
            String string = userListFormatSQL.formatQuery(listProperties);
            vector = this.ucp.getAllRoles(string);
        } else {
            vector = this.theApp.getAllRolesCache();
            if (vector == null) {
                try {
                    vector = this.ucp.getAllRoles();
                    this.theApp.setAllRolesCache(vector);
                }
                catch (AdminException adminException) {
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                }
            }
        }
        return vector;
    }

    public Vector getRoleNames(ListProperties listProperties) throws AdminException {
        Vector<String> vector = new Vector<String>();
        String string = "";
        Vector vector2 = this.getAllRoles(listProperties);
        int n = 0;
        while (n < vector2.size()) {
            UserObj userObj = (UserObj)vector2.elementAt(n);
            string = userObj.getUserName();
            vector.addElement(string);
            ++n;
        }
        return vector;
    }

    public Vector getAllRoles() throws AdminException {
        Vector vector = this.theApp.getAllRolesCache();
        if (vector == null) {
            vector = new Vector();
            try {
                this.ucp.init(this.cimClient, this.wbemMgmtScope);
                vector = this.ucp.getAllRoles();
                this.theApp.setAllRolesCache(vector);
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
        return vector;
    }

    public Vector getAllGroups(ListProperties listProperties) throws AdminException {
        Vector vector = new Vector();
        this.groupProxy.init(this.cimClient, this.wbemMgmtScope);
        if (listProperties != null) {
            GroupListFormatSQL groupListFormatSQL = new GroupListFormatSQL();
            String string = groupListFormatSQL.formatQuery(listProperties);
            vector = this.groupProxy.getGroupList(string);
        } else {
            vector = this.theApp.getAllGroupsCache();
            if (vector == null) {
                vector = new Vector();
                try {
                    vector = this.groupProxy.getGroupList(null);
                    this.theApp.setAllGroupsCache(vector);
                }
                catch (AdminException adminException) {
                    this.theApp.reportErrorException((Exception)((Object)adminException));
                }
            }
        }
        return vector;
    }

    public Vector getGroupNames(ListProperties listProperties) throws AdminException {
        Vector<String> vector = new Vector<String>();
        String string = "";
        Vector vector2 = this.getAllGroups(listProperties);
        int n = 0;
        while (n < vector2.size()) {
            GroupObj groupObj = (GroupObj)vector2.elementAt(n);
            string = groupObj.getGroupName();
            vector.addElement(string);
            ++n;
        }
        return vector;
    }

    public Vector getAllGroups() throws AdminException {
        Vector vector = this.theApp.getAllGroupsCache();
        if (vector == null) {
            vector = new Vector();
            try {
                this.groupProxy.init(this.cimClient, this.wbemMgmtScope);
                vector = this.groupProxy.getGroupList(null);
                this.theApp.setAllGroupsCache(vector);
            }
            catch (AdminException adminException) {
                this.theApp.reportErrorException((Exception)((Object)adminException));
            }
        }
        return vector;
    }
}

