/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.projmgr.client.ProjMgrContextHelpListener;
import com.sun.admin.projmgr.client.ProjMgrPropsPanel;
import com.sun.admin.projmgr.client.ResourceControlPropsDlg;
import com.sun.admin.projmgr.client.ResourceControlTreeTableModel;
import com.sun.admin.projmgr.client.ResourceProps;
import com.sun.admin.projmgr.client.TreeTable;
import com.sun.admin.projmgr.client.TreeTableSelectionListener;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.admin.projmgr.common.ProjMgrException;
import com.sun.admin.projmgr.common.ProjectObj;
import com.sun.admin.projmgr.common.ResourceControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;

public class ResourceProps
extends ProjMgrPropsPanel
implements TreeTableSelectionListener {
    private VProjMgr theApp;
    private ResourceBundle bundle;
    private boolean hasWriteAuth;
    private GenInfoPanel infoPanel;
    private JDialog propsDlg;
    private ResourceProps resourceProps;
    private boolean isNew;
    private GridBagConstraints gbc;
    private ProjectObj newProjObj;
    private JScrollPane scrollPane;
    private TreeTable treeTable;
    private JButton editRctlBtn;
    private JButton addRctlBtn;
    private JButton delRctlBtn;
    private JButton viewRctlBtn;
    private ResourceControlPropsDlg rctlDlg;
    private Boolean rctlDlgInProgress = new Boolean(false);
    private ActionString actionString;
    private Vector helpCache;
    private ProjMgrContextHelpListener helpListener;
    private ToolTipManager toolTipMgr;
    private int initialDelay;
    private int dismissDelay;
    private int lastSelection = -1;
    private static final int HELP_CACHE_SIZE = 5;
    private static final int VISIBLE_ROWS = 13;
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public ResourceProps(VProjMgr vProjMgr, JDialog jDialog, ProjectObj projectObj, GenInfoPanel genInfoPanel, boolean bl) {
        this.theApp = vProjMgr;
        this.bundle = vProjMgr.getResourceBundle();
        this.hasWriteAuth = vProjMgr.getProjMgr().hasWriteAuthorization();
        this.resourceProps = this;
        this.infoPanel = genInfoPanel;
        this.isNew = bl;
        this.propsDlg = jDialog;
        this.newProjObj = bl ? new ProjectObj() : (ProjectObj)projectObj.clone();
        this.createGui(projectObj);
        this.toolTipMgr = ToolTipManager.sharedInstance();
        this.initialDelay = this.toolTipMgr.getInitialDelay();
        this.dismissDelay = this.toolTipMgr.getDismissDelay();
        this.helpCache = new Vector(5);
        this.treeTable.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, this.helpCache, this.infoPanel, "new_res_treetable")));
        if (this.hasWriteAuth) {
            this.editRctlBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, this.helpCache, this.infoPanel, "new_res_edit_btn")));
            this.addRctlBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, this.helpCache, this.infoPanel, "new_res_add_btn")));
            this.delRctlBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, this.helpCache, this.infoPanel, "new_res_del_btn")));
        } else {
            this.viewRctlBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, this.helpCache, this.infoPanel, "new_res_view_btn")));
        }
        Thread thread = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((ProjMgrContextHelpListener)((Object)ResourceProps.this.getFocusListener())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    private void createGui(ProjectObj projectObj) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        ResourceControl[] resourceControlArray = this.isNew ? new ResourceControl[]{} : projectObj.getProjectAttributeObjs();
        this.treeTable = new TreeTable(new ResourceControlTreeTableModel(this.bundle, resourceControlArray));
        this.treeTable.addSelectionListener(this);
        this.treeTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ResourceProps.this.setTableFocus(true);
            }

            public void focusLost(FocusEvent focusEvent) {
                ResourceProps.this.setTableFocus(false);
            }
        });
        this.treeTable.addMouseListener(new MouseListener(){

            public void mouseEntered(MouseEvent mouseEvent) {
                ResourceProps.this.toolTipMgr.setInitialDelay(250);
                ResourceProps.this.toolTipMgr.setDismissDelay(15000);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ResourceProps.this.toolTipMgr.setInitialDelay(ResourceProps.this.initialDelay);
                ResourceProps.this.toolTipMgr.setDismissDelay(ResourceProps.this.dismissDelay);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (ResourceProps.this.hasWriteAuth) {
                        ResourceProps.this.editRctlBtn.doClick();
                    } else {
                        ResourceProps.this.viewRctlBtn.doClick();
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.scrollPane = new JScrollPane(this.treeTable, 20, 31);
        this.scrollPane.getViewport().setBackground(this.treeTable.getBackground());
        Constraints.constrain((Container)this, (Component)this.scrollPane, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)24, (int)12, (int)0, (int)12);
        double d = (double)(13 * this.treeTable.getRowHeight()) + this.treeTable.getTableHeader().getPreferredSize().getHeight();
        double d2 = this.scrollPane.getPreferredSize().getHeight() - this.scrollPane.getViewport().getPreferredSize().getHeight();
        double d3 = this.scrollPane.getPreferredSize().getWidth();
        this.scrollPane.setPreferredSize(new Dimension((int)d3, (int)(d += d2)));
        this.scrollPane.setMinimumSize(this.scrollPane.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)6, (int)0, (int)6, (int)0);
        if (this.hasWriteAuth) {
            this.editRctlBtn = this.setUpButton("proj_edit_rctl_btn", new EditRctlBtnListener(), false);
            Constraints.constrain((Container)jPanel, (Component)this.editRctlBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.addRctlBtn = this.setUpButton("proj_add_rctl_btn", new AddRctlBtnListener(), resourceControlArray.length < ResourceControl.RCTLS.length);
            Constraints.constrain((Container)jPanel, (Component)this.addRctlBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)6, (int)0, (int)0);
            this.delRctlBtn = this.setUpButton("proj_del_rctl_btn", new DelRctlBtnListener(), false);
            Constraints.constrain((Container)jPanel, (Component)this.delRctlBtn, (int)2, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)6, (int)0, (int)12);
        } else {
            this.viewRctlBtn = this.setUpButton("proj_view_rctl_btn", new ViewRctlBtnListener(), false);
            Constraints.constrain((Container)jPanel, (Component)this.viewRctlBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)6, (int)0, (int)12);
        }
        Constraints.constrain((Container)this, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)2, (int)1, (int)0, (int)3, (int)17, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    private JButton setUpButton(String string, ActionListener actionListener, boolean bl) {
        this.actionString = new ActionString(ResourceStrings.getString((ResourceBundle)this.bundle, (String)string));
        JButton jButton = new JButton(this.actionString.getString());
        jButton.setMnemonic(this.actionString.getMnemonic());
        jButton.addActionListener(actionListener);
        jButton.setMinimumSize(jButton.getPreferredSize());
        jButton.setEnabled(bl);
        return jButton;
    }

    private void setTableFocus(boolean bl) {
        if (bl) {
            if (this.treeTable.getRowCount() > 0) {
                this.treeTable.requestFocus();
                if (this.lastSelection >= 0 && this.lastSelection < this.treeTable.getRowCount()) {
                    this.treeTable.setRowSelectionInterval(this.lastSelection, this.lastSelection);
                }
            }
        } else {
            this.lastSelection = this.treeTable.getSelectedRow();
        }
    }

    public void valueChanged(EventObject eventObject) {
        this.setButtonsEnabled();
    }

    private void setButtonsEnabled() {
        boolean bl;
        boolean bl2 = bl = this.treeTable.getSelectedRowCount() > 0 && !((ResourceControlTreeTableModel)this.treeTable.getTreeTableModel()).isCategory(this.treeTable.nodeForRow(this.treeTable.getSelectedRow()));
        if (!this.hasWriteAuth) {
            this.viewRctlBtn.setEnabled(bl);
            return;
        }
        this.editRctlBtn.setEnabled(bl);
        this.delRctlBtn.setEnabled(bl);
        int n = ResourceControl.RCTLS.length;
        int n2 = this.newProjObj.getProjectAttributeObjs().length;
        boolean bl3 = n2 < n;
        this.addRctlBtn.setEnabled(n2 < n);
    }

    public boolean isSyntaxOK() {
        return true;
    }

    public ProjectObj updateProps(ProjectObj projectObj) {
        try {
            projectObj.setProjectAttributes(this.newProjObj.getProjectAttributes());
        }
        catch (ProjMgrException projMgrException) {
            // empty catch block
        }
        return projectObj;
    }

    public String getHelpName() {
        return "new_res";
    }

    private void setUpDialog(ResourceControlPropsDlg resourceControlPropsDlg) {
        resourceControlPropsDlg.pack();
        resourceControlPropsDlg.setSize(resourceControlPropsDlg.getPreferredSize());
        resourceControlPropsDlg.setLocation(ResourceProps.screenSize.width / 2 - resourceControlPropsDlg.getSize().width / 2, ResourceProps.screenSize.height / 2 - resourceControlPropsDlg.getSize().height / 2);
        resourceControlPropsDlg.setVisible(true);
    }

    static /* synthetic */ int access$1902(ResourceProps resourceProps, int n) {
        resourceProps.lastSelection = n;
        return resourceProps.lastSelection;
    }

    static /* synthetic */ void access$2000(ResourceProps resourceProps) {
        resourceProps.setButtonsEnabled();
    }

    private class ViewRctlBtnListener
    implements ActionListener {
        private ViewRctlBtnListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (ResourceProps.this.treeTable.getSelectedRow() < 0) {
                return;
            }
            Boolean bl = ResourceProps.this.rctlDlgInProgress;
            synchronized (bl) {
                if (ResourceProps.this.rctlDlgInProgress.booleanValue()) {
                    return;
                }
                ResourceProps.this.rctlDlgInProgress = Boolean.TRUE;
            }
            int n = ResourceProps.this.treeTable.getSelectedRow();
            String string = (String)ResourceProps.this.treeTable.getValueAt(n, 0);
            ResourceControl[] resourceControlArray = ResourceProps.this.newProjObj.getProjectAttributeObjs();
            ResourceControl resourceControl = null;
            int n2 = 0;
            while (n2 < resourceControlArray.length) {
                if (string.equals(resourceControlArray[n2].getName())) {
                    resourceControl = resourceControlArray[n2];
                }
                ++n2;
            }
            ResourceProps.this.rctlDlg = new ResourceControlPropsDlg(ResourceProps.this.theApp, ResourceProps.this.propsDlg, resourceControl);
            ResourceProps.this.setUpDialog(ResourceProps.this.rctlDlg);
            Boolean bl2 = ResourceProps.this.rctlDlgInProgress;
            synchronized (bl2) {
                ResourceProps.this.rctlDlgInProgress = Boolean.FALSE;
            }
        }
    }

    class DelRctlBtnListener
    implements ActionListener {
        private WarningDialog warningDlg = null;
        private JPanel warnPanel = null;

        DelRctlBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!ResourceProps.this.hasWriteAuth || ResourceProps.this.treeTable.getSelectedRow() < 0) {
                return;
            }
            if (this.warnPanel == null) {
                this.warnPanel = new JPanel(new GridBagLayout());
                object = new GridBagConstraints();
                int n = 30;
                FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)ResourceProps.this.bundle, (String)"sure_delete_rctl"), n);
                flowArea.setSize(flowArea.getPreferredSize());
                Constraints.constrain((Container)this.warnPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)ResourceProps.this.bundle, (String)"deleting_rctl"), n);
                flowArea.setSize(flowArea.getPreferredSize());
                Constraints.constrain((Container)this.warnPanel, (Component)flowArea, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)ResourceProps.this.bundle, (String)"removes_entry_rctl"), n);
                flowArea.setSize(flowArea.getPreferredSize());
                Constraints.constrain((Container)this.warnPanel, (Component)flowArea, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
            }
            object = new ActionListener(this){
                private final /* synthetic */ DelRctlBtnListener this$1;
                {
                    this.this$1 = delRctlBtnListener;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Thread thread = new Thread(this){
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            int n = ResourceProps.access$900(DelRctlBtnListener.access$1800(4.access$1700(this.this$2))).getSelectedRow();
                            String string = (String)ResourceProps.access$900(DelRctlBtnListener.access$1800(4.access$1700(this.this$2))).getValueAt(n, 0);
                            try {
                                ResourceProps.access$1100(DelRctlBtnListener.access$1800(4.access$1700(this.this$2))).setProjectAttribute(string, null);
                            }
                            catch (ProjMgrException projMgrException) {
                                // empty catch block
                            }
                            ResourceProps.access$900(DelRctlBtnListener.access$1800(4.access$1700(this.this$2))).refreshData(ResourceProps.access$1100(DelRctlBtnListener.access$1800(4.access$1700(this.this$2))).getProjectAttributeObjs());
                            ResourceProps.access$1902(DelRctlBtnListener.access$1800(4.access$1700(this.this$2)), -1);
                            ResourceProps.access$2000(DelRctlBtnListener.access$1800(4.access$1700(this.this$2)));
                        }
                    };
                    thread.start();
                }

                static /* synthetic */ DelRctlBtnListener access$1700(4 var0) {
                    return var0.this$1;
                }
            };
            this.warningDlg = new WarningDialog(ResourceProps.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)ResourceProps.this.bundle, (String)"warning_rctl"), this.warnPanel, (ActionListener)object, ResourceStrings.getString((ResourceBundle)ResourceProps.this.bundle, (String)"warning_delete"));
        }

        static /* synthetic */ ResourceProps access$1800(DelRctlBtnListener delRctlBtnListener) {
            return delRctlBtnListener.ResourceProps.this;
        }
    }

    class AddRctlBtnListener
    implements ActionListener {
        AddRctlBtnListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!ResourceProps.this.hasWriteAuth) {
                return;
            }
            Boolean bl = ResourceProps.this.rctlDlgInProgress;
            synchronized (bl) {
                if (ResourceProps.this.rctlDlgInProgress.booleanValue()) {
                    return;
                }
                ResourceProps.this.rctlDlgInProgress = Boolean.TRUE;
            }
            ResourceControl[] resourceControlArray = ResourceProps.this.newProjObj.getProjectAttributeObjs();
            ArrayList<String> arrayList = new ArrayList<String>(resourceControlArray.length);
            int n = 0;
            while (n < resourceControlArray.length) {
                arrayList.add(resourceControlArray[n].getName());
                ++n;
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(ResourceControl.RCTLS.length);
            int n2 = 0;
            while (n2 < ResourceControl.RCTLS.length) {
                arrayList2.add(ResourceControl.RCTLS[n2][0]);
                ++n2;
            }
            ArrayList arrayList3 = new ArrayList(arrayList2.size());
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                if (!arrayList.contains(arrayList2.get(n3))) {
                    arrayList3.add(arrayList2.get(n3));
                }
                ++n3;
            }
            String[] stringArray = new String[arrayList3.size()];
            int n4 = 0;
            while (n4 < arrayList3.size()) {
                stringArray[n4] = (String)arrayList3.get(n4);
                ++n4;
            }
            ResourceProps.this.rctlDlg = new ResourceControlPropsDlg(ResourceProps.this.theApp, ResourceProps.this.propsDlg, stringArray);
            ResourceProps.this.setUpDialog(ResourceProps.this.rctlDlg);
            if (ResourceProps.this.rctlDlg.isOkClicked()) {
                object = ResourceProps.this.rctlDlg.getResourceControl();
                try {
                    ResourceProps.this.newProjObj.setProjectAttribute(((ResourceControl)object).getName(), (ResourceControl)object);
                }
                catch (ProjMgrException projMgrException) {
                    new ErrorDialog(ResourceProps.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)ResourceProps.this.bundle, (String)"er_rctl_data"));
                }
                ResourceProps.this.treeTable.refreshData(ResourceProps.this.newProjObj.getProjectAttributeObjs());
                ResourceProps.this.valueChanged(null);
            }
            object = ResourceProps.this.rctlDlgInProgress;
            synchronized (object) {
                ResourceProps.this.rctlDlgInProgress = Boolean.FALSE;
            }
        }
    }

    private class EditRctlBtnListener
    implements ActionListener {
        private EditRctlBtnListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ResourceProps.this.hasWriteAuth || ResourceProps.this.treeTable.getSelectedRow() < 0) {
                return;
            }
            Boolean bl = ResourceProps.this.rctlDlgInProgress;
            synchronized (bl) {
                if (ResourceProps.this.rctlDlgInProgress.booleanValue()) {
                    return;
                }
                ResourceProps.this.rctlDlgInProgress = Boolean.TRUE;
            }
            int n = ResourceProps.this.treeTable.getSelectedRow();
            String string = (String)ResourceProps.this.treeTable.getValueAt(n, 0);
            ResourceControl[] resourceControlArray = ResourceProps.this.newProjObj.getProjectAttributeObjs();
            ResourceControl resourceControl = null;
            int n2 = 0;
            while (n2 < resourceControlArray.length) {
                if (string.equals(resourceControlArray[n2].getName())) {
                    resourceControl = resourceControlArray[n2];
                }
                ++n2;
            }
            ResourceProps.this.rctlDlg = new ResourceControlPropsDlg(ResourceProps.this.theApp, ResourceProps.this.propsDlg, resourceControl);
            ResourceProps.this.setUpDialog(ResourceProps.this.rctlDlg);
            if (ResourceProps.this.rctlDlg.isOkClicked()) {
                resourceControl = ResourceProps.this.rctlDlg.getResourceControl();
                try {
                    ResourceProps.this.newProjObj.setProjectAttribute(resourceControl.getName(), resourceControl);
                }
                catch (ProjMgrException projMgrException) {
                    new ErrorDialog(ResourceProps.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)ResourceProps.this.bundle, (String)"er_rctl_data"));
                }
                ResourceProps.this.treeTable.refreshData(ResourceProps.this.newProjObj.getProjectAttributeObjs());
            }
            Boolean bl2 = ResourceProps.this.rctlDlgInProgress;
            synchronized (bl2) {
                ResourceProps.this.rctlDlgInProgress = Boolean.FALSE;
            }
        }
    }
}

