/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.projmgr.client.AbstractTreeTableModel;
import com.sun.admin.projmgr.client.ResourceControlDisplay;
import com.sun.admin.projmgr.client.TreeTableModel;
import com.sun.admin.projmgr.common.ResourceControl;
import com.sun.admin.projmgr.common.ResourceControlValue;
import java.util.ResourceBundle;

public class ResourceControlTreeTableModel
extends AbstractTreeTableModel
implements TreeTableModel {
    protected static final Class[] COLUMN_TYPES = new Class[]{class$com$sun$admin$projmgr$client$TreeTableModel == null ? (class$com$sun$admin$projmgr$client$TreeTableModel = ResourceControlTreeTableModel.class$("com.sun.admin.projmgr.client.TreeTableModel")) : class$com$sun$admin$projmgr$client$TreeTableModel, class$java$lang$String == null ? (class$java$lang$String = ResourceControlTreeTableModel.class$("java.lang.String")) : class$java$lang$String};
    private String[] columnNames;
    public static final int NAME_COLUMN = 0;
    public static final int VALUE_COLUMN = 1;
    public static final String RCTL_CATEGORY_FLAG = "com.sun.admin.projmgr.client.category";
    private ResourceControl[] rctls = null;
    private ResourceControlDisplay rctlDisplay;
    private ResourceBundle bundle;
    static /* synthetic */ Class class$com$sun$admin$projmgr$client$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public ResourceControlTreeTableModel(ResourceBundle resourceBundle) {
        this.setRoot(new ResourceControlData("", true));
        this.bundle = resourceBundle;
        this.rctlDisplay = new ResourceControlDisplay(resourceBundle);
    }

    public ResourceControlTreeTableModel(ResourceBundle resourceBundle, ResourceControl[] resourceControlArray) {
        this(resourceBundle);
        this.rctls = resourceControlArray;
        if (resourceControlArray == null) {
            return;
        }
        this.columnNames = new String[2];
        this.columnNames[0] = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_rctl_col");
        this.columnNames[1] = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_value_col");
        ResourceControlData resourceControlData = (ResourceControlData)this.getRoot();
        int n = 0;
        while (n < ResourceControl.RCTL_CATEGORIES.length) {
            resourceControlData.addChild(new ResourceControlData(ResourceControl.RCTL_CATEGORIES[n], true));
            ++n;
        }
        this.refreshData(resourceControlArray);
    }

    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    protected Object[] getChildren(Object object) {
        ResourceControlData resourceControlData = (ResourceControlData)object;
        return resourceControlData.getChildren();
    }

    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    public boolean isLeaf(Object object) {
        if (((ResourceControlData)object).isCategory()) {
            return false;
        }
        return ((ResourceControlData)object).getChildren() == null || ((ResourceControlData)object).getChildren().length == 0;
    }

    public int getRowCount() {
        return this.rctls == null ? 0 : this.rctls.length;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n < 0 || n >= this.columnNames.length) {
            return null;
        }
        return this.columnNames[n];
    }

    public Class getColumnClass(int n) {
        if (n < 0 || n >= this.columnNames.length) {
            return null;
        }
        return COLUMN_TYPES[n];
    }

    public Object getValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                return ((ResourceControlData)object).getName();
            }
            case 1: {
                if (((ResourceControlData)object).isCategory()) {
                    return "";
                }
                return ((ResourceControlData)object).getValue();
            }
        }
        return null;
    }

    public void setValueAt(Object object, Object object2, int n) {
        if (object == null) {
            return;
        }
        switch (n) {
            case 0: {
                ((ResourceControlData)object2).setName((String)object);
                break;
            }
            case 1: {
                ((ResourceControlData)object2).setValue((ResourceControlValue[])object);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void refreshData(ResourceControl[] resourceControlArray) {
        ResourceControlData resourceControlData = (ResourceControlData)this.getRoot();
        ResourceControlData[] resourceControlDataArray = resourceControlData.getChildren();
        int n = 0;
        while (n < resourceControlDataArray.length) {
            resourceControlDataArray[n].setChildren(null);
            ++n;
        }
        this.rctls = resourceControlArray;
        int n2 = 0;
        while (n2 < resourceControlArray.length) {
            String string = resourceControlArray[n2].getCategory();
            ResourceControlData resourceControlData2 = (ResourceControlData)this.getCategoryNode(string);
            if (resourceControlData2 != null) {
                resourceControlData2.addChild(new ResourceControlData(resourceControlArray[n2]));
            }
            ++n2;
        }
    }

    public String getToolTipStr(Object object) {
        ResourceControl resourceControl = ((ResourceControlData)object).getResourceControl();
        return this.rctlDisplay.getToolTipStr(resourceControl.getValues());
    }

    public boolean isCategory(Object object) {
        return ((ResourceControlData)object).isCategory();
    }

    private Object getCategoryNode(String string) {
        ResourceControlData resourceControlData = (ResourceControlData)this.getRoot();
        ResourceControlData[] resourceControlDataArray = (ResourceControlData[])this.getChildren(resourceControlData);
        if (resourceControlDataArray != null) {
            int n = 0;
            while (n < resourceControlDataArray.length) {
                if (resourceControlDataArray[n].getName().equals(string)) {
                    return resourceControlDataArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public void debugPrint() {
        ResourceControlData resourceControlData = (ResourceControlData)this.getRoot();
        System.out.println("TreeTable root node is " + resourceControlData.toString());
        int n = 0;
        while (n < this.getChildCount(resourceControlData)) {
            ResourceControlData resourceControlData2 = (ResourceControlData)this.getChild(resourceControlData, n);
            System.out.println("  " + resourceControlData2);
            int n2 = 0;
            while (n2 < this.getChildCount(resourceControlData2)) {
                ResourceControlData resourceControlData3 = (ResourceControlData)this.getChild(resourceControlData2, n2);
                System.out.println("    " + resourceControlData3 + " = " + resourceControlData3.getValue());
                ++n2;
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ResourceControlData {
        private ResourceControl rctl;
        private String name;
        private ResourceControlData[] children = null;
        private boolean isCategory;

        public ResourceControlData(String string, boolean bl) {
            this.name = string;
            this.isCategory = bl;
        }

        public ResourceControlData(ResourceControl resourceControl) {
            this.rctl = resourceControl;
            this.name = resourceControl.getName();
            this.isCategory = false;
        }

        public boolean isCategory() {
            return this.isCategory;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
            if (!this.isCategory) {
                this.rctl.setName(string);
            }
        }

        public String getValue() {
            return this.isCategory ? "" : ResourceControlTreeTableModel.this.rctlDisplay.getRctlValuesDisplayString(this.rctl.getValues());
        }

        public void setValue(ResourceControlValue[] resourceControlValueArray) {
            if (this.isCategory) {
                return;
            }
            int n = 0;
            while (n < this.rctl.getNumValues()) {
                this.rctl.removeValue(0);
                ++n;
            }
            int n2 = 0;
            while (n2 < resourceControlValueArray.length) {
                this.rctl.addValue(resourceControlValueArray[n2]);
                ++n2;
            }
        }

        public ResourceControl getResourceControl() {
            return this.rctl;
        }

        public void setResourceControl(ResourceControl resourceControl) {
            this.rctl = resourceControl;
        }

        public void setChildren(ResourceControlData[] resourceControlDataArray) {
            this.children = resourceControlDataArray;
        }

        public ResourceControlData[] getChildren() {
            return this.children;
        }

        public void addChild(ResourceControlData resourceControlData) {
            int n = this.children == null ? 0 : this.children.length;
            ResourceControlData[] resourceControlDataArray = new ResourceControlData[n + 1];
            int n2 = 0;
            while (n2 < n) {
                resourceControlDataArray[n2] = this.children[n2];
                ++n2;
            }
            resourceControlDataArray[n] = resourceControlData;
            this.children = new ResourceControlData[n + 1];
            int n3 = 0;
            while (n3 < n + 1) {
                this.children[n3] = resourceControlDataArray[n3];
                ++n3;
            }
        }

        public String toString() {
            return this.isCategory ? this.name : this.rctl.getControl();
        }

        public String debugPrint() {
            return this.rctl.toString();
        }
    }
}

