/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.projmgr.client.ProjMgrContextHelpListener;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.admin.projmgr.common.ResourceControl;
import com.sun.admin.projmgr.common.ResourceControlValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

class ResourceControlPropsDlg
extends AdminDialog
implements ListSelectionListener {
    private VProjMgr theApp;
    private ResourceBundle bundle;
    private boolean hasWriteAuth;
    private GenInfoPanel infoPanel;
    private ResourceControl newRctl = null;
    private ResourceControlValue tmpRctlValue = new ResourceControlValue();
    private String[] rctlNames = null;
    private boolean isNew;
    private ResourceControlPropsDlg rctlDlg;
    private ActionString actionString;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private JPanel mainPanel;
    private JPanel rctlPanel;
    private JPanel tablePanel;
    private JPanel formPanel;
    private JPanel inputPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel buttonPanel;
    private JPanel movePanel;
    private JLabel rctlLbl;
    private JComboBox rctlCBox;
    private JScrollPane scrollPane;
    private ResourceTable resourceTable;
    private JTextField threshField;
    private JComboBox unitsCBox;
    private JComboBox privCBox;
    private JComboBox signalCBox;
    private JComboBox actionCBox;
    private JButton updateBtn;
    private JButton deleteBtn;
    private JButton addBtn;
    private JButton clearBtn;
    private JButton moveUpBtn;
    private JButton moveDownBtn;
    private JButton okBtn;
    private JButton cancelBtn;
    private boolean isOkClicked = false;
    private ErrorDialog errorDlg;
    private String privBasic;
    private String privPrivileged;
    private String sigNoSignal;
    private String actNoAction;
    private String actDeny;
    private boolean isSizeType = false;
    private boolean isTimeType = false;
    private String[] sizeUnits;
    private String[] timeUnits;
    private static final int SIZE_DEFAULT_INDEX = 0;
    private static final int TIME_DEFAULT_INDEX = 1;
    private static final int PRIV_DEFAULT_INDEX = 1;
    private static final int HELP_CACHE_SIZE = 13;
    private static final int VISIBLE_ROWS = 3;

    public ResourceControlPropsDlg(VProjMgr vProjMgr, JDialog jDialog, ResourceControl resourceControl) {
        super((Dialog)jDialog, "");
        this.initialize(vProjMgr, false);
        this.newRctl = (ResourceControl)resourceControl.clone();
        this.constructGui();
    }

    public ResourceControlPropsDlg(VProjMgr vProjMgr, JDialog jDialog, String[] stringArray) {
        super((Dialog)jDialog, "");
        this.initialize(vProjMgr, true);
        this.rctlNames = stringArray;
        this.newRctl = new ResourceControl("");
        this.constructGui();
    }

    private void initialize(VProjMgr vProjMgr, boolean bl) {
        this.setModal(true);
        this.theApp = vProjMgr;
        this.hasWriteAuth = vProjMgr.getProjMgr().hasWriteAuthorization();
        this.bundle = vProjMgr.getResourceBundle();
        this.isNew = bl;
        this.rctlDlg = this;
    }

    private void constructGui() {
        Object object;
        JComponent jComponent;
        if (this.isNew) {
            this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_dlg_add"));
        } else if (this.hasWriteAuth) {
            this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_dlg_edit"));
        } else {
            this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_dlg_view"));
        }
        this.gbc = new GridBagConstraints();
        this.privBasic = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_basic");
        this.privPrivileged = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_priv");
        this.sigNoSignal = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_nosignal");
        this.actNoAction = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_noaction");
        this.actDeny = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_deny");
        this.mainPanel = this.getRightPanel();
        this.gbl = new GridBagLayout();
        this.mainPanel.setLayout(this.gbl);
        this.rctlPanel = new JPanel(this.gbl);
        this.tablePanel = new JPanel(this.gbl);
        this.formPanel = new JPanel(this.gbl);
        this.inputPanel = new JPanel(this.gbl);
        this.leftPanel = new JPanel(this.gbl);
        this.rightPanel = new JPanel(this.gbl);
        this.buttonPanel = new JPanel(this.gbl);
        this.movePanel = new JPanel(this.gbl);
        this.actionString = !this.hasWriteAuth ? new ActionString(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_view_lbl")) : (this.isNew ? new ActionString(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_add_lbl")) : new ActionString(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_edit_lbl")));
        this.rctlLbl = new JLabel(this.actionString.getString());
        this.rctlLbl.setDisplayedMnemonic(this.actionString.getMnemonic());
        if (this.isNew) {
            this.rctlCBox = new JComboBox<String>(this.rctlNames);
            this.rctlCBox.addActionListener(new RctlNameListener());
            this.rctlLbl.setLabelFor(this.rctlCBox);
            jComponent = this.rctlCBox;
            if (this.rctlNames != null && this.rctlNames.length > 0) {
                this.newRctl.setName(this.rctlNames[0]);
            }
        } else {
            jComponent = new JLabel(this.newRctl.getName());
        }
        JLabel jLabel = this.setUpLabel("proj_rctl_values_lbl");
        this.resourceTable = new ResourceTable();
        this.resourceTable.addSelectionListener(this);
        this.resourceTable.setBackground(this.mainPanel.getBackground());
        this.resourceTable.setMinimumSize(this.resourceTable.getPreferredSize());
        jLabel.setLabelFor(this.resourceTable);
        this.scrollPane = new JScrollPane(this.resourceTable, 20, 31);
        this.scrollPane.getViewport().setBackground(this.resourceTable.getBackground());
        double d = (double)(3 * this.resourceTable.getRowHeight()) + this.resourceTable.getTableHeader().getPreferredSize().getHeight();
        double d2 = this.scrollPane.getPreferredSize().getHeight() - this.scrollPane.getViewport().getPreferredSize().getHeight();
        double d3 = this.scrollPane.getPreferredSize().getWidth();
        this.scrollPane.setPreferredSize(new Dimension((int)d3, (int)(d += d2)));
        this.scrollPane.setMinimumSize(this.scrollPane.getPreferredSize());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("");
        this.formPanel.setBorder(titledBorder);
        JLabel jLabel2 = this.setUpLabel("proj_rctl_thresh_lbl");
        this.threshField = new JTextField("", 10);
        jLabel2.setLabelFor(this.threshField);
        this.sizeUnits = this.tmpRctlValue.getAllSizeUnits();
        this.timeUnits = this.tmpRctlValue.getAllTimeUnits();
        String string = this.newRctl.getControlType();
        if (string == "size_control" || string == "file_size_control") {
            this.unitsCBox = new JComboBox<String>(this.sizeUnits);
            this.unitsCBox.setSelectedIndex(0);
            this.isSizeType = true;
        } else if (string == "time_control" || string == "cpu_time_control") {
            this.unitsCBox = new JComboBox<String>(this.timeUnits);
            this.unitsCBox.setSelectedIndex(1);
            this.isTimeType = true;
        } else {
            this.unitsCBox = new JComboBox();
            this.unitsCBox.setEnabled(false);
        }
        JLabel jLabel3 = this.setUpLabel("proj_rctl_priv_lbl");
        String[] stringArray = new String[]{this.privBasic, this.privPrivileged};
        this.privCBox = new JComboBox<String>(stringArray);
        this.privCBox.setSelectedIndex(1);
        jLabel3.setLabelFor(this.privCBox);
        JLabel jLabel4 = this.setUpLabel("proj_rctl_signal_lbl");
        this.signalCBox = this.isNew ? new JComboBox<String>(this.tmpRctlValue.getAllSignals("generic_control")) : new JComboBox<String>(this.tmpRctlValue.getAllSignals(this.newRctl.getControlType()));
        this.signalCBox.insertItemAt(this.sigNoSignal, 0);
        this.signalCBox.setSelectedIndex(0);
        jLabel4.setLabelFor(this.signalCBox);
        JLabel jLabel5 = this.setUpLabel("proj_rctl_action_lbl");
        this.actionCBox = new JComboBox();
        this.actionCBox.addItem(this.actNoAction);
        this.actionCBox.addItem(this.actDeny);
        jLabel5.setLabelFor(this.actionCBox);
        this.addBtn = this.setUpButton("proj_rctl_add_btn", new AddBtnListener(), true);
        this.deleteBtn = this.setUpButton("proj_rctl_delete_btn", new DeleteBtnListener(), false);
        this.updateBtn = this.setUpButton("proj_rctl_update_btn", new UpdateBtnListener(), false);
        this.clearBtn = this.setUpButton("proj_rctl_clear_btn", new ClearBtnListener(), true);
        this.moveUpBtn = this.setUpButton("proj_rctl_move_up", new MoveListener(), false);
        this.moveUpBtn.setIcon(this.theApp.loadImageIcon("move_up.gif"));
        this.moveUpBtn.setHorizontalTextPosition(2);
        this.moveDownBtn = this.setUpButton("proj_rctl_move_down", new MoveListener(), false);
        this.moveDownBtn.setIcon(this.theApp.loadImageIcon("move_dn.gif"));
        this.moveDownBtn.setHorizontalTextPosition(2);
        this.okBtn = this.getOKBtn();
        this.okBtn.setText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_ok_btn"));
        this.okBtn.addActionListener(new OKCancelBtnListener());
        this.okBtn.setEnabled(this.hasWriteAuth);
        this.cancelBtn = this.getCancelBtn();
        this.cancelBtn.setText(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"proj_rctl_cancel_btn"));
        this.cancelBtn.addActionListener(new OKCancelBtnListener());
        JPanel jPanel = this.getbuttonPanel();
        jPanel.remove(this.getApplyBtn());
        Constraints.constrain((Container)this.mainPanel, (Component)this.rctlPanel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)this.mainPanel, (Component)this.tablePanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)this.mainPanel, (Component)this.formPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)this.formPanel, (Component)this.inputPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)0, (int)6);
        Constraints.constrain((Container)this.inputPanel, (Component)this.leftPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.inputPanel, (Component)this.rightPanel, (int)2, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)this.formPanel, (Component)this.buttonPanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)12, (int)6, (int)6, (int)6);
        Constraints.constrain((Container)this.mainPanel, (Component)this.movePanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)12);
        Constraints.constrain((Container)this.mainPanel, (Component)new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), (int)0, (int)4, (int)2, (int)0, (int)3, (int)17, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.rctlPanel, (Component)this.rctlLbl, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.rctlPanel, (Component)jComponent, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)0);
        Constraints.constrain((Container)this.tablePanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.tablePanel, (Component)this.scrollPane, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)3, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.leftPanel, (Component)jLabel2, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.leftPanel, (Component)this.threshField, (int)1, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)3, (int)0, (int)0);
        Constraints.constrain((Container)this.leftPanel, (Component)this.unitsCBox, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)3, (int)0, (int)0);
        Constraints.constrain((Container)this.leftPanel, (Component)jLabel3, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.leftPanel, (Component)this.privCBox, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)3, (int)0, (int)0);
        Constraints.constrain((Container)this.rightPanel, (Component)jLabel4, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.rightPanel, (Component)this.signalCBox, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)3, (int)0, (int)0);
        Constraints.constrain((Container)this.rightPanel, (Component)jLabel5, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)6, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.rightPanel, (Component)this.actionCBox, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)3, (int)0, (int)0);
        Constraints.constrain((Container)this.buttonPanel, (Component)this.addBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.buttonPanel, (Component)this.deleteBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)3, (int)0, (int)0);
        Constraints.constrain((Container)this.buttonPanel, (Component)this.updateBtn, (int)2, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)3, (int)0, (int)0);
        Constraints.constrain((Container)this.buttonPanel, (Component)this.clearBtn, (int)3, (int)0, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (int)0, (int)3, (int)0, (int)0);
        int n = jLabel.getFont().getSize() + 3;
        Constraints.constrain((Container)this.movePanel, (Component)this.moveUpBtn, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)n, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)this.movePanel, (Component)this.moveDownBtn, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)0, (int)0, (int)0);
        this.pack();
        Vector vector = new Vector(13);
        GenInfoPanel genInfoPanel = this.rctlDlg.getInfoPanel();
        this.setDefaultFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg")), true);
        if (this.isNew) {
            this.rctlCBox.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_names")));
        }
        this.resourceTable.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_values")));
        this.threshField.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_thresh")));
        this.unitsCBox.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_units")));
        this.privCBox.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_priv")));
        this.signalCBox.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_signal")));
        this.actionCBox.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_action")));
        if (this.hasWriteAuth) {
            this.updateBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_update")));
            this.deleteBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_delete")));
            this.addBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_add")));
            this.clearBtn.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_clear")));
            object = new ProjMgrContextHelpListener(this.theApp, vector, genInfoPanel, "new_res_rctl_props_dlg_move");
            this.moveUpBtn.addFocusListener((FocusListener)object);
            this.moveDownBtn.addFocusListener((FocusListener)object);
        }
        object = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ResourceControlPropsDlg.this.rctlDlg.dispose();
            }
        };
        this.addWindowListener((WindowListener)object);
    }

    private JLabel setUpLabel(String string) {
        this.actionString = new ActionString(ResourceStrings.getString((ResourceBundle)this.bundle, (String)string));
        JLabel jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        return jLabel;
    }

    private JButton setUpButton(String string, ActionListener actionListener, boolean bl) {
        this.actionString = new ActionString(ResourceStrings.getString((ResourceBundle)this.bundle, (String)string));
        JButton jButton = new JButton(this.actionString.getString());
        jButton.setMnemonic(this.actionString.getMnemonic());
        jButton.addActionListener(actionListener);
        jButton.setMinimumSize(jButton.getPreferredSize());
        jButton.setEnabled(bl);
        return jButton;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonsEnabled();
    }

    private void setButtonsEnabled() {
        if (!this.hasWriteAuth) {
            return;
        }
        int n = this.resourceTable.getSelectedRow();
        this.updateBtn.setEnabled(n >= 0);
        this.deleteBtn.setEnabled(n >= 0);
        this.moveUpBtn.setEnabled(n > 0);
        this.moveDownBtn.setEnabled(n >= 0 && n < this.resourceTable.getRowCount() - 1);
    }

    public ResourceControl getResourceControl() {
        return this.newRctl;
    }

    private int indexOf(ResourceControlValue resourceControlValue) {
        ArrayList arrayList = this.newRctl.getValues();
        int n = 0;
        while (n < arrayList.size()) {
            ResourceControlValue resourceControlValue2 = (ResourceControlValue)arrayList.get(n);
            if (resourceControlValue.equals(resourceControlValue2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void clearForm() {
        this.threshField.setText("");
        if (this.isSizeType) {
            this.unitsCBox.setSelectedIndex(0);
        } else if (this.isTimeType) {
            this.unitsCBox.setSelectedIndex(1);
        }
        this.privCBox.setSelectedIndex(1);
        this.signalCBox.setSelectedIndex(0);
        this.actionCBox.setSelectedIndex(0);
    }

    private boolean isFormDataOK() {
        String string = this.threshField.getText().trim();
        if (string.equals("")) {
            return false;
        }
        try {
            BigInteger bigInteger = new BigInteger(string);
            this.tmpRctlValue.validateValue(bigInteger);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private ResourceControlValue getRctlValueFromInput() {
        ResourceControlValue resourceControlValue = new ResourceControlValue();
        try {
            if (this.isSizeType || this.isTimeType) {
                resourceControlValue.setThreshold(new BigInteger(this.threshField.getText()), (String)this.unitsCBox.getSelectedItem());
            } else {
                resourceControlValue.setThreshold(new BigInteger(this.threshField.getText()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.errorDlg = new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_rctl_values"));
            return null;
        }
        String string = (String)this.privCBox.getSelectedItem();
        resourceControlValue.setPrivilege(string.equals(this.privBasic) ? "basic" : "priv");
        String string2 = (String)this.signalCBox.getSelectedItem();
        resourceControlValue.setSignal(string2.equals(this.sigNoSignal) ? "" : string2);
        String string3 = (String)this.actionCBox.getSelectedItem();
        resourceControlValue.setAction(string3.equals(this.actNoAction) ? "none" : "deny");
        resourceControlValue.setControlType(this.newRctl.getControlType());
        return resourceControlValue;
    }

    private boolean isInputUnsaved() {
        if (this.threshField.getText().length() > 0) {
            ResourceControlValue resourceControlValue = this.getRctlValueFromInput();
            ArrayList arrayList = this.newRctl.getValues();
            int n = 0;
            while (n < arrayList.size()) {
                ResourceControlValue resourceControlValue2 = (ResourceControlValue)arrayList.get(n);
                resourceControlValue2.setControlType(resourceControlValue.getControlType());
                if (resourceControlValue.equals(resourceControlValue2)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean isOkClicked() {
        return this.isOkClicked;
    }

    class RctlNameListener
    implements ActionListener {
        private String type;
        private boolean isFileSizeType = false;
        private boolean isCpuTimeType = false;
        private String[] genSignals;
        private String[] fileSizeSignals;
        private String[] cpuTimeSignals;
        private boolean saveSet;
        private boolean discardSet;

        public RctlNameListener() {
            String[] stringArray = ResourceControlPropsDlg.this.tmpRctlValue.getAllSignals("generic_control");
            this.genSignals = new String[stringArray.length + 1];
            this.genSignals[0] = ResourceControlPropsDlg.this.sigNoSignal;
            int n = 1;
            while (n < this.genSignals.length) {
                this.genSignals[n] = stringArray[n - 1];
                ++n;
            }
            stringArray = ResourceControlPropsDlg.this.tmpRctlValue.getAllSignals("cpu_time_control");
            this.cpuTimeSignals = new String[stringArray.length + 1];
            this.cpuTimeSignals[0] = ResourceControlPropsDlg.this.sigNoSignal;
            int n2 = 1;
            while (n2 < this.cpuTimeSignals.length) {
                this.cpuTimeSignals[n2] = stringArray[n2 - 1];
                ++n2;
            }
            stringArray = ResourceControlPropsDlg.this.tmpRctlValue.getAllSignals("file_size_control");
            this.fileSizeSignals = new String[stringArray.length + 1];
            this.fileSizeSignals[0] = ResourceControlPropsDlg.this.sigNoSignal;
            int n3 = 1;
            while (n3 < this.fileSizeSignals.length) {
                this.fileSizeSignals[n3] = stringArray[n3 - 1];
                ++n3;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ResourceControlPropsDlg.this.isNew || ResourceControlPropsDlg.this.unitsCBox == null || ResourceControlPropsDlg.this.signalCBox == null) {
                return;
            }
            String string = (String)ResourceControlPropsDlg.this.rctlCBox.getSelectedItem();
            if (ResourceControlPropsDlg.this.newRctl.getNumValues() > 0 && !string.equals(ResourceControlPropsDlg.this.newRctl.getName())) {
                JPanel jPanel = new JPanel(ResourceControlPropsDlg.this.gbl);
                Object[] objectArray = new Object[]{ResourceControlPropsDlg.this.newRctl.getName()};
                String string2 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warn_discard_value"), objectArray);
                FlowArea flowArea = new FlowArea(string2, 30);
                flowArea.setMinimumSize(flowArea.getPreferredSize());
                ResourceControlPropsDlg.this.gbc;
                ResourceControlPropsDlg.this.gbc;
                Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                this.saveSet = false;
                this.discardSet = false;
                new WarningDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warn_discard"), jPanel, new ActionListener(this){
                    private final /* synthetic */ RctlNameListener this$1;
                    {
                        this.this$1 = rctlNameListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RctlNameListener.access$3602(this.this$1, true);
                    }
                }, new ActionListener(this){
                    private final /* synthetic */ RctlNameListener this$1;
                    {
                        this.this$1 = rctlNameListener;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RctlNameListener.access$3702(this.this$1, true);
                    }
                }, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning_Save"), ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning_Discard"));
                if (this.saveSet) {
                    ResourceControlPropsDlg.this.rctlCBox.setSelectedItem(ResourceControlPropsDlg.this.newRctl.getName());
                    return;
                }
                if (this.discardSet) {
                    ResourceControlPropsDlg.this.newRctl.removeValues();
                    ResourceControlPropsDlg.this.resourceTable.updateTable();
                    ResourceControlPropsDlg.this.newRctl.setName(string);
                }
            } else {
                ResourceControlPropsDlg.this.newRctl.setName(string);
            }
            this.type = ResourceControlPropsDlg.this.newRctl.getControlType();
            if (this.type.equals("size_control") || this.type.equals("file_size_control")) {
                if (!ResourceControlPropsDlg.this.isSizeType) {
                    ResourceControlPropsDlg.this.unitsCBox.setEnabled(true);
                    ResourceControlPropsDlg.this.unitsCBox.removeAllItems();
                    int n = 0;
                    while (n < ResourceControlPropsDlg.this.sizeUnits.length) {
                        ResourceControlPropsDlg.this.unitsCBox.addItem(ResourceControlPropsDlg.this.sizeUnits[n]);
                        ++n;
                    }
                    ResourceControlPropsDlg.this.unitsCBox.setSelectedIndex(0);
                    ResourceControlPropsDlg.this.isSizeType = true;
                    ResourceControlPropsDlg.this.isTimeType = false;
                }
                if (this.type.equals("file_size_control") && !this.isFileSizeType) {
                    ResourceControlPropsDlg.this.signalCBox.removeAllItems();
                    int n = 0;
                    while (n < this.fileSizeSignals.length) {
                        ResourceControlPropsDlg.this.signalCBox.addItem(this.fileSizeSignals[n]);
                        ++n;
                    }
                    ResourceControlPropsDlg.this.signalCBox.setSelectedIndex(0);
                    this.isFileSizeType = true;
                    this.isCpuTimeType = false;
                }
            } else if (this.type.equals("time_control") || this.type.equals("cpu_time_control")) {
                if (!ResourceControlPropsDlg.this.isTimeType) {
                    ResourceControlPropsDlg.this.unitsCBox.setEnabled(true);
                    ResourceControlPropsDlg.this.unitsCBox.removeAllItems();
                    int n = 0;
                    while (n < ResourceControlPropsDlg.this.timeUnits.length) {
                        ResourceControlPropsDlg.this.unitsCBox.addItem(ResourceControlPropsDlg.this.timeUnits[n]);
                        ++n;
                    }
                    ResourceControlPropsDlg.this.unitsCBox.setSelectedIndex(1);
                    ResourceControlPropsDlg.this.isSizeType = false;
                    ResourceControlPropsDlg.this.isTimeType = true;
                }
                if (this.type == "cpu_time_control" && !this.isCpuTimeType) {
                    ResourceControlPropsDlg.this.signalCBox.removeAllItems();
                    int n = 0;
                    while (n < this.cpuTimeSignals.length) {
                        ResourceControlPropsDlg.this.signalCBox.addItem(this.cpuTimeSignals[n]);
                        ++n;
                    }
                    ResourceControlPropsDlg.this.signalCBox.setSelectedIndex(0);
                    this.isFileSizeType = false;
                    this.isCpuTimeType = true;
                }
            } else {
                if (ResourceControlPropsDlg.this.isTimeType || ResourceControlPropsDlg.this.isSizeType) {
                    ResourceControlPropsDlg.this.unitsCBox.setEnabled(false);
                    ResourceControlPropsDlg.this.unitsCBox.removeAllItems();
                    ResourceControlPropsDlg.this.isSizeType = false;
                    ResourceControlPropsDlg.this.isTimeType = false;
                }
                if (this.isFileSizeType || this.isCpuTimeType) {
                    ResourceControlPropsDlg.this.signalCBox.removeAllItems();
                    int n = 0;
                    while (n < this.genSignals.length) {
                        ResourceControlPropsDlg.this.signalCBox.addItem(this.genSignals[n]);
                        ++n;
                    }
                    ResourceControlPropsDlg.this.signalCBox.setSelectedIndex(0);
                    this.isFileSizeType = false;
                    this.isCpuTimeType = false;
                }
            }
        }

        static /* synthetic */ boolean access$3602(RctlNameListener rctlNameListener, boolean bl) {
            rctlNameListener.saveSet = bl;
            return rctlNameListener.saveSet;
        }

        static /* synthetic */ boolean access$3702(RctlNameListener rctlNameListener, boolean bl) {
            rctlNameListener.discardSet = bl;
            return rctlNameListener.discardSet;
        }
    }

    class MoveListener
    implements ActionListener {
        MoveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ResourceControlPropsDlg.this.resourceTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            ResourceControlPropsDlg.this.tmpRctlValue = ResourceControlPropsDlg.this.newRctl.getValueAt(n);
            if (actionEvent.getSource() == ResourceControlPropsDlg.this.moveUpBtn) {
                if (n < 1) {
                    return;
                }
                ResourceControlPropsDlg.this.newRctl.removeValue(n);
                ResourceControlPropsDlg.this.newRctl.addValue(--n, ResourceControlPropsDlg.this.tmpRctlValue);
                ResourceControlPropsDlg.this.resourceTable.updateTable();
                ResourceControlPropsDlg.this.resourceTable.setRowSelectionInterval(n, n);
                ResourceControlPropsDlg.this.moveUpBtn.setEnabled(n > 0);
            } else {
                if (n < 0 || n >= ResourceControlPropsDlg.this.resourceTable.getRowCount() - 1) {
                    return;
                }
                ResourceControlPropsDlg.this.newRctl.removeValue(n);
                ResourceControlPropsDlg.this.newRctl.addValue(++n, ResourceControlPropsDlg.this.tmpRctlValue);
                ResourceControlPropsDlg.this.resourceTable.updateTable();
                ResourceControlPropsDlg.this.resourceTable.setRowSelectionInterval(n, n);
                ResourceControlPropsDlg.this.moveDownBtn.setEnabled(n >= 0 && n < ResourceControlPropsDlg.this.resourceTable.getRowCount() - 1);
            }
            ResourceControlPropsDlg.this.setButtonsEnabled();
        }
    }

    class ClearBtnListener
    implements ActionListener {
        ClearBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceControlPropsDlg.this.clearForm();
            ResourceControlPropsDlg.this.setButtonsEnabled();
        }
    }

    class UpdateBtnListener
    implements ActionListener {
        UpdateBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ResourceControlPropsDlg.this.isFormDataOK()) {
                ResourceControlPropsDlg.this.errorDlg = new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"er_rctl_values"));
                return;
            }
            ResourceControlValue resourceControlValue = ResourceControlPropsDlg.this.getRctlValueFromInput();
            if (resourceControlValue == null) {
                return;
            }
            int n = ResourceControlPropsDlg.this.resourceTable.getSelectedRow();
            int n2 = ResourceControlPropsDlg.this.indexOf(resourceControlValue);
            if (n2 >= 0 && n2 != n) {
                ResourceControlPropsDlg.this.errorDlg = new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"er_rctl_equal_thresholds"));
                return;
            }
            ResourceControlPropsDlg.this.newRctl.setValueAt(n, resourceControlValue);
            ResourceControlPropsDlg.this.resourceTable.updateTable();
            ResourceControlPropsDlg.this.resourceTable.setRowSelectionInterval(n, n);
            ResourceControlPropsDlg.this.clearForm();
            ResourceControlPropsDlg.this.setButtonsEnabled();
        }
    }

    class DeleteBtnListener
    implements ActionListener {
        DeleteBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceControlPropsDlg.this.newRctl.removeValue(ResourceControlPropsDlg.this.resourceTable.getSelectedRow());
            ResourceControlPropsDlg.this.resourceTable.updateTable();
            ResourceControlPropsDlg.this.clearForm();
            ResourceControlPropsDlg.this.setButtonsEnabled();
        }
    }

    class AddBtnListener
    implements ActionListener {
        AddBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ResourceControlPropsDlg.this.isFormDataOK()) {
                ResourceControlPropsDlg.this.errorDlg = new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"er_rctl_values"));
                return;
            }
            ResourceControlValue resourceControlValue = ResourceControlPropsDlg.this.getRctlValueFromInput();
            if (resourceControlValue == null) {
                return;
            }
            int n = ResourceControlPropsDlg.this.indexOf(resourceControlValue);
            if (n >= 0) {
                ResourceControlPropsDlg.this.errorDlg = new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"er_rctl_equal_thresholds"));
                return;
            }
            ResourceControlPropsDlg.this.newRctl.addValue(0, resourceControlValue);
            ResourceControlPropsDlg.this.resourceTable.updateTable();
            ResourceControlPropsDlg.this.clearForm();
            ResourceControlPropsDlg.this.setButtonsEnabled();
        }
    }

    class OKCancelBtnListener
    implements ActionListener {
        private boolean doOk = true;
        private boolean ignoreUnsaved = true;

        OKCancelBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == ResourceControlPropsDlg.this.okBtn) {
                    Object[] objectArray;
                    int n;
                    JPanel jPanel;
                    Object object;
                    ActionListener actionListener;
                    if (!ResourceControlPropsDlg.this.resourceTable.isSyntaxOK()) {
                        return;
                    }
                    if (ResourceControlPropsDlg.this.isNew) {
                        ResourceControlPropsDlg.this.newRctl.setName((String)ResourceControlPropsDlg.this.rctlCBox.getSelectedItem());
                    }
                    if (ResourceControlPropsDlg.this.isInputUnsaved()) {
                        actionListener = new ActionListener(this){
                            private final /* synthetic */ OKCancelBtnListener this$1;
                            {
                                this.this$1 = oKCancelBtnListener;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                OKCancelBtnListener.access$2302(this.this$1, true);
                            }
                        };
                        object = new ActionListener(this){
                            private final /* synthetic */ OKCancelBtnListener this$1;
                            {
                                this.this$1 = oKCancelBtnListener;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                OKCancelBtnListener.access$2302(this.this$1, false);
                            }
                        };
                        jPanel = new JPanel(ResourceControlPropsDlg.this.gbl);
                        n = 30;
                        objectArray = new Object[]{ResourceControlPropsDlg.this.rctlDlg.getTitle()};
                        String string = MessageFormat.format(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warn_unsaved_value"), objectArray);
                        FlowArea flowArea = new FlowArea(string, n);
                        flowArea.setMinimumSize(flowArea.getPreferredSize());
                        ResourceControlPropsDlg.this.gbc;
                        ResourceControlPropsDlg.this.gbc;
                        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                        new WarningDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning"), jPanel, actionListener, (ActionListener)object, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning_OK"));
                        if (!this.ignoreUnsaved) {
                            return;
                        }
                    }
                    if (!ResourceControlPropsDlg.this.isNew && ResourceControlPropsDlg.this.newRctl.getNumValues() == 0) {
                        actionListener = new ActionListener(this){
                            private final /* synthetic */ OKCancelBtnListener this$1;
                            {
                                this.this$1 = oKCancelBtnListener;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                OKCancelBtnListener.access$2602(this.this$1, true);
                                ResourceControlPropsDlg.access$000(OKCancelBtnListener.access$2700(this.this$1)).dispose();
                            }
                        };
                        object = new ActionListener(this){
                            private final /* synthetic */ OKCancelBtnListener this$1;
                            {
                                this.this$1 = oKCancelBtnListener;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                OKCancelBtnListener.access$2602(this.this$1, false);
                            }
                        };
                        jPanel = new JPanel(ResourceControlPropsDlg.this.gbl);
                        n = 30;
                        objectArray = new FlowArea(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"sure_delete_rctl"), n);
                        objectArray.setMinimumSize(objectArray.getPreferredSize());
                        ResourceControlPropsDlg.this.gbc;
                        ResourceControlPropsDlg.this.gbc;
                        Constraints.constrain((Container)jPanel, (Component)objectArray, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                        objectArray = new FlowArea(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"deleting_rctl"), n);
                        objectArray.setMinimumSize(objectArray.getPreferredSize());
                        ResourceControlPropsDlg.this.gbc;
                        ResourceControlPropsDlg.this.gbc;
                        Constraints.constrain((Container)jPanel, (Component)objectArray, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                        objectArray = new FlowArea(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"removes_entry_rctl"), n);
                        objectArray.setMinimumSize(objectArray.getPreferredSize());
                        ResourceControlPropsDlg.this.gbc;
                        ResourceControlPropsDlg.this.gbc;
                        Constraints.constrain((Container)jPanel, (Component)objectArray, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                        new WarningDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning_rctl"), jPanel, actionListener, (ActionListener)object, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning_delete"));
                    } else if (ResourceControlPropsDlg.this.isNew && ResourceControlPropsDlg.this.newRctl.getNumValues() == 0) {
                        actionListener = new ActionListener(this){
                            private final /* synthetic */ OKCancelBtnListener this$1;
                            {
                                this.this$1 = oKCancelBtnListener;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                ResourceControlPropsDlg.access$2802(OKCancelBtnListener.access$2700(this.this$1), false);
                                ResourceControlPropsDlg.access$000(OKCancelBtnListener.access$2700(this.this$1)).dispose();
                            }
                        };
                        object = new JPanel(ResourceControlPropsDlg.this.gbl);
                        int n2 = 30;
                        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warn_no_value"), n2);
                        flowArea.setMinimumSize(flowArea.getPreferredSize());
                        ResourceControlPropsDlg.this.gbc;
                        ResourceControlPropsDlg.this.gbc;
                        Constraints.constrain((Container)object, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
                        new WarningDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning"), (JPanel)object, actionListener, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"warning_OK"));
                        this.doOk = false;
                    }
                    if (this.doOk) {
                        ResourceControlPropsDlg.this.isOkClicked = true;
                        ResourceControlPropsDlg.this.rctlDlg.dispose();
                    }
                } else {
                    ResourceControlPropsDlg.this.isOkClicked = false;
                    ResourceControlPropsDlg.this.rctlDlg.dispose();
                }
            }
            catch (Exception exception) {
                ResourceControlPropsDlg.this.errorDlg = new ErrorDialog(null, exception.getLocalizedMessage());
            }
        }

        static /* synthetic */ boolean access$2302(OKCancelBtnListener oKCancelBtnListener, boolean bl) {
            oKCancelBtnListener.ignoreUnsaved = bl;
            return oKCancelBtnListener.ignoreUnsaved;
        }

        static /* synthetic */ boolean access$2602(OKCancelBtnListener oKCancelBtnListener, boolean bl) {
            oKCancelBtnListener.doOk = bl;
            return oKCancelBtnListener.doOk;
        }

        static /* synthetic */ ResourceControlPropsDlg access$2700(OKCancelBtnListener oKCancelBtnListener) {
            return oKCancelBtnListener.ResourceControlPropsDlg.this;
        }
    }

    class ResourceTable
    extends JTable {
        private ResourceTable table;
        private ResourceDataTableModel model;
        private ResourceControlValue rctlValue;
        private ArrayList valueChangeListeners = new ArrayList();

        public ResourceTable() {
            this.table = this;
            this.table.setLayout(new GridBagLayout());
            this.model = new ResourceDataTableModel();
            this.table.setAutoCreateColumnsFromModel(false);
            this.table.setModel(this.model);
            this.table.setShowGrid(true);
            this.table.setAutoResizeMode(4);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.setSelectionMode(0);
            TableColumn tableColumn = new TableColumn(0);
            tableColumn = this.model.setUpColumn(tableColumn, 0);
            this.table.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn = this.model.setUpColumn(tableColumn, 1);
            this.table.addColumn(tableColumn);
            tableColumn = new TableColumn(2);
            tableColumn = this.model.setUpColumn(tableColumn, 2);
            this.table.addColumn(tableColumn);
            tableColumn = new TableColumn(3);
            tableColumn = this.model.setUpColumn(tableColumn, 3);
            this.table.addColumn(tableColumn);
            this.table.addMouseListener(new MouseListener(this){
                private final /* synthetic */ ResourceTable this$1;
                {
                    this.this$1 = resourceTable;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        ResourceTable.access$100(this.this$1);
                        ResourceControlPropsDlg.access$300(ResourceTable.access$200(this.this$1));
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            this.model.fireTableDataChanged();
        }

        public JTable getResourceTable() {
            return this.table;
        }

        public void updateTable() {
            this.model.updateModel();
        }

        public boolean isSyntaxOK() {
            String string = ResourceControlPropsDlg.this.newRctl.getControlType();
            ArrayList<ResourceControlValue> arrayList = new ArrayList<ResourceControlValue>(this.getRowCount());
            int n = 0;
            while (n < this.getRowCount()) {
                try {
                    String string2;
                    String string3 = (String)this.getValueAt(n, 0);
                    ResourceControlValue resourceControlValue = new ResourceControlValue();
                    resourceControlValue.setThreshold(string3, string);
                    String string4 = (String)this.getValueAt(n, 1);
                    if (string4.equals(ResourceControlPropsDlg.this.privBasic)) {
                        string4 = "basic";
                    } else if (string4.equals(ResourceControlPropsDlg.this.privPrivileged)) {
                        string4 = "priv";
                    }
                    resourceControlValue.validatePrivilege(string4);
                    resourceControlValue.setPrivilege(string4);
                    String string5 = (String)this.getValueAt(n, 3);
                    if (!string5.equals(ResourceControlPropsDlg.this.actNoAction) && !string5.equals(ResourceControlPropsDlg.this.actDeny)) {
                        resourceControlValue.validateAction(string5);
                    }
                    if (!(string2 = (String)this.getValueAt(n, 2)).equals(ResourceControlPropsDlg.this.sigNoSignal)) {
                        resourceControlValue.validateSignal(string2, string);
                    }
                    resourceControlValue.setControlType(string);
                    arrayList.add(resourceControlValue);
                }
                catch (Exception exception) {
                    ResourceControlPropsDlg.this.errorDlg = new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"er_rctl_table"));
                    return false;
                }
                ++n;
            }
            return true;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (this.table == null) {
                return;
            }
            this.updateFields();
            if (this.valueChangeListeners == null) {
                return;
            }
            int n = 0;
            while (n < this.valueChangeListeners.size()) {
                ListSelectionListener listSelectionListener = (ListSelectionListener)this.valueChangeListeners.get(n);
                listSelectionListener.valueChanged(listSelectionEvent);
                ++n;
            }
        }

        public synchronized void addSelectionListener(ListSelectionListener listSelectionListener) {
            this.valueChangeListeners.add(listSelectionListener);
        }

        public synchronized void removeSelectionListener(ListSelectionListener listSelectionListener) {
            this.valueChangeListeners.remove(listSelectionListener);
        }

        private void updateFields() {
            if (this.table == null) {
                return;
            }
            int n = this.table.getSelectedRow();
            if (n >= 0) {
                ResourceControlValue resourceControlValue = ResourceControlPropsDlg.this.newRctl.getValueAt(n);
                if (resourceControlValue == null) {
                    return;
                }
                ResourceControlPropsDlg.this.threshField.setText(resourceControlValue.getThreshold().toString());
                ResourceControlPropsDlg.this.unitsCBox.setSelectedItem(resourceControlValue.getThresholdUnits());
                ResourceControlPropsDlg.this.privCBox.setSelectedItem(this.getValueAt(n, 1));
                ResourceControlPropsDlg.this.signalCBox.setSelectedItem(this.getValueAt(n, 2));
                ResourceControlPropsDlg.this.actionCBox.setSelectedItem(this.getValueAt(n, 3));
            }
        }

        static /* synthetic */ void access$100(ResourceTable resourceTable) {
            resourceTable.updateFields();
        }

        class ColumnData {
            private String title;
            private int width;
            private int align;
            private boolean editable;
            private DefaultTableCellRenderer renderer;
            private DefaultCellEditor editor;

            public ColumnData(String string, int n, int n2, boolean bl) {
                this.title = string;
                this.width = n;
                this.align = n2;
                this.editable = bl;
                this.renderer = new DefaultTableCellRenderer();
                this.renderer.setHorizontalAlignment(n2);
                this.renderer.setBorder(new EmptyBorder(0, 3, 0, 3));
                this.editor = new DefaultCellEditor(new JTextField(""));
            }

            public String getTitle() {
                return this.title;
            }

            public int getWidth() {
                return this.width;
            }

            public int getAlignment() {
                return this.align;
            }

            public boolean isEditable() {
                return this.editable;
            }

            public DefaultTableCellRenderer getRenderer() {
                return this.renderer;
            }

            public DefaultCellEditor getEditor() {
                return this.editor;
            }
        }

        class ResourceDataTableModel
        extends AbstractTableModel {
            public static final int NUM_COLS = 4;
            public static final int THRESHOLD_COL = 0;
            public static final int PRIV_COL = 1;
            public static final int SIGNAL_COL = 2;
            public static final int ACTION_COL = 3;
            private ArrayList resourceValues;
            private ColumnData[] columnData = new ColumnData[4];

            public ResourceDataTableModel() {
                this.columnData[0] = new ColumnData(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"proj_rctl_thresh_col"), 0, 4, false);
                this.columnData[1] = new ColumnData(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"proj_rctl_priv_col"), 0, 2, true);
                this.columnData[2] = new ColumnData(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"proj_rctl_signal_col"), 0, 2, true);
                this.columnData[3] = new ColumnData(ResourceStrings.getString((ResourceBundle)ResourceControlPropsDlg.this.bundle, (String)"proj_rctl_action_col"), 0, 2, true);
                if (ResourceControlPropsDlg.this.newRctl == null) {
                    return;
                }
                this.resourceValues = ResourceControlPropsDlg.this.newRctl.getValues();
            }

            public void updateModel() {
                if (ResourceControlPropsDlg.this.newRctl == null) {
                    return;
                }
                this.resourceValues = ResourceControlPropsDlg.this.newRctl.getValues();
                this.fireTableDataChanged();
            }

            public int getColumnCount() {
                return this.resourceValues == null ? 0 : 4;
            }

            public int getRowCount() {
                return this.resourceValues == null ? 0 : this.resourceValues.size();
            }

            public TableColumn setUpColumn(TableColumn tableColumn, int n) {
                if (n < 0 || n >= this.getColumnCount()) {
                    return tableColumn;
                }
                tableColumn.setHeaderValue(this.columnData[n].getTitle());
                tableColumn.setCellRenderer(this.columnData[n].getRenderer());
                tableColumn.setCellEditor(this.columnData[n].getEditor());
                tableColumn.setMinWidth(tableColumn.getPreferredWidth());
                return tableColumn;
            }

            public ColumnData getColumnData(int n) {
                if (n < 0 || n >= this.getColumnCount()) {
                    return null;
                }
                return this.columnData[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public Object getValueAt(int n, int n2) {
                if (this.resourceValues == null || this.resourceValues.size() == 0 || n < 0 || n >= this.getRowCount()) {
                    return "";
                }
                ResourceTable.this.rctlValue = (ResourceControlValue)this.resourceValues.get(n);
                if (ResourceTable.this.rctlValue == null) {
                    return "";
                }
                switch (n2) {
                    case 0: {
                        return ResourceTable.this.rctlValue.getThresholdStr();
                    }
                    case 1: {
                        String string = ResourceTable.this.rctlValue.getPrivilege();
                        if (string == "basic") {
                            return ResourceControlPropsDlg.this.privBasic;
                        }
                        return ResourceControlPropsDlg.this.privPrivileged;
                    }
                    case 2: {
                        if (ResourceTable.this.rctlValue.getSignal().equals("")) {
                            return ResourceControlPropsDlg.this.sigNoSignal;
                        }
                        return ResourceTable.this.rctlValue.getSignalStr();
                    }
                    case 3: {
                        String string = ResourceTable.this.rctlValue.getAction();
                        if (string.equals("") || string == "none") {
                            return ResourceControlPropsDlg.this.actNoAction;
                        }
                        return ResourceControlPropsDlg.this.actDeny;
                    }
                }
                return "";
            }

            public void setValueAt(Object object, int n, int n2) {
                if (n < 0 || n >= this.getRowCount()) {
                    return;
                }
                ResourceTable.this.rctlValue = (ResourceControlValue)this.resourceValues.get(n);
                switch (n2) {
                    case 0: {
                        try {
                            ResourceTable.this.rctlValue.setThreshold((String)object, ResourceControlPropsDlg.this.newRctl.getControlType());
                        }
                        catch (Exception exception) {
                            ResourceControlValue resourceControlValue = ResourceTable.this.rctlValue;
                            ResourceTable.this.rctlValue;
                            resourceControlValue.setThreshold(ResourceControlValue.MIN_VALUE);
                        }
                        break;
                    }
                    case 1: {
                        ResourceTable.this.rctlValue.setPrivilege((String)object);
                        break;
                    }
                    case 2: {
                        ResourceTable.this.rctlValue.setSignal((String)object);
                        break;
                    }
                    case 3: {
                        ResourceTable.this.rctlValue.setAction((String)object);
                    }
                }
            }

            public void printTable() {
                System.out.println("\nResource Data Table:\n");
                if (this.resourceValues == null) {
                    return;
                }
                int n = 0;
                while (n < this.resourceValues.size()) {
                    ResourceTable.this.rctlValue = (ResourceControlValue)this.resourceValues.get(n);
                    System.out.print("\tRow " + n + ": ");
                    System.out.println(ResourceTable.this.rctlValue.toString());
                    ++n;
                }
                System.out.println();
            }
        }
    }
}

