/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.projmgr.common.ResourceControl;
import com.sun.admin.projmgr.common.ResourceControlValue;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class ResourceControlDisplay {
    private ResourceBundle bundle;
    private String strBasic;
    private String strPriv;
    private String strNoAction;
    private String strNoSignal;
    private String strDeny;
    private String strThreshTT;
    private String strPrivTT;
    private String strSignalTT;
    private String strActionTT;
    private String strDelim;
    private static final String OPEN_PAREN = "(";
    private static final String CLOSE_PAREN = ")";
    private static final String HTML_START = "<html>";
    private static final String HTML_END = "</html>";
    private static final String BOLD_START = "<b>";
    private static final String BOLD_END = "</b>";
    private static final String BREAK = "<p>";

    public ResourceControlDisplay(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
        this.strBasic = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_basic");
        this.strPriv = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_priv");
        this.strNoAction = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_noaction");
        this.strNoSignal = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_nosignal");
        this.strDeny = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_deny");
        this.strThreshTT = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_thresh_tooltip");
        this.strPrivTT = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_priv_tooltip");
        this.strSignalTT = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_signal_tooltip");
        this.strActionTT = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_action_tooltip");
        this.strDelim = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"proj_delim_tooltip") + " ";
    }

    public String getRctlDisplayString(ResourceControl resourceControl) {
        StringBuffer stringBuffer = new StringBuffer(resourceControl.getName());
        stringBuffer.append("=");
        stringBuffer.append(this.getRctlValuesDisplayString(resourceControl.getValues()));
        return stringBuffer.toString();
    }

    public String getRctlValuesDisplayString(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < arrayList.size()) {
            stringBuffer.append(this.getRctlValueDisplayString((ResourceControlValue)arrayList.get(n)));
            stringBuffer.append(",");
            ++n;
        }
        return stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1).toString() : "";
    }

    public String getRctlValueDisplayString(ResourceControlValue resourceControlValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OPEN_PAREN);
        stringBuffer.append(resourceControlValue.getThresholdStr()).append(this.strDelim);
        stringBuffer.append(resourceControlValue.getPrivilege() == "basic" ? this.strBasic : this.strPriv);
        stringBuffer.append(this.strDelim);
        stringBuffer.append(resourceControlValue.getSignal().equals("") ? this.strNoSignal : resourceControlValue.getSignalStr());
        stringBuffer.append(this.strDelim);
        String string = resourceControlValue.getAction();
        stringBuffer.append(string.equals("") || string == "none" ? this.strNoAction : this.strDeny);
        stringBuffer.append(CLOSE_PAREN);
        return stringBuffer.toString();
    }

    public String getToolTipStr(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HTML_START);
        int n = 0;
        while (n < arrayList.size()) {
            ResourceControlValue resourceControlValue = (ResourceControlValue)arrayList.get(n);
            stringBuffer.append(BOLD_START).append(this.strThreshTT).append(BOLD_END);
            stringBuffer.append(" ").append(resourceControlValue.getThresholdStr());
            stringBuffer.append(this.strDelim);
            stringBuffer.append(BOLD_START).append(this.strPrivTT).append(BOLD_END);
            stringBuffer.append(" ");
            stringBuffer.append(resourceControlValue.getPrivilege() == "basic" ? this.strBasic : this.strPriv);
            stringBuffer.append(this.strDelim);
            stringBuffer.append(BOLD_START).append(this.strSignalTT).append(BOLD_END);
            stringBuffer.append(" ");
            stringBuffer.append(resourceControlValue.getSignal().equals("") ? this.strNoSignal : resourceControlValue.getSignalStr());
            stringBuffer.append(this.strDelim);
            stringBuffer.append(BOLD_START).append(this.strActionTT).append(BOLD_END);
            stringBuffer.append(" ");
            String string = resourceControlValue.getAction();
            stringBuffer.append(string.equals("") || string == "none" ? this.strNoAction : this.strDeny);
            if (n + 1 < arrayList.size()) {
                stringBuffer.append(BREAK);
            }
            ++n;
        }
        stringBuffer.append(HTML_END);
        return stringBuffer.toString();
    }
}

