/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.projmgr.client.Content;
import com.sun.admin.projmgr.client.PropsDlg;
import com.sun.admin.projmgr.client.ServiceWrapper;
import com.sun.admin.projmgr.client.TreeNodeData;
import com.sun.admin.projmgr.client.UserMgrUtility;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.admin.projmgr.common.ProjectObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;

public class ProjectContent
extends Content {
    private ResourceBundle bundle;
    private ImageIcon smallProjIcon;
    private ImageIcon largeProjIcon;
    private ProjectContent projectContent = this;
    private static String[][] columnHeaders = null;

    public ProjectContent(VProjMgr vProjMgr) {
        super(vProjMgr);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)vProjMgr.getMenuBar());
        this.rootNode.setToolBar((JToolBar)vProjMgr.getToolBar());
        this.bundle = vProjMgr.getResourceBundle();
        this.sortPreferencesKey = this.getClass().getName() + ".sortPreferences";
        this.smallProjIcon = vProjMgr.loadImageIcon("finalprojects_16b.gif");
        this.largeProjIcon = vProjMgr.loadImageIcon("finalprojects_32c.gif");
    }

    public void createProperties() {
        Thread thread = new Thread(){

            public void run() {
                ProjectContent.this.theApp.waitOn();
                PropsDlg propsDlg = new PropsDlg(ProjectContent.this.theApp, null, ProjectContent.this.projectContent, 1);
                propsDlg.show();
                ProjectContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void cloneProperties() {
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                ProjectContent.this.theApp.waitOn();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                ProjectObj projectObj = (ProjectObj)vScopeNode.getPayload();
                projectObj = ProjectContent.this.populateMembers(projectObj);
                ArrayList arrayList = projectObj.getUnrecognizedAttributes();
                if (arrayList.size() > 0) {
                    ProjectContent.this.showUnrecognizedAttrDlg(projectObj.getProjectName(), arrayList);
                }
                PropsDlg propsDlg = new PropsDlg(ProjectContent.this.theApp, projectObj, ProjectContent.this.projectContent, 2);
                propsDlg.show();
                ProjectContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void viewProperties() {
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                ProjectContent.this.theApp.waitOn();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                ProjectObj projectObj = (ProjectObj)vScopeNode.getPayload();
                projectObj = ProjectContent.this.populateMembers(projectObj);
                ArrayList arrayList = projectObj.getUnrecognizedAttributes();
                if (arrayList != null && arrayList.size() > 0) {
                    ProjectContent.this.showUnrecognizedAttrDlg(projectObj.getProjectName(), arrayList);
                }
                PropsDlg propsDlg = new PropsDlg(ProjectContent.this.theApp, projectObj, ProjectContent.this.projectContent, 0);
                propsDlg.show();
                ProjectContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    private ProjectObj populateMembers(ProjectObj projectObj) {
        try {
            projectObj = this.theApp.getProjMgr().getAllMembers(projectObj);
            String[] stringArray = projectObj.getProjectUsers();
            int n = Array.getLength(stringArray);
            if (n == 0) {
                projectObj.setProjectUsers(new String[0]);
                projectObj.setProjectRoles(new String[0]);
                return projectObj;
            }
            UserMgrUtility userMgrUtility = new UserMgrUtility(this.theApp);
            Vector vector = userMgrUtility.getRoleNames(null);
            int n2 = vector.size();
            if (n2 == 0) {
                projectObj.setProjectRoles(new String[0]);
                return projectObj;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n2);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                arrayList.add(string);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            int n3 = 0;
            while (n3 < n) {
                if (arrayList.contains(stringArray[n3])) {
                    arrayList3.add(stringArray[n3]);
                } else {
                    arrayList2.add(stringArray[n3]);
                }
                ++n3;
            }
            int n4 = arrayList3.size();
            String[] stringArray2 = new String[n4];
            int n5 = 0;
            while (n5 < n4) {
                stringArray2[n5] = (String)arrayList3.get(n5);
                ++n5;
            }
            int n6 = arrayList2.size();
            String[] stringArray3 = new String[n6];
            int n7 = 0;
            while (n7 < n6) {
                stringArray3[n7] = (String)arrayList2.get(n7);
                ++n7;
            }
            projectObj.setProjectUsers(stringArray3);
            projectObj.setProjectRoles(stringArray2);
        }
        catch (AdminException adminException) {
            this.theApp.reportErrorException((Exception)((Object)adminException));
        }
        return projectObj;
    }

    private void showUnrecognizedAttrDlg(String string, ArrayList arrayList) {
        final String string2 = string;
        final ArrayList arrayList2 = arrayList;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < arrayList2.size()) {
                    stringBuffer.append((String)arrayList2.get(n)).append("\n");
                    ++n;
                }
                Object[] objectArray = new Object[]{string2, stringBuffer.toString()};
                String string = MessageFormat.format(ResourceStrings.getString((ResourceBundle)ProjectContent.this.bundle, (String)"warn_rctl_list"), objectArray);
                new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)ProjectContent.this.bundle, (String)"details_title"), string, true);
            }
        };
        JPanel jPanel = new JPanel(new GridBagLayout());
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warn_rctl"), objectArray);
        FlowArea flowArea = new FlowArea(string3, 30);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
        new WarningDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning"), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_details"));
    }

    public void deleteSelected() {
        if (!this.theApp.getProjMgr().hasWriteAuthorization()) {
            return;
        }
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 30;
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"sure_delete_project"), n);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"deleting_project"), n);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
        flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"removes_entry_project"), n);
        flowArea.setSize(flowArea.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)2, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)5);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$400(this.this$1).theApp.waitOn();
                        int n = 0;
                        while (n < 5.access$500(this.this$1).size()) {
                            try {
                                VScopeNode vScopeNode = (VScopeNode)5.access$500(this.this$1).elementAt(n);
                                ProjectObj projectObj = (ProjectObj)vScopeNode.getPayload();
                                5.access$400(this.this$1).theApp.getProjMgr().deleteProject(projectObj);
                                ProjectContent.access$600(5.access$400(this.this$1), projectObj);
                            }
                            catch (Exception exception) {
                                5.access$400(this.this$1).theApp.reportErrorException(exception);
                            }
                            ++n;
                        }
                        5.access$400(this.this$1).setSelected(new Vector<E>());
                        5.access$400(this.this$1).theApp.waitOff();
                    }
                };
                thread.start();
            }

            static /* synthetic */ ProjectContent access$400(5 var0) {
                return var0.ProjectContent.this;
            }

            static /* synthetic */ Vector access$500(5 var0) {
                return var0.vector;
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"warning_project"), jPanel, actionListener, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"warning_delete"));
    }

    public String whatAmI() {
        return "projectMgr";
    }

    public String[][] getColumnHeaders() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        Object[][] objectArray = new Object[][]{{ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"table_proj_id"), new Integer(20016)}, {ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"table_proj_desc"), new Integer(64)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ProjectObj projectObj) {
        String string;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        if ((string = columnHeaders[n++][0]) != null) {
            try {
                Integer n2 = new Integer(projectObj.getProjectID());
                hashtable.put(string, n2);
            }
            catch (Exception exception) {
                hashtable.put(string, projectObj.getProjectID());
            }
        }
        if ((string = columnHeaders[n++][0]) != null) {
            hashtable.put(string, projectObj.getProjectDescription());
        }
        return hashtable;
    }

    public void refresh() {
        this.theApp.setAllUsersCache(null);
        this.theApp.setAllGroupsCache(null);
        this.theApp.setAllRolesCache(null);
        this.vDataCache.removeAllElements();
        System.gc();
        final ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        this.clear(false);
        this.theApp.setInfoBar("");
        int n = this.getDisplayChunkSize();
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), n);
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"getting_projects");
        if (this.treeNode.getResultPane() == null) {
            this.treeNode.setResultPane((Component)new VBusyPanel(string));
            this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode));
        }
        this.theApp.setStatusBar(string);
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updateprogress", null));
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                ProjectContent.this.treeNode.setResultPane(null);
                ProjectContent.this.theApp.fireConsoleAction(new VConsoleEvent((Object)ProjectContent.this.theApp, "vconsole.updatescope", (Object)ProjectContent.this.treeNode));
                if (vector == null) {
                    ProjectContent.this.theApp.setStatusBar(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"getting_projects_done"));
                    ProjectContent.this.updateInfoBar();
                    ProjectContent.this.theApp.fireConsoleAction(new VConsoleEvent((Object)ProjectContent.this.theApp, "vconsole.updateprogress", null));
                    ProjectContent.this.theApp.waitOff();
                    return;
                }
                ProjectContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                ProjectContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        myListFetch.start();
        this.bRefresh = true;
    }

    public void appendToResultsPane(Vector vector) {
        ProjectObj projectObj;
        String string = this.treeNode.getHTMLText();
        int n = 0;
        while (n < vector.size()) {
            projectObj = (ProjectObj)vector.elementAt(n);
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.theApp.getMenuBar().getPopupMenu(), this.smallProjIcon, this.largeProjIcon, projectObj.getProjectName(), null, null, -1, (Object)projectObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setColumnValues(ProjectContent.getColumnValues(projectObj));
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(projectObj);
            ++n;
        }
        projectObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
        this.fireConsoleActionFromAWTThread((VConsoleEvent)projectObj);
    }

    private void removeFromResultsPane(ProjectObj projectObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            ProjectObj projectObj2 = (ProjectObj)vScopeNode.getPayload();
            if (projectObj2 == projectObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.fireConsoleActionFromAWTThread(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        this.rootNode.removeAllChildren();
        System.gc();
        if (this.treeNode.getInternalRoot() == null) {
            this.treeNode.setInternalRoot(this.rootNode);
        }
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.fireConsoleActionFromAWTThread(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public void updateInfoBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"projectContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setInfoBar(string2);
    }

    public void updateDefaultColumns() {
    }

    private int getServerChunkSize() {
        return 0;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    private void fireConsoleActionFromAWTThread(VConsoleEvent vConsoleEvent) {
        final VConsoleEvent vConsoleEvent2 = vConsoleEvent;
        if (EventQueue.isDispatchThread()) {
            this.theApp.fireConsoleAction(vConsoleEvent2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ProjectContent.this.theApp.fireConsoleAction(vConsoleEvent2);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ void access$600(ProjectContent projectContent, ProjectObj projectObj) {
        projectContent.removeFromResultsPane(projectObj);
    }

    class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper projMgr;
        ProjectObj projObj = null;

        public MyListFetch(int n, int n2) {
            super(n, n2);
            this.projMgr = ProjectContent.this.theApp.getProjMgr();
            TreeNodeData treeNodeData = (TreeNodeData)ProjectContent.this.treeNode.getPayload();
            this.projObj = treeNodeData.getProjectObj();
        }

        public Vector listAll() throws AdminException {
            return this.projMgr.getAllProjects();
        }

        public void listTrace(String string) {
            ProjectContent.this.theApp.Trace(string);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)ProjectContent.this.theApp.getResourceBundle(), (String)"BEANNAME");
        }
    }
}

