/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.projmgr.client.Content;
import com.sun.admin.projmgr.client.ContentEvent;
import com.sun.admin.projmgr.client.ContentListener;
import com.sun.admin.projmgr.client.NavigationSelectionListener;
import com.sun.admin.projmgr.client.ProjectActionsListener;
import com.sun.admin.projmgr.client.TreeNodeData;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class MainToolBar
extends JToolBar
implements PropertyChangeListener {
    private ContentListener contentListener;
    private Content content;
    private VProjMgr theApp;
    private ResourceBundle bundle;
    private ToolBarButton tbNew;
    private final int groupGap = 9;
    ProjectActionsListener buttonClickListener;
    private ImageIcon newProjectIcon;
    private static String NEW_PROJ_TEXT;
    private Insets textMargin = new Insets(0, 2, 0, 2);

    public MainToolBar(VProjMgr vProjMgr) {
        this.theApp = vProjMgr;
        this.bundle = vProjMgr.getResourceBundle();
        this.buttonClickListener = new ProjectActionsListener(vProjMgr);
        NEW_PROJ_TEXT = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"tbar_addProj");
        this.setLayout(new GridBagLayout());
        this.tbNew = new ToolBarButton("tbar_addProj", "finalprojects_toolbar", "NewProject");
        Constraints.constrain((Container)this, (Component)this.tbNew, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)1.0, (int)0, (int)5, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                MainToolBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        vProjMgr.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                if (MainToolBar.this.content != null) {
                    MainToolBar.this.content.removeContentListener(MainToolBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                MainToolBar.this.content = treeNodeData.getContent();
                MainToolBar.this.content.addContentListener(MainToolBar.this.contentListener);
                MainToolBar.this.configureForContent();
                MainToolBar.this.notifySelectionChange(MainToolBar.this.content.getNumSelections());
            }

            public void toolStopped() {
            }

            public void toolDestroyed() {
            }
        });
        this.newProjectIcon = vProjMgr.loadImageIcon("finalprojects_toolbar.gif");
    }

    private void configureForContent() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        if (!this.theApp.getProjMgr().hasWriteAuthorization()) {
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
        }
        this.tbNew.setEnabled(this.theApp.getProjMgr().hasWriteAuthorization());
    }

    private void notifySelectionChange(int n) {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        if (n == 1) {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
        } else {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "false");
        }
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        vConsoleProperties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        if (!this.theApp.getProjMgr().hasWriteAuthorization()) {
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
            this.tbNew.setEnabled(false);
        }
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        if (vConsoleProperties != null) {
            this.setButtonDisplay(vConsoleProperties.getProperty("vconsole.buttondisplay"));
            vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setButtonDisplay(String string) {
        if (string.equals("vconsole.textonly")) {
            this.installString(this.tbNew, NEW_PROJ_TEXT);
            this.installIcon(this.tbNew, null);
        } else if (string.equals("vconsole.icononly")) {
            this.installString(this.tbNew, null);
            this.installIcon(this.tbNew, this.newProjectIcon);
        } else if (string.equals("vconsole.textandicon")) {
            this.installString(this.tbNew, NEW_PROJ_TEXT);
            this.installIcon(this.tbNew, this.newProjectIcon);
        }
    }

    private void installString(AbstractButton abstractButton, String string) {
        if (abstractButton != null) {
            abstractButton.setFont(ResourceManager.bodyFont);
            abstractButton.setText(string);
            this.setMargin(null);
        }
    }

    private void installIcon(AbstractButton abstractButton, ImageIcon imageIcon) {
        if (abstractButton != null) {
            abstractButton.setIcon(imageIcon);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.buttondisplay")) {
            this.setButtonDisplay(this.theApp.getProperties().getProperty("vconsole.buttondisplay"));
        }
    }

    class ToolBarButton
    extends JButton {
        private ImageIcon enabledIcon;
        private Border defaultBorder;

        public ToolBarButton(String string) {
            this(string, "???", "undefined");
        }

        public ToolBarButton(String string, String string2, String string3) {
            ResourceBundle resourceBundle = MainToolBar.this.theApp.getResourceBundle();
            this.enabledIcon = MainToolBar.this.theApp.loadImageIcon(string2 + ".gif");
            if (this.enabledIcon != null && this.enabledIcon.getIconHeight() != -1) {
                this.setIcon(this.enabledIcon);
            } else {
                this.setText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string));
            }
            this.setBorderPainted(true);
            this.defaultBorder = this.getBorder();
            this.setFocusPainted(false);
            this.setActionCommand(string3);
            this.setToolTipText(ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string));
            this.setMargin(null);
            this.addActionListener(MainToolBar.this.buttonClickListener);
        }

        public void showAsDepressed() {
            this.setBorder(BorderFactory.createBevelBorder(1));
        }

        public void showAsEnabled() {
            this.setBorder(this.defaultBorder);
            this.setEnabled(true);
        }
    }
}

