/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ISOLatinField;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.SelectableLabel;
import com.sun.admin.projmgr.client.ProjMgrContextHelpListener;
import com.sun.admin.projmgr.client.ProjMgrPropsPanel;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.admin.projmgr.common.ProjectObj;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;

public class GenProps
extends ProjMgrPropsPanel {
    private static final int NAME_MIN = 1;
    private static final int NAME_MAX = 64;
    private ISOLatinField nameTextField;
    private JIntSpinBox idSpinBox;
    private SelectableLabel idLabel;
    private ISOLatinField descField;
    private GenInfoPanel infoPanel;
    private VProjMgr theApp;
    private ResourceBundle bundle;
    private boolean isNew;
    private boolean isClone;
    private Component compToCheck;
    private SyntaxChecker syntaxChecker = new SyntaxChecker();

    public GenProps(VProjMgr vProjMgr, ProjectObj projectObj, GenInfoPanel genInfoPanel, boolean bl, boolean bl2) {
        Object object;
        this.theApp = vProjMgr;
        this.bundle = vProjMgr.getResourceBundle();
        this.infoPanel = genInfoPanel;
        this.isNew = bl;
        this.isClone = bl2;
        this.createGui(projectObj);
        Vector vector = new Vector(5);
        this.nameTextField.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, vector, this.infoPanel, "new_gen_name")));
        this.nameTextField.addFocusListener((FocusListener)this.syntaxChecker);
        this.descField.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, vector, this.infoPanel, "new_gen_descr")));
        this.descField.addFocusListener((FocusListener)this.syntaxChecker);
        if (bl || bl2) {
            object = new ProjMgrContextHelpListener(vProjMgr, vector, this.infoPanel, "new_gen_id");
            this.idSpinBox.getTextField().addFocusListener((FocusListener)object);
            this.idSpinBox.getTextField().addFocusListener(this.syntaxChecker);
            this.idSpinBox.getUpButton().addFocusListener((FocusListener)object);
            this.idSpinBox.getUpButton().addFocusListener(this.syntaxChecker);
            this.idSpinBox.getUpButton().setNextFocusableComponent((Component)this.descField);
            this.idSpinBox.getDownButton().addFocusListener((FocusListener)object);
            this.idSpinBox.getDownButton().addFocusListener(this.syntaxChecker);
        } else {
            this.idLabel.addFocusListener((FocusListener)((Object)new ProjMgrContextHelpListener(vProjMgr, vector, this.infoPanel, "prop_gen_id")));
        }
        object = new Thread(){

            public void run() {
                try {
                    ContextHelpListener.loadHelp((ContextHelpListener)((ProjMgrContextHelpListener)((Object)GenProps.this.getFocusListener())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ((Thread)object).start();
    }

    private void createGui(ProjectObj projectObj) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (this.isNew) {
            try {
                string2 = this.theApp.getProjMgr().getNextProjectID();
                if (string2 == null) {
                    string2 = "100";
                }
            }
            catch (AdminException adminException) {
                string2 = "100";
            }
        } else if (this.isClone) {
            string3 = projectObj.getProjectDescription();
            try {
                string2 = this.theApp.getProjMgr().getNextProjectID();
                if (string2 == null) {
                    string2 = "100";
                }
            }
            catch (AdminException adminException) {
                string2 = "100";
            }
        } else {
            string = projectObj.getProjectName();
            string2 = projectObj.getProjectID();
            string3 = projectObj.getProjectDescription();
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        int n = 0;
        JLabel jLabel = new JLabel();
        this.setUpLabel(this.bundle, jLabel, "proj_name");
        Constraints.constrain((Container)this, (Component)jLabel, (int)0, (int)n, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.nameTextField = new ISOLatinField(64, string, 15);
        this.nameTextField.setMinimumSize(this.nameTextField.getPreferredSize());
        jLabel.setLabelFor((Component)this.nameTextField);
        Constraints.constrain((Container)this, (Component)this.nameTextField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        JLabel jLabel2 = new JLabel();
        this.setUpLabel(this.bundle, jLabel2, "proj_id");
        Constraints.constrain((Container)this, (Component)jLabel2, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        if (this.isNew || this.isClone) {
            this.idSpinBox = new JIntSpinBox(10, 100, Integer.MAX_VALUE);
            this.idSpinBox.getTextField().setText(string2);
            this.idSpinBox.getTextField().setHorizontalAlignment(4);
            jLabel2.setLabelFor(this.idSpinBox.getTextField());
            Constraints.constrain((Container)this, (Component)this.idSpinBox, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        } else {
            this.idLabel = new SelectableLabel(string2);
            jLabel2.setLabelFor((Component)this.idLabel);
            Constraints.constrain((Container)this, (Component)this.idLabel, (int)1, (int)n, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        }
        JLabel jLabel3 = new JLabel();
        this.setUpLabel(this.bundle, jLabel3, "proj_desc");
        Constraints.constrain((Container)this, (Component)jLabel3, (int)0, (int)(++n), (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.descField = new ISOLatinField(256, "", 15);
        this.descField.setMinimumSize(this.descField.getPreferredSize());
        this.descField.setText(string3);
        jLabel3.setLabelFor((Component)this.descField);
        Constraints.constrain((Container)this, (Component)this.descField, (int)1, (int)n, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)1.0, (int)12, (int)12, (int)0, (int)0);
    }

    public boolean checkTemporarySyntax() {
        if (this.compToCheck == this.nameTextField && this.nameTextField.getText().length() > 0 && !this.isNameSyntaxOK()) {
            this.nameTextField.requestFocus();
            this.nameTextField.selectAll();
            return true;
        }
        if ((this.isNew || this.isClone) && this.compToCheck == this.idSpinBox.getTextField() && !this.isIDValueOK()) {
            this.idSpinBox.getTextField().requestFocus();
            this.idSpinBox.getTextField().selectAll();
            return true;
        }
        if (this.compToCheck == this.descField && !this.isDescSyntaxOK()) {
            this.descField.requestFocus();
            this.descField.selectAll();
            return true;
        }
        return false;
    }

    public void setDefaultFocus() {
        if (this.compToCheck == null) {
            this.nameTextField.requestFocus();
        } else {
            this.compToCheck.requestFocus();
        }
    }

    private boolean isNameSyntaxOK() {
        String string = this.nameTextField.getText();
        String[] stringArray = new String[]{"0", "-", ".", "_"};
        if (string.length() < 1) {
            String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_name");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string2);
            return false;
        }
        if (!Character.isLetter(string.charAt(0))) {
            String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_name");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string3);
            return false;
        }
        if (string.length() > 64) {
            String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_name");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string4);
            return false;
        }
        if (!CheckSyntax.isStringOK((String)string, (String[])stringArray)) {
            String string5 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_name");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string5);
            return false;
        }
        if (CheckSyntax.contains((String)string, (int)32)) {
            String string6 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_name");
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string6);
            return false;
        }
        return true;
    }

    private boolean isIDValueOK() {
        if (this.isNew || this.isClone) {
            String string = this.idSpinBox.getStringValue();
            if (string.equals("")) {
                String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_id");
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string2);
                return false;
            }
            long l = Long.parseLong(string);
            if (l < 100L) {
                String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_id");
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string3);
                return false;
            }
            if (l > Integer.MAX_VALUE) {
                String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_gen_id");
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string4);
                return false;
            }
        }
        return true;
    }

    private boolean isDescSyntaxOK() {
        if (CheckSyntax.isDescLenOK((String)this.descField.getText())) {
            return true;
        }
        String string = CheckSyntax.getErrorString();
        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), string);
        return false;
    }

    public boolean isSyntaxOK() {
        if (!this.isNameSyntaxOK()) {
            this.nameTextField.requestFocus();
            this.nameTextField.selectAll();
            return false;
        }
        if (!this.isIDValueOK()) {
            this.idSpinBox.getTextField().requestFocus();
            this.idSpinBox.getTextField().selectAll();
            return false;
        }
        this.descField.requestFocus();
        this.descField.selectAll();
        return this.isDescSyntaxOK();
    }

    public ProjectObj updateProps(ProjectObj projectObj) {
        String string = this.nameTextField.getText();
        String string2 = this.descField.getText();
        projectObj.setProjectDescription(string2);
        projectObj.setProjectName(string);
        if (this.isNew || this.isClone) {
            String string3 = this.idSpinBox.getStringValue();
            projectObj.setProjectID(string3);
        }
        return projectObj;
    }

    public String getHelpName() {
        return "new_gen";
    }

    class SyntaxChecker
    implements FocusListener {
        SyntaxChecker() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component == GenProps.this.compToCheck) {
                return;
            }
            if ((GenProps.this.isNew || GenProps.this.isClone) && (component == GenProps.this.idSpinBox.getDownButton() && GenProps.this.compToCheck == GenProps.this.idSpinBox.getTextField() || component == GenProps.this.idSpinBox.getUpButton() && GenProps.this.compToCheck == GenProps.this.idSpinBox.getTextField())) {
                return;
            }
            GenProps.this.checkTemporarySyntax();
            GenProps.this.compToCheck = component;
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

