/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.projmgr.client.ContentEvent;
import com.sun.admin.projmgr.client.ContentListener;
import com.sun.admin.projmgr.client.ProjectActionsListener;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;

public abstract class Content {
    private Vector listeners = new Vector();
    protected boolean bRefresh = false;
    protected VScopeNode treeNode = null;
    protected VScopeNode rootNode = null;
    protected Vector vDataCache = new Vector();
    protected VProjMgr theApp;
    protected String sortPreferencesKey;

    protected abstract String[][] getColumnHeaders();

    public Content(VProjMgr vProjMgr) {
        this.theApp = vProjMgr;
        vProjMgr.getContentInstances().addElement(this);
    }

    public Vector getSelected() {
        return this.theApp.getDisplayModel().getSelectedNodes();
    }

    public void setSelected(Vector vector) {
        this.theApp.getDisplayModel().setSelectedNodes(vector);
        this.onSelection(vector);
    }

    public void onSelection(Vector vector) {
        this.fireItemPressed(vector.size());
    }

    public int getNumSelections() {
        return this.theApp.getDisplayModel().getSelectedNodes().size();
    }

    public void clearSelection() {
        this.theApp.getDisplayModel().clearSelection();
        this.fireItemPressed(0);
    }

    protected String[][] constructColumnHeaders(Object[][] objectArray) {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        int n = objectArray.length;
        String[][] stringArray = new String[n][3];
        JLabel jLabel = new JLabel();
        jLabel.setFont(ResourceManager.labelFont);
        FontMetrics fontMetrics = jLabel.getFontMetrics(ResourceManager.labelFont);
        jLabel.setFont(ResourceManager.bodyFont);
        FontMetrics fontMetrics2 = jLabel.getFontMetrics(ResourceManager.labelFont);
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectArray[n2][0];
            stringArray[n2][0] = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string);
            int n3 = fontMetrics.stringWidth(stringArray[n2][0]);
            n3 += fontMetrics.stringWidth("AAAA");
            int n4 = (Integer)objectArray[n2][1];
            int n5 = 0;
            if (n4 > 20000) {
                n5 = 20000;
            } else if (n4 > 10000) {
                n5 = 10000;
            }
            int n6 = fontMetrics2.stringWidth("A");
            n6 *= (n4 -= n5);
            stringArray[n2][1] = new String(String.valueOf(Math.max(n3, n6 += n5)));
            ++n2;
        }
        return stringArray;
    }

    public abstract void refresh();

    public abstract void createProperties();

    public abstract void cloneProperties();

    public abstract void viewProperties();

    public abstract void deleteSelected();

    public void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
        ProjectActionsListener projectActionsListener = new ProjectActionsListener(this.theApp);
        projectActionsListener.actionPerformed(actionEvent);
    }

    public abstract String whatAmI();

    protected abstract void updateInfoBar();

    protected abstract void updateDefaultColumns();

    public void updateSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        String string = vConsoleProperties.getProperty(this.sortPreferencesKey);
        if (string == null || string.equals("null")) {
            return;
        }
        String string2 = "vconsole.sortup";
        if (string.indexOf(45) >= 0) {
            string2 = "vconsole.sortdown";
        }
        Integer[] integerArray = new Integer[1];
        try {
            int n = Integer.parseInt(string.substring(1));
            integerArray[0] = new Integer(n);
        }
        catch (Exception exception) {
            integerArray[0] = new Integer(0);
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, string2, (Object)integerArray);
        this.theApp.fireConsoleAction(vConsoleEvent);
        vConsoleProperties.setProperty("vconsole.sortedcolumn", string);
    }

    public void saveSortPreferences() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty(this.sortPreferencesKey, vConsoleProperties.getProperty("vconsole.sortedcolumn"));
    }

    public String[] getFilterAttributes() {
        return null;
    }

    public Vector getFilters() {
        return null;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public boolean isShowByTypeSupported() {
        return false;
    }

    public void setFilters(Vector vector) {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.die();
    }

    public void die() {
        this.theApp.getContentInstances().removeElement(this);
    }

    public int getNumInstances() {
        return this.theApp.getContentInstances().size();
    }

    public Content getInstance(int n) {
        if (n < 0 || n >= this.theApp.getContentInstances().size()) {
            return null;
        }
        return (Content)this.theApp.getContentInstances().elementAt(n);
    }

    public Vector getInstances() {
        return this.theApp.getContentInstances();
    }

    public void setTreeNode(VScopeNode vScopeNode) {
        this.treeNode = vScopeNode;
    }

    public VScopeNode getTreeNode() {
        return this.treeNode;
    }

    public VScopeNode getInternalRoot() {
        return this.rootNode;
    }

    public Vector getDataCache() {
        return this.vDataCache;
    }

    public abstract void clear(boolean var1);

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    public synchronized void addContentListener(ContentListener contentListener) {
        this.listeners.addElement(contentListener);
    }

    public synchronized void removeContentListener(ContentListener contentListener) {
        this.listeners.removeElement(contentListener);
    }

    protected void fireItemPressed(int n) {
        ContentEvent contentEvent = new ContentEvent(this, n, null);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ContentListener contentListener = (ContentListener)this.listeners.elementAt(n2);
            contentListener.itemPressed(contentEvent);
            ++n2;
        }
    }
}

