/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.projmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.projmgr.client.ServiceWrapper;
import com.sun.admin.projmgr.client.VProjMgr;
import com.sun.admin.projmgr.client.WbemServiceWrapper;
import com.sun.admin.projmgr.common.ProjMgrException;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import java.util.ResourceBundle;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;

public class ApplicationContext {
    private VProjMgr theApp;
    private ToolContext toolContext;
    private AdminMgmtScope scope;

    public ApplicationContext(VProjMgr vProjMgr, ToolContext toolContext) {
        this.theApp = vProjMgr;
        this.toolContext = toolContext;
        this.scope = (AdminMgmtScope)toolContext.getParameter("ToolContext.MGMTSCOPE");
    }

    private String getServiceType() {
        String string = "Wbem";
        try {
            String string2 = System.getProperty("projmgr.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = this.getServiceType();
        String string2 = "com.sun.admin.projmgr.client." + string + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProjMgrException("EXM_SPRT_GUI_SERVICE_NOT_REACHABLE", (Object)string, (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
        }
        catch (Exception exception) {
            ProjMgrException projMgrException = new ProjMgrException("EXM_SPRT_GUI_CANT_GET_SERVICE_WRAPPER", (Object)string, (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
            projMgrException.addArg(exception.getMessage());
            throw projMgrException;
        }
        int n = 2;
        int n2 = 1;
        while (n2 <= n) {
            block8: {
                try {
                    if (serviceWrapper instanceof WbemServiceWrapper) {
                        String string3 = toolInfrastructure.getIdentity().getAuthenHost();
                        CIMNameSpace cIMNameSpace = new CIMNameSpace(this.getMgmtServer(), "root\\cimv2");
                        Object[] objectArray = new Object[]{cIMNameSpace, new String("cim-rmi")};
                        CIMClient cIMClient = (CIMClient)toolInfrastructure.getExternalClient(ExternalClientList.JAVAXWBEM, objectArray);
                        serviceWrapper.init(cIMClient, toolInfrastructure, this.scope);
                        break;
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("TIMED_OUT") && n2 <= n) break block8;
                    if (exception.getMessage().equals("NO_CIMOM")) {
                        throw new ProjMgrException("EXM_SPRT_GUI_CANT_CONNECT_NO_CIMOM", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"));
                    }
                    throw new ProjMgrException("EXM_SPRT_GUI_CANT_CONNECT_TO_SERVER", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), exception.getMessage());
                }
            }
            ++n2;
        }
        return serviceWrapper;
    }

    public void closeConnection(ToolInfrastructure toolInfrastructure) throws AdminException {
        try {
            String string = this.scope.getMgmtServerName();
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string, "root\\cimv2");
            Object[] objectArray = new Object[]{cIMNameSpace, new String("cim-rmi")};
            toolInfrastructure.releaseExternalClient(ExternalClientList.JAVAXWBEM, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMgmtServer() {
        return this.scope.getMgmtServerName();
    }
}

