/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WizButtonListener;
import com.sun.admin.cis.common.WizardStep;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class Wizard
extends JDialog {
    boolean forwardEnabled = false;
    boolean finishVisible = false;
    WizButtonPanel buttonPanel;
    WizContentsPanel contentsPanel;
    WizStepPanel stepPanel;
    Vector steps;
    Vector[] branchingSteps;
    int subStepNumber = 0;
    int pathNumber = 0;
    boolean usingBranches = false;
    WizardStep activeStep = null;
    int stepNumber = 0;
    Vector listeners;
    String basedir = "";

    public Wizard(Frame frame, String string) {
        super(frame, string, true);
        this.doStartup();
    }

    public Wizard(Frame frame, String string, String string2) {
        super(frame, string, true);
        this.basedir = string2;
        this.basedir = this.basedir.concat(File.separator + "cis" + File.separator + "common" + File.separator + "images" + File.separator);
        this.doStartup();
    }

    private void doStartup() {
        this.getContentPane().setLayout(new BorderLayout());
        this.steps = new Vector();
        this.listeners = new Vector();
        this.buttonPanel = new WizButtonPanel();
        this.getContentPane().add((Component)this.buttonPanel, "South");
        JPanel jPanel = new JPanel(new BorderLayout());
        EscKeyListener escKeyListener = new EscKeyListener();
        EnterKeyListener enterKeyListener = new EnterKeyListener();
        jPanel.registerKeyboardAction(escKeyListener, KeyStroke.getKeyStroke(27, 0, true), 2);
        jPanel.registerKeyboardAction(enterKeyListener, KeyStroke.getKeyStroke(10, 0, true), 2);
        this.contentsPanel = new WizContentsPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)this.contentsPanel, "Center");
        jPanel.add((Component)jPanel2, "West");
        this.stepPanel = new WizStepPanel();
        jPanel.add((Component)this.stepPanel, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        this.buttonPanel.addWizButtonListener(new WizButtonListener(){

            public void buttonPressed(int n) {
                switch (n) {
                    case 0: {
                        Wizard.this.showPreviousStep();
                        break;
                    }
                    case 1: {
                        Wizard.this.showNextStep();
                        break;
                    }
                    case 4: {
                        Wizard.this.buttonPanel.setFinishEnabled(false);
                        Wizard.this.doFinish();
                        break;
                    }
                    case 2: {
                        Wizard.this.doCancel();
                        break;
                    }
                }
            }
        });
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pack();
            Dimension dimension = this.getSize();
            int n = 600;
            int n2 = 425;
            if (dimension.width > 600) {
                n = dimension.width;
            }
            if (dimension.height > 425) {
                n2 = dimension.height;
            }
            Dimension dimension2 = new Dimension(n, n2);
            this.setSize(dimension2);
        }
        this.invalidate();
        this.validate();
        this.repaint();
        this.setResizable(false);
        super.setVisible(bl);
    }

    public void addStep(WizardStep wizardStep) {
        this.steps.addElement(wizardStep);
        this.contentsPanel.addStep(wizardStep);
        this.stepPanel.addStep(wizardStep);
    }

    public void addBranchingStep(WizardStep wizardStep, int n) {
        this.branchingSteps = new Vector[n + 1];
        int n2 = 0;
        while (n2 < n + 1) {
            this.branchingSteps[n2] = new Vector();
            this.branchingSteps[n2].addElement(wizardStep);
            ++n2;
        }
        this.steps.addElement(wizardStep);
        this.contentsPanel.addStep(wizardStep);
        this.stepPanel.addStep(wizardStep);
    }

    public void addSubStep(WizardStep wizardStep, int n) {
        this.branchingSteps[n].addElement(wizardStep);
        this.stepPanel.addStep(wizardStep);
    }

    public void setBranchPath(int n) {
        this.usingBranches = true;
        this.pathNumber = n;
        this.subStepNumber = 0;
    }

    public WizardStep getCurrentStep() {
        return this.activeStep;
    }

    private boolean showStep(WizardStep wizardStep, int n) {
        if (this.activeStep != null && !this.activeStep.setInactive(n)) {
            return false;
        }
        this.activeStep = wizardStep;
        this.stepPanel.showStep(wizardStep);
        if (!this.usingBranches) {
            this.contentsPanel.showStep(wizardStep);
            if (wizardStep == this.steps.firstElement()) {
                this.buttonPanel.showFirst();
            } else if (wizardStep == this.steps.lastElement()) {
                this.buttonPanel.showLast();
            } else {
                this.buttonPanel.showMiddle();
            }
        } else {
            this.buttonPanel.showMiddle();
        }
        this.activeStep.setActive(n);
        return true;
    }

    private boolean showStep(int n, int n2) throws ArrayIndexOutOfBoundsException {
        WizardStep wizardStep = !this.usingBranches ? (WizardStep)this.steps.elementAt(n) : (WizardStep)this.branchingSteps[this.pathNumber].elementAt(n);
        return this.showStep(wizardStep, n2);
    }

    public void showFirstStep() {
        this.stepNumber = 0;
        this.showStep(this.stepNumber, 1);
    }

    public void showNextStep() {
        if (!this.usingBranches) {
            ++this.stepNumber;
            try {
                if (!this.showStep(this.stepNumber, 1)) {
                    --this.stepNumber;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                --this.stepNumber;
            }
        } else {
            ++this.subStepNumber;
            try {
                if (!this.showStep(this.subStepNumber, 1)) {
                    --this.subStepNumber;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.usingBranches = false;
                try {
                    if (!this.showStep(++this.stepNumber, 1)) {
                        --this.stepNumber;
                        this.usingBranches = true;
                        --this.subStepNumber;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                    --this.stepNumber;
                }
            }
        }
    }

    public void showPreviousStep() {
        this.finishVisible = false;
        if (!this.usingBranches) {
            --this.stepNumber;
            try {
                if (!this.showStep(this.stepNumber, -1)) {
                    ++this.stepNumber;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ++this.stepNumber;
            }
        } else {
            --this.subStepNumber;
            try {
                if (!this.showStep(this.subStepNumber, -1)) {
                    ++this.subStepNumber;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.usingBranches = false;
                try {
                    this.showStep(--this.stepNumber, -1);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                    ++this.stepNumber;
                }
            }
        }
    }

    public void showLastStep() {
        this.stepNumber = this.steps.size() - 1;
        this.finishVisible = true;
        this.showStep(this.stepNumber, 1);
    }

    public void setForwardEnabled(boolean bl) {
        this.buttonPanel.setForwardEnabled(bl);
    }

    public void setFinishEnabled(boolean bl) {
        this.buttonPanel.setFinishEnabled(bl);
    }

    public void doCancel() {
        this.fireActionPerformed("cancelled");
        this.dispose();
    }

    public void doFinish() {
        this.fireActionPerformed("finished");
        this.dispose();
    }

    public static JComponent createTextArea(String string, int n, int n2) {
        FlowArea flowArea = new FlowArea(string, n2);
        flowArea.setSize(flowArea.getPreferredSize());
        JScrollPane jScrollPane = new JScrollPane(flowArea, 21, 31);
        Border border = BorderFactory.createEmptyBorder();
        jScrollPane.setBorder(border);
        return jScrollPane;
    }

    public static JComponent createTextArea(String string, int n) {
        FlowArea flowArea = new FlowArea(string, n);
        JScrollPane jScrollPane = new JScrollPane(flowArea, 21, 31);
        Border border = BorderFactory.createEmptyBorder();
        jScrollPane.setBorder(border);
        return jScrollPane;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    protected void fireActionPerformed(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void onEnterKey() {
        Component component = SwingUtilities.findFocusOwner(this);
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            jButton.doClick();
        } else {
            this.buttonPanel.forwardButton.doClick();
        }
    }

    protected class EnterKeyListener
    implements ActionListener {
        protected EnterKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Wizard.this.finishVisible) {
                Wizard.this.doFinish();
            } else if (Wizard.this.buttonPanel.isForwardEnabled()) {
                Wizard.this.onEnterKey();
            }
        }
    }

    protected class EscKeyListener
    implements ActionListener {
        protected EscKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.buttonPanel.cancelButton.requestFocus();
            Wizard.this.buttonPanel.cancelButton.doClick();
        }
    }

    class WizStepPanel
    extends JPanel {
        CardLayout layout = new CardLayout();

        public WizStepPanel() {
            this.setLayout(this.layout);
            this.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        }

        public void addStep(WizardStep wizardStep) {
            this.add(wizardStep.getComponent(), wizardStep.getDescription());
        }

        public void showStep(WizardStep wizardStep) {
            this.layout.show(this, wizardStep.getDescription());
        }
    }

    class WizContentsPanel
    extends JPanel {
        JList contentsList;
        ContentsModel model;
        ContentsSelectionModel selectionModel;

        public WizContentsPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout(this, 1));
            JLabel jLabel = new JLabel(ResourceStrings.getString("steps_label"));
            jLabel.setForeground(Color.black);
            jLabel.setAlignmentX(0.0f);
            this.add(jLabel);
            this.model = new ContentsModel();
            this.contentsList = new JList(this.model);
            this.contentsList.setBackground(Color.white);
            this.selectionModel = new ContentsSelectionModel();
            this.contentsList.setSelectionModel(this.selectionModel);
            this.contentsList.setCellRenderer(new ContentsRenderer());
            JScrollPane jScrollPane = new JScrollPane(this.contentsList, 20, 31);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(15, 10, 0, 0));
            jScrollPane.setBackground(Color.white);
            jScrollPane.setAlignmentX(0.0f);
            this.add(jScrollPane);
            this.add(Box.createVerticalGlue());
        }

        public void addStep(WizardStep wizardStep) {
            this.model.addItem(wizardStep.getDescription());
        }

        public void showStep(WizardStep wizardStep) {
            this.selectionModel.setEnabled(true);
            this.contentsList.setSelectedValue(wizardStep.getDescription(), true);
            this.selectionModel.setEnabled(false);
        }

        class ContentsSelectionModel
        extends DefaultListSelectionModel {
            private boolean enabled = false;

            ContentsSelectionModel() {
            }

            public void addSelectionInterval(int n, int n2) {
                if (this.enabled) {
                    super.addSelectionInterval(n, n2);
                }
            }

            public void clearSelection() {
                if (this.enabled) {
                    super.clearSelection();
                }
            }

            public void insertIndexInterval(int n, int n2, boolean bl) {
                if (this.enabled) {
                    super.insertIndexInterval(n, n2, bl);
                }
            }

            public void removeIndexInterval(int n, int n2) {
                if (this.enabled) {
                    super.removeIndexInterval(n, n2);
                }
            }

            public void removeSelectionInterval(int n, int n2) {
                if (this.enabled) {
                    super.removeSelectionInterval(n, n2);
                }
            }

            public void setSelectionInterval(int n, int n2) {
                if (this.enabled) {
                    super.setSelectionInterval(n, n2);
                }
            }

            public void setEnabled(boolean bl) {
                this.enabled = bl;
            }
        }

        class ContentsRenderer
        implements ListCellRenderer {
            NumberFormat nf = NumberFormat.getInstance();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JComponent jComponent = Wizard.createTextArea((String)object, 2, 14);
                jComponent.setAlignmentY(0.0f);
                JLabel jLabel = new JLabel(this.nf.format(n + 1));
                jLabel.setForeground(Color.black);
                jLabel.setAlignmentY(0.0f);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                jPanel.add(jLabel);
                jPanel.add(Box.createHorizontalStrut(5));
                jPanel.add(jComponent);
                jPanel.setBackground(jList.getSelectionBackground());
                jPanel.setOpaque(bl);
                return jPanel;
            }
        }

        class ContentsModel
        extends AbstractListModel {
            Vector data = new Vector();

            public Object getElementAt(int n) {
                return this.data.elementAt(n);
            }

            public int getSize() {
                return this.data.size();
            }

            public void addItem(String string) {
                this.data.addElement(string);
                this.fireIntervalAdded(this, this.data.size() - 1, this.data.size() - 1);
            }
        }
    }

    class WizButtonPanel
    extends JPanel {
        JButton backButton;
        JButton forwardButton;
        JButton cancelButton;
        JButton finishButton;
        JButton backButton2;
        JButton cancelButton2;
        Vector listeners;
        ButtonAdaptor adaptor;
        JPanel innerPanel;

        private void setUpButton(JButton jButton, String string) {
            jButton.setToolTipText(string);
            jButton.setBorderPainted(true);
            jButton.setFocusPainted(false);
            jButton.setMargin(new Insets(0, 2, 0, 2));
        }

        public WizButtonPanel() {
            ImageIcon imageIcon;
            Object object;
            this.setBorder(new EtchedBorder());
            this.setLayout(new FlowLayout(2));
            this.innerPanel = new JPanel(new CardLayout());
            this.adaptor = new ButtonAdaptor();
            this.listeners = new Vector();
            String string = ResourceStrings.getString("back_button");
            if (!Wizard.this.basedir.equals("")) {
                object = new String(Wizard.this.basedir);
                object = ((String)object).concat("back.gif");
                imageIcon = new ImageIcon((String)object, string);
                this.backButton = new JButton(imageIcon);
                this.setUpButton(this.backButton, string);
                this.backButton2 = new JButton(imageIcon);
                this.setUpButton(this.backButton2, string);
            } else {
                this.backButton = new JButton(ResourceStrings.getString("back_button"));
                this.backButton2 = new JButton(ResourceStrings.getString("back_button"));
            }
            this.backButton.addActionListener(this.adaptor);
            this.backButton2.addActionListener(this.adaptor);
            this.backButton.setAlignmentY(0.5f);
            this.backButton2.setAlignmentY(0.5f);
            string = ResourceStrings.getString("next_button");
            if (!Wizard.this.basedir.equals("")) {
                object = new String(Wizard.this.basedir);
                object = ((String)object).concat("forward.gif");
                imageIcon = new ImageIcon((String)object, string);
                this.forwardButton = new JButton(imageIcon);
                this.setUpButton(this.forwardButton, string);
            } else {
                this.forwardButton = new JButton(ResourceStrings.getString("next_button"));
            }
            this.forwardButton.addActionListener(this.adaptor);
            this.forwardButton.setAlignmentY(0.5f);
            this.finishButton = new JButton(ResourceStrings.getString("finish_button"));
            this.finishButton.addActionListener(this.adaptor);
            this.finishButton.setAlignmentY(0.5f);
            this.cancelButton = new JButton(ResourceStrings.getString("cancel_button"));
            this.cancelButton.addActionListener(this.adaptor);
            this.cancelButton.setAlignmentY(0.5f);
            this.cancelButton2 = new JButton(ResourceStrings.getString("cancel_button"));
            this.cancelButton2.addActionListener(this.adaptor);
            this.cancelButton2.setAlignmentY(0.5f);
            object = Box.createHorizontalBox();
            ((Container)object).add(Box.createHorizontalGlue());
            ((Container)object).add(this.backButton);
            ((Container)object).add(Box.createHorizontalStrut(5));
            ((Container)object).add(this.forwardButton);
            ((Container)object).add(Box.createHorizontalStrut(5));
            ((Container)object).add(this.cancelButton);
            ((Container)object).add(Box.createHorizontalStrut(5));
            this.innerPanel.add((Component)object, "normal");
            object = Box.createHorizontalBox();
            ((Container)object).add(Box.createHorizontalGlue());
            ((Container)object).add(this.backButton2);
            ((Container)object).add(Box.createHorizontalStrut(5));
            ((Container)object).add(this.finishButton);
            ((Container)object).add(Box.createHorizontalStrut(5));
            ((Container)object).add(this.cancelButton2);
            ((Container)object).add(Box.createHorizontalStrut(5));
            this.innerPanel.add((Component)object, "finish");
            this.add(this.innerPanel);
        }

        public void showFirst() {
            this.backButton.setEnabled(false);
            this.setForwardEnabled(false);
            ((CardLayout)this.innerPanel.getLayout()).show(this.innerPanel, "normal");
        }

        public void showLast() {
            this.backButton.setEnabled(true);
            Wizard.this.finishVisible = true;
            this.setFinishEnabled(false);
            ((CardLayout)this.innerPanel.getLayout()).show(this.innerPanel, "finish");
        }

        public void showMiddle() {
            this.backButton.setEnabled(true);
            this.setForwardEnabled(false);
            ((CardLayout)this.innerPanel.getLayout()).show(this.innerPanel, "normal");
        }

        public void setForwardEnabled(boolean bl) {
            this.forwardButton.setEnabled(bl);
            Wizard.this.forwardEnabled = bl;
        }

        public boolean isForwardEnabled() {
            return Wizard.this.forwardEnabled;
        }

        public void setFinishEnabled(boolean bl) {
            this.finishButton.setEnabled(bl);
            if (bl) {
                this.finishButton.requestFocus();
            }
        }

        public void addWizButtonListener(WizButtonListener wizButtonListener) {
            this.listeners.addElement(wizButtonListener);
        }

        public void removeWizButtonListener(WizButtonListener wizButtonListener) {
            this.listeners.removeElement(wizButtonListener);
        }

        class ButtonAdaptor
        implements ActionListener {
            ButtonAdaptor() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = -1;
                Object object = actionEvent.getSource();
                if (object == WizButtonPanel.this.backButton || object == WizButtonPanel.this.backButton2) {
                    n = 0;
                } else if (object == WizButtonPanel.this.forwardButton) {
                    n = 1;
                } else if (object == WizButtonPanel.this.cancelButton || object == WizButtonPanel.this.cancelButton2) {
                    n = 2;
                } else if (object == WizButtonPanel.this.finishButton) {
                    n = 4;
                }
                Enumeration enumeration = WizButtonPanel.this.listeners.elements();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    WizButtonListener wizButtonListener = (WizButtonListener)enumeration.nextElement();
                    wizButtonListener.buttonPressed(n);
                }
            }
        }
    }
}

