/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClient;

public class WbemService {
    private ToolInfrastructure tinf;

    public WbemService(ToolInfrastructure toolInfrastructure) {
        this.tinf = toolInfrastructure;
    }

    public WbemClientProxy getServiceHandle(String string, String string2, AdminMgmtScope adminMgmtScope) throws AdminException {
        CIMClient cIMClient;
        Object object;
        WbemClientProxy wbemClientProxy = null;
        try {
            wbemClientProxy = (WbemClientProxy)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AdminException("Class not found: " + string2);
        }
        catch (Exception exception) {
            throw new AdminException("Error creating instance of service proxy", exception);
        }
        try {
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string, "root\\cimv2");
            object = new Object[]{cIMNameSpace, new String("cim-rmi")};
            cIMClient = (CIMClient)this.tinf.getExternalClient(ExternalClientList.JAVAXWBEM, object);
        }
        catch (Exception exception) {
            throw new AdminException("Error retrieving CIM client handle", exception);
        }
        object = null;
        if (adminMgmtScope != null) {
            try {
                object = new WbemMgmtScope(adminMgmtScope.getMgmtScopeType(), adminMgmtScope.getMgmtDomainName());
            }
            catch (Exception exception) {
                throw new AdminException("Error converting console scope", exception);
            }
        }
        try {
            wbemClientProxy.init(cIMClient, (WbemMgmtScope)object);
        }
        catch (Exception exception) {
            throw new AdminException("Error initializing service proxy", exception);
        }
        return wbemClientProxy;
    }

    public void releaseServiceHandle(String string, AdminMgmtScope adminMgmtScope) throws AdminException {
        try {
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string, "root\\cimv2");
            Object[] objectArray = new Object[]{cIMNameSpace, new String("cim-rmi")};
            this.tinf.releaseExternalClient(ExternalClientList.JAVAXWBEM, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

