/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WarningDialog {
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private static final GridBagConstraints gbc = new GridBagConstraints();
    private JDialog dialog;
    private JButton okBtn;
    private JButton cancelBtn;
    private JFrame parent;
    private String title = ResourceStrings.getString("warning_title");
    private JPanel msgPanel = null;
    private String okBtnLabel = ResourceStrings.getString("w_ok_button");
    private String cancelBtnLabel = ResourceStrings.getString("w_cancel_button");
    private ActionListener listener;
    private ActionListener clientCancelListener = null;
    private static ImageIcon warningIcon = null;

    public WarningDialog(JFrame jFrame, JPanel jPanel, ActionListener actionListener) {
        this(jFrame, jPanel, actionListener, (ActionListener)null);
    }

    public WarningDialog(JFrame jFrame, JPanel jPanel, ActionListener actionListener, ActionListener actionListener2) {
        this.parent = jFrame;
        this.msgPanel = jPanel;
        this.listener = actionListener;
        this.clientCancelListener = actionListener2;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener) {
        this(jFrame, string, jPanel, actionListener, (ActionListener)null);
    }

    public WarningDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener, ActionListener actionListener2) {
        this.parent = jFrame;
        this.title = string;
        this.msgPanel = jPanel;
        this.listener = actionListener;
        this.clientCancelListener = actionListener2;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, JPanel jPanel, ActionListener actionListener, String string) {
        this(jFrame, jPanel, actionListener, null, string);
    }

    public WarningDialog(JFrame jFrame, JPanel jPanel, ActionListener actionListener, ActionListener actionListener2, String string) {
        this.parent = jFrame;
        this.msgPanel = jPanel;
        this.okBtnLabel = string;
        this.listener = actionListener;
        this.clientCancelListener = actionListener2;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener, String string2) {
        this(jFrame, string, jPanel, actionListener, null, string2);
    }

    public WarningDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener, ActionListener actionListener2, String string2) {
        this.parent = jFrame;
        this.title = string;
        this.msgPanel = jPanel;
        this.okBtnLabel = string2;
        this.listener = actionListener;
        this.clientCancelListener = actionListener2;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, JPanel jPanel, ActionListener actionListener, ActionListener actionListener2, String string2, String string3) {
        this.parent = jFrame;
        this.title = string;
        this.msgPanel = jPanel;
        this.okBtnLabel = string2;
        this.cancelBtnLabel = string3;
        this.listener = actionListener;
        this.clientCancelListener = actionListener2;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, String string2, ActionListener actionListener, String string3) {
        this.parent = jFrame;
        this.title = string;
        this.okBtnLabel = string3;
        this.listener = actionListener;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        FlowArea flowArea = new FlowArea(string2, 30, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.msgPanel = jPanel;
        this.createWarningDialog();
    }

    public WarningDialog(JFrame jFrame, String string, String string2, ActionListener actionListener, ActionListener actionListener2, String string3) {
        this.parent = jFrame;
        this.title = string;
        this.okBtnLabel = string3;
        this.listener = actionListener;
        this.clientCancelListener = actionListener2;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        FlowArea flowArea = new FlowArea(string2, 30, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        this.msgPanel = jPanel;
        this.createWarningDialog();
    }

    private void createWarningDialog() {
        this.dialog = new JDialog(this.parent, this.title, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        SpecialKeyListener specialKeyListener = new SpecialKeyListener();
        this.dialog.addKeyListener(specialKeyListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel2, 0, 0, 1, 2, 3, 17, 0.0, 1.0, 5, 5, 5, 0);
        JLabel jLabel = this.getIconLabel();
        Constraints.constrain(jPanel2, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain(jPanel2, jPanel3, 0, 1, 1, 1, 3, 17, 0.0, 1.0, 0, 0, 0, 0);
        this.msgPanel.setMinimumSize(this.msgPanel.getPreferredSize());
        Constraints.constrain(jPanel, this.msgPanel, 1, 0, 1, 1, 1, 17, 1.0, 1.0, 20, 10, 20, 20);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        jPanel3 = new JPanel();
        Constraints.constrain(jPanel4, jPanel3, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.okBtn = new JButton(this.okBtnLabel);
        this.okBtn.addActionListener(new OKBtnListener());
        Constraints.constrain(jPanel4, this.okBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.cancelBtn = new JButton(this.cancelBtnLabel);
        this.cancelBtn.addActionListener(new CancelBtnListener());
        Constraints.constrain(jPanel4, this.cancelBtn, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 0, 5, 5);
        Constraints.constrain(jPanel, jPanel4, 1, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.dialog.getContentPane().setLayout(gridBagLayout);
        Constraints.constrain(this.dialog.getContentPane(), jPanel, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.dialog.pack();
        this.dialog.pack();
        this.centerDialog();
        this.dialog.setResizable(false);
        this.okBtn.requestFocus();
        this.okBtn.setNextFocusableComponent(this.cancelBtn);
        this.cancelBtn.setNextFocusableComponent(this.okBtn);
        this.dialog.setVisible(true);
    }

    private JLabel getIconLabel() {
        if (warningIcon == null) {
            warningIcon = ConsoleUtility.loadImageIcon((String)"/com/sun/admin/cis/common/images/warning_icon.gif", this.getClass());
        }
        JLabel jLabel = new JLabel(warningIcon);
        return jLabel;
    }

    public void centerDialog() {
        this.dialog.setLocation(WarningDialog.screenSize.width / 2 - this.dialog.getSize().width / 2, WarningDialog.screenSize.height / 2 - this.dialog.getSize().height / 2);
    }

    protected class SpecialKeyListener
    extends KeyAdapter {
        protected SpecialKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                if (WarningDialog.this.okBtn.hasFocus()) {
                    WarningDialog.this.okBtn.doClick();
                } else if (WarningDialog.this.cancelBtn.hasFocus()) {
                    WarningDialog.this.cancelBtn.doClick();
                }
            } else if (keyEvent.getKeyCode() == 27) {
                WarningDialog.this.cancelBtn.doClick();
            }
        }
    }

    class CancelBtnListener
    implements ActionListener {
        CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (WarningDialog.this.clientCancelListener != null) {
                WarningDialog.this.clientCancelListener.actionPerformed(actionEvent);
            }
            WarningDialog.this.dialog.dispose();
        }
    }

    class OKBtnListener
    implements ActionListener {
        OKBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = new JButton();
            jButton.addActionListener(WarningDialog.this.listener);
            jButton.doClick();
            WarningDialog.this.dialog.dispose();
        }
    }
}

